/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.custom;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyLog;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;

public class MultipartRequest
extends Request<String> {
    public static final String KEY_PICTURE = "file";
    private HttpEntity mHttpEntity;
    private Map<String, String> textParams;
    private Response.Listener mListener;

    public MultipartRequest(String url, String filePath, Map<String, String> textParams, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(1, url, errorListener);
        this.textParams = textParams;
        this.mListener = listener;
        this.mHttpEntity = this.buildMultipartEntity(filePath);
    }

    public MultipartRequest(String url, File file, Map<String, String> textParams, Response.Listener<String> listener, Response.ErrorListener errorListener) {
        super(1, url, errorListener);
        this.textParams = textParams;
        this.mListener = listener;
        this.mHttpEntity = this.buildMultipartEntity(file);
    }

    private HttpEntity buildMultipartEntity(String filePath) {
        File file = new File(filePath);
        return this.buildMultipartEntity(file);
    }

    private HttpEntity buildMultipartEntity(File file) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        FileBody fileBody = new FileBody(file);
        builder.addPart(KEY_PICTURE, (ContentBody)fileBody);
        for (Map.Entry<String, String> entry : this.textParams.entrySet()) {
            builder.addTextBody(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }

    @Override
    public String getBodyContentType() {
        return this.mHttpEntity.getContentType().getValue();
    }

    @Override
    public byte[] getBody() throws AuthFailureError {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.mHttpEntity.writeTo((OutputStream)bos);
        }
        catch (IOException e) {
            VolleyLog.e("IOException writing to ByteArrayOutputStream", new Object[0]);
        }
        return bos.toByteArray();
    }

    @Override
    protected Response<String> parseNetworkResponse(NetworkResponse response) {
        String parsed;
        try {
            parsed = new String(response.data, HttpHeaderParser.parseCharset(response.headers));
        }
        catch (UnsupportedEncodingException e) {
            parsed = new String(response.data);
        }
        return Response.success(parsed, HttpHeaderParser.parseCacheHeaders(response));
    }

    @Override
    protected void deliverResponse(String response) {
        this.mListener.onResponse(response);
    }
}

