# Meteor.js 3 + React

In this tutorial, we will create a simple To-Do app using [React](https://react.dev/) and Meteor 3.0. Meteor works well with other frameworks like [Blaze](https://www.blazejs.org/), [Vue 3](https://vuejs.org/), [Solid](https://www.solidjs.com/), and [Svelte](https://svelte.dev/).

React is a popular JavaScript library for building user interfaces. It allows you to create dynamic and interactive applications by composing UI components. React uses a declarative approach, where you define how the UI should look based on the state, and it efficiently updates the view when the state changes. With JSX, a syntax extension that combines JavaScript and HTML, React makes it easy to create reusable components that manage their own state and render seamlessly in the browser.

To start building your React app, you'll need a code editor. If you're unsure which one to choose, [Visual Studio Code](https://code.visualstudio.com/) is a good option. After installing it, you can enhance your experience by adding extensions like [Meteor Toolbox](https://marketplace.visualstudio.com/items?itemName=meteor-toolbox.meteor-toolbox).

Let’s begin building your app!

# Table of Contents

[[toc]]

<!-- @include: ./1.creating-the-app.md-->
<!-- @include: ./2.collections.md-->
<!-- @include: ./3.forms-and-events.md-->
<!-- @include: ./4.update-and-remove.md-->
<!-- @include: ./5.styles.md-->
<!-- @include: ./6.filter-tasks.md-->
<!-- @include: ./7.adding-user-accounts.md-->
<!-- @include: ./8.deploying.md-->
<!-- @include: ./9.next-steps.md-->
