# Changelog

This is a complete history of changes for Meteor releases.

[//]: # (Do not edit this file by hand.)

[//]: # (This is a generated file.)

[//]: # (If you want to change something in this file)

[//]: # (go to meteor/docs/generators/changelog/docs)



## v3.1.0, 2024-11-20

### Highlights

- Upgrade to Node v22
- Upgrade Mongo Driver to v6
- Upgrade Express to v5
- HMR performance improvements
- Bring the `roles` package into the core
- Solve remaining issues with Top Level Await and Reify
- Refactor part of the real-time code in the `mongo` package into TypeScript
- Deprecate `underscore` and eliminate it from packages
- Fix Cordova dependency issues
- Simplify Meteor.EnvironmentVariable and make sure it works in all cases
- Stop using Rosetta for development MongoDB on Apple Silicon
- Test improvements
- Bump `http` package to 3.0.0

#### Breaking Changes

- Express is now at v5 and some it's APIs have changed.

####  Internal API changes

N/A

#### Migration Steps

Please run the following command to update your project:

```bash

meteor update --release 3.1

```

Make sure to migrate userland code to use the new Express APIs:

https://expressjs.com/en/guide/migrating-5.html

The MongoDB Node.js driver implemented a significant breaking change regarding operation handling. Applications leveraging `rawCollection()` or `rawDatabase()` methods must now utilize Promise-based syntax exclusively, as the callback-pattern API has been deprecated and removed. This modification affects all direct MongoDB operations previously using callback functions.


#### Bumped Meteor Packages

- accounts-password@3.0.3
- babel-compiler@7.11.2
- boilerplate-generator-tests@1.5.3
- ddp-client@3.0.3
- ddp-server@3.0.3
- http@3.0.0
- ecmascript@0.16.10
- email@3.1.1
- meteor-tool@3.1.0
- meteor@2.0.2
- minifier-js@3.0.1
- minimongo@2.0.2
- modules@0.20.3
- mongo@2.0.3
- coffeescript-compiler@2.4.2
- coffeescript@2.7.2
- mongo-decimal@0.2.0
- npm-mongo@6.10.0
- shell-server@0.6.1
- test-helpers@2.0.2
- test-in-console@2.0.1
- tinytest@1.3.1
- typescript@5.6.3
- url@1.3.5
- webapp@2.0.4


#### Bumped NPM Packages

- meteor-babel@7.20.1
- meteor-installer@3.1.0
- meteor-node-stubs@1.2.12


#### Special thanks to

✨✨✨

- [@denihs](https://github.com/denihs)
- [@nachocodoner](https://github.com/nachocodoner)
- [@leonardoventurini](https://github.com/leonardoventurini)
- [@StorytellerCZ](https://github.com/StorytellerCZ)
- [@zodern](https://github.com/zodern)
- [@harry97](https://github.com/harry97)
- [@permb](https://github.com/permb)
- [@9Morello](https://github.com/9Morello)
- [@wreiske](https://github.com/wreiske)
- [@MarcoTribuz](https://github.com/MarcoTribuz)
- [@MeteorCoder](https://forums.meteor.com/u/meteorcoder/summary)

✨✨✨
## v3.0.4, 2024-10-15

### Highlights

- Node 20.18.0 & Typescript 5.6.2
- Updated webapp dependencies.
- DDP-server and DDP-client removed underscore
- Remove dependencies on Blaze packages when using static-html
- Fix Cordova on Windows
- Fix Cordova build on using plugins describing dependencies
- Various Windows specific fixes

#### Breaking Changes

N/A

####  Internal API changes

N/A

#### Migration Steps

Please run the following command to update your project:

```bash

meteor update --release 3.0.4

```

#### Meteor Version Release

* `Bumped packages`:
  - accounts-base@3.0.3                
  - babel-compiler@7.11.1              
  - caching-compiler@2.0.1             
  - check@1.4.4                        
  - ddp-client@3.0.2                   
  - ddp-server@3.0.2                   
  - ecmascript-runtime@0.8.3           
  - modules@0.20.2                     
  - static-html-tools@1.0.0            
  - static-html@1.4.0                  
  - url@1.3.4                          
  - webapp@2.0.3                       
  - meteor-tool@3.0.4

#### Special thanks to
N/A
## v3.0.3, 2024-09-11

### Highlights

- Fixed `Meteor.userId` only being invoked with `bindEnvironment`.
- Updated to Node `20.17.x`.
- Fixed an issue where `meteor --open` opens the browser before the app is started.
- Investigated and addressed the error when installing the `jam:method` package.
- Improved the message for new available versions when running an app.
- Updated the documentation link inside `install.sh`.
- Resolved the issue where subscriptions stopped after a parameter change.
- Added MongoDB connection telemetry.
- Bumped the `email` package to prevent update errors.
- Cordova package updates

#### Breaking Changes

N/A

####  Internal API changes

- Some internal changes to how async contexts are handled, ensuring better performance and garbage collection.

#### Migration Steps

Please run the following command to update your project:

```bash

meteor update --release 3.0.3

```

If you've had your Meteor installation for over a year, we suggest reinstalling it to avoid any package installation issues. You can do this by running a few quick commands:

```bash
npx meteor uninstall // or rm -rf ~/.meteor
npx meteor
```



#### Meteor Version Release

* `Bumped packages`:
  - accounts-base@3.0.2
  - accounts-password@3.0.2
  - email@3.1.0
  - mongo@2.0.2


#### Special thanks to

- [@ayewo](https://github.com/ayewo).
- [@denihs](https://github.com/denihs).
- [@harryadel](https://github.com/harryadel).
- [@kbarr1212](https://github.com/kbarr1212).
- [@leonardoventurini](https://github.com/leonardoventurini).
- [@nachocodoner](https://github.com/nachocodoner).

## v3.0.2, 2024-08-14

### Highlights

* Bump the patch for some packages, so we publish them using Meteor 3 tooling. [PR](https://github.com/meteor/meteor/pull/13231)
* Fix subscription still resetting documents [PR](https://github.com/meteor/meteor/pull/13236)
* Fix auth sub sending ready twice on load [PR](https://github.com/meteor/meteor/pull/13247)
* Remove version constraints from http package in accounts-twitter [PR](https://github.com/meteor/meteor/pull/13268)
* Deprecate Meteor.user() usage on server side [PR](https://github.com/meteor/meteor/pull/13288)

#### Breaking Changes

N/A

####  Internal API changes

N/A

#### Migration Steps

Please run the following command to update your project:

```bash

meteor update --release 3.0.2

```


#### Meteor Version Release

* `Bumped packages`:
  - accounts-2fa@3.0.1
  - accounts-base@3.0.1
  - accounts-password@3.0.1
  - accounts-twitter@1.5.2
  - ddp-client@3.0.1
  - ddp-common@1.4.4
  - ddp-server@3.0.1
  - email@3.0.1
  - meteor@2.0.1
  - minimongo@2.0.1
  - mongo@2.0.1
  - npm-mongo@4.17.4
  - test-helpers@2.0.1
  - webapp@2.0.1



#### Special thanks to

- [@leonardoventurini](https://github.com/leonardoventurini).
- [@StorytellerCZ](https://github.com/StorytellerCZ).


For making this great framework even better!


## v3.0.1, 2024-07-16

### Highlights

* Bump the patch for some packages, so we publish them using Meteor 3 tooling. [PR](https://github.com/meteor/meteor/pull/13231)

#### Breaking Changes

N/A

####  Internal API changes

N/A

#### Migration Steps

Please run the following command to update your project:

```bash

meteor update --release 3.0.1

```


#### Meteor Version Release


* `Bumped packages`:
  - accounts-ui-unstyled@1.7.2
  - crosswalk@1.7.3
  - facebook-oauth@1.11.4
  - npm-mongo@4.17.3
  - package-version-parser@3.2.3
  - twitter-config-ui@1.0.2


#### Special thanks to

- [@denihs](https://github.com/denihs).


For making this great framework even better!


## v3.0, 2024-07-15

### Highlights

#### Breaking Changes

- Meteor tool
  - 'meteor reset' command only affects the local project cache. Use `--db` option to also remove the local database.

- `accounts-2fa@3.0.0`:

  - Some methods are now async. See below:
  - `Accounts._is2faEnabledForUser`
  - `(Meteor Method) - generate2faActivationQrCode`
  - `(Meteor Method) - enableUser2fa`
  - `(Meteor Method) - disableUser2fa`
  - `(Meteor Method) - has2faEnabled`

- `accounts-base@3.0.0`:

  - `methods.removeOtherTokens` is now async
  - `Accounts.destroyToken` is now async
  - `Accounts.insertUserDoc` is now async
  - `Accounts.updateOrCreateUserFromExternalService` is now async
  - `Accounts.expirePasswordToken` is now async
  - `Accounts.setupUsersCollection` is now async
  - `Meteor.user` is now async in server

- `accounts-facebook@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-github@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-google@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-meetup@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-meteor-developer@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-password@3.0.0`:

  - Some server methods are now async:
  - `Accounts.sendResetPasswordEmail`
  - `Accounts.sendEnrollmentEmail`
  - `Accounts.sendVerificationEmail`
  - `Accounts.addEmail`
  - `Accounts.removeEmail`
  - `Accounts.verifyEmail`
  - `Accounts.createUserVerifyingEmail`
  - `Accounts.createUser`
  - `Accounts.generateVerificationToken`
  - `Accounts.generateResetToken`
  - `Accounts.forgotPassword`
  - `Accounts.setPassword` -- no longer exists, you should use Accounts.setPasswordAsync [PR](https://github.com/meteor/meteor/pull/13030)
  - `Accounts.changePassword`
  - `Accounts.setUsername`
  - `Accounts.findUserByEmail`
  - `Accounts.findUserByUsername`

- `accounts-passwordless@3.0.0`:

  - `Accounts.sendLoginTokenEmail` is now async.

- `accounts-twitter@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-ui-unstyled@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `accounts-weibo@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `allow-deny@2.0.0`:

  - Updated to accept async functions.

- `appcache@2.0.0`:

  - Updated internal api to use `handlers`

- `audit-argument-checks@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `autopublish@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `autoupdate@2.0.0`:

  - Updated api to be async, with asyncronous queueing.

- `babel-compiler@8.0.0`:

  - Removed `Promise.await` default transform.
  - Added top-level-await to packages.

- `babel-runtime@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `base64@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `binary-heap@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- Build system:
  - removed `Assets.getText`
  - removed `Assets.getBinary`

- `blaze@3.0.0`:
  - Todo

- `boilerplate-generator-tests@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `boilerplate-generator@2.0.0`:

  - `toHTML` is no longer available (it was already deprecated). Use `toHTMLStream` instead.
  - Updated to use `handlers`

- `browser-policy-common@2.0.0`:

  - Updated to use `handlers`

- `browser-policy-content@2.0.0`:

  - Some methods are now async. See below:
    - `BrowserPolicy.content.setPolicy`
    - `BrowserPolicy.content.allowInlineScripts`
    - `BrowserPolicy.content.disallowInlineScripts`
    - `BrowserPolicy.content.disallowAll`
    - `BrowserPolicy.setDefaultPolicy`

- `browser-policy-framing@2.0.0`:
  - Package was bumped due to a dependency update. No code changes were made.

- `browser-policy@2.0.0`:
  Updated to use async methods from `browser-policy-common` and `browser-policy-content`.

- `caching-compiler@2.0.0`:

  - `afterLink` is now async.
  - Updated to use now async API.

- `callback-hook@2.0.0`:

  - Added `forEachAsync` method.

- `check@2.0.0`:

  - Removed `fibers` related tests.

- `constraint-solver@2.0.0`:

  - Some methods are now async. See below:

    - `ConstraintSolver.getVersionCostSteps`
    - `ConstraintSolver.analyze`
    - `ConstraintSolver.resolve`

  - Updated tests to be async.
  - Removed a few underscore usage.
  - Added updated to use async methods

- `context@1.0.0`:

  - Removed `fibers` from package.

- `core-runtime@2.0.0`:

  - Created package to load packages and the app.
  - This is the pakcages that sets up the Runtime.

- `crosswalk@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ddp-client@3.0.0`:

  - Added `isAsyncCall` method to know if call is being made by a async method.
  - Removed `fibers` from package.
  - Updated tests to use async methods.

- `ddp-common@2.0.0`:

  - Added `.fence` option.

- `ddp-rate-limiter@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ddp-server@3.0.0`:

  - Updated to use async methods.
  - Removed `fibers` from package.
  - Updated tests to use async methods.
  - Turned server implementation to async.

- `ddp@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `diff-sequence@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `disable-oplog@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ecmascript-runtime-client@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ecmascript-runtime-server@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ecmascript-runtime@1.0.0`:

  - Added dependency to `@babel/runtime`.

- `ecmascript@1.0.0`:

  - Added dependency to `@babel/runtime`.
  - Moved runtime tests.

- `ejson@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `email@3.0.0`:

  - `Email.send` is no longer available. Use `Email.sendAsync` instead.
  - Updated types to reflext async methods and `Email.send` depracation.

- `es5-shim@5.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `facebook-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `facebook-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `facts-base@2.0.0`:

  - turned unorderd deps on `ddp` to false.

- `facts-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `fetch@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `force-ssl-common@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `force-ssl@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `geojson-utils@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `github-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `github-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `google-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `google-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `hot-code-push@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `http@`:
  - Updated handlers to use `handlers`
- `id-map@2.0.0`:

  - Added `forEachAsync` method.

- `insecure@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `inter-process-messaging@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `launch-screen@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `localstorage@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `logging@2.0.0`:

  - Added dependency to `@babel/runtime`.

- `logic-solver@3.0.0`:
  `Logic.disablingAssertions` is now async.
  `minMaxWS` is now async.

- `meetup-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `meetup-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `meteor-base@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `meteor-developer-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `meteor-developer-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `meteor-tool@3.0.0`:

  - Changes to how meteor apps are being created [PR](https://github.com/meteor/meteor/pull/12697)

- `meteor@2.0.0`:

  - Async local storage was added to help deal with async methods.
  - Added `promiseEmmiter` to help with async methods.
  - Removed `fibers` from package.
  - `Meteor.absoluteUrl` in localhost uses `127.0.1` by default.

- `minifier-css@2.0.0`:

  - `minifyCss` is now async.
  - Removed `fibers` from package.

- `minifier-js@3.0.0`:

  - `minifyJs` is now async.
  - `terserMinify` no longer takes callbacks
  - Removed `fibers` from package.

* `minimongo@2.0.0`:
  - `cursor.observe` now returns `isReady` and `isReadyPromise` wich indicates
    if the cursor is ready and if the callbacks are have been called.
    If you only use it in the `Client` or as a `LocalCollection` things have not
    changed.

- `mobile-experience@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `mobile-status-bar@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `modern-browsers@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `modules-runtime@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `modules@1.0.0`:

  - Updated `reify` version.

- `mongo-decimal@`:

  - Updated to use `async` methods.

- `mongo-dev-server@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `mongo-id@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `mongo-livedata@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `mongo@2.0.0`:

  - Updated to unify methods, `update`,`insert`,`remove`, `fetch` are now async, they are
    the same as their `*Async` counterpart.
  - `ensureIndex` and `createIndex` are now async.

- `npm-mongo@5.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `oauth-encryption@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `oauth@`:

  - `_endOfPopupResponseTemplate` and `_endOfRedirectResponseTemplate` are no longer a property but now a function that returns a promise of the same value as before
  - the following server methods are now async:
  - `OAuth._renderOauthResults`
  - `OAuth._endOfLoginResponse`
  - `OAuth.renderEndOfLoginResponse`
  - `OAuth._storePendingCredential`
  - `OAuth._retrievePendingCredential`
  - `ensureConfigured`
  - `_cleanStaleResults`

- `oauth@3.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `oauth1@`:

  - the following server methods are now async:
  - `OAuth._storeRequestToken`
  - `OAuth._retrieveRequestToken`

- `oauth1@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `oauth2@`:

  - `OAuth._requestHandlers['2']` is now async.

- `oauth2@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `ordered-dict@2.0.0`:

  - Added `forEachAsync` method.

- `package-stats-opt-out@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `package-version-parser@4.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `promise@1.0.0`:

  - Removed `fibers` usage

- `random@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `rate-limit@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `reactive-dict@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `reactive-var@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `reload-safetybelt@2.0.0`:

  - Added `ecmascript` package to `package.js`

- `reload@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `retry@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `routepolicy@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `server-render@1.0.0`:

  - Updated usage with `getBoilerplate` that are now `async`.

- `service-configuration@2.0.0`:

  - Updated to use `createIndexAsync`.

- `session@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `sha@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `shell-server@1.0.0`:

  - Updated to handle promises results.

- `socket-stream-client@1.0.0`:

  - Updated tests to handle `async` code.

- `spiderable@`:

  - Updated handlers to use `handlers` that are now using express
  - removed `fibers` usage if flag is set to `true`

- `standard-minifier-css@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `standard-minifier-js@3.0.0`:

  - `processFilesForBundle` is now `async`.

- `standard-minifiers@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `static-html@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `test-helpers@2.0.0`:

  - Updated to use `async` methods.
  - Removed `fibers` usage.
  - Added possibliy to use `async` tests.

- `test-in-browser@2.0.0`:

  - Updated css to be in dark mode.

- `test-in-console@2.0.0`:

  - Updated log identation.

- `test-server-tests-in-console-once@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `tinytest-harness@1.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `tinytest@2.0.0`:

  - Added `test name` to logs.
  - Removed `fibers` usage.

- `twitter-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `twitter-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `typescript@5.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `underscore-tests@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `underscore@2.0.0`:

  - Removed dependency in meteor package.

- `url@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `webapp-hashing@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `webapp@2.0.0`:

  - These methods are now async:

    - `WebAppInternals.reloadClientPrograms()`
    - `WebAppInternals.pauseClient()`
    - `WebAppInternals.generateClientProgram()`
    - `WebAppInternals.generateBoilerplate()`
    - `WebAppInternals.setInlineScriptsAllowed()`
    - `WebAppInternals.enableSubresourceIntegrity()`
    - `WebAppInternals.setBundledJsCssUrlRewriteHook()`
    - `WebAppInternals.setBundledJsCssPrefix()`
    - `WebAppInternals.getBoilerplate`

  - Changed engine from connect to express and changed api naming to match express. See below:
  - `WebApp.connectHandlers.use(middleware)` is now `WebApp.handlers.use(middleware)`
  - `WebApp.rawConnectHandlers.use(middleware)` is now `WebApp.rawHandlers.use(middleware)`
  - `WebApp.connectApp` is now `WebApp.expressApp`
  - `WebApp.addRuntimeConfigHook` accepts async callbacks

- `weibo-config-ui@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

- `weibo-oauth@2.0.0`:

  - Package was bumped due to a dependency update. No code changes were made.

#### New Public API


- `Build system` [PR](https://github.com/meteor/meteor/pull/13030):
  - Assets.getTextAsync
  - Assets.getBinaryAsync

- `accounts-base`: (2.9+)

  - `Meteor.userAsync()`

- `callback-hook`:forEachAsync

  - `forEachAsync`

- `ddp-server`: (2.8+)

  - `Meteor.callAsync()`

- `minifier-css`: (2.9+)

  - `CssTools.minifyCssAsync()`

- `mongo`:

  - `Mongo.Collection`: (2.8+)
    - `createCappedCollectionAsync`
    - `createIndexAsync`
    - `dropCollectionAsync`
    - `dropIndexAsync`
    - `findOneAsync`
    - `insertAsync`
    - `removeAsync`
    - `updateAsync`
    - `upsertAsync`
  - `Collection.Cursor`: (2.8+)
    - `countAsync`
    - `fetchAsync`
    - `forEachAsync`
    - `mapAsync`
    - `[Symbol.asyncIterator]` so this code should work:
      ```js
      for await (const document of collection.find(query, options)) /* ... */
      ```

#### Internal API changes

`accounts-base`:

- `_attemptLogin`
- `_loginMethod`
- `_runLoginHandlers`

* Upgraded `node-gyp` to v9.4.0
* Upgraded `node-pre-gyp` to `@mapbox/node-pre-gyp` v1.0.11

#### New Internal API

`accounts-password`:

- `Accounts._checkPasswordAsync`

#### Special thanks to

- [@StorytellerCZ](https://github.com/sponsors/StorytellerCZ/)

For making this great framework even better!
