



# Introduction {#introduction}

:::info You are reading the Meteor 3 documentation!

- Searching for the Meteor 2 documentation? Access the [Meteor 2 Docs](https://v2-docs.meteor.com/).
- Upgrading from Meteor 2? Check out the [Migration Guide](https://v3-migration-docs.meteor.com/).
  :::

Meteor is a full-stack JavaScript platform for developing modern web and mobile applications. Meteor includes a key set of technologies for building connected-client reactive applications, a build tool, and a curated set of packages from the Node.js and general JavaScript community.

- Meteor allows you to develop in **one language**, JavaScript or TypeScript, in all environments: application server, web browser, and mobile device.

- Meteor uses **data on the wire**, meaning the server sends data, not HTML, and the client renders it.

- Meteor **embraces the ecosystem**, bringing the best parts of the extremely active JavaScript community to you in a careful and considered way.

- Meteor provides **full stack reactivity**, allowing your UI to seamlessly reflect the true state of the world with minimal development effort.

- Meteor offers **flexibility in front-end** development, allowing you to choose your preferred framework such as React, Vue, Blaze, Svelte, or Solid.

- Meteor **simplifies back-end and front-end integration** through Methods, its built-in Remote Procedure Call (RPC) system for seamless communication.

- Meteor includes a **ready-to-use Login and Accounts** package, eliminating the need to rebuild authentication systems for your applications.

## Meteor Resources {#learning-more}

### Learning Meteor

- Start by learning how to install Meteor in the [Installation Section](/about/install.html).

- The tutorials are the perfect place to start. Build a simple app to manage a task list! Available for [React](/tutorials/react/index.html), and [Vue 3](/tutorials/vue/meteorjs3-vue3-vue-meteor-tracker.html). Blaze and Svelte tutorials are coming soon.

- Participate in Meteor's fully professional, engaging and interactive online school. Join [Meteor University](https://university.meteor.com/). Our courses cover Meteor 2 but most of the content is still relevant.

- Subscribe to our official [Youtube channel](https://www.youtube.com/@meteorsoftware) and watch the latest MeteorJS videos and presentations.

### Developer Resources

- Explore and contribute to our [GitHub repository](https://github.com/meteor). You can access our code, request new features, and start contributing.

- Enhance your coding experience with the [VS Code Extension](https://marketplace.visualstudio.com/items?itemName=meteor-toolbox.meteor-toolbox), which provides IntelliSense support for Meteor's core and packages.

- Use the [Chrome Extension](https://chrome.google.com/webstore/detail/meteor-devtools-evolved/ibniinmoafhgbifjojidlagmggecmpgf) or [Firefox Extension](https://addons.mozilla.org/en-US/firefox/addon/meteor-devtools-evolved/) for insights into your app's performance and to understand what is going on under the hood of your application.

- Discover [Meteor Examples](https://github.com/meteor/examples) to see a range of projects built with Meteor.

- Visit [Atmosphere](https://atmospherejs.com), the dedicated repository for Meteor community packages.

### Join Our Community

- Participate in the [Official Forum](https://forums.meteor.com) for project news, support, and community discussions.

- Join the discussion and live streams on the official [Meteor Lounge Discord](https://discord.gg/hZkTCaVjmT).

- Engage with peers in the [Meteor Slack Community](https://join.slack.com/t/meteor-community/shared_invite/enQtODA0NTU2Nzk5MTA3LWY5NGMxMWRjZDgzYWMyMTEyYTQ3MTcwZmU2YjM5MTY3MjJkZjQ0NWRjOGZlYmIxZjFlYTA5Mjg4OTk3ODRiOTc).
