*This file is automatically generated from [`doctool.js`](doctool.js).*

# doctool.js

Usage: `doctool.js ...jsfiles...`

Reads each `.js` file and writes a `.md` file in the same directory.
The output file consists of the concatenation of the "doc comments"
in the input file, which are assumed to contain Markdown content,
including any section headings necessary to organize the file.

A "doc comment" must begin at the start of a line or after
whitespace.  There are two kinds of doc comments: `/** ... */`
(block) comments and `/// ...` (triple-slash) comments.

If a file begins with the magic string "///!README", the output
filename is changed to `README.md`.

Examples:

```
/**
 * This is a block comment.  The parser strips the sequence,
 * [optional whitespace, `*`, optional single space] from
 * every line that has it.
 *
For lines that don't, no big deal.

    Leading whitespace will be preserved here.

 * We can create a bullet list in here:
 *
 * * This is a bullet
 */
```

```
/** Single-line block comments are also ok. */
```

```
/**
A block comment whose first line doesn't have a `*` receives
no stripping of `*` characters on any line.

* This is a bullet

*/
```

```
/// A triple-slash comment starts with `///` followed by an
/// optional space (i.e. one space is removed if present).
/// Multiple consecutive lines that start with `///` are
/// treated together as a single doc comment.
/** Separate doc comments get separate paragraphs. */
```
