import { Showdown } from './showdown';

if (Package.templating) {
  var Template = Package.templating.Template;
  var Blaze = Package.blaze.Blaze; // implied by `templating`
  var HTML = Package.htmljs.HTML; // implied by `blaze`

  Blaze.Template.registerHelper("markdown", new Template('markdown', function () {
    var view = this;
    var content = '';
    if (view.templateContentBlock) {
      content = Blaze._toText(view.templateContentBlock, HTML.TEXTMODE.STRING);
    }
    var converter = new Showdown.converter();
    return HTML.Raw(converter.makeHtml(content));
  }));
}
