// This file contains data for tests in benchmark-tests.js.

// It defines the variables `railsGems` and `sinatraGems`.

// The data has been heavily adapted and is not semantically
// equivalent to its original source.  It's just a big dataset to
// throw at the solver that is sort of organic and semi-realistic.

railsGems = [
  {"name":"rack-cache","number":"1.2.0","dependencies":[]},
  {"name":"htmlentities","number":"4.0.0","dependencies":[]},
  {"name":"hpricot","number":"0.10.0","dependencies":[]},
  {"name":"hpricot","number":"1.10.0","dependencies":[]},
  {"name":"roauth","number":"0.5.0","dependencies":[]},
  {"name":"rack-accept","number":"1.5.0","dependencies":[]},
  {"name":"mini-portile","number":"0.5.0","dependencies":[]},
  {"name":"actionview","number":"4.1.0","dependencies":[]},
  {"name":"redis-rack-cache","number":"1.1.0","dependencies":[]},
  {"name":"jnunemaker-crack","number":"0.2.0","dependencies":[]},
  {"name":"echoe","number":"1.2.2","dependencies":[]},
  {"name":"hoe","number":"1.2.2","dependencies":[]},
  {"name":"hoe","number":"1.3.0","dependencies":[]},
  {"name":"hoe","number":"1.20.3","dependencies":[]},
  {"name":"hoe","number":"2.20.1","dependencies":[]},
  {"name":"unicode","number":"0.4.4","dependencies":[]},
  {"name":"fog-brightbox","number":"0.0.1","dependencies":[]},
  {"name":"fog-json","number":"0.0.1","dependencies":[]},
  {"name":"fog-core","number":"1.21.1","dependencies":[]},
  {"name":"mongrel","number":"1.1.1","dependencies":[]},
  {"name":"bundler","number":"1.0.0","dependencies":[]},
  {"name":"bundler","number":"1.0.2","dependencies":[]},
  {"name":"bundler","number":"1.1.0","dependencies":[]},
  {"name":"bundler","number":"1.2.0","dependencies":[]},
  {"name":"bundler","number":"1.3.0","dependencies":[]},
  {"name":"bundler","number":"1.4.0","dependencies":[]},
  {"name":"bundler","number":"1.5.0","dependencies":[]},
  {"name":"bundler","number":"1.6.0","dependencies":[]},
  {"name":"bundler","number":"1.7.0","dependencies":[]},
  {"name":"bundler","number":"1.8.0","dependencies":[]},
  {"name":"bundler","number":"1.9.0","dependencies":[]},
  {"name":"bundler","number":"2.0.0","dependencies":[]},
  {"name":"bcrypt","number":"3.1.7","dependencies":[]},
  {"name":"bcrypt","number":"3.1.6","dependencies":[]},
  {"name":"bcrypt","number":"3.1.3","dependencies":[]},
  {"name":"shotgun","number":"0.6.0","dependencies":[["rack",null]]},
  {"name":"shotgun","number":"0.4.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.5.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.7.0","dependencies":[["rack","1.0.0"]]},
  {"name":"shotgun","number":"0.8.0","dependencies":[["rack","1.0.0"]]},
  {"name":"shotgun","number":"0.2.0","dependencies":[["rack",null],["launchy",null],["rack",null],["launchy",null]]},
  {"name":"shotgun","number":"0.1.0","dependencies":[["rack",null],["rack",null]]},
  {"name":"shotgun","number":"0.3.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.9.0","dependencies":[["rack","1.0.0"]]},
  {"name":"backports","number":"0.15.0","dependencies":[]},
  {"name":"backports","number":"1.15.0","dependencies":[]},
  {"name":"backports","number":"2.15.0","dependencies":[]},
  {"name":"backports","number":"3.15.0","dependencies":[]},
  {"name":"sprockets-sass","number":"1.0.0","dependencies":[]},
  {"name":"ace-rails-ap","number":"2.0.1","dependencies":[]},
  {"name":"ace-rails-ap","number":"0.0.1","dependencies":[]},
  {"name":"ace-rails-ap","number":"0.0.2","dependencies":[]},
  {"name":"ace-rails-ap","number":"1.0.0","dependencies":[]},
  {"name":"ace-rails-ap","number":"0.0.3","dependencies":[]},
  {"name":"ace-rails-ap","number":"2.0.0","dependencies":[]},
  {"name":"actionmailer","number":"4.0.4","dependencies":[["mail","2.5.4"],["actionpack","=4.0.4"]]},
  {"name":"actionmailer","number":"3.2.17","dependencies":[["mail","2.5.4"],["actionpack","=3.2.17"]]},
  {"name":"actionmailer","number":"4.0.3","dependencies":[["mail","2.5.4"],["actionpack","=4.0.3"]]},
  {"name":"actionmailer","number":"4.0.2","dependencies":[["mail","2.5.4"],["actionpack","=4.0.2"]]},
  {"name":"actionmailer","number":"3.2.16","dependencies":[["mail","2.5.4"],["actionpack","=3.2.16"]]},
  {"name":"actionmailer","number":"4.0.1","dependencies":[["mail","2.5.4"],["actionpack","=4.0.1"]]},
  {"name":"actionmailer","number":"3.2.15","dependencies":[["mail","2.5.4"],["actionpack","=3.2.15"]]},
  {"name":"actionmailer","number":"0.9.0","dependencies":[["actionpack","=1.8.0"]]},
  {"name":"actionmailer","number":"1.2.4","dependencies":[["actionpack","=1.12.4"]]},
  {"name":"actionmailer","number":"1.3.2","dependencies":[["actionpack","=1.13.2"]]},
  {"name":"actionmailer","number":"0.9.1","dependencies":[["actionpack","=1.8.1"]]},
  {"name":"actionmailer","number":"1.1.4","dependencies":[["actionpack","=1.11.1"]]},
  {"name":"actionmailer","number":"2.2.3","dependencies":[["actionpack","=2.2.3"]]},
  {"name":"actionmailer","number":"1.3.1","dependencies":[["actionpack","=1.13.1"]]},
  {"name":"actionmailer","number":"0.4.0","dependencies":[["actionpack",null]]},
  {"name":"actionmailer","number":"1.0.1","dependencies":[["actionpack","=1.9.1"]]},
  {"name":"actionmailer","number":"2.3.4","dependencies":[["actionpack","=2.3.4"]]},
  {"name":"actionmailer","number":"3.0.15","dependencies":[["actionpack","=3.0.15"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.2.2","dependencies":[["actionpack","=3.2.2"],["mail","2.4.0"]]},
  {"name":"actionmailer","number":"2.3.11","dependencies":[["actionpack","=2.3.11"]]},
  {"name":"actionmailer","number":"2.3.10","dependencies":[["actionpack","=2.3.10"]]},
  {"name":"actionmailer","number":"1.2.5","dependencies":[["actionpack","=1.12.5"]]},
  {"name":"actionmailer","number":"3.0.6","dependencies":[["actionpack","=3.0.6"],["mail","2.2.15"]]},
  {"name":"actionmailer","number":"3.0.16","dependencies":[["actionpack","=3.0.16"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"2.3.8","dependencies":[["actionpack","=2.3.8"]]},
  {"name":"actionmailer","number":"1.1.1","dependencies":[["actionpack","=1.10.1"]]},
  {"name":"actionmailer","number":"2.0.0","dependencies":[["actionpack","=2.0.0"]]},
  {"name":"actionmailer","number":"2.1.1","dependencies":[["actionpack","=2.1.1"]]},
  {"name":"actionmailer","number":"2.3.2","dependencies":[["actionpack","=2.3.2"]]},
  {"name":"actionmailer","number":"1.2.2","dependencies":[["actionpack","=1.12.2"]]},
  {"name":"actionmailer","number":"0.7.0","dependencies":[["actionpack","=1.5.0"]]},
  {"name":"actionmailer","number":"3.0.3","dependencies":[["actionpack","=3.0.3"],["mail","2.2.9"]]},
  {"name":"actionmailer","number":"3.0.10","dependencies":[["actionpack","=3.0.10"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.0.0","dependencies":[["actionpack","=3.0.0"],["mail","2.2.5"]]},
  {"name":"actionmailer","number":"3.0.14","dependencies":[["actionpack","=3.0.14"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"1.1.3","dependencies":[["actionpack","=1.11.0"]]},
  {"name":"actionmailer","number":"0.5.0","dependencies":[["actionpack",null]]},
  {"name":"actionmailer","number":"3.1.0","dependencies":[["actionpack","=3.1.0"],["mail","2.3.0"]]},
  {"name":"actionmailer","number":"1.2.0","dependencies":[["actionpack","=1.12.0"]]},
  {"name":"actionmailer","number":"1.3.5","dependencies":[["actionpack","=1.13.5"]]},
  {"name":"actionmailer","number":"1.3.6","dependencies":[["actionpack","=1.13.6"]]},
  {"name":"actionmailer","number":"3.2.0","dependencies":[["actionpack","=3.2.0"],["mail","2.4.0"]]},
  {"name":"actionmailer","number":"3.2.4","dependencies":[["actionpack","=3.2.4"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"2.1.2","dependencies":[["actionpack","=2.1.2"]]},
  {"name":"actionmailer","number":"3.0.9","dependencies":[["actionpack","=3.0.9"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.1.8","dependencies":[["actionpack","=3.1.8"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"3.2.3","dependencies":[["actionpack","=3.2.3"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.2.5","dependencies":[["actionpack","=3.2.5"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.2.7","dependencies":[["actionpack","=3.2.7"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.1.4","dependencies":[["actionpack","=3.1.4"],["mail","2.3.0"]]},
  {"name":"actionmailer","number":"2.2.2","dependencies":[["actionpack","=2.2.2"]]},
  {"name":"actionmailer","number":"3.0.2","dependencies":[["actionpack","=3.0.2"],["mail","2.2.9"]]},
  {"name":"actionmailer","number":"1.1.2","dependencies":[["actionpack","=1.10.2"]]},
  {"name":"actionmailer","number":"2.3.6","dependencies":[["actionpack","=2.3.6"]]},
  {"name":"actionmailer","number":"3.0.17","dependencies":[["actionpack","=3.0.17"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.1.2","dependencies":[["actionpack","=3.1.2"],["mail","2.3.0"]]},
  {"name":"actionmailer","number":"3.1.5","dependencies":[["actionpack","=3.1.5"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"3.2.6","dependencies":[["actionpack","=3.2.6"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"0.7.1","dependencies":[["actionpack","=1.5.1"]]},
  {"name":"actionmailer","number":"2.0.1","dependencies":[["actionpack","=2.0.1"]]},
  {"name":"actionmailer","number":"2.3.12","dependencies":[["actionpack","=2.3.12"]]},
  {"name":"actionmailer","number":"1.0.0","dependencies":[["actionpack","=1.9.0"]]},
  {"name":"actionmailer","number":"1.3.0","dependencies":[["actionpack","=1.13.0"]]},
  {"name":"actionmailer","number":"1.2.1","dependencies":[["actionpack","=1.12.1"]]},
  {"name":"actionmailer","number":"3.0.1","dependencies":[["actionpack","=3.0.1"],["mail","2.2.5"]]},
  {"name":"actionmailer","number":"3.0.7","dependencies":[["actionpack","=3.0.7"],["mail","2.2.15"]]},
  {"name":"actionmailer","number":"2.3.5","dependencies":[["actionpack","=2.3.5"]]},
  {"name":"actionmailer","number":"2.0.2","dependencies":[["actionpack","=2.0.2"]]},
  {"name":"actionmailer","number":"0.6.0","dependencies":[["actionpack",null]]},
  {"name":"actionmailer","number":"2.3.7","dependencies":[["actionpack","=2.3.7"]]},
  {"name":"actionmailer","number":"2.0.5","dependencies":[["actionpack","=2.0.5"]]},
  {"name":"actionmailer","number":"3.0.12","dependencies":[["actionpack","=3.0.12"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"2.1.0","dependencies":[["actionpack","=2.1.0"]]},
  {"name":"actionmailer","number":"3.0.11","dependencies":[["actionpack","=3.0.11"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.1.7","dependencies":[["actionpack","=3.1.7"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"1.3.3","dependencies":[["actionpack","=1.13.3"]]},
  {"name":"actionmailer","number":"3.0.8","dependencies":[["actionpack","=3.0.8"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.2.8","dependencies":[["actionpack","=3.2.8"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"0.6.1","dependencies":[["actionpack",null]]},
  {"name":"actionmailer","number":"3.0.4","dependencies":[["actionpack","=3.0.4"],["mail","2.2.15"]]},
  {"name":"actionmailer","number":"1.1.5","dependencies":[["actionpack","=1.11.2"]]},
  {"name":"actionmailer","number":"1.3.4","dependencies":[["actionpack","=1.13.4"]]},
  {"name":"actionmailer","number":"0.3.0","dependencies":[["actionpack",null]]},
  {"name":"actionmailer","number":"3.1.1","dependencies":[["actionpack","=3.1.1"],["mail","2.3.0"]]},
  {"name":"actionmailer","number":"3.1.3","dependencies":[["actionpack","=3.1.3"],["mail","2.3.0"]]},
  {"name":"actionmailer","number":"2.3.9","dependencies":[["actionpack","=2.3.9"]]},
  {"name":"actionmailer","number":"3.1.6","dependencies":[["actionpack","=3.1.6"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"2.0.4","dependencies":[["actionpack","=2.0.4"]]},
  {"name":"actionmailer","number":"3.2.1","dependencies":[["actionpack","=3.2.1"],["mail","2.4.0"]]},
  {"name":"actionmailer","number":"2.3.14","dependencies":[["actionpack","=2.3.14"]]},
  {"name":"actionmailer","number":"3.0.13","dependencies":[["actionpack","=3.0.13"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"1.2.3","dependencies":[["actionpack","=1.12.3"]]},
  {"name":"actionmailer","number":"0.8.1","dependencies":[["actionpack","=1.7.0"]]},
  {"name":"actionmailer","number":"3.0.5","dependencies":[["actionpack","=3.0.5"],["mail","2.2.15"]]},
  {"name":"actionmailer","number":"0.8.0","dependencies":[["actionpack","=1.6.0"]]},
  {"name":"actionmailer","number":"2.3.3","dependencies":[["actionpack","=2.3.3"]]},
  {"name":"actionmailer","number":"3.2.9","dependencies":[["actionpack","=3.2.9"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.1.9","dependencies":[["actionpack","=3.1.9"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"3.2.10","dependencies":[["actionpack","=3.2.10"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.0.18","dependencies":[["actionpack","=3.0.18"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"3.0.19","dependencies":[["actionpack","=3.0.19"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"2.3.15","dependencies":[["actionpack","=2.3.15"]]},
  {"name":"actionmailer","number":"3.2.11","dependencies":[["actionpack","=3.2.11"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.1.10","dependencies":[["actionpack","=3.1.10"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"3.0.20","dependencies":[["actionpack","=3.0.20"],["mail","2.2.19"]]},
  {"name":"actionmailer","number":"2.3.16","dependencies":[["actionpack","=2.3.16"]]},
  {"name":"actionmailer","number":"2.3.17","dependencies":[["actionpack","=2.3.17"]]},
  {"name":"actionmailer","number":"3.2.12","dependencies":[["actionpack","=3.2.12"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.1.11","dependencies":[["actionpack","=3.1.11"],["mail","2.3.3"]]},
  {"name":"actionmailer","number":"2.3.18","dependencies":[["actionpack","=2.3.18"]]},
  {"name":"actionmailer","number":"3.1.12","dependencies":[["actionpack","=3.1.12"],["mail","2.4.4"]]},
  {"name":"actionmailer","number":"3.2.13","dependencies":[["actionpack","=3.2.13"],["mail","2.5.3"]]},
  {"name":"actionmailer","number":"4.0.0","dependencies":[["actionpack","=4.0.0"],["mail","2.5.3"]]},
  {"name":"actionmailer","number":"3.2.14","dependencies":[["actionpack","=3.2.14"],["mail","2.5.4"]]},
  {"name":"actionpack","number":"4.0.4","dependencies":[["erubis","2.7.0"],["rack-test","0.6.2"],["rack","1.5.2"],["builder","3.1.0"],["activesupport","=4.0.4"]]},
  {"name":"actionpack","number":"3.2.17","dependencies":[["erubis","2.7.0"],["sprockets","2.2.1"],["journey","1.0.4"],["rack-test","0.6.1"],["rack","1.4.5"],["builder","3.0.0"],["rack-cache","1.2.0"],["activemodel","=3.2.17"],["activesupport","=3.2.17"]]},
  {"name":"actionpack","number":"4.0.3","dependencies":[["erubis","2.7.0"],["rack-test","0.6.2"],["rack","1.5.2"],["builder","3.1.0"],["activesupport","=4.0.3"]]},
  {"name":"actionpack","number":"4.0.2","dependencies":[["erubis","2.7.0"],["rack-test","0.6.2"],["rack","1.5.2"],["builder","3.1.0"],["activesupport","=4.0.2"]]},
  {"name":"actionpack","number":"3.2.16","dependencies":[["erubis","2.7.0"],["sprockets","2.2.1"],["journey","1.0.4"],["rack-test","0.6.1"],["rack","1.4.5"],["builder","3.0.0"],["rack-cache","1.2.0"],["activemodel","=3.2.16"],["activesupport","=3.2.16"]]},
  {"name":"actionpack","number":"4.0.1","dependencies":[["erubis","2.7.0"],["rack-test","0.6.2"],["rack","1.5.2"],["builder","3.1.0"],["activesupport","=4.0.1"]]},
  {"name":"actionpack","number":"3.2.15","dependencies":[["erubis","2.7.0"],["sprockets","2.2.1"],["journey","1.0.4"],["rack-test","0.6.1"],["rack","1.4.5"],["builder","3.0.0"],["rack-cache","1.2.0"],["activemodel","=3.2.15"],["activesupport","=3.2.15"]]},
  {"name":"actionpack","number":"3.2.7","dependencies":[["activesupport","=3.2.7"],["activemodel","=3.2.7"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.1.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.7","dependencies":[["activesupport","=3.0.7"],["activemodel","=3.0.7"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.13","dependencies":[["activesupport","=3.0.13"],["activemodel","=3.0.13"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"2.3.8","dependencies":[["activesupport","=2.3.8"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"1.0.0","dependencies":[]},
  {"name":"actionpack","number":"1.12.2","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"actionpack","number":"3.0.1","dependencies":[["activesupport","=3.0.1"],["activemodel","=3.0.1"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"],["rack","1.2.1"],["rack-test","0.5.4"],["rack-mount","0.6.12"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"1.11.2","dependencies":[["activesupport","=1.2.5"]]},
  {"name":"actionpack","number":"3.2.0","dependencies":[["activesupport","=3.2.0"],["activemodel","=3.2.0"],["rack-cache","1.1.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.0"],["sprockets","2.1.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.1.1","dependencies":[["activesupport","=3.1.1"],["activemodel","=3.1.1"],["rack-cache","1.1.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.2"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.1.7","dependencies":[["activesupport","=3.1.7"],["activemodel","=3.1.7"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.4","dependencies":[["activesupport","=3.2.4"],["activemodel","=3.2.4"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"0.9.0","dependencies":[]},
  {"name":"actionpack","number":"1.0.1","dependencies":[]},
  {"name":"actionpack","number":"3.0.5","dependencies":[["activesupport","=3.0.5"],["activemodel","=3.0.5"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.13"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.12","dependencies":[["activesupport","=3.0.12"],["activemodel","=3.0.12"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.11","dependencies":[["activesupport","=3.0.11"],["activemodel","=3.0.11"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"1.3.1","dependencies":[]},
  {"name":"actionpack","number":"3.1.6","dependencies":[["activesupport","=3.1.6"],["activemodel","=3.1.6"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"1.3.0","dependencies":[]},
  {"name":"actionpack","number":"2.0.4","dependencies":[["activesupport","=2.0.4"]]},
  {"name":"actionpack","number":"1.12.3","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"actionpack","number":"1.12.4","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"actionpack","number":"3.2.6","dependencies":[["activesupport","=3.2.6"],["activemodel","=3.2.6"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.3","dependencies":[["activesupport","=3.0.3"],["activemodel","=3.0.3"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"],["rack","1.2.1"],["rack-test","0.5.6"],["rack-mount","0.6.13"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"1.12.5","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"actionpack","number":"3.1.2","dependencies":[["activesupport","=3.1.2"],["activemodel","=3.1.2"],["rack-cache","1.1.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.5"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.1.0"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"2.3.2","dependencies":[["activesupport","=2.3.2"]]},
  {"name":"actionpack","number":"1.10.2","dependencies":[["activesupport","=1.2.2"]]},
  {"name":"actionpack","number":"1.2.0","dependencies":[]},
  {"name":"actionpack","number":"1.8.0","dependencies":[["activesupport","=1.0.4"]]},
  {"name":"actionpack","number":"1.1.0","dependencies":[]},
  {"name":"actionpack","number":"3.1.0","dependencies":[["activesupport","=3.1.0"],["activemodel","=3.1.0"],["rack-cache","1.0.3"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.2"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.0"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"2.1.2","dependencies":[["activesupport","=2.1.2"]]},
  {"name":"actionpack","number":"2.1.0","dependencies":[["activesupport","=2.1.0"]]},
  {"name":"actionpack","number":"2.3.9","dependencies":[["activesupport","=2.3.9"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"2.3.14","dependencies":[["activesupport","=2.3.14"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"2.2.3","dependencies":[["activesupport","=2.2.3"]]},
  {"name":"actionpack","number":"1.13.5","dependencies":[["activesupport","=1.4.4"]]},
  {"name":"actionpack","number":"3.0.14","dependencies":[["activesupport","=3.0.14"],["activemodel","=3.0.14"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"1.11.0","dependencies":[["activesupport","=1.2.3"]]},
  {"name":"actionpack","number":"2.3.3","dependencies":[["activesupport","=2.3.3"],["rack","1.0.0"]]},
  {"name":"actionpack","number":"2.2.2","dependencies":[["activesupport","=2.2.2"]]},
  {"name":"actionpack","number":"2.3.4","dependencies":[["activesupport","=2.3.4"],["rack","1.0.0"]]},
  {"name":"actionpack","number":"1.7.0","dependencies":[["activesupport","=1.0.3"]]},
  {"name":"actionpack","number":"3.0.9","dependencies":[["activesupport","=3.0.9"],["activemodel","=3.0.9"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.10","dependencies":[["activesupport","=3.0.10"],["activemodel","=3.0.10"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.0","dependencies":[["activesupport","=3.0.0"],["activemodel","=3.0.0"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"],["rack","1.2.1"],["rack-test","0.5.4"],["rack-mount","0.6.12"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"2.1.1","dependencies":[["activesupport","=2.1.1"]]},
  {"name":"actionpack","number":"1.13.1","dependencies":[["activesupport","=1.4.0"]]},
  {"name":"actionpack","number":"2.3.12","dependencies":[["activesupport","=2.3.12"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"1.4.0","dependencies":[]},
  {"name":"actionpack","number":"2.3.11","dependencies":[["activesupport","=2.3.11"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"0.9.5","dependencies":[]},
  {"name":"actionpack","number":"2.0.0","dependencies":[["activesupport","=2.0.0"]]},
  {"name":"actionpack","number":"2.3.7","dependencies":[["activesupport","=2.3.7"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"1.6.0","dependencies":[["activesupport","=1.0.2"]]},
  {"name":"actionpack","number":"1.5.0","dependencies":[["activesupport","=1.0.0"]]},
  {"name":"actionpack","number":"2.3.6","dependencies":[["activesupport","=2.3.6"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"1.9.0","dependencies":[["activesupport","=1.1.0"]]},
  {"name":"actionpack","number":"1.13.6","dependencies":[["activesupport","=1.4.4"]]},
  {"name":"actionpack","number":"1.12.1","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"actionpack","number":"2.0.1","dependencies":[["activesupport","=2.0.1"]]},
  {"name":"actionpack","number":"1.9.1","dependencies":[["activesupport","=1.1.1"]]},
  {"name":"actionpack","number":"1.10.1","dependencies":[["activesupport","=1.2.1"]]},
  {"name":"actionpack","number":"1.12.0","dependencies":[["activesupport","=1.3.0"]]},
  {"name":"actionpack","number":"2.0.2","dependencies":[["activesupport","=2.0.2"]]},
  {"name":"actionpack","number":"2.0.5","dependencies":[["activesupport","=2.0.5"]]},
  {"name":"actionpack","number":"1.13.4","dependencies":[["activesupport","=1.4.3"]]},
  {"name":"actionpack","number":"1.13.2","dependencies":[["activesupport","=1.4.1"]]},
  {"name":"actionpack","number":"3.1.3","dependencies":[["activesupport","=3.1.3"],["activemodel","=3.1.3"],["rack-cache","1.1.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.5"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.15","dependencies":[["activesupport","=3.0.15"],["activemodel","=3.0.15"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.16","dependencies":[["activesupport","=3.0.16"],["activemodel","=3.0.16"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.1.5","dependencies":[["activesupport","=3.1.5"],["activemodel","=3.1.5"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.17","dependencies":[["activesupport","=3.0.17"],["activemodel","=3.0.17"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.1.8","dependencies":[["activesupport","=3.1.8"],["activemodel","=3.1.8"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.1","dependencies":[["activesupport","=3.2.1"],["activemodel","=3.2.1"],["rack-cache","1.1.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.8","dependencies":[["activesupport","=3.2.8"],["activemodel","=3.2.8"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.1.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.2","dependencies":[["activesupport","=3.0.2"],["activemodel","=3.0.2"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"],["rack","1.2.1"],["rack-test","0.5.6"],["rack-mount","0.6.13"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"2.3.10","dependencies":[["activesupport","=2.3.10"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"3.0.6","dependencies":[["activesupport","=3.0.6"],["activemodel","=3.0.6"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.0.8","dependencies":[["activesupport","=3.0.8"],["activemodel","=3.0.8"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"2.3.5","dependencies":[["activesupport","=2.3.5"],["rack","1.0.0"]]},
  {"name":"actionpack","number":"3.0.4","dependencies":[["activesupport","=3.0.4"],["activemodel","=3.0.4"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"],["rack","1.2.1"],["rack-test","0.5.7"],["rack-mount","0.6.13"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.2.2","dependencies":[["activesupport","=3.2.2"],["activemodel","=3.2.2"],["rack-cache","1.1.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.3","dependencies":[["activesupport","=3.2.3"],["activemodel","=3.2.3"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.5","dependencies":[["activesupport","=3.2.5"],["activemodel","=3.2.5"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.1"],["sprockets","2.1.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"1.8.1","dependencies":[["activesupport","=1.0.4"]]},
  {"name":"actionpack","number":"1.13.3","dependencies":[["activesupport","=1.4.2"]]},
  {"name":"actionpack","number":"1.13.0","dependencies":[["activesupport","=1.4.0"]]},
  {"name":"actionpack","number":"1.11.1","dependencies":[["activesupport","=1.2.4"]]},
  {"name":"actionpack","number":"1.5.1","dependencies":[["activesupport","=1.0.1"]]},
  {"name":"actionpack","number":"3.1.4","dependencies":[["activesupport","=3.1.4"],["activemodel","=3.1.4"],["rack-cache","1.1.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.3"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.9","dependencies":[["activesupport","=3.2.9"],["activemodel","=3.2.9"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.18","dependencies":[["activesupport","=3.0.18"],["activemodel","=3.0.18"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.2.10","dependencies":[["activesupport","=3.2.10"],["activemodel","=3.2.10"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.1.9","dependencies":[["activesupport","=3.1.9"],["activemodel","=3.1.9"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.11","dependencies":[["activesupport","=3.2.11"],["activemodel","=3.2.11"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.0"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.0.19","dependencies":[["activesupport","=3.0.19"],["activemodel","=3.0.19"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"3.1.10","dependencies":[["activesupport","=3.1.10"],["activemodel","=3.1.10"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"2.3.15","dependencies":[["activesupport","=2.3.15"],["rack","1.1.3"]]},
  {"name":"actionpack","number":"2.3.16","dependencies":[["activesupport","=2.3.16"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"3.0.20","dependencies":[["activesupport","=3.0.20"],["activemodel","=3.0.20"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"],["rack","1.2.5"],["rack-test","0.5.7"],["rack-mount","0.6.14"],["tzinfo","0.3.23 || 1.0.0"],["erubis","2.6.6"]]},
  {"name":"actionpack","number":"2.3.17","dependencies":[["activesupport","=2.3.17"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"3.2.12","dependencies":[["activesupport","=3.2.12"],["activemodel","=3.2.12"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.5"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.1.11","dependencies":[["activesupport","=3.1.11"],["activemodel","=3.1.11"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"2.3.18","dependencies":[["activesupport","=2.3.18"],["rack","1.1.0"]]},
  {"name":"actionpack","number":"3.1.12","dependencies":[["activesupport","=3.1.12"],["activemodel","=3.1.12"],["rack-cache","1.2.0"],["builder","3.0.0"],["i18n","0.6.0"],["rack","1.3.6"],["rack-test","0.6.1"],["rack-mount","0.8.2"],["sprockets","2.0.4"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.13","dependencies":[["activesupport","=3.2.13"],["activemodel","=3.2.13"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.5"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"4.0.0","dependencies":[["activesupport","=4.0.0"],["builder","3.1.0"],["rack","1.5.2"],["rack-test","0.6.2"],["erubis","2.7.0"]]},
  {"name":"actionpack","number":"3.2.14","dependencies":[["activesupport","=3.2.14"],["activemodel","=3.2.14"],["rack-cache","1.2.0"],["builder","3.0.0"],["rack","1.4.5"],["rack-test","0.6.1"],["journey","1.0.4"],["sprockets","2.2.1"],["erubis","2.7.0"]]},
  {"name":"actionpack-action-caching","number":"1.1.1","dependencies":[["actionpack","4.0.0"]]},
  {"name":"actionpack-action-caching","number":"1.1.0","dependencies":[["actionpack","4.0.0"]]},
  {"name":"actionpack-action-caching","number":"1.0.0","dependencies":[["actionpack","4.0.0"]]},
  {"name":"actionpack-page-caching","number":"1.0.2","dependencies":[["actionpack","4.0.0"]]},
  {"name":"actionpack-page-caching","number":"1.0.1","dependencies":[["actionpack","4.0.0"]]},
  {"name":"actionpack-page-caching","number":"1.0.0","dependencies":[["actionpack","4.0.0"]]},
  {"name":"activemodel","number":"4.0.4","dependencies":[["builder","3.1.0"],["activesupport","=4.0.4"]]},
  {"name":"activemodel","number":"3.2.17","dependencies":[["builder","3.0.0"],["activesupport","=3.2.17"]]},
  {"name":"activemodel","number":"4.0.3","dependencies":[["builder","3.1.0"],["activesupport","=4.0.3"]]},
  {"name":"activemodel","number":"4.0.2","dependencies":[["builder","3.1.0"],["activesupport","=4.0.2"]]},
  {"name":"activemodel","number":"3.2.16","dependencies":[["builder","3.0.0"],["activesupport","=3.2.16"]]},
  {"name":"activemodel","number":"4.0.1","dependencies":[["builder","3.1.0"],["activesupport","=4.0.1"]]},
  {"name":"activemodel","number":"3.2.15","dependencies":[["builder","3.0.0"],["activesupport","=3.2.15"]]},
  {"name":"activemodel","number":"3.0.2","dependencies":[["activesupport","=3.0.2"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"]]},
  {"name":"activemodel","number":"3.2.7","dependencies":[["activesupport","=3.2.7"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.3","dependencies":[["activesupport","=3.0.3"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"]]},
  {"name":"activemodel","number":"3.0.15","dependencies":[["activesupport","=3.0.15"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.1","dependencies":[["activesupport","=3.1.1"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.0.6","dependencies":[["activesupport","=3.0.6"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.2.4","dependencies":[["activesupport","=3.2.4"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.2.5","dependencies":[["activesupport","=3.2.5"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.11","dependencies":[["activesupport","=3.0.11"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.9","dependencies":[["activesupport","=3.0.9"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.5","dependencies":[["activesupport","=3.0.5"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"]]},
  {"name":"activemodel","number":"3.0.7","dependencies":[["activesupport","=3.0.7"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.0","dependencies":[["activesupport","=3.0.0"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"]]},
  {"name":"activemodel","number":"3.0.10","dependencies":[["activesupport","=3.0.10"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.1","dependencies":[["activesupport","=3.0.1"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.1"]]},
  {"name":"activemodel","number":"3.0.8","dependencies":[["activesupport","=3.0.8"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.2","dependencies":[["activesupport","=3.1.2"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.1","dependencies":[["activesupport","=3.2.1"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.1.5","dependencies":[["activesupport","=3.1.5"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.2","dependencies":[["activesupport","=3.2.2"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.14","dependencies":[["activesupport","=3.0.14"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.16","dependencies":[["activesupport","=3.0.16"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.2.3","dependencies":[["activesupport","=3.2.3"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.1.6","dependencies":[["activesupport","=3.1.6"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.1.0","dependencies":[["activesupport","=3.1.0"],["builder","3.0.0"],["i18n","0.6.0"],["bcrypt-ruby","3.0.0"]]},
  {"name":"activemodel","number":"3.2.0","dependencies":[["activesupport","=3.2.0"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.1.4","dependencies":[["activesupport","=3.1.4"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.0.17","dependencies":[["activesupport","=3.0.17"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.7","dependencies":[["activesupport","=3.1.7"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.1.8","dependencies":[["activesupport","=3.1.8"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.6","dependencies":[["activesupport","=3.2.6"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.2.8","dependencies":[["activesupport","=3.2.8"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.4","dependencies":[["activesupport","=3.0.4"],["builder","2.1.2 || 3.0.0"],["i18n","0.4.0"]]},
  {"name":"activemodel","number":"3.0.12","dependencies":[["activesupport","=3.0.12"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.0.13","dependencies":[["activesupport","=3.0.13"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.3","dependencies":[["activesupport","=3.1.3"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.9","dependencies":[["activesupport","=3.2.9"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.2.10","dependencies":[["activesupport","=3.2.10"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.18","dependencies":[["activesupport","=3.0.18"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.9","dependencies":[["activesupport","=3.1.9"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.1.10","dependencies":[["activesupport","=3.1.10"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.0.19","dependencies":[["activesupport","=3.0.19"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.2.11","dependencies":[["activesupport","=3.2.11"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.0.20","dependencies":[["activesupport","=3.0.20"],["builder","2.1.2 || 3.0.0"],["i18n","0.5.0"]]},
  {"name":"activemodel","number":"3.1.11","dependencies":[["activesupport","=3.1.11"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.12","dependencies":[["activesupport","=3.2.12"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"3.1.12","dependencies":[["activesupport","=3.1.12"],["builder","3.0.0"],["i18n","0.6.0"]]},
  {"name":"activemodel","number":"3.2.13","dependencies":[["activesupport","=3.2.13"],["builder","3.0.0"]]},
  {"name":"activemodel","number":"4.0.0","dependencies":[["activesupport","=4.0.0"],["builder","3.1.0"]]},
  {"name":"activemodel","number":"3.2.14","dependencies":[["activesupport","=3.2.14"],["builder","3.0.0"]]},
  {"name":"activerecord","number":"4.0.4","dependencies":[["activerecord-deprecated-finders","1.0.2"],["arel","4.0.0 || 5.0.0"],["activemodel","=4.0.4"],["activesupport","=4.0.4"]]},
  {"name":"activerecord","number":"3.2.17","dependencies":[["tzinfo","0.3.29 || 1.0.0"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["activemodel","=3.2.17"],["activesupport","=3.2.17"]]},
  {"name":"activerecord","number":"4.0.3","dependencies":[["activerecord-deprecated-finders","1.0.2"],["arel","4.0.0 || 5.0.0"],["activemodel","=4.0.3"],["activesupport","=4.0.3"]]},
  {"name":"activerecord","number":"4.0.2","dependencies":[["activerecord-deprecated-finders","1.0.2"],["arel","4.0.0 || 5.0.0"],["activemodel","=4.0.2"],["activesupport","=4.0.2"]]},
  {"name":"activerecord","number":"3.2.16","dependencies":[["tzinfo","0.3.29 || 1.0.0"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["activemodel","=3.2.16"],["activesupport","=3.2.16"]]},
  {"name":"activerecord","number":"4.0.1","dependencies":[["activerecord-deprecated-finders","1.0.2"],["arel","4.0.0 || 5.0.0"],["activemodel","=4.0.1"],["activesupport","=4.0.1"]]},
  {"name":"activerecord","number":"3.2.15","dependencies":[["tzinfo","0.3.29 || 1.0.0"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["activemodel","=3.2.15"],["activesupport","=3.2.15"]]},
  {"name":"activerecord","number":"3.0.1","dependencies":[["activesupport","=3.0.1"],["activemodel","=3.0.1"],["arel","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.7","dependencies":[["activesupport","=3.2.7"],["activemodel","=3.2.7"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.7","dependencies":[["activesupport","=3.1.7"],["activemodel","=3.1.7"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"1.14.2","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"activerecord","number":"2.0.4","dependencies":[["activesupport","=2.0.4"]]},
  {"name":"activerecord","number":"2.2.3","dependencies":[["activesupport","=2.2.3"]]},
  {"name":"activerecord","number":"1.5.1","dependencies":[]},
  {"name":"activerecord","number":"1.14.1","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"activerecord","number":"3.2.6","dependencies":[["activesupport","=3.2.6"],["activemodel","=3.2.6"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.5","dependencies":[["activesupport","=2.3.5"]]},
  {"name":"activerecord","number":"1.15.1","dependencies":[["activesupport","=1.4.0"]]},
  {"name":"activerecord","number":"3.0.11","dependencies":[["activesupport","=3.0.11"],["activemodel","=3.0.11"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.5","dependencies":[["activesupport","=3.0.5"],["activemodel","=3.0.5"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.1","dependencies":[["activesupport","=3.1.1"],["activemodel","=3.1.1"],["arel","2.2.1 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.3","dependencies":[["activesupport","=3.1.3"],["activemodel","=3.1.3"],["arel","2.2.1 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"1.15.4","dependencies":[["activesupport","=1.4.3"]]},
  {"name":"activerecord","number":"2.3.14","dependencies":[["activesupport","=2.3.14"]]},
  {"name":"activerecord","number":"1.10.0","dependencies":[["activesupport","=1.0.4"]]},
  {"name":"activerecord","number":"3.0.0","dependencies":[["activesupport","=3.0.0"],["activemodel","=3.0.0"],["arel","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"1.8.0","dependencies":[["activesupport","=1.0.1"]]},
  {"name":"activerecord","number":"1.13.2","dependencies":[["activesupport","=1.2.5"]]},
  {"name":"activerecord","number":"3.2.3","dependencies":[["activesupport","=3.2.3"],["activemodel","=3.2.3"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"1.15.0","dependencies":[["activesupport","=1.4.0"]]},
  {"name":"activerecord","number":"1.2.0","dependencies":[]},
  {"name":"activerecord","number":"2.1.2","dependencies":[["activesupport","=2.1.2"]]},
  {"name":"activerecord","number":"1.9.1","dependencies":[["activesupport","=1.0.3"]]},
  {"name":"activerecord","number":"2.3.2","dependencies":[["activesupport","=2.3.2"]]},
  {"name":"activerecord","number":"2.3.11","dependencies":[["activesupport","=2.3.11"]]},
  {"name":"activerecord","number":"3.0.2","dependencies":[["activesupport","=3.0.2"],["activemodel","=3.0.2"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"1.11.1","dependencies":[["activesupport","=1.1.1"]]},
  {"name":"activerecord","number":"3.0.12","dependencies":[["activesupport","=3.0.12"],["activemodel","=3.0.12"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.2.2","dependencies":[["activesupport","=2.2.2"]]},
  {"name":"activerecord","number":"1.11.0","dependencies":[["activesupport","=1.1.0"]]},
  {"name":"activerecord","number":"3.1.2","dependencies":[["activesupport","=3.1.2"],["activemodel","=3.1.2"],["arel","2.2.1 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.0","dependencies":[["activesupport","=3.2.0"],["activemodel","=3.2.0"],["arel","3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.4","dependencies":[["activesupport","=2.3.4"]]},
  {"name":"activerecord","number":"1.9.0","dependencies":[["activesupport","=1.0.2"]]},
  {"name":"activerecord","number":"1.14.3","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"activerecord","number":"1.13.1","dependencies":[["activesupport","=1.2.4"]]},
  {"name":"activerecord","number":"1.3.0","dependencies":[]},
  {"name":"activerecord","number":"1.4.0","dependencies":[]},
  {"name":"activerecord","number":"1.15.2","dependencies":[["activesupport","=1.4.1"]]},
  {"name":"activerecord","number":"3.0.8","dependencies":[["activesupport","=3.0.8"],["activemodel","=3.0.8"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.10","dependencies":[["activesupport","=2.3.10"]]},
  {"name":"activerecord","number":"1.1.0","dependencies":[]},
  {"name":"activerecord","number":"1.15.5","dependencies":[["activesupport","=1.4.4"]]},
  {"name":"activerecord","number":"1.13.0","dependencies":[["activesupport","=1.2.3"]]},
  {"name":"activerecord","number":"1.10.1","dependencies":[["activesupport","=1.0.4"]]},
  {"name":"activerecord","number":"1.15.6","dependencies":[["activesupport","=1.4.4"]]},
  {"name":"activerecord","number":"1.7.0","dependencies":[["activesupport","=1.0.0"]]},
  {"name":"activerecord","number":"1.6.0","dependencies":[]},
  {"name":"activerecord","number":"3.0.6","dependencies":[["activesupport","=3.0.6"],["activemodel","=3.0.6"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.3","dependencies":[["activesupport","=3.0.3"],["activemodel","=3.0.3"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.7","dependencies":[["activesupport","=2.3.7"]]},
  {"name":"activerecord","number":"2.0.2","dependencies":[["activesupport","=2.0.2"]]},
  {"name":"activerecord","number":"3.1.4","dependencies":[["activesupport","=3.1.4"],["activemodel","=3.1.4"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.5","dependencies":[["activesupport","=3.1.5"],["activemodel","=3.1.5"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.3","dependencies":[["activesupport","=2.3.3"]]},
  {"name":"activerecord","number":"2.1.0","dependencies":[["activesupport","=2.1.0"]]},
  {"name":"activerecord","number":"2.0.5","dependencies":[["activesupport","=2.0.5"]]},
  {"name":"activerecord","number":"1.15.3","dependencies":[["activesupport","=1.4.2"]]},
  {"name":"activerecord","number":"3.0.9","dependencies":[["activesupport","=3.0.9"],["activemodel","=3.0.9"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.10","dependencies":[["activesupport","=3.0.10"],["activemodel","=3.0.10"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.6","dependencies":[["activesupport","=2.3.6"]]},
  {"name":"activerecord","number":"1.12.2","dependencies":[["activesupport","=1.2.2"]]},
  {"name":"activerecord","number":"1.12.1","dependencies":[["activesupport","=1.2.1"]]},
  {"name":"activerecord","number":"2.3.12","dependencies":[["activesupport","=2.3.12"]]},
  {"name":"activerecord","number":"1.14.4","dependencies":[["activesupport","=1.3.1"]]},
  {"name":"activerecord","number":"3.0.13","dependencies":[["activesupport","=3.0.13"],["activemodel","=3.0.13"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.14","dependencies":[["activesupport","=3.0.14"],["activemodel","=3.0.14"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.6","dependencies":[["activesupport","=3.1.6"],["activemodel","=3.1.6"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.15","dependencies":[["activesupport","=3.0.15"],["activemodel","=3.0.15"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.5","dependencies":[["activesupport","=3.2.5"],["activemodel","=3.2.5"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.0","dependencies":[["activesupport","=3.1.0"],["activemodel","=3.1.0"],["arel","2.2.1 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.16","dependencies":[["activesupport","=3.0.16"],["activemodel","=3.0.16"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.17","dependencies":[["activesupport","=3.0.17"],["activemodel","=3.0.17"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.8","dependencies":[["activesupport","=3.1.8"],["activemodel","=3.1.8"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.8","dependencies":[["activesupport","=3.2.8"],["activemodel","=3.2.8"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.7","dependencies":[["activesupport","=3.0.7"],["activemodel","=3.0.7"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"1.0.0","dependencies":[]},
  {"name":"activerecord","number":"3.2.1","dependencies":[["activesupport","=3.2.1"],["activemodel","=3.2.1"],["arel","3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.2","dependencies":[["activesupport","=3.2.2"],["activemodel","=3.2.2"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.0.1","dependencies":[["activesupport","=2.0.1"]]},
  {"name":"activerecord","number":"2.3.9","dependencies":[["activesupport","=2.3.9"]]},
  {"name":"activerecord","number":"3.2.4","dependencies":[["activesupport","=3.2.4"],["activemodel","=3.2.4"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"1.14.0","dependencies":[["activesupport","=1.3.0"]]},
  {"name":"activerecord","number":"1.5.0","dependencies":[]},
  {"name":"activerecord","number":"3.0.4","dependencies":[["activesupport","=3.0.4"],["activemodel","=3.0.4"],["arel","2.0.2 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.1.1","dependencies":[["activesupport","=2.1.1"]]},
  {"name":"activerecord","number":"2.0.0","dependencies":[["activesupport","=2.0.0"]]},
  {"name":"activerecord","number":"2.3.8","dependencies":[["activesupport","=2.3.8"]]},
  {"name":"activerecord","number":"3.2.9","dependencies":[["activesupport","=3.2.9"],["activemodel","=3.2.9"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.18","dependencies":[["activesupport","=3.0.18"],["activemodel","=3.0.18"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.10","dependencies":[["activesupport","=3.2.10"],["activemodel","=3.2.10"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.9","dependencies":[["activesupport","=3.1.9"],["activemodel","=3.1.9"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.15","dependencies":[["activesupport","=2.3.15"]]},
  {"name":"activerecord","number":"3.2.11","dependencies":[["activesupport","=3.2.11"],["activemodel","=3.2.11"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.19","dependencies":[["activesupport","=3.0.19"],["activemodel","=3.0.19"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"3.1.10","dependencies":[["activesupport","=3.1.10"],["activemodel","=3.1.10"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.0.20","dependencies":[["activesupport","=3.0.20"],["activemodel","=3.0.20"],["arel","2.0.10 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.23 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.16","dependencies":[["activesupport","=2.3.16"]]},
  {"name":"activerecord","number":"2.3.17","dependencies":[["activesupport","=2.3.17"]]},
  {"name":"activerecord","number":"3.1.11","dependencies":[["activesupport","=3.1.11"],["activemodel","=3.1.11"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.12","dependencies":[["activesupport","=3.2.12"],["activemodel","=3.2.12"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"2.3.18","dependencies":[["activesupport","=2.3.18"]]},
  {"name":"activerecord","number":"3.1.12","dependencies":[["activesupport","=3.1.12"],["activemodel","=3.1.12"],["arel","2.2.3 || 3.0.0 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"3.2.13","dependencies":[["activesupport","=3.2.13"],["activemodel","=3.2.13"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord","number":"4.0.0","dependencies":[["activesupport","=4.0.0"],["activemodel","=4.0.0"],["arel","4.0.0 || 5.0.0"],["activerecord-deprecated-finders","1.0.2"]]},
  {"name":"activerecord","number":"3.2.14","dependencies":[["activesupport","=3.2.14"],["activemodel","=3.2.14"],["arel","3.0.2 || 4.0.0 || 5.0.0"],["tzinfo","0.3.29 || 1.0.0"]]},
  {"name":"activerecord-deprecated-finders","number":"0.0.1","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"0.0.2","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"0.0.3","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"1.0.0","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"1.0.1","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"1.0.2","dependencies":[]},
  {"name":"activerecord-deprecated-finders","number":"1.0.3","dependencies":[]},
  {"name":"activesupport","number":"4.0.4","dependencies":[["thread-safe","0.1.0"],["minitest","4.2.0 || 5.0.0"],["tzinfo","0.3.37 || 1.0.0"],["multi-json","1.3.0"],["i18n",null]]},
  {"name":"activesupport","number":"3.2.17","dependencies":[["multi-json","1.0.0"],["i18n",null]]},
  {"name":"activesupport","number":"4.0.3","dependencies":[["thread-safe","0.1.0"],["minitest","4.2.0 || 5.0.0"],["tzinfo","0.3.37 || 1.0.0"],["multi-json","1.3.0"],["i18n",null]]},
  {"name":"activesupport","number":"4.0.2","dependencies":[["thread-safe","0.1.0"],["minitest","4.2.0 || 5.0.0"],["tzinfo","0.3.37 || 1.0.0"],["multi-json","1.3.0"],["i18n",null]]},
  {"name":"activesupport","number":"3.2.16","dependencies":[["multi-json","1.0.0"],["i18n",null]]},
  {"name":"activesupport","number":"4.0.1","dependencies":[["thread-safe","0.1.0"],["minitest","4.2.0 || 5.0.0"],["tzinfo","0.3.37 || 1.0.0"],["multi-json","1.3.0"],["i18n",null]]},
  {"name":"activesupport","number":"3.2.15","dependencies":[["multi-json","1.0.0"],["i18n",null]]},
  {"name":"activesupport","number":"2.3.10","dependencies":[]},
  {"name":"activesupport","number":"2.3.7","dependencies":[]},
  {"name":"activesupport","number":"1.0.2","dependencies":[]},
  {"name":"activesupport","number":"1.4.1","dependencies":[]},
  {"name":"activesupport","number":"1.2.5","dependencies":[]},
  {"name":"activesupport","number":"3.1.7","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.7","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"1.2.3","dependencies":[]},
  {"name":"activesupport","number":"2.3.2","dependencies":[]},
  {"name":"activesupport","number":"3.0.9","dependencies":[]},
  {"name":"activesupport","number":"2.0.2","dependencies":[]},
  {"name":"activesupport","number":"1.4.3","dependencies":[]},
  {"name":"activesupport","number":"2.1.0","dependencies":[]},
  {"name":"activesupport","number":"3.1.2","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"1.1.1","dependencies":[]},
  {"name":"activesupport","number":"2.3.14","dependencies":[]},
  {"name":"activesupport","number":"3.0.12","dependencies":[]},
  {"name":"activesupport","number":"2.0.0","dependencies":[]},
  {"name":"activesupport","number":"3.0.3","dependencies":[]},
  {"name":"activesupport","number":"2.2.2","dependencies":[]},
  {"name":"activesupport","number":"2.1.1","dependencies":[]},
  {"name":"activesupport","number":"2.3.9","dependencies":[]},
  {"name":"activesupport","number":"3.0.2","dependencies":[]},
  {"name":"activesupport","number":"2.3.5","dependencies":[]},
  {"name":"activesupport","number":"2.3.6","dependencies":[]},
  {"name":"activesupport","number":"2.2.3","dependencies":[]},
  {"name":"activesupport","number":"1.2.2","dependencies":[]},
  {"name":"activesupport","number":"1.4.0","dependencies":[]},
  {"name":"activesupport","number":"3.0.11","dependencies":[]},
  {"name":"activesupport","number":"2.3.4","dependencies":[]},
  {"name":"activesupport","number":"2.3.12","dependencies":[]},
  {"name":"activesupport","number":"2.3.3","dependencies":[]},
  {"name":"activesupport","number":"1.1.0","dependencies":[]},
  {"name":"activesupport","number":"3.1.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"1.4.4","dependencies":[]},
  {"name":"activesupport","number":"3.2.2","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.1","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"2.0.4","dependencies":[]},
  {"name":"activesupport","number":"3.0.1","dependencies":[]},
  {"name":"activesupport","number":"3.0.8","dependencies":[]},
  {"name":"activesupport","number":"3.0.13","dependencies":[]},
  {"name":"activesupport","number":"1.0.4","dependencies":[]},
  {"name":"activesupport","number":"2.1.2","dependencies":[]},
  {"name":"activesupport","number":"1.2.1","dependencies":[]},
  {"name":"activesupport","number":"2.3.8","dependencies":[]},
  {"name":"activesupport","number":"1.0.1","dependencies":[]},
  {"name":"activesupport","number":"1.3.1","dependencies":[]},
  {"name":"activesupport","number":"3.0.6","dependencies":[]},
  {"name":"activesupport","number":"3.0.5","dependencies":[]},
  {"name":"activesupport","number":"1.2.4","dependencies":[]},
  {"name":"activesupport","number":"3.0.0","dependencies":[]},
  {"name":"activesupport","number":"1.0.3","dependencies":[]},
  {"name":"activesupport","number":"3.0.7","dependencies":[]},
  {"name":"activesupport","number":"3.0.14","dependencies":[]},
  {"name":"activesupport","number":"3.2.4","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.0","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.0.15","dependencies":[]},
  {"name":"activesupport","number":"3.0.16","dependencies":[]},
  {"name":"activesupport","number":"3.1.1","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.0.17","dependencies":[]},
  {"name":"activesupport","number":"3.1.3","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.1.6","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.1.5","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.1.8","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.5","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.8","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.0.10","dependencies":[]},
  {"name":"activesupport","number":"1.3.0","dependencies":[]},
  {"name":"activesupport","number":"1.4.2","dependencies":[]},
  {"name":"activesupport","number":"3.2.6","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.0.4","dependencies":[]},
  {"name":"activesupport","number":"2.3.11","dependencies":[]},
  {"name":"activesupport","number":"2.0.1","dependencies":[]},
  {"name":"activesupport","number":"1.0.0","dependencies":[]},
  {"name":"activesupport","number":"3.1.4","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.3","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"2.0.5","dependencies":[]},
  {"name":"activesupport","number":"3.2.9","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.0.18","dependencies":[]},
  {"name":"activesupport","number":"3.1.9","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.10","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.1.10","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.11","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"2.3.15","dependencies":[]},
  {"name":"activesupport","number":"3.0.19","dependencies":[]},
  {"name":"activesupport","number":"2.3.16","dependencies":[]},
  {"name":"activesupport","number":"3.0.20","dependencies":[]},
  {"name":"activesupport","number":"3.1.11","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"2.3.17","dependencies":[]},
  {"name":"activesupport","number":"3.2.12","dependencies":[["i18n","0.6.0"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"2.3.18","dependencies":[]},
  {"name":"activesupport","number":"3.1.12","dependencies":[["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"3.2.13","dependencies":[["i18n","=0.6.1"],["multi-json","1.0.0"]]},
  {"name":"activesupport","number":"4.0.0","dependencies":[["i18n",null],["multi-json","1.3.0"],["tzinfo","0.3.37 || 1.0.0"],["minitest","4.2.0 || 5.0.0"],["thread-safe","0.1.0"]]},
  {"name":"activesupport","number":"3.2.14","dependencies":[["i18n",null],["multi-json","1.0.0"]]},
  {"name":"acts-as-taggable-on","number":"3.0.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"3.0.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"3.0.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.1.0","dependencies":[["rails",null]]},
  {"name":"acts-as-taggable-on","number":"2.0.1","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.5","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.11","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.8","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.3.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.2.1","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"1.1.1","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.3","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.2.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.0.5","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.2","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.4","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.3.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"1.0.12","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.0.4","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.19","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.0.3","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.2.0","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"1.0.7","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.14","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.6","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.0","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.8","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.7","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.0.2","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.13","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.6","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"0.0.0","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.1.9","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.10","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.16","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.9","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.15","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.18","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"1.0.17","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.0.6","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.0.0","dependencies":[]},
  {"name":"acts-as-taggable-on","number":"2.1.1","dependencies":[["rails",null]]},
  {"name":"acts-as-taggable-on","number":"2.3.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.3.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.4.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"acts-as-taggable-on","number":"2.4.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"addressable","number":"2.3.6","dependencies":[]},
  {"name":"addressable","number":"2.1.1","dependencies":[]},
  {"name":"addressable","number":"1.0.1","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"2.2.3","dependencies":[]},
  {"name":"addressable","number":"2.3.2","dependencies":[]},
  {"name":"addressable","number":"2.2.5","dependencies":[]},
  {"name":"addressable","number":"0.1.1","dependencies":[["rake",null],["rspec",null]]},
  {"name":"addressable","number":"0.1.0","dependencies":[["rake",null],["rspec",null]]},
  {"name":"addressable","number":"2.0.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"],["launchy",null]]},
  {"name":"addressable","number":"1.0.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"1.0.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"2.1.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"],["launchy",null]]},
  {"name":"addressable","number":"2.0.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"],["launchy",null]]},
  {"name":"addressable","number":"2.2.4","dependencies":[]},
  {"name":"addressable","number":"2.2.7","dependencies":[]},
  {"name":"addressable","number":"2.2.8","dependencies":[]},
  {"name":"addressable","number":"2.2.2","dependencies":[]},
  {"name":"addressable","number":"2.2.0","dependencies":[]},
  {"name":"addressable","number":"1.0.3","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"2.2.6","dependencies":[]},
  {"name":"addressable","number":"0.1.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"2.0.1","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"],["launchy",null]]},
  {"name":"addressable","number":"1.0.4","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0"]]},
  {"name":"addressable","number":"2.1.2","dependencies":[]},
  {"name":"addressable","number":"2.2.1","dependencies":[]},
  {"name":"addressable","number":"2.3.3","dependencies":[]},
  {"name":"addressable","number":"2.3.4","dependencies":[]},
  {"name":"addressable","number":"2.3.5","dependencies":[]},
  {"name":"annotate","number":"2.6.2","dependencies":[["activerecord","2.3.0 || 3.0.0 || 4.0.0"],["rake",null]]},
  {"name":"annotate","number":"2.6.1","dependencies":[["activerecord","2.3.0 || 3.0.0 || 4.0.0"],["rake",null]]},
  {"name":"annotate","number":"2.6.0","dependencies":[["activerecord","2.3.0 || 3.0.0 || 4.0.0"],["rake",null]]},
  {"name":"annotate","number":"2.4.0","dependencies":[]},
  {"name":"annotate","number":"2.5.0","dependencies":[["rake",null]]},
  {"name":"arel","number":"4.0.2","dependencies":[]},
  {"name":"arel","number":"5.0.0","dependencies":[]},
  {"name":"arel","number":"3.0.3","dependencies":[]},
  {"name":"arel","number":"4.0.1","dependencies":[]},
  {"name":"arel","number":"2.0.9","dependencies":[]},
  {"name":"arel","number":"0.3.2","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.0.5","dependencies":[]},
  {"name":"arel","number":"2.0.10","dependencies":[]},
  {"name":"arel","number":"2.1.0","dependencies":[]},
  {"name":"arel","number":"0.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.1.4","dependencies":[]},
  {"name":"arel","number":"0.1.0","dependencies":[]},
  {"name":"arel","number":"3.0.1","dependencies":[]},
  {"name":"arel","number":"2.0.0","dependencies":[]},
  {"name":"arel","number":"2.0.1","dependencies":[]},
  {"name":"arel","number":"2.0.7","dependencies":[]},
  {"name":"arel","number":"2.1.3","dependencies":[]},
  {"name":"arel","number":"0.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"0.3.3","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.2.3","dependencies":[]},
  {"name":"arel","number":"3.0.0","dependencies":[]},
  {"name":"arel","number":"2.0.2","dependencies":[]},
  {"name":"arel","number":"1.0.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.0.8","dependencies":[]},
  {"name":"arel","number":"2.0.4","dependencies":[]},
  {"name":"arel","number":"2.2.0","dependencies":[]},
  {"name":"arel","number":"1.0.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.0.3","dependencies":[]},
  {"name":"arel","number":"2.1.2","dependencies":[]},
  {"name":"arel","number":"2.1.1","dependencies":[]},
  {"name":"arel","number":"0.3.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.0.6","dependencies":[]},
  {"name":"arel","number":"0.2.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"0.2.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"0.1.2","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"arel","number":"2.2.1","dependencies":[]},
  {"name":"arel","number":"2.2.2","dependencies":[]},
  {"name":"arel","number":"3.0.2","dependencies":[]},
  {"name":"arel","number":"4.0.0","dependencies":[]},
  {"name":"asciidoctor","number":"0.0.4","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.2","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.3","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.1","dependencies":[["json",null],["nokogiri",null]]},
  {"name":"asciidoctor","number":"0.1.4","dependencies":[]},
  {"name":"asciidoctor","number":"0.0.5","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.7","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.6","dependencies":[["json",null],["tilt",null]]},
  {"name":"asciidoctor","number":"0.0.9","dependencies":[]},
  {"name":"asciidoctor","number":"0.1.0","dependencies":[]},
  {"name":"asciidoctor","number":"0.1.1","dependencies":[]},
  {"name":"asciidoctor","number":"0.1.2","dependencies":[]},
  {"name":"asciidoctor","number":"0.1.3","dependencies":[]},
  {"name":"atomic","number":"1.1.16","dependencies":[]},
  {"name":"atomic","number":"1.1.15","dependencies":[]},
  {"name":"atomic","number":"1.1.14","dependencies":[]},
  {"name":"atomic","number":"0.0.9","dependencies":[]},
  {"name":"atomic","number":"0.0.3","dependencies":[]},
  {"name":"atomic","number":"0.0.7","dependencies":[]},
  {"name":"atomic","number":"1.0.1","dependencies":[]},
  {"name":"atomic","number":"0.0.5","dependencies":[]},
  {"name":"atomic","number":"0.0.8","dependencies":[]},
  {"name":"atomic","number":"0.0.2","dependencies":[]},
  {"name":"atomic","number":"0.0.4","dependencies":[]},
  {"name":"atomic","number":"1.0.0","dependencies":[]},
  {"name":"atomic","number":"0.0.6","dependencies":[]},
  {"name":"atomic","number":"0.0.1","dependencies":[]},
  {"name":"atomic","number":"1.0.2","dependencies":[]},
  {"name":"atomic","number":"1.1.0","dependencies":[]},
  {"name":"atomic","number":"1.1.4","dependencies":[]},
  {"name":"atomic","number":"1.1.1","dependencies":[]},
  {"name":"atomic","number":"1.1.2","dependencies":[]},
  {"name":"atomic","number":"1.1.3","dependencies":[]},
  {"name":"atomic","number":"1.1.5","dependencies":[]},
  {"name":"atomic","number":"1.1.6","dependencies":[]},
  {"name":"atomic","number":"1.1.7","dependencies":[]},
  {"name":"atomic","number":"1.1.8","dependencies":[]},
  {"name":"atomic","number":"1.1.9","dependencies":[]},
  {"name":"atomic","number":"1.1.10","dependencies":[]},
  {"name":"atomic","number":"1.1.11","dependencies":[]},
  {"name":"atomic","number":"1.1.12","dependencies":[]},
  {"name":"atomic","number":"1.1.13","dependencies":[]},
  {"name":"awesome-print","number":"1.2.0","dependencies":[]},
  {"name":"awesome-print","number":"1.0.1","dependencies":[]},
  {"name":"awesome-print","number":"0.2.0","dependencies":[]},
  {"name":"awesome-print","number":"0.1.2","dependencies":[]},
  {"name":"awesome-print","number":"0.4.0","dependencies":[]},
  {"name":"awesome-print","number":"0.1.0","dependencies":[]},
  {"name":"awesome-print","number":"0.3.1","dependencies":[]},
  {"name":"awesome-print","number":"0.3.2","dependencies":[]},
  {"name":"awesome-print","number":"1.0.0","dependencies":[]},
  {"name":"awesome-print","number":"0.1.1","dependencies":[]},
  {"name":"awesome-print","number":"0.1.3","dependencies":[]},
  {"name":"awesome-print","number":"0.1.4","dependencies":[]},
  {"name":"awesome-print","number":"0.3.0","dependencies":[]},
  {"name":"awesome-print","number":"0.2.1","dependencies":[]},
  {"name":"awesome-print","number":"1.0.2","dependencies":[]},
  {"name":"awesome-print","number":"1.1.0","dependencies":[]},
  {"name":"axiom-types","number":"0.1.0","dependencies":[["thread-safe","0.1.3"],["ice-nine","0.11.0"],["descendants-tracker","0.0.3"]]},
  {"name":"axiom-types","number":"0.0.5","dependencies":[["ice-nine","0.9.0"],["descendants-tracker","0.0.1"]]},
  {"name":"axiom-types","number":"0.0.4","dependencies":[["ice-nine","0.9.0"],["descendants-tracker","0.0.1"]]},
  {"name":"axiom-types","number":"0.0.1","dependencies":[["backports","3.1.1"],["descendants-tracker","0.0.1"],["ice-nine","0.7.0"]]},
  {"name":"axiom-types","number":"0.0.2","dependencies":[["backports","3.3.2"],["descendants-tracker","0.0.1"],["ice-nine","0.8.0"]]},
  {"name":"axiom-types","number":"0.0.3","dependencies":[["descendants-tracker","0.0.1"],["ice-nine","0.9.0"]]},
  {"name":"bcrypt-ruby","number":"3.1.5","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"3.1.4","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"3.1.3","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"2.1.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"1.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.4","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.2","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.3","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.2","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.5","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.4","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.0.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.3","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.2","dependencies":[]},
  {"name":"better-errors","number":"1.1.0","dependencies":[["coderay","1.0.0"],["erubis","2.6.6"]]},
  {"name":"better-errors","number":"1.0.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"1.0.1","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.0.1","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.2","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.3","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.4","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.5","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.6","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.7","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.0.8","dependencies":[["erubis",null],["coderay",null]]},
  {"name":"better-errors","number":"0.1.0","dependencies":[["erubis","2.7.0"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.1.1","dependencies":[["erubis","2.7.0"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.2.0","dependencies":[["erubis","2.7.0"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.3.0","dependencies":[["erubis","2.7.0"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.3.2","dependencies":[["erubis","2.7.0"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.5.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.6.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.7.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.7.2","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.8.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"better-errors","number":"0.9.0","dependencies":[["erubis","2.6.6"],["coderay","1.0.0"]]},
  {"name":"binding-of-caller","number":"0.5.0","dependencies":[]},
  {"name":"binding-of-caller","number":"0.2.0","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.2","dependencies":[]},
  {"name":"binding-of-caller","number":"0.3.1","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.6","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.5","dependencies":[]},
  {"name":"binding-of-caller","number":"0.3.0","dependencies":[]},
  {"name":"binding-of-caller","number":"0.4.1","dependencies":[]},
  {"name":"binding-of-caller","number":"0.4.0","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.0","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.1","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.3","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.4","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.7","dependencies":[]},
  {"name":"binding-of-caller","number":"0.6.8","dependencies":[]},
  {"name":"binding-of-caller","number":"0.7.1","dependencies":[["debug-inspector",null]]},
  {"name":"binding-of-caller","number":"0.7.0","dependencies":[["debug-inspector",null]]},
  {"name":"binding-of-caller","number":"0.7.2","dependencies":[["debug-inspector",null]]},
  {"name":"bootstrap-sass","number":"3.1.1","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"3.1.0","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"3.0.3","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"3.0.2","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"3.0.1","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"3.0.0","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"2.1.0","dependencies":[]},
  {"name":"bootstrap-sass","number":"2.0.2","dependencies":[]},
  {"name":"bootstrap-sass","number":"1.2.0","dependencies":[["sass-rails",null]]},
  {"name":"bootstrap-sass","number":"1.4.2","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"1.4.1","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"1.3.2","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"1.3.0","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"1.4.3","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"2.0.1","dependencies":[]},
  {"name":"bootstrap-sass","number":"1.4.0","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"2.0.4","dependencies":[]},
  {"name":"bootstrap-sass","number":"1.4.4","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"1.2.1","dependencies":[["sass-rails",null]]},
  {"name":"bootstrap-sass","number":"1.3.1","dependencies":[["sass-rails","3.1.0 || 4.0.0"]]},
  {"name":"bootstrap-sass","number":"2.0.3","dependencies":[]},
  {"name":"bootstrap-sass","number":"2.0.0","dependencies":[]},
  {"name":"bootstrap-sass","number":"2.1.1","dependencies":[]},
  {"name":"bootstrap-sass","number":"2.2.1","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"2.2.2","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"2.3.0","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"2.3.1","dependencies":[["sass","3.2.0"]]},
  {"name":"bootstrap-sass","number":"2.3.2","dependencies":[["sass","3.2.0"]]},
  {"name":"builder","number":"3.1.3","dependencies":[]},
  {"name":"builder","number":"2.1.1","dependencies":[]},
  {"name":"builder","number":"1.2.1","dependencies":[]},
  {"name":"builder","number":"2.1.2","dependencies":[]},
  {"name":"builder","number":"3.0.4","dependencies":[]},
  {"name":"builder","number":"1.2.4","dependencies":[]},
  {"name":"builder","number":"3.0.1","dependencies":[]},
  {"name":"builder","number":"3.0.3","dependencies":[]},
  {"name":"builder","number":"3.1.4","dependencies":[]},
  {"name":"builder","number":"1.2.2","dependencies":[]},
  {"name":"builder","number":"3.1.1","dependencies":[]},
  {"name":"builder","number":"3.0.0","dependencies":[]},
  {"name":"builder","number":"3.1.0","dependencies":[]},
  {"name":"builder","number":"1.1.0","dependencies":[]},
  {"name":"builder","number":"2.0.0","dependencies":[]},
  {"name":"builder","number":"1.2.3","dependencies":[]},
  {"name":"builder","number":"1.2.0","dependencies":[]},
  {"name":"builder","number":"3.0.2","dependencies":[]},
  {"name":"builder","number":"3.1.2","dependencies":[]},
  {"name":"builder","number":"3.2.0","dependencies":[]},
  {"name":"builder","number":"3.2.1","dependencies":[]},
  {"name":"builder","number":"3.2.2","dependencies":[]},
  {"name":"capybara","number":"2.2.1","dependencies":[["xpath","2.0.0"],["rack-test",null],["rack","1.0.0"],["mime-types","1.16.0 || 2.0.0"],["nokogiri","1.3.3"]]},
  {"name":"capybara","number":"2.2.0","dependencies":[["xpath","2.0.0"],["rack-test",null],["rack","1.0.0"],["mime-types","1.16.0 || 2.0.0"],["nokogiri","1.3.3"]]},
  {"name":"capybara","number":"0.3.9","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.4.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["celerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null],["xpath","0.1.2 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"0.3.5","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.1.2","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null],["database-cleaner",null]]},
  {"name":"capybara","number":"0.3.7","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.1.4","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.2.0","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.1.0","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["database-cleaner",null]]},
  {"name":"capybara","number":"0.1.3","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.3.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.3.6","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"0.1.1","dependencies":[["nokogiri","1.3.3"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["database-cleaner",null]]},
  {"name":"capybara","number":"1.1.1","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"0.3.8","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["culerity",null],["selenium-webdriver",null],["rack","1.0.0"],["rack-test",null]]},
  {"name":"capybara","number":"1.1.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"1.1.2","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"1.0.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","0.2.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"1.0.1","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"1.1.3","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"2.0.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"2.0.1","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"1.1.4","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","0.1.4 || 1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"2.0.2","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"2.0.3","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["selenium-webdriver","2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","1.0.0 || 2.0.0"]]},
  {"name":"capybara","number":"2.1.0","dependencies":[["nokogiri","1.3.3"],["mime-types","1.16.0 || 2.0.0"],["rack","1.0.0"],["rack-test",null],["xpath","2.0.0"]]},
  {"name":"carrierwave","number":"0.10.0","dependencies":[["mime-types","1.16.0 || 2.0.0"],["json","1.7.0"],["activemodel","3.2.0 || 4.0.0"],["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.5.5","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.2.1","dependencies":[]},
  {"name":"carrierwave","number":"0.6.0","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.6.1","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.5.7","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.4.9","dependencies":[]},
  {"name":"carrierwave","number":"0.3.2","dependencies":[]},
  {"name":"carrierwave","number":"0.4.10","dependencies":[]},
  {"name":"carrierwave","number":"0.3.0","dependencies":[]},
  {"name":"carrierwave","number":"0.4.1","dependencies":[]},
  {"name":"carrierwave","number":"0.3.5","dependencies":[]},
  {"name":"carrierwave","number":"0.1.0","dependencies":[]},
  {"name":"carrierwave","number":"0.5.8","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.3.4","dependencies":[]},
  {"name":"carrierwave","number":"0.5.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.5.6","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.2.0","dependencies":[]},
  {"name":"carrierwave","number":"0.4.6","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.5.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.4.3","dependencies":[]},
  {"name":"carrierwave","number":"0.4.8","dependencies":[["activesupport","2.3.8 || 3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.2.4","dependencies":[]},
  {"name":"carrierwave","number":"0.4.7","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.3.1","dependencies":[]},
  {"name":"carrierwave","number":"0.2.3","dependencies":[]},
  {"name":"carrierwave","number":"0.5.3","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.4.0","dependencies":[]},
  {"name":"carrierwave","number":"0.4.4","dependencies":[]},
  {"name":"carrierwave","number":"0.5.2","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.5.4","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.3.3","dependencies":[]},
  {"name":"carrierwave","number":"0.4.2","dependencies":[]},
  {"name":"carrierwave","number":"0.4.5","dependencies":[]},
  {"name":"carrierwave","number":"0.6.2","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.7.0","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.7.1","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.8.0","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"]]},
  {"name":"carrierwave","number":"0.9.0","dependencies":[["activesupport","3.2.0 || 4.0.0"],["activemodel","3.2.0 || 4.0.0"],["json","1.7.0"]]},
  {"name":"celluloid","number":"0.15.2","dependencies":[["timers","1.1.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.7.2","dependencies":[]},
  {"name":"celluloid","number":"0.8.0","dependencies":[]},
  {"name":"celluloid","number":"0.0.3","dependencies":[]},
  {"name":"celluloid","number":"0.6.1","dependencies":[]},
  {"name":"celluloid","number":"0.7.1","dependencies":[]},
  {"name":"celluloid","number":"0.9.0","dependencies":[]},
  {"name":"celluloid","number":"0.9.1","dependencies":[]},
  {"name":"celluloid","number":"0.6.2","dependencies":[]},
  {"name":"celluloid","number":"0.7.0","dependencies":[]},
  {"name":"celluloid","number":"0.0.1","dependencies":[["celluloid",null]]},
  {"name":"celluloid","number":"0.1.0","dependencies":[]},
  {"name":"celluloid","number":"0.2.1","dependencies":[]},
  {"name":"celluloid","number":"0.5.0","dependencies":[]},
  {"name":"celluloid","number":"0.10.0","dependencies":[]},
  {"name":"celluloid","number":"0.11.1","dependencies":[["timers","1.0.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.12.0","dependencies":[["timers","1.0.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.12.1","dependencies":[["timers","1.0.0 || 2.0.0"],["facter","1.6.12"]]},
  {"name":"celluloid","number":"0.12.2","dependencies":[["timers","1.0.0 || 2.0.0"],["facter","1.6.12"]]},
  {"name":"celluloid","number":"0.2.2","dependencies":[]},
  {"name":"celluloid","number":"0.11.0","dependencies":[]},
  {"name":"celluloid","number":"0.2.0","dependencies":[]},
  {"name":"celluloid","number":"0.6.0","dependencies":[]},
  {"name":"celluloid","number":"0.12.3","dependencies":[["timers","1.0.0 || 2.0.0"],["facter","1.6.12"]]},
  {"name":"celluloid","number":"0.15.1","dependencies":[["timers","1.1.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.12.4","dependencies":[["timers","1.0.0 || 2.0.0"],["facter","1.6.12"]]},
  {"name":"celluloid","number":"0.13.0","dependencies":[["timers","1.0.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.14.0","dependencies":[["timers","1.0.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.14.1","dependencies":[["timers","1.0.0 || 2.0.0"]]},
  {"name":"celluloid","number":"0.15.0","dependencies":[["timers","1.1.0 || 2.0.0"]]},
  {"name":"charlock-holmes","number":"0.6.4","dependencies":[]},
  {"name":"charlock-holmes","number":"0.4.0","dependencies":[]},
  {"name":"charlock-holmes","number":"0.2.0","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.0","dependencies":[]},
  {"name":"charlock-holmes","number":"0.3.0","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.3","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.8","dependencies":[]},
  {"name":"charlock-holmes","number":"0.5.0","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.2","dependencies":[]},
  {"name":"charlock-holmes","number":"0.4.1","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.5","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.6","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.7","dependencies":[]},
  {"name":"charlock-holmes","number":"0.6.9","dependencies":[]},
  {"name":"cliver","number":"0.3.2","dependencies":[]},
  {"name":"cliver","number":"0.3.1","dependencies":[]},
  {"name":"cliver","number":"0.2.2","dependencies":[]},
  {"name":"cliver","number":"0.0.1","dependencies":[]},
  {"name":"cliver","number":"0.1.0","dependencies":[]},
  {"name":"cliver","number":"0.1.1","dependencies":[]},
  {"name":"cliver","number":"0.1.2","dependencies":[]},
  {"name":"cliver","number":"0.1.3","dependencies":[]},
  {"name":"cliver","number":"0.1.4","dependencies":[]},
  {"name":"cliver","number":"0.1.5","dependencies":[]},
  {"name":"cliver","number":"0.2.0","dependencies":[]},
  {"name":"cliver","number":"0.2.1","dependencies":[]},
  {"name":"code-analyzer","number":"0.4.4","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.4.3","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.1.0","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.1.1","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.2.0","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.3.0","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.3.1","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.3.2","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.4.0","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.4.2","dependencies":[["sexp-processor",null]]},
  {"name":"code-analyzer","number":"0.4.1","dependencies":[["sexp-processor",null]]},
  {"name":"coderay","number":"1.0.2","dependencies":[]},
  {"name":"coderay","number":"1.0.7","dependencies":[]},
  {"name":"coderay","number":"1.0.6","dependencies":[]},
  {"name":"coderay","number":"0.8.303","dependencies":[]},
  {"name":"coderay","number":"0.9.4","dependencies":[]},
  {"name":"coderay","number":"0.9.5","dependencies":[]},
  {"name":"coderay","number":"0.8.263","dependencies":[]},
  {"name":"coderay","number":"0.9.6","dependencies":[]},
  {"name":"coderay","number":"1.0.1","dependencies":[]},
  {"name":"coderay","number":"0.8.357","dependencies":[]},
  {"name":"coderay","number":"0.9.3","dependencies":[]},
  {"name":"coderay","number":"1.0.4","dependencies":[]},
  {"name":"coderay","number":"1.0.0","dependencies":[]},
  {"name":"coderay","number":"0.8.260","dependencies":[]},
  {"name":"coderay","number":"1.0.5","dependencies":[]},
  {"name":"coderay","number":"0.9.2","dependencies":[]},
  {"name":"coderay","number":"0.8.273","dependencies":[]},
  {"name":"coderay","number":"0.9.8","dependencies":[]},
  {"name":"coderay","number":"1.0.3","dependencies":[]},
  {"name":"coderay","number":"0.9.7","dependencies":[]},
  {"name":"coderay","number":"0.8.270","dependencies":[]},
  {"name":"coderay","number":"0.9.1","dependencies":[]},
  {"name":"coderay","number":"0.8.312","dependencies":[]},
  {"name":"coderay","number":"1.0.8","dependencies":[]},
  {"name":"coderay","number":"1.0.9","dependencies":[]},
  {"name":"coderay","number":"1.1.0","dependencies":[]},
  {"name":"coercible","number":"1.0.0","dependencies":[["descendants-tracker","0.0.1"]]},
  {"name":"coercible","number":"0.0.1","dependencies":[["backports","2.6.0 || 3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"coercible","number":"0.0.2","dependencies":[["backports","2.8.0 || 3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"coercible","number":"0.1.0","dependencies":[["backports","2.8.0 || 3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"coercible","number":"0.2.0","dependencies":[["backports","3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"coffee-rails","number":"4.0.1","dependencies":[["railties","4.0.0"],["coffee-script","2.2.0"]]},
  {"name":"coffee-rails","number":"3.2.1","dependencies":[["coffee-script","2.2.0"],["railties","3.2.0 || 4.0.0"]]},
  {"name":"coffee-rails","number":"3.2.0","dependencies":[["coffee-script","2.2.0"],["railties","3.2.0 || 4.0.0"]]},
  {"name":"coffee-rails","number":"3.1.0","dependencies":[["coffee-script","2.2.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"coffee-rails","number":"3.1.1","dependencies":[["coffee-script","2.2.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"coffee-rails","number":"3.2.2","dependencies":[["coffee-script","2.2.0"],["railties","3.2.0 || 4.0.0"]]},
  {"name":"coffee-rails","number":"4.0.0","dependencies":[["coffee-script","2.2.0"],["railties","4.0.0"]]},
  {"name":"coffee-script","number":"2.1.1","dependencies":[["coffee-script-source",null]]},
  {"name":"coffee-script","number":"0.1.4","dependencies":[]},
  {"name":"coffee-script","number":"0.2.4","dependencies":[]},
  {"name":"coffee-script","number":"1.0.0","dependencies":[]},
  {"name":"coffee-script","number":"0.1.6","dependencies":[]},
  {"name":"coffee-script","number":"2.0.0","dependencies":[["coffee-script-source",null]]},
  {"name":"coffee-script","number":"0.3.0","dependencies":[]},
  {"name":"coffee-script","number":"0.1.3","dependencies":[]},
  {"name":"coffee-script","number":"0.2.6","dependencies":[]},
  {"name":"coffee-script","number":"0.2.3","dependencies":[]},
  {"name":"coffee-script","number":"0.2.1","dependencies":[]},
  {"name":"coffee-script","number":"0.2.5","dependencies":[]},
  {"name":"coffee-script","number":"0.1.1","dependencies":[]},
  {"name":"coffee-script","number":"0.2.2","dependencies":[]},
  {"name":"coffee-script","number":"0.1.5","dependencies":[]},
  {"name":"coffee-script","number":"0.1.2","dependencies":[]},
  {"name":"coffee-script","number":"2.1.3","dependencies":[["coffee-script-source",null]]},
  {"name":"coffee-script","number":"2.1.2","dependencies":[["coffee-script-source",null]]},
  {"name":"coffee-script","number":"2.2.0","dependencies":[["coffee-script-source",null],["execjs",null]]},
  {"name":"coffee-script","number":"0.1.0","dependencies":[]},
  {"name":"coffee-script","number":"1.1.0","dependencies":[]},
  {"name":"coffee-script","number":"0.3.1","dependencies":[]},
  {"name":"coffee-script","number":"2.1.0","dependencies":[["coffee-script-source",null]]},
  {"name":"coffee-script","number":"0.3.2","dependencies":[]},
  {"name":"coffee-script","number":"0.2.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.7.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.0.0","dependencies":[]},
  {"name":"coffee-script-source","number":"0.9.6","dependencies":[]},
  {"name":"coffee-script-source","number":"1.3.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.1.0","dependencies":[]},
  {"name":"coffee-script-source","number":"0.9.5","dependencies":[]},
  {"name":"coffee-script-source","number":"1.0.1","dependencies":[]},
  {"name":"coffee-script-source","number":"0.9.4","dependencies":[]},
  {"name":"coffee-script-source","number":"1.1.1","dependencies":[]},
  {"name":"coffee-script-source","number":"1.1.2","dependencies":[]},
  {"name":"coffee-script-source","number":"1.2.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.3.1","dependencies":[]},
  {"name":"coffee-script-source","number":"1.3.2","dependencies":[]},
  {"name":"coffee-script-source","number":"1.3.3","dependencies":[]},
  {"name":"coffee-script-source","number":"1.4.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.5.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.6.0","dependencies":[]},
  {"name":"coffee-script-source","number":"1.6.1","dependencies":[]},
  {"name":"coffee-script-source","number":"1.6.2","dependencies":[]},
  {"name":"coffee-script-source","number":"1.6.3","dependencies":[]},
  {"name":"colored","number":"1.0.0","dependencies":[]},
  {"name":"colored","number":"1.1.0","dependencies":[]},
  {"name":"colored","number":"1.2.0","dependencies":[]},
  {"name":"colorize","number":"0.7.0","dependencies":[]},
  {"name":"colorize","number":"0.6.0","dependencies":[]},
  {"name":"colorize","number":"0.5.6","dependencies":[]},
  {"name":"colorize","number":"0.5.0","dependencies":[]},
  {"name":"colorize","number":"0.5.7","dependencies":[]},
  {"name":"colorize","number":"0.5.8","dependencies":[]},
  {"name":"colorize","number":"0.5.5","dependencies":[["hoe","1.2.2 || 2.0.0"]]},
  {"name":"connection-pool","number":"2.0.0","dependencies":[]},
  {"name":"connection-pool","number":"1.2.0","dependencies":[]},
  {"name":"connection-pool","number":"0.1.0","dependencies":[]},
  {"name":"connection-pool","number":"0.0.1","dependencies":[]},
  {"name":"connection-pool","number":"0.0.3","dependencies":[]},
  {"name":"connection-pool","number":"0.9.0","dependencies":[]},
  {"name":"connection-pool","number":"0.9.2","dependencies":[]},
  {"name":"connection-pool","number":"0.9.1","dependencies":[]},
  {"name":"connection-pool","number":"0.0.2","dependencies":[]},
  {"name":"connection-pool","number":"0.9.3","dependencies":[]},
  {"name":"connection-pool","number":"1.0.0","dependencies":[]},
  {"name":"connection-pool","number":"1.1.0","dependencies":[]},
  {"name":"coveralls","number":"0.7.0","dependencies":[["simplecov",null],["thor",null],["multi-json","1.3.0"],["term-ansicolor",null],["rest-client",null]]},
  {"name":"coveralls","number":"0.6.8","dependencies":[["rest-client",null],["term-ansicolor",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.9","dependencies":[["rest-client",null],["term-ansicolor",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.1","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.2","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.3","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.4","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.5","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.6","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.7","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.8","dependencies":[["rest-client",null],["colorize",null],["json",null],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.5.9","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.0","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.1","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.2","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.3","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.4","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.5","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.6","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"coveralls","number":"0.6.7","dependencies":[["rest-client",null],["colorize",null],["multi-json","1.3.0"],["thor",null],["simplecov",null]]},
  {"name":"crack","number":"0.4.2","dependencies":[["safe-yaml","1.0.0"]]},
  {"name":"crack","number":"0.1.1","dependencies":[]},
  {"name":"crack","number":"0.1.8","dependencies":[]},
  {"name":"crack","number":"0.1.3","dependencies":[]},
  {"name":"crack","number":"0.1.7","dependencies":[]},
  {"name":"crack","number":"0.3.0","dependencies":[]},
  {"name":"crack","number":"0.1.6","dependencies":[]},
  {"name":"crack","number":"0.1.5","dependencies":[]},
  {"name":"crack","number":"0.1.4","dependencies":[]},
  {"name":"crack","number":"0.1.2","dependencies":[]},
  {"name":"crack","number":"0.2.0","dependencies":[]},
  {"name":"crack","number":"0.3.1","dependencies":[]},
  {"name":"crack","number":"0.3.2","dependencies":[]},
  {"name":"crack","number":"0.4.0","dependencies":[["safe-yaml","0.9.0 || 1.0.0"]]},
  {"name":"crack","number":"0.4.1","dependencies":[["safe-yaml","0.9.0 || 1.0.0"]]},
  {"name":"d3-rails","number":"3.4.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.4.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.4.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.4.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.13","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.12","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.11","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.10","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.9","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.8","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.7","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.7.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.7","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.9","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.8","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.7","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.8","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.1.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.7.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.8.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.9.7","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.10.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.10.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.10.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.10.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"0.0.10","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"2.8.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.0.8","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.1.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.1.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.1.6","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.1.9","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.1.10","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.3","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.4","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.7","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.2.8","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"d3-rails","number":"3.3.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"daemons","number":"1.1.0","dependencies":[]},
  {"name":"daemons","number":"0.3.0","dependencies":[]},
  {"name":"daemons","number":"0.0.1","dependencies":[]},
  {"name":"daemons","number":"0.4.1","dependencies":[]},
  {"name":"daemons","number":"1.0.10","dependencies":[]},
  {"name":"daemons","number":"0.2.0","dependencies":[]},
  {"name":"daemons","number":"1.0.6","dependencies":[]},
  {"name":"daemons","number":"1.0.0","dependencies":[]},
  {"name":"daemons","number":"1.0.5","dependencies":[]},
  {"name":"daemons","number":"1.0.3","dependencies":[]},
  {"name":"daemons","number":"1.1.8","dependencies":[]},
  {"name":"daemons","number":"1.1.2","dependencies":[]},
  {"name":"daemons","number":"1.0.4","dependencies":[]},
  {"name":"daemons","number":"1.0.7","dependencies":[]},
  {"name":"daemons","number":"0.4.2","dependencies":[]},
  {"name":"daemons","number":"1.0.8","dependencies":[]},
  {"name":"daemons","number":"1.0.1","dependencies":[]},
  {"name":"daemons","number":"0.4.0","dependencies":[]},
  {"name":"daemons","number":"1.1.3","dependencies":[]},
  {"name":"daemons","number":"1.1.6","dependencies":[]},
  {"name":"daemons","number":"1.1.5","dependencies":[]},
  {"name":"daemons","number":"1.0.2","dependencies":[]},
  {"name":"daemons","number":"1.0.9","dependencies":[]},
  {"name":"daemons","number":"0.4.3","dependencies":[]},
  {"name":"daemons","number":"0.4.4","dependencies":[]},
  {"name":"daemons","number":"1.1.4","dependencies":[]},
  {"name":"daemons","number":"1.1.9","dependencies":[]},
  {"name":"daemons","number":"0.2.1","dependencies":[]},
  {"name":"database-cleaner","number":"1.2.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.7.2","dependencies":[]},
  {"name":"database-cleaner","number":"0.3.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.4.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.4.2","dependencies":[]},
  {"name":"database-cleaner","number":"0.4.3","dependencies":[]},
  {"name":"database-cleaner","number":"0.5.2","dependencies":[]},
  {"name":"database-cleaner","number":"0.5.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.7","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.7.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.6","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.1","dependencies":[]},
  {"name":"database-cleaner","number":"0.4.1","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.4","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.3","dependencies":[]},
  {"name":"database-cleaner","number":"0.8.0","dependencies":[]},
  {"name":"database-cleaner","number":"0.2.3","dependencies":[]},
  {"name":"database-cleaner","number":"0.7.1","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.2","dependencies":[]},
  {"name":"database-cleaner","number":"0.6.5","dependencies":[]},
  {"name":"database-cleaner","number":"0.5.1","dependencies":[]},
  {"name":"database-cleaner","number":"0.9.1","dependencies":[]},
  {"name":"database-cleaner","number":"1.0.1","dependencies":[]},
  {"name":"database-cleaner","number":"1.1.0","dependencies":[]},
  {"name":"database-cleaner","number":"1.1.1","dependencies":[]},
  {"name":"debug-inspector","number":"0.0.1","dependencies":[]},
  {"name":"debug-inspector","number":"0.0.2","dependencies":[]},
  {"name":"default-value-for","number":"3.0.0","dependencies":[]},
  {"name":"default-value-for","number":"1.0.4","dependencies":[]},
  {"name":"default-value-for","number":"1.0.1","dependencies":[]},
  {"name":"default-value-for","number":"1.0.3","dependencies":[]},
  {"name":"default-value-for","number":"1.0.7","dependencies":[]},
  {"name":"default-value-for","number":"2.0.0","dependencies":[]},
  {"name":"default-value-for","number":"2.0.1","dependencies":[]},
  {"name":"default-value-for","number":"1.0.5","dependencies":[]},
  {"name":"default-value-for","number":"1.0.0","dependencies":[]},
  {"name":"default-value-for","number":"1.0.6","dependencies":[]},
  {"name":"default-value-for","number":"0.1.0","dependencies":[]},
  {"name":"default-value-for","number":"2.0.2","dependencies":[]},
  {"name":"default-value-for","number":"2.0.3","dependencies":[]},
  {"name":"descendants-tracker","number":"0.0.3","dependencies":[]},
  {"name":"descendants-tracker","number":"0.0.2","dependencies":[]},
  {"name":"descendants-tracker","number":"0.0.1","dependencies":[]},
  {"name":"devise","number":"3.2.4","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.2.3","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.2.2","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.2.1","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.1.2","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.0.4","dependencies":[["railties","3.2.6 || 4.0.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"2.2.8","dependencies":[["railties","3.1.0 || 4.0.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.1"]]},
  {"name":"devise","number":"3.2.0","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"3.1.1","dependencies":[["railties","3.2.6 || 4.0.0"],["thread-safe","0.1.0"],["bcrypt-ruby","3.0.0"],["orm-adapter","0.1.0"],["warden","1.2.3"]]},
  {"name":"devise","number":"1.5.0","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"0.5.6","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"2.0.2","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"0.4.1","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"1.0.4","dependencies":[["warden","0.9.4 || 1.0.0"]]},
  {"name":"devise","number":"1.5.2","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"1.5.1","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"0.2.2","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"1.3.4","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.0.8","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"2.0.1","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"1.1.1","dependencies":[["warden","0.10.7 || 1.0.0"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.0.10","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"0.4.3","dependencies":[["warden","0.5.2 || 1.0.0"]]},
  {"name":"devise","number":"0.7.3","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"1.0.2","dependencies":[["warden","0.9.3 || 1.0.0"]]},
  {"name":"devise","number":"0.7.0","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"1.1.6","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.5.3","dependencies":[["warden","0.6.1 || 1.0.0"]]},
  {"name":"devise","number":"0.7.4","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"0.8.0","dependencies":[["warden","0.8.0 || 1.0.0"]]},
  {"name":"devise","number":"1.0.9","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"0.5.5","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"1.1.7","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.9.2","dependencies":[["warden","0.9.0 || 1.0.0"]]},
  {"name":"devise","number":"1.0.3","dependencies":[["warden","0.9.4 || 1.0.0"]]},
  {"name":"devise","number":"1.5.3","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"0.5.1","dependencies":[["warden","0.6.0 || 1.0.0"]]},
  {"name":"devise","number":"0.6.3","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"0.5.2","dependencies":[["warden","0.6.1 || 1.0.0"]]},
  {"name":"devise","number":"0.4.2","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"0.7.1","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"0.9.0","dependencies":[["warden","0.9.0 || 1.0.0"]]},
  {"name":"devise","number":"0.6.2","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"0.7.2","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"1.0.7","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"1.1.3","dependencies":[["warden","0.10.7 || 1.0.0"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.1.8","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.2.1","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"1.3.2","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.9.1","dependencies":[["warden","0.9.0 || 1.0.0"]]},
  {"name":"devise","number":"0.6.0","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"0.7.5","dependencies":[["warden","0.6.4 || 1.0.0"]]},
  {"name":"devise","number":"1.1.2","dependencies":[["warden","0.10.7 || 1.0.0"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.4.2","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.0.11","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"0.2.0","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"0.4.0","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"1.4.5","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"1.4.9","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"1.4.3","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"0.1.1","dependencies":[["warden","0.5.0 || 1.0.0"]]},
  {"name":"devise","number":"1.1.0","dependencies":[["warden","0.10.7 || 1.0.0"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.3.3","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.3.0","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"2.1.0","dependencies":[["warden","1.1.1"],["orm-adapter","0.0.7"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.1.1","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.1.2","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"0.5.4","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"1.3.1","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.1.0","dependencies":[["warden","0.5.0 || 1.0.0"]]},
  {"name":"devise","number":"2.0.0","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"1.1.4","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.2.1","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.2.0","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.0.0","dependencies":[["warden","0.9.0 || 1.0.0"]]},
  {"name":"devise","number":"1.1.5","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.1.9","dependencies":[["warden","1.0.2"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"0.2.3","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"0.3.0","dependencies":[["warden","0.5.1 || 1.0.0"]]},
  {"name":"devise","number":"1.0.6","dependencies":[["warden","0.10.3 || 1.0.0"]]},
  {"name":"devise","number":"1.4.8","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"1.4.1","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","2.1.2 || 3.0.0"]]},
  {"name":"devise","number":"1.0.1","dependencies":[["warden","0.9.0 || 1.0.0"]]},
  {"name":"devise","number":"0.5.0","dependencies":[["warden","0.5.2 || 1.0.0"]]},
  {"name":"devise","number":"1.0.5","dependencies":[["warden","0.10.2 || 1.0.0"]]},
  {"name":"devise","number":"0.8.1","dependencies":[["warden","0.8.1 || 1.0.0"]]},
  {"name":"devise","number":"0.8.2","dependencies":[["warden","0.8.1 || 1.0.0"]]},
  {"name":"devise","number":"0.6.1","dependencies":[["warden","0.6.3 || 1.0.0"]]},
  {"name":"devise","number":"1.4.7","dependencies":[["warden","1.0.3"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"2.0.4","dependencies":[["warden","1.1.1"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"3.1.0","dependencies":[["warden","1.2.3"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["thread-safe","0.1.0"],["railties","3.2.6 || 4.0.0"]]},
  {"name":"devise","number":"2.2.0","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.2.1","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.2.2","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.2.3","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"1.5.4","dependencies":[["warden","1.1.0"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"]]},
  {"name":"devise","number":"2.0.5","dependencies":[["warden","1.1.1"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.1.3","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.2.4","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"3.0.0","dependencies":[["warden","1.2.3"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.2.6 || 4.0.0"]]},
  {"name":"devise","number":"3.0.1","dependencies":[["warden","1.2.3"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.2.6 || 4.0.0"]]},
  {"name":"devise","number":"2.2.5","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"3.0.2","dependencies":[["warden","1.2.3"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.2.6 || 4.0.0"]]},
  {"name":"devise","number":"2.2.6","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"3.0.3","dependencies":[["warden","1.2.3"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.2.6 || 4.0.0"]]},
  {"name":"devise","number":"2.2.7","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.0.6","dependencies":[["warden","1.1.1"],["orm-adapter","0.0.3"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise","number":"2.1.4","dependencies":[["warden","1.2.1"],["orm-adapter","0.1.0"],["bcrypt-ruby","3.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"devise-async","number":"0.9.0","dependencies":[["devise","3.2.0"]]},
  {"name":"devise-async","number":"0.1.0","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.0.2","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.2.0","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.3.0","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.3.1","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.0.1","dependencies":[["devise",null]]},
  {"name":"devise-async","number":"0.1.1","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.8.0","dependencies":[["devise","2.2.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.4.0","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.5.0","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.5.1","dependencies":[["devise","1.1.0 || 2.0.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.6.0","dependencies":[["devise","2.2.0 || 3.0.0"]]},
  {"name":"devise-async","number":"0.7.0","dependencies":[["devise","2.2.0 || 3.0.0"]]},
  {"name":"diff-lcs","number":"1.2.5","dependencies":[]},
  {"name":"diff-lcs","number":"1.1.2","dependencies":[]},
  {"name":"diff-lcs","number":"1.1.1","dependencies":[]},
  {"name":"diff-lcs","number":"1.1.3","dependencies":[]},
  {"name":"diff-lcs","number":"1.2.0","dependencies":[]},
  {"name":"diff-lcs","number":"1.2.1","dependencies":[]},
  {"name":"diff-lcs","number":"1.2.2","dependencies":[]},
  {"name":"diff-lcs","number":"1.2.3","dependencies":[]},
  {"name":"diff-lcs","number":"1.2.4","dependencies":[]},
  {"name":"docile","number":"1.1.3","dependencies":[]},
  {"name":"docile","number":"1.1.2","dependencies":[]},
  {"name":"docile","number":"1.1.1","dependencies":[]},
  {"name":"docile","number":"0.9.1","dependencies":[]},
  {"name":"docile","number":"0.9.2","dependencies":[]},
  {"name":"docile","number":"0.9.0","dependencies":[]},
  {"name":"docile","number":"1.0.0","dependencies":[]},
  {"name":"docile","number":"1.0.1","dependencies":[]},
  {"name":"docile","number":"1.0.2","dependencies":[]},
  {"name":"docile","number":"1.0.3","dependencies":[]},
  {"name":"docile","number":"1.0.4","dependencies":[]},
  {"name":"docile","number":"1.0.5","dependencies":[]},
  {"name":"docile","number":"1.1.0","dependencies":[]},
  {"name":"dotenv","number":"0.10.0","dependencies":[]},
  {"name":"dotenv","number":"0.2.0","dependencies":[]},
  {"name":"dotenv","number":"0.1.0","dependencies":[]},
  {"name":"dotenv","number":"0.1.1","dependencies":[]},
  {"name":"dotenv","number":"0.3.0","dependencies":[]},
  {"name":"dotenv","number":"0.4.0","dependencies":[]},
  {"name":"dotenv","number":"0.5.0","dependencies":[]},
  {"name":"dotenv","number":"0.6.0","dependencies":[]},
  {"name":"dotenv","number":"0.7.0","dependencies":[]},
  {"name":"dotenv","number":"0.8.0","dependencies":[]},
  {"name":"dotenv","number":"0.9.0","dependencies":[]},
  {"name":"email-spec","number":"1.1.1","dependencies":[["rspec","2.0.0"]]},
  {"name":"email-spec","number":"0.6.1","dependencies":[]},
  {"name":"email-spec","number":"0.3.8","dependencies":[]},
  {"name":"email-spec","number":"0.6.0","dependencies":[]},
  {"name":"email-spec","number":"0.3.6","dependencies":[]},
  {"name":"email-spec","number":"0.6.5","dependencies":[]},
  {"name":"email-spec","number":"0.3.1","dependencies":[]},
  {"name":"email-spec","number":"1.0.1","dependencies":[["rspec","2.0.0"]]},
  {"name":"email-spec","number":"0.6.4","dependencies":[]},
  {"name":"email-spec","number":"1.2.1","dependencies":[["mail","2.2.0"],["rspec","2.0.0"]]},
  {"name":"email-spec","number":"0.2.1","dependencies":[]},
  {"name":"email-spec","number":"1.2.0","dependencies":[["mail","2.2.0"],["rspec","2.0.0"]]},
  {"name":"email-spec","number":"0.6.6","dependencies":[["rspec",null]]},
  {"name":"email-spec","number":"0.6.2","dependencies":[]},
  {"name":"email-spec","number":"0.2.0","dependencies":[]},
  {"name":"email-spec","number":"0.3.7","dependencies":[]},
  {"name":"email-spec","number":"0.3.5","dependencies":[]},
  {"name":"email-spec","number":"0.5.0","dependencies":[]},
  {"name":"email-spec","number":"0.3.0","dependencies":[]},
  {"name":"email-spec","number":"0.4.0","dependencies":[]},
  {"name":"email-spec","number":"0.6.3","dependencies":[]},
  {"name":"email-spec","number":"1.4.0","dependencies":[["launchy","2.1.0"],["mail","2.2.0"]]},
  {"name":"email-spec","number":"1.5.0","dependencies":[["launchy","2.1.0"],["mail","2.2.0"]]},
  {"name":"email-validator","number":"1.2.2","dependencies":[["activemodel",null]]},
  {"name":"email-validator","number":"1.2.1","dependencies":[["activemodel",null]]},
  {"name":"email-validator","number":"1.1.0","dependencies":[]},
  {"name":"email-validator","number":"1.2.3","dependencies":[["activemodel",null]]},
  {"name":"email-validator","number":"1.0.0","dependencies":[]},
  {"name":"email-validator","number":"1.2.4","dependencies":[["activemodel",null]]},
  {"name":"email-validator","number":"1.3.0","dependencies":[["activemodel",null]]},
  {"name":"email-validator","number":"1.4.0","dependencies":[["activemodel",null]]},
  {"name":"emoji","number":"1.0.1","dependencies":[["json",null]]},
  {"name":"emoji","number":"1.0.0","dependencies":[["json",null]]},
  {"name":"emoji","number":"0.1.0","dependencies":[]},
  {"name":"emoji","number":"0.1.1","dependencies":[]},
  {"name":"enumerize","number":"0.8.0","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.1.1","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.2.2","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.3.0","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.0.2","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.0.3","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.1.0","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.0.4","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.2.1","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.4.0","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.2.0","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.0.1","dependencies":[["activesupport","3.1.3 || 4.0.0"]]},
  {"name":"enumerize","number":"0.5.0","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.5.1","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.6.0","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.6.1","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"enumerize","number":"0.7.0","dependencies":[["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"equalizer","number":"0.0.9","dependencies":[]},
  {"name":"equalizer","number":"0.0.8","dependencies":[]},
  {"name":"equalizer","number":"0.0.1","dependencies":[["backports","2.6.4 || 3.0.0"],["adamantium","0.0.3"]]},
  {"name":"equalizer","number":"0.0.2","dependencies":[["backports","2.6.4 || 3.0.0"],["adamantium","0.0.3"]]},
  {"name":"equalizer","number":"0.0.3","dependencies":[["backports","2.7.0 || 3.0.0"],["adamantium","0.0.5"]]},
  {"name":"equalizer","number":"0.0.4","dependencies":[["backports","2.8.2 || 3.0.0"],["adamantium","0.0.6"]]},
  {"name":"equalizer","number":"0.0.5","dependencies":[["backports","3.0.0"],["adamantium","0.0.6"]]},
  {"name":"equalizer","number":"0.0.7","dependencies":[]},
  {"name":"erubis","number":"1.1.0","dependencies":[]},
  {"name":"erubis","number":"2.3.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.2.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.5","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.3.1","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.5.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.4","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.1","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.0.1","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"1.0.0","dependencies":[]},
  {"name":"erubis","number":"2.0.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.2","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.4.1","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.6.6","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.4.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.1.0","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"1.0.1","dependencies":[]},
  {"name":"erubis","number":"2.6.3","dependencies":[["abstract","1.0.0"]]},
  {"name":"erubis","number":"2.7.0","dependencies":[]},
  {"name":"escape-utils","number":"1.0.1","dependencies":[]},
  {"name":"escape-utils","number":"1.0.0","dependencies":[]},
  {"name":"escape-utils","number":"0.1.4","dependencies":[]},
  {"name":"escape-utils","number":"0.1.3","dependencies":[]},
  {"name":"escape-utils","number":"0.1.8","dependencies":[]},
  {"name":"escape-utils","number":"0.2.3","dependencies":[]},
  {"name":"escape-utils","number":"0.1.6","dependencies":[]},
  {"name":"escape-utils","number":"0.2.0","dependencies":[]},
  {"name":"escape-utils","number":"0.1.5","dependencies":[]},
  {"name":"escape-utils","number":"0.2.1","dependencies":[]},
  {"name":"escape-utils","number":"0.1.1","dependencies":[]},
  {"name":"escape-utils","number":"0.2.2","dependencies":[]},
  {"name":"escape-utils","number":"0.2.4","dependencies":[]},
  {"name":"escape-utils","number":"0.1.9","dependencies":[]},
  {"name":"escape-utils","number":"0.1.2","dependencies":[]},
  {"name":"escape-utils","number":"0.1.0","dependencies":[]},
  {"name":"escape-utils","number":"0.1.7","dependencies":[]},
  {"name":"escape-utils","number":"0.3.0","dependencies":[]},
  {"name":"escape-utils","number":"0.3.1","dependencies":[]},
  {"name":"escape-utils","number":"0.3.2","dependencies":[]},
  {"name":"eventmachine","number":"0.3.1","dependencies":[]},
  {"name":"eventmachine","number":"0.4.5","dependencies":[]},
  {"name":"eventmachine","number":"0.7.2","dependencies":[]},
  {"name":"eventmachine","number":"0.4.0","dependencies":[]},
  {"name":"eventmachine","number":"0.12.10","dependencies":[]},
  {"name":"eventmachine","number":"0.4.3","dependencies":[]},
  {"name":"eventmachine","number":"0.12.6","dependencies":[]},
  {"name":"eventmachine","number":"0.12.4","dependencies":[]},
  {"name":"eventmachine","number":"1.0.0","dependencies":[]},
  {"name":"eventmachine","number":"0.5.1","dependencies":[]},
  {"name":"eventmachine","number":"0.5.3","dependencies":[]},
  {"name":"eventmachine","number":"0.7.0","dependencies":[]},
  {"name":"eventmachine","number":"0.4.2","dependencies":[]},
  {"name":"eventmachine","number":"0.9.0","dependencies":[]},
  {"name":"eventmachine","number":"0.8.0","dependencies":[]},
  {"name":"eventmachine","number":"0.12.0","dependencies":[]},
  {"name":"eventmachine","number":"0.12.2","dependencies":[]},
  {"name":"eventmachine","number":"0.5.2","dependencies":[]},
  {"name":"eventmachine","number":"0.10.0","dependencies":[]},
  {"name":"eventmachine","number":"0.8.1","dependencies":[]},
  {"name":"eventmachine","number":"0.4.4","dependencies":[]},
  {"name":"eventmachine","number":"0.12.8","dependencies":[]},
  {"name":"eventmachine","number":"1.0.1","dependencies":[]},
  {"name":"eventmachine","number":"1.0.3","dependencies":[]},
  {"name":"eventmachine","number":"1.0.2","dependencies":[]},
  {"name":"excon","number":"0.32.1","dependencies":[]},
  {"name":"excon","number":"0.32.0","dependencies":[]},
  {"name":"excon","number":"0.31.0","dependencies":[]},
  {"name":"excon","number":"0.30.0","dependencies":[]},
  {"name":"excon","number":"0.29.0","dependencies":[]},
  {"name":"excon","number":"0.28.0","dependencies":[]},
  {"name":"excon","number":"0.27.6","dependencies":[]},
  {"name":"excon","number":"0.27.5","dependencies":[]},
  {"name":"excon","number":"0.27.4","dependencies":[]},
  {"name":"excon","number":"0.27.3","dependencies":[]},
  {"name":"excon","number":"0.27.2","dependencies":[]},
  {"name":"excon","number":"0.27.1","dependencies":[]},
  {"name":"excon","number":"0.27.0","dependencies":[]},
  {"name":"excon","number":"0.26.0","dependencies":[]},
  {"name":"excon","number":"0.5.1","dependencies":[]},
  {"name":"excon","number":"0.6.1","dependencies":[]},
  {"name":"excon","number":"0.13.0","dependencies":[]},
  {"name":"excon","number":"0.0.20","dependencies":[]},
  {"name":"excon","number":"0.14.2","dependencies":[]},
  {"name":"excon","number":"0.3.0","dependencies":[]},
  {"name":"excon","number":"0.2.3","dependencies":[]},
  {"name":"excon","number":"0.9.2","dependencies":[]},
  {"name":"excon","number":"0.7.0","dependencies":[]},
  {"name":"excon","number":"0.6.5","dependencies":[]},
  {"name":"excon","number":"0.3.5","dependencies":[]},
  {"name":"excon","number":"0.0.4","dependencies":[]},
  {"name":"excon","number":"0.0.23","dependencies":[]},
  {"name":"excon","number":"0.10.0","dependencies":[]},
  {"name":"excon","number":"0.7.11","dependencies":[]},
  {"name":"excon","number":"0.6.6","dependencies":[]},
  {"name":"excon","number":"0.7.12","dependencies":[]},
  {"name":"excon","number":"0.0.18","dependencies":[]},
  {"name":"excon","number":"0.3.3","dependencies":[]},
  {"name":"excon","number":"0.9.0","dependencies":[]},
  {"name":"excon","number":"0.7.10","dependencies":[]},
  {"name":"excon","number":"0.16.3","dependencies":[]},
  {"name":"excon","number":"0.0.8","dependencies":[]},
  {"name":"excon","number":"0.3.2","dependencies":[]},
  {"name":"excon","number":"0.5.6","dependencies":[]},
  {"name":"excon","number":"0.5.2","dependencies":[]},
  {"name":"excon","number":"0.0.21","dependencies":[]},
  {"name":"excon","number":"0.0.16","dependencies":[]},
  {"name":"excon","number":"0.9.6","dependencies":[]},
  {"name":"excon","number":"0.14.3","dependencies":[]},
  {"name":"excon","number":"0.5.3","dependencies":[]},
  {"name":"excon","number":"0.1.4","dependencies":[]},
  {"name":"excon","number":"0.12.0","dependencies":[]},
  {"name":"excon","number":"0.5.4","dependencies":[]},
  {"name":"excon","number":"0.9.3","dependencies":[]},
  {"name":"excon","number":"0.0.24","dependencies":[]},
  {"name":"excon","number":"0.0.15","dependencies":[]},
  {"name":"excon","number":"0.9.1","dependencies":[]},
  {"name":"excon","number":"0.7.6","dependencies":[]},
  {"name":"excon","number":"0.7.7","dependencies":[]},
  {"name":"excon","number":"0.4.0","dependencies":[]},
  {"name":"excon","number":"0.14.1","dependencies":[]},
  {"name":"excon","number":"0.5.7","dependencies":[]},
  {"name":"excon","number":"0.0.26","dependencies":[]},
  {"name":"excon","number":"0.7.5","dependencies":[]},
  {"name":"excon","number":"0.3.7","dependencies":[]},
  {"name":"excon","number":"0.3.4","dependencies":[]},
  {"name":"excon","number":"0.2.4","dependencies":[]},
  {"name":"excon","number":"0.6.0","dependencies":[]},
  {"name":"excon","number":"0.7.4","dependencies":[]},
  {"name":"excon","number":"0.16.0","dependencies":[]},
  {"name":"excon","number":"0.16.2","dependencies":[]},
  {"name":"excon","number":"0.16.4","dependencies":[]},
  {"name":"excon","number":"0.16.5","dependencies":[]},
  {"name":"excon","number":"0.0.17","dependencies":[]},
  {"name":"excon","number":"0.0.3","dependencies":[]},
  {"name":"excon","number":"0.2.6","dependencies":[]},
  {"name":"excon","number":"0.9.5","dependencies":[]},
  {"name":"excon","number":"0.16.1","dependencies":[]},
  {"name":"excon","number":"0.0.1","dependencies":[]},
  {"name":"excon","number":"0.15.1","dependencies":[]},
  {"name":"excon","number":"0.8.0","dependencies":[]},
  {"name":"excon","number":"0.10.1","dependencies":[]},
  {"name":"excon","number":"0.5.8","dependencies":[]},
  {"name":"excon","number":"0.6.3","dependencies":[]},
  {"name":"excon","number":"0.13.1","dependencies":[]},
  {"name":"excon","number":"0.3.1","dependencies":[]},
  {"name":"excon","number":"0.1.0","dependencies":[]},
  {"name":"excon","number":"0.3.8","dependencies":[]},
  {"name":"excon","number":"0.2.7","dependencies":[]},
  {"name":"excon","number":"0.1.2","dependencies":[]},
  {"name":"excon","number":"0.0.10","dependencies":[]},
  {"name":"excon","number":"0.6.2","dependencies":[]},
  {"name":"excon","number":"0.2.1","dependencies":[]},
  {"name":"excon","number":"0.2.0","dependencies":[]},
  {"name":"excon","number":"0.0.14","dependencies":[]},
  {"name":"excon","number":"0.7.9","dependencies":[]},
  {"name":"excon","number":"0.7.3","dependencies":[]},
  {"name":"excon","number":"0.0.13","dependencies":[]},
  {"name":"excon","number":"0.14.0","dependencies":[]},
  {"name":"excon","number":"0.7.1","dependencies":[]},
  {"name":"excon","number":"0.0.7","dependencies":[]},
  {"name":"excon","number":"0.5.5","dependencies":[]},
  {"name":"excon","number":"0.2.8","dependencies":[]},
  {"name":"excon","number":"0.0.12","dependencies":[]},
  {"name":"excon","number":"0.15.4","dependencies":[]},
  {"name":"excon","number":"0.6.4","dependencies":[]},
  {"name":"excon","number":"0.3.6","dependencies":[]},
  {"name":"excon","number":"0.5.0","dependencies":[]},
  {"name":"excon","number":"0.13.3","dependencies":[]},
  {"name":"excon","number":"0.13.4","dependencies":[]},
  {"name":"excon","number":"0.15.5","dependencies":[]},
  {"name":"excon","number":"0.15.3","dependencies":[]},
  {"name":"excon","number":"0.15.0","dependencies":[]},
  {"name":"excon","number":"0.13.2","dependencies":[]},
  {"name":"excon","number":"0.0.2","dependencies":[]},
  {"name":"excon","number":"0.0.5","dependencies":[]},
  {"name":"excon","number":"0.7.2","dependencies":[]},
  {"name":"excon","number":"0.9.4","dependencies":[]},
  {"name":"excon","number":"0.1.3","dependencies":[]},
  {"name":"excon","number":"0.0.19","dependencies":[]},
  {"name":"excon","number":"0.0.22","dependencies":[]},
  {"name":"excon","number":"0.15.2","dependencies":[]},
  {"name":"excon","number":"0.11.0","dependencies":[]},
  {"name":"excon","number":"0.1.1","dependencies":[]},
  {"name":"excon","number":"0.7.8","dependencies":[]},
  {"name":"excon","number":"0.0.11","dependencies":[]},
  {"name":"excon","number":"0.2.2","dependencies":[]},
  {"name":"excon","number":"0.0.25","dependencies":[]},
  {"name":"excon","number":"0.16.7","dependencies":[]},
  {"name":"excon","number":"0.16.8","dependencies":[]},
  {"name":"excon","number":"0.16.10","dependencies":[]},
  {"name":"excon","number":"0.16.9","dependencies":[]},
  {"name":"excon","number":"0.17.0","dependencies":[]},
  {"name":"excon","number":"0.18.3","dependencies":[]},
  {"name":"excon","number":"0.18.0","dependencies":[]},
  {"name":"excon","number":"0.18.2","dependencies":[]},
  {"name":"excon","number":"0.18.1","dependencies":[]},
  {"name":"excon","number":"0.18.4","dependencies":[]},
  {"name":"excon","number":"0.18.5","dependencies":[]},
  {"name":"excon","number":"0.19.0","dependencies":[]},
  {"name":"excon","number":"0.19.1","dependencies":[]},
  {"name":"excon","number":"0.19.2","dependencies":[]},
  {"name":"excon","number":"0.19.3","dependencies":[]},
  {"name":"excon","number":"0.19.4","dependencies":[]},
  {"name":"excon","number":"0.19.5","dependencies":[]},
  {"name":"excon","number":"0.20.0","dependencies":[]},
  {"name":"excon","number":"0.20.1","dependencies":[]},
  {"name":"excon","number":"0.21.0","dependencies":[]},
  {"name":"excon","number":"0.22.0","dependencies":[]},
  {"name":"excon","number":"0.22.1","dependencies":[]},
  {"name":"excon","number":"0.23.0","dependencies":[]},
  {"name":"excon","number":"0.24.0","dependencies":[]},
  {"name":"excon","number":"0.25.0","dependencies":[]},
  {"name":"excon","number":"0.25.1","dependencies":[]},
  {"name":"excon","number":"0.25.2","dependencies":[]},
  {"name":"excon","number":"0.25.3","dependencies":[]},
  {"name":"execjs","number":"2.0.2","dependencies":[]},
  {"name":"execjs","number":"1.2.9","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.7","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.11","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.10","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.1.1","dependencies":[]},
  {"name":"execjs","number":"0.4.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.5","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.8","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.3.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.3.2","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.1.3","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.1","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.6","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.1.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.4","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.1.1","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.2.1","dependencies":[]},
  {"name":"execjs","number":"0.3.1","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.4.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.13","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.3.1","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.12","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.3","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.2.0","dependencies":[]},
  {"name":"execjs","number":"0.3.4","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.3.2","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.3.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.1.2","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.2.2","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"1.0.0","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.3.3","dependencies":[["multi-json","1.0.0"]]},
  {"name":"execjs","number":"0.1.0","dependencies":[]},
  {"name":"execjs","number":"2.0.0","dependencies":[]},
  {"name":"execjs","number":"2.0.1","dependencies":[]},
  {"name":"factory-girl","number":"4.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"4.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.1.5","dependencies":[]},
  {"name":"factory-girl","number":"1.1.3","dependencies":[["activesupport","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"4.0.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.2.3","dependencies":[]},
  {"name":"factory-girl","number":"1.1.1","dependencies":[["activesupport","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.6.0","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.1.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.0.5","dependencies":[]},
  {"name":"factory-girl","number":"3.6.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.0.3","dependencies":[]},
  {"name":"factory-girl","number":"1.1.0","dependencies":[["activesupport","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.2.0","dependencies":[]},
  {"name":"factory-girl","number":"2.6.4","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.6.2","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.4.2","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.5.1","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"1.1.2","dependencies":[["activesupport","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.3.1","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"2.4.2","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"1.2.2","dependencies":[]},
  {"name":"factory-girl","number":"3.2.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.3.1","dependencies":[]},
  {"name":"factory-girl","number":"1.2.4","dependencies":[]},
  {"name":"factory-girl","number":"2.4.1","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"2.5.0","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"3.0.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.0.4","dependencies":[]},
  {"name":"factory-girl","number":"2.1.0","dependencies":[]},
  {"name":"factory-girl","number":"3.1.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.5.2","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.3.0","dependencies":[]},
  {"name":"factory-girl","number":"2.2.0","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"2.6.1","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.0.1","dependencies":[]},
  {"name":"factory-girl","number":"2.4.0","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"1.1.4","dependencies":[["activesupport","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"1.3.2","dependencies":[]},
  {"name":"factory-girl","number":"2.6.3","dependencies":[["activesupport","2.3.9 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"2.3.2","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"1.3.3","dependencies":[]},
  {"name":"factory-girl","number":"2.1.2","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"2.0.2","dependencies":[]},
  {"name":"factory-girl","number":"1.2.1","dependencies":[]},
  {"name":"factory-girl","number":"2.3.0","dependencies":[["activesupport",null]]},
  {"name":"factory-girl","number":"3.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.4.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.5.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.6.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"4.1.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"3.6.2","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl","number":"4.2.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"4.4.1","dependencies":[["factory-girl","4.4.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"4.4.0","dependencies":[["factory-girl","4.4.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"4.3.0","dependencies":[["factory-girl","4.3.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.6.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.6.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.3.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.2.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.1.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.4.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.4.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.5.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.5.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"4.0.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.2.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.4.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.3.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.0.1","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.7.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.6.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.6.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.5.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.1.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.1.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.0.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.5.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","2.4.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"1.0.0","dependencies":[["rails","3.0.0 || 4.0.0"],["factory-girl","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"2.0.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.0.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.2.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.2.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"3.3.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","3.3.0 || 4.0.0"]]},
  {"name":"factory-girl-rails","number":"4.1.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","4.1.0"]]},
  {"name":"factory-girl-rails","number":"4.2.0","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","4.2.0"]]},
  {"name":"factory-girl-rails","number":"4.2.1","dependencies":[["railties","3.0.0 || 4.0.0"],["factory-girl","4.2.0"]]},
  {"name":"faraday","number":"0.9.0","dependencies":[["multipart-post","1.2.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.9","dependencies":[["multipart-post","1.2.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.5.4","dependencies":[["addressable","2.2.2"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.5.3","dependencies":[["addressable","2.2.2"],["multipart-post","1.0.1 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.4.1","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.0.2","dependencies":[]},
  {"name":"faraday","number":"0.1.1","dependencies":[]},
  {"name":"faraday","number":"0.5.1","dependencies":[["addressable","2.2.2"],["multipart-post","1.0.1 || 2.0.0"],["rack","1.2.1"]]},
  {"name":"faraday","number":"0.2.2","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.5.2","dependencies":[["addressable","2.2.2"],["multipart-post","1.0.1 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.7.1","dependencies":[["addressable","2.2.6"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.5.7","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.6.1","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.2.0","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.4.0","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.3.0","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.4.5","dependencies":[["rack","1.0.1"],["addressable","2.1.1"]]},
  {"name":"faraday","number":"0.7.6","dependencies":[["addressable","2.2.0"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.3.1","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.5.5","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.8.4","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.7.4","dependencies":[["addressable","2.2.6"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.2.3","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.7.5","dependencies":[["addressable","2.2.6"],["multipart-post","1.1.3 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.7.0","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.5.6","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.7.3","dependencies":[["addressable","2.2.6"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.7.2","dependencies":[["addressable","2.2.6"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.1.0","dependencies":[]},
  {"name":"faraday","number":"0.4.2","dependencies":[["rack","1.1.0"],["addressable","=2.1.1"]]},
  {"name":"faraday","number":"0.6.0","dependencies":[["addressable","2.2.4"],["multipart-post","1.1.0 || 2.0.0"],["rack","1.1.0"],["rack","1.1.0"]]},
  {"name":"faraday","number":"0.2.4","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.5.0","dependencies":[["addressable","2.1.1"],["multipart-post","1.0.1 || 2.0.0"],["rack","1.2.1"]]},
  {"name":"faraday","number":"0.2.1","dependencies":[["rack",null],["addressable",null]]},
  {"name":"faraday","number":"0.8.0","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.2","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.1","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.4.6","dependencies":[["rack","1.0.1"],["addressable","2.1.1"]]},
  {"name":"faraday","number":"0.4.4","dependencies":[["rack","1.0.1"],["addressable","=2.1.1"]]},
  {"name":"faraday","number":"0.1.2","dependencies":[]},
  {"name":"faraday","number":"0.4.3","dependencies":[["rack","1.1.0"],["addressable","=2.1.1"]]},
  {"name":"faraday","number":"0.0.1","dependencies":[]},
  {"name":"faraday","number":"0.8.5","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.6","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.7","dependencies":[["multipart-post","1.1.0 || 2.0.0"]]},
  {"name":"faraday","number":"0.8.8","dependencies":[["multipart-post","1.2.0 || 2.0.0"]]},
  {"name":"faraday-middleware","number":"0.7.0","dependencies":[["faraday","0.7.3"]]},
  {"name":"faraday-middleware","number":"0.6.0","dependencies":[["faraday","0.6.0"]]},
  {"name":"faraday-middleware","number":"0.6.5","dependencies":[["faraday","0.6.0"]]},
  {"name":"faraday-middleware","number":"0.8.0","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.1.1","dependencies":[["faraday","0.4.5"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["multi-xml","0.0.1"],["oauth2","0.0.13"],["roauth","0.0.3"]]},
  {"name":"faraday-middleware","number":"0.8.2","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.6.3","dependencies":[["faraday","0.6.0"]]},
  {"name":"faraday-middleware","number":"0.1.5","dependencies":[["faraday","0.5.0"]]},
  {"name":"faraday-middleware","number":"0.3.2","dependencies":[["faraday","0.5.4"]]},
  {"name":"faraday-middleware","number":"0.8.3","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.8.1","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.8.4","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.1.6","dependencies":[["faraday","0.5.0"]]},
  {"name":"faraday-middleware","number":"0.0.5","dependencies":[["faraday","0.4.5"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["oauth2","0.0.13"]]},
  {"name":"faraday-middleware","number":"0.1.0","dependencies":[["faraday","0.4.5"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["oauth2","0.0.13"]]},
  {"name":"faraday-middleware","number":"0.2.1","dependencies":[["faraday","0.5.1"]]},
  {"name":"faraday-middleware","number":"0.1.4","dependencies":[["faraday","0.5.0"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["multi-xml","0.1.0"],["oauth2","0.1.0"]]},
  {"name":"faraday-middleware","number":"0.0.4","dependencies":[["faraday","0.4.5"]]},
  {"name":"faraday-middleware","number":"0.2.0","dependencies":[["faraday","0.5.1"]]},
  {"name":"faraday-middleware","number":"0.1.7","dependencies":[["faraday","0.5.1"]]},
  {"name":"faraday-middleware","number":"0.3.1","dependencies":[["faraday","0.5.3"]]},
  {"name":"faraday-middleware","number":"0.1.3","dependencies":[["faraday","0.4.5"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["multi-xml","0.1.0"],["oauth2","0.0.13"]]},
  {"name":"faraday-middleware","number":"0.1.2","dependencies":[["faraday","0.4.5"],["hashie","0.4.0 || 1.0.0 || 2.0.0"],["multi-json","0.0.4 || 1.0.0"],["multi-xml","0.0.1"],["oauth2","0.0.13"]]},
  {"name":"faraday-middleware","number":"0.8.7","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.8.8","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.8.5","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.2.3","dependencies":[["faraday","0.5.2"]]},
  {"name":"faraday-middleware","number":"0.3.0","dependencies":[["faraday","0.5.3"]]},
  {"name":"faraday-middleware","number":"0.8.6","dependencies":[["faraday",null]]},
  {"name":"faraday-middleware","number":"0.2.2","dependencies":[["faraday","0.5.2"]]},
  {"name":"faraday-middleware","number":"0.9.0","dependencies":[["faraday",null]]},
  {"name":"ffaker","number":"1.23.0","dependencies":[]},
  {"name":"ffaker","number":"1.22.1","dependencies":[]},
  {"name":"ffaker","number":"1.22.0","dependencies":[]},
  {"name":"ffaker","number":"1.21.0","dependencies":[]},
  {"name":"ffaker","number":"1.20.0","dependencies":[]},
  {"name":"ffaker","number":"1.19.0","dependencies":[]},
  {"name":"ffaker","number":"1.13.0","dependencies":[]},
  {"name":"ffaker","number":"1.2.0","dependencies":[]},
  {"name":"ffaker","number":"1.5.0","dependencies":[]},
  {"name":"ffaker","number":"1.7.0","dependencies":[]},
  {"name":"ffaker","number":"1.11.0","dependencies":[]},
  {"name":"ffaker","number":"1.8.0","dependencies":[]},
  {"name":"ffaker","number":"0.3.4","dependencies":[]},
  {"name":"ffaker","number":"0.3.6","dependencies":[]},
  {"name":"ffaker","number":"1.9.1","dependencies":[]},
  {"name":"ffaker","number":"1.0.0","dependencies":[]},
  {"name":"ffaker","number":"0.4.0","dependencies":[]},
  {"name":"ffaker","number":"1.10.1","dependencies":[]},
  {"name":"ffaker","number":"1.6.0","dependencies":[]},
  {"name":"ffaker","number":"1.1.0","dependencies":[]},
  {"name":"ffaker","number":"1.8.1","dependencies":[]},
  {"name":"ffaker","number":"1.4.0","dependencies":[]},
  {"name":"ffaker","number":"0.3.3","dependencies":[]},
  {"name":"ffaker","number":"0.3.5","dependencies":[]},
  {"name":"ffaker","number":"0.3.7","dependencies":[]},
  {"name":"ffaker","number":"0.3.2","dependencies":[]},
  {"name":"ffaker","number":"1.3.0","dependencies":[]},
  {"name":"ffaker","number":"1.12.0","dependencies":[]},
  {"name":"ffaker","number":"1.12.1","dependencies":[]},
  {"name":"ffaker","number":"1.14.0","dependencies":[]},
  {"name":"ffaker","number":"1.15.0","dependencies":[]},
  {"name":"ffaker","number":"1.16.0","dependencies":[]},
  {"name":"ffaker","number":"1.16.1","dependencies":[]},
  {"name":"ffaker","number":"1.16.2","dependencies":[]},
  {"name":"ffaker","number":"1.17.0","dependencies":[]},
  {"name":"ffaker","number":"1.18.0","dependencies":[]},
  {"name":"ffi","number":"1.9.3","dependencies":[]},
  {"name":"ffi","number":"0.5.4","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.0.2","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.0.9","dependencies":[]},
  {"name":"ffi","number":"0.5.0","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.5.3","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.0.4","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.1.3","dependencies":[]},
  {"name":"ffi","number":"0.5.1","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.0.1","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.1.0","dependencies":[]},
  {"name":"ffi","number":"1.0.5","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.0.11","dependencies":[]},
  {"name":"ffi","number":"1.0.3","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.6.3","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.4.0","dependencies":[]},
  {"name":"ffi","number":"1.0.0","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.6.2","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.1.1","dependencies":[]},
  {"name":"ffi","number":"1.0.6","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.3.0","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"1.0.10","dependencies":[]},
  {"name":"ffi","number":"0.6.0","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.1.5","dependencies":[]},
  {"name":"ffi","number":"0.2.0","dependencies":[]},
  {"name":"ffi","number":"0.1.1","dependencies":[]},
  {"name":"ffi","number":"1.1.2","dependencies":[]},
  {"name":"ffi","number":"0.6.4","dependencies":[]},
  {"name":"ffi","number":"0.3.2","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"0.1.0","dependencies":[]},
  {"name":"ffi","number":"1.1.4","dependencies":[]},
  {"name":"ffi","number":"0.3.5","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"0.3.3","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"0.6.1","dependencies":[["rake",null]]},
  {"name":"ffi","number":"0.3.4","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"0.3.1","dependencies":[["bones","2.4.2"]]},
  {"name":"ffi","number":"1.0.7","dependencies":[["rake",null]]},
  {"name":"ffi","number":"1.2.0","dependencies":[]},
  {"name":"ffi","number":"1.2.1","dependencies":[]},
  {"name":"ffi","number":"1.3.0","dependencies":[]},
  {"name":"ffi","number":"1.3.1","dependencies":[]},
  {"name":"ffi","number":"1.5.0","dependencies":[]},
  {"name":"ffi","number":"1.4.0","dependencies":[]},
  {"name":"ffi","number":"1.6.0","dependencies":[]},
  {"name":"ffi","number":"1.7.0","dependencies":[]},
  {"name":"ffi","number":"1.8.1","dependencies":[]},
  {"name":"ffi","number":"1.9.0","dependencies":[]},
  {"name":"fog","number":"1.21.0","dependencies":[["fog-brightbox",null],["nokogiri","1.5.11"],["fog-json",null],["fog-core","1.21.1"]]},
  {"name":"fog","number":"1.20.0","dependencies":[["nokogiri","1.5.11"],["net-ssh","2.1.3"],["net-scp","1.1.0"],["mime-types",null],["multi-json","1.0.0"],["formatador","0.2.0"],["excon","0.31.0"],["builder",null]]},
  {"name":"fog","number":"1.19.0","dependencies":[["ruby-hmac",null],["nokogiri","1.5.0"],["net-ssh","2.1.3"],["net-scp","1.1.0"],["mime-types",null],["multi-json","1.0.0"],["formatador","0.2.0"],["excon","0.31.0"],["builder",null]]},
  {"name":"fog","number":"1.18.0","dependencies":[["ruby-hmac",null],["nokogiri","1.5.0"],["net-ssh","2.1.3"],["net-scp","1.1.0"],["mime-types",null],["multi-json","1.0.0"],["formatador","0.2.0"],["excon","0.28.0"],["builder",null]]},
  {"name":"fog","number":"1.17.0","dependencies":[["ruby-hmac",null],["nokogiri","1.5.0"],["net-ssh","2.1.3"],["net-scp","1.1.0"],["mime-types",null],["multi-json","1.0.0"],["formatador","0.2.0"],["excon","0.27.0"],["builder",null]]},
  {"name":"fog","number":"1.16.0","dependencies":[["unicode","0.4.4"],["ruby-hmac",null],["nokogiri","1.5.0"],["net-ssh","2.1.3"],["net-scp","1.1.0"],["mime-types",null],["multi-json","1.0.0"],["formatador","0.2.0"],["excon","0.27.0"],["builder",null]]},
  {"name":"fog","number":"0.8.0","dependencies":[["builder",null],["excon","0.6.1"],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.1.3"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.5.2","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.23","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.76","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.8","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.26","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.1","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.2.15","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.3","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.61","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.57","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.16","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.92","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.27","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.1.0","dependencies":[["builder",null],["excon","0.7.4"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.2.1"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.2","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.10","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.13","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.30","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["named-parameters",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.90","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.11.0","dependencies":[["builder",null],["excon","0.6.5"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.4"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.5","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.25","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.0","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.94","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.10","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.78","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.12","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.3.8","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.29","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["named-parameters","=0.0.14"],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.7.2","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.1.3"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.46","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.23","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.14","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.8.1","dependencies":[["builder",null],["excon","0.6.1"],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.1.3"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.6.0","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.80","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.5.1","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.5","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.19","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.15","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.39","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.77","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.40","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.3.1","dependencies":[["builder",null],["excon","0.13.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.56","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.4.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.59","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.5.0","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.83","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.65","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.34","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.13","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.41","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.21","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.6","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.0","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.33","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.7.0","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.64","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.19","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.66","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.84","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.25","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.11","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.3.27","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["named-parameters",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.8.2","dependencies":[["builder",null],["excon","0.6.1"],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.1.3"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.100","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.37","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.26","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.20","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.3","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.4","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.10.0","dependencies":[["builder",null],["excon","0.6.5"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.4"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.4","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.20","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.6","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.24","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.89","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.32","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.8","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.28","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["named-parameters",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.3","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.81","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.93","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.3.0","dependencies":[["builder",null],["excon","0.12.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.0","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.31","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.1","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.9","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.1.2","dependencies":[["builder",null],["excon","0.9.0"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.91","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.51","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.29","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.79","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.44","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.21","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.2","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.19","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.2.18","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.1.6","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.96","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.18","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.12","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.43","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.4","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.5.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.5","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.9.0","dependencies":[["builder",null],["excon","0.6.1"],["formatador",null],["json",null],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.4"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.20","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.1.5","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.34","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.69","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.35","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.3","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.97","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.14","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.95","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.7","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.7","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.16","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.72","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.2","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.2.23","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.2.0","dependencies":[["builder",null],["excon","0.12.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.18","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.55","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.10","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.21","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.24","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.70","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.82","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.60","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.98","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.58","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.10","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.17","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.17","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.7.1","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.26","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.27","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.9","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.99","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.47","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.5.3","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.25","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.62","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.22","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.8","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.3.24","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.28","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.71","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.0.0","dependencies":[["builder",null],["excon","0.7.3"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.4"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.33","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.52","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.54","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.6","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.63","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.30","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.45","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.22","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.13","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.74","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.7","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.88","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.6.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.67","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.50","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.1","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.73","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.9","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.31","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["named-parameters",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.1.1","dependencies":[["builder",null],["excon","0.7.4"],["formatador","0.2.0"],["multi-json","1.0.3"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.28","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.11","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.32","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.17","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.14","dependencies":[["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.22","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.87","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.49","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.75","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.85","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.15","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.68","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.42","dependencies":[["excon",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.38","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.4.0","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.53","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.30","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.9","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.2.4","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.0.48","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.36","dependencies":[["excon",null],["mime-types",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.3.12","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.4.1","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.4"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.0.86","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"0.2.16","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null],["builder",null]]},
  {"name":"fog","number":"0.3.11","dependencies":[["builder",null],["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh","2.0.23"],["nokogiri","1.4.3"],["ruby-hmac",null]]},
  {"name":"fog","number":"0.1.7","dependencies":[["excon",null],["formatador",null],["json",null],["mime-types",null],["net-ssh",null],["nokogiri",null],["ruby-hmac",null]]},
  {"name":"fog","number":"1.7.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.8.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.9.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.0.4"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.10.0","dependencies":[["builder",null],["excon","0.14.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.10.1","dependencies":[["builder",null],["excon","0.20.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.11.0","dependencies":[["builder",null],["excon","0.20.0"],["formatador","0.2.0"],["json","1.7.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.11.1","dependencies":[["builder",null],["excon","0.20.0"],["formatador","0.2.0"],["json","1.7.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.12.0","dependencies":[["builder",null],["excon","0.22.1"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.12.1","dependencies":[["builder",null],["excon","0.23.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.14.0","dependencies":[["builder",null],["excon","0.25.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"fog","number":"1.13.0","dependencies":[["builder",null],["excon","0.25.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["ruby-hmac",null],["nokogiri","1.5.0"]]},
  {"name":"fog","number":"1.15.0","dependencies":[["builder",null],["excon","0.25.0"],["formatador","0.2.0"],["multi-json","1.0.0"],["mime-types",null],["net-scp","1.1.0"],["net-ssh","2.1.3"],["nokogiri","1.5.0"],["ruby-hmac",null]]},
  {"name":"font-awesome-rails","number":"4.0.3","dependencies":[["railties","3.2.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"4.0.1","dependencies":[["railties","3.2.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"4.0.0","dependencies":[["railties","3.2.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.3.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.2.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.4.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.2.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.1.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.4.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"0.5.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"3.0.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"3.0.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"3.1.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"3.2.0","dependencies":[["railties","3.2.0 || 4.0.0"]]},
  {"name":"font-awesome-rails","number":"3.2.1","dependencies":[["railties","3.2.0 || 4.0.0"]]},
  {"name":"foreman","number":"0.2.0","dependencies":[["thor","0.13.6"]]},
  {"name":"foreman","number":"0.17.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.24.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.5.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.9.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.13.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.32.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.59.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.42.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.9.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.14.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.1.0","dependencies":[["thor","0.13.6"]]},
  {"name":"foreman","number":"0.4.7","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.49.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.15.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.35.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.9.2","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.7.5","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.18.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.54.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.4.5","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.27.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.53.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.43.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.7.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.44.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.38.0","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.12.0","dependencies":[["json","1.5.1"],["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.4.6","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.1.1","dependencies":[["thor","0.13.6"]]},
  {"name":"foreman","number":"0.7.2","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.3.2","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.39.0","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.21.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.40.0","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.4.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.45.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.10.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.34.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.11.1","dependencies":[["json","1.5.1"],["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.8.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.20.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.46.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.4.2","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.0.1","dependencies":[["thor","0.13.6"]]},
  {"name":"foreman","number":"0.52.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.37.1","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.5.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.41.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.7.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.23.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.0.2","dependencies":[["thor","0.13.6"]]},
  {"name":"foreman","number":"0.7.4","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.33.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.4.4","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.34.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.33.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.22.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.6.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.3.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.37.2","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.51.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.10.0","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.26.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.57.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.60.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.19.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.7.3","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.4.3","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.31.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.30.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.26.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.30.1","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.25.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.60.2","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.29.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.13.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.16.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.36.0","dependencies":[["term-ansicolor","1.0.5"],["thor",null]]},
  {"name":"foreman","number":"0.50.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.3.1","dependencies":[["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.56.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.55.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.36.1","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.47.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.11.0","dependencies":[["json","1.5.1"],["term-ansicolor","1.0.5"],["thor","0.13.6"]]},
  {"name":"foreman","number":"0.48.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.58.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.37.0","dependencies":[["term-ansicolor","1.0.7"],["thor",null]]},
  {"name":"foreman","number":"0.61.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.62.0","dependencies":[["thor",null]]},
  {"name":"foreman","number":"0.63.0","dependencies":[["thor",null],["dotenv",null]]},
  {"name":"formatador","number":"0.1.3","dependencies":[]},
  {"name":"formatador","number":"0.1.1","dependencies":[]},
  {"name":"formatador","number":"0.0.6","dependencies":[]},
  {"name":"formatador","number":"0.1.2","dependencies":[]},
  {"name":"formatador","number":"0.0.11","dependencies":[]},
  {"name":"formatador","number":"0.0.15","dependencies":[]},
  {"name":"formatador","number":"0.0.14","dependencies":[]},
  {"name":"formatador","number":"0.0.3","dependencies":[]},
  {"name":"formatador","number":"0.0.13","dependencies":[]},
  {"name":"formatador","number":"0.0.5","dependencies":[]},
  {"name":"formatador","number":"0.0.4","dependencies":[]},
  {"name":"formatador","number":"0.0.9","dependencies":[]},
  {"name":"formatador","number":"0.0.12","dependencies":[]},
  {"name":"formatador","number":"0.2.2","dependencies":[]},
  {"name":"formatador","number":"0.2.3","dependencies":[]},
  {"name":"formatador","number":"0.0.7","dependencies":[]},
  {"name":"formatador","number":"0.0.10","dependencies":[]},
  {"name":"formatador","number":"0.2.0","dependencies":[]},
  {"name":"formatador","number":"0.1.5","dependencies":[]},
  {"name":"formatador","number":"0.1.4","dependencies":[]},
  {"name":"formatador","number":"0.1.0","dependencies":[]},
  {"name":"formatador","number":"0.2.1","dependencies":[]},
  {"name":"formatador","number":"0.0.16","dependencies":[]},
  {"name":"formatador","number":"0.0.1","dependencies":[]},
  {"name":"formatador","number":"0.2.4","dependencies":[]},
  {"name":"gemnasium-gitlab-service","number":"0.2.1","dependencies":[["rugged","0.19.0"]]},
  {"name":"gemnasium-gitlab-service","number":"0.1.2","dependencies":[["gitlab-git","3.0.0 || 4.0.0 || 5.0.0"]]},
  {"name":"gemnasium-gitlab-service","number":"0.1.1","dependencies":[["gitlab-git","5.0.0"]]},
  {"name":"gemnasium-gitlab-service","number":"0.1.0","dependencies":[["gitlab-git","5.5.0"]]},
  {"name":"gherkin-ruby","number":"0.3.1","dependencies":[["racc",null]]},
  {"name":"gherkin-ruby","number":"0.1.0","dependencies":[["rexical",null],["racc",null]]},
  {"name":"gherkin-ruby","number":"0.2.0","dependencies":[["rexical",null]]},
  {"name":"gherkin-ruby","number":"0.2.1","dependencies":[]},
  {"name":"gherkin-ruby","number":"0.0.1","dependencies":[["parslet",null]]},
  {"name":"gherkin-ruby","number":"0.0.2","dependencies":[["parslet",null]]},
  {"name":"gherkin-ruby","number":"0.3.0","dependencies":[]},
  {"name":"github-markdown","number":"0.6.5","dependencies":[]},
  {"name":"github-markdown","number":"0.6.4","dependencies":[]},
  {"name":"github-markdown","number":"0.6.3","dependencies":[]},
  {"name":"github-markdown","number":"0.6.2","dependencies":[]},
  {"name":"github-markdown","number":"0.6.1","dependencies":[]},
  {"name":"github-markdown","number":"0.6.0","dependencies":[]},
  {"name":"github-markdown","number":"0.5.5","dependencies":[]},
  {"name":"github-markdown","number":"0.5.4","dependencies":[]},
  {"name":"github-markdown","number":"0.5.0","dependencies":[]},
  {"name":"github-markdown","number":"0.1.3","dependencies":[]},
  {"name":"github-markdown","number":"0.3.2","dependencies":[]},
  {"name":"github-markdown","number":"0.3.0","dependencies":[]},
  {"name":"github-markdown","number":"0.2.0","dependencies":[]},
  {"name":"github-markdown","number":"0.3.1","dependencies":[]},
  {"name":"github-markdown","number":"0.2.1","dependencies":[]},
  {"name":"github-markdown","number":"0.4.0","dependencies":[]},
  {"name":"github-markdown","number":"0.4.1","dependencies":[]},
  {"name":"github-markdown","number":"0.5.1","dependencies":[]},
  {"name":"github-markdown","number":"0.5.2","dependencies":[]},
  {"name":"github-markdown","number":"0.5.3","dependencies":[]},
  {"name":"github-markup","number":"1.1.0","dependencies":[]},
  {"name":"github-markup","number":"1.0.3","dependencies":[]},
  {"name":"github-markup","number":"1.0.2","dependencies":[]},
  {"name":"github-markup","number":"1.0.1","dependencies":[]},
  {"name":"github-markup","number":"1.0.0","dependencies":[]},
  {"name":"github-markup","number":"0.3.3","dependencies":[]},
  {"name":"github-markup","number":"0.5.2","dependencies":[]},
  {"name":"github-markup","number":"0.3.2","dependencies":[]},
  {"name":"github-markup","number":"0.5.1","dependencies":[]},
  {"name":"github-markup","number":"0.1.3","dependencies":[]},
  {"name":"github-markup","number":"0.1.4","dependencies":[]},
  {"name":"github-markup","number":"0.3.0","dependencies":[]},
  {"name":"github-markup","number":"0.2.0","dependencies":[]},
  {"name":"github-markup","number":"0.1.1","dependencies":[]},
  {"name":"github-markup","number":"0.3.1","dependencies":[]},
  {"name":"github-markup","number":"0.2.1","dependencies":[]},
  {"name":"github-markup","number":"0.1.2","dependencies":[]},
  {"name":"github-markup","number":"0.2.2","dependencies":[]},
  {"name":"github-markup","number":"0.7.0","dependencies":[]},
  {"name":"github-markup","number":"0.7.1","dependencies":[]},
  {"name":"github-markup","number":"0.7.2","dependencies":[]},
  {"name":"github-markup","number":"0.7.3","dependencies":[]},
  {"name":"github-markup","number":"0.7.4","dependencies":[]},
  {"name":"github-markup","number":"0.5.0","dependencies":[]},
  {"name":"github-markup","number":"0.5.3","dependencies":[]},
  {"name":"github-markup","number":"0.1.6","dependencies":[]},
  {"name":"github-markup","number":"0.1.5","dependencies":[]},
  {"name":"github-markup","number":"0.4.0","dependencies":[]},
  {"name":"github-markup","number":"0.1.7","dependencies":[]},
  {"name":"github-markup","number":"0.7.5","dependencies":[]},
  {"name":"gitlab-gollum-lib","number":"1.1.0","dependencies":[["stringex","1.5.1 || 2.0.0"],["nokogiri","1.5.9"],["sanitize","2.0.3"],["github-markdown","0.5.3"],["github-markup",null],["gitlab-grit","2.6.1"]]},
  {"name":"gitlab-gollum-lib","number":"1.0.2","dependencies":[["stringex","1.5.1 || 2.0.0"],["nokogiri","1.5.9"],["sanitize","2.0.3"],["github-markdown","0.5.3"],["github-markup",null],["gitlab-pygments.rb","0.5.4"],["gitlab-grit","2.6.1"]]},
  {"name":"gitlab-gollum-lib","number":"1.0.0","dependencies":[["gitlab-grit","2.5.1"],["github-markup",null],["github-markdown","0.5.3"],["pygments.rb","0.4.2"],["sanitize","2.0.3"],["nokogiri","1.5.9"],["stringex","1.5.1 || 2.0.0"]]},
  {"name":"gitlab-gollum-lib","number":"1.0.1","dependencies":[["gitlab-grit","2.5.1"],["github-markup",null],["github-markdown","0.5.3"],["pygments.rb","0.4.2"],["sanitize","2.0.3"],["nokogiri","1.5.9"],["stringex","1.5.1 || 2.0.0"]]},
  {"name":"gitlab-grack","number":"2.0.0","dependencies":[["rack","1.5.1"]]},
  {"name":"gitlab-grack","number":"1.1.0","dependencies":[["rack","1.4.1"]]},
  {"name":"gitlab-grack","number":"1.0.0","dependencies":[["rack","1.4.1"]]},
  {"name":"gitlab-grack","number":"1.0.1","dependencies":[["rack","1.4.1"]]},
  {"name":"gitlab-grit","number":"2.6.4","dependencies":[["diff-lcs","1.1.0"],["mime-types","1.15.0 || 2.0.0"],["posix-spawn","0.3.6"],["charlock-holmes","0.6.9"]]},
  {"name":"gitlab-grit","number":"2.6.3","dependencies":[["diff-lcs","1.1.0"],["mime-types","1.15.0 || 2.0.0"],["posix-spawn","0.3.6"],["charlock-holmes","0.6.9"]]},
  {"name":"gitlab-grit","number":"2.6.2","dependencies":[["diff-lcs","1.1.0"],["mime-types","1.15.0 || 2.0.0"],["posix-spawn","0.3.6"],["charlock-holmes","0.6.9"]]},
  {"name":"gitlab-grit","number":"2.5.2","dependencies":[["diff-lcs","1.1.0"],["mime-types","1.15.0 || 2.0.0"],["posix-spawn","0.3.6"],["charlock-holmes","0.6.9"]]},
  {"name":"gitlab-grit","number":"2.6.1","dependencies":[["diff-lcs","1.1.0"],["mime-types","1.15.0 || 2.0.0"],["posix-spawn","0.3.6"],["charlock-holmes","0.6.9"]]},
  {"name":"gitlab-grit","number":"1.0.0","dependencies":[["posix-spawn","0.3.6"],["mime-types","1.15.0 || 2.0.0"],["diff-lcs","1.1.0"]]},
  {"name":"gitlab-grit","number":"2.5.0","dependencies":[["posix-spawn","0.3.6"],["mime-types","1.15.0 || 2.0.0"],["diff-lcs","1.1.0"]]},
  {"name":"gitlab-grit","number":"2.5.1","dependencies":[["charlock-holmes","0.6.9"],["posix-spawn","0.3.6"],["mime-types","1.15.0 || 2.0.0"],["diff-lcs","1.1.0"]]},
  {"name":"gitlab-grit","number":"2.6.0","dependencies":[["charlock-holmes","0.6.9"],["posix-spawn","0.3.6"],["mime-types","1.15.0 || 2.0.0"],["diff-lcs","1.1.0"]]},
  {"name":"gitlab-linguist","number":"3.0.0","dependencies":[["mime-types","1.19.0 || 2.0.0"],["escape-utils","0.2.4 || 1.0.0"],["charlock-holmes","0.6.6"]]},
  {"name":"gitlab-linguist","number":"2.9.6","dependencies":[["gitlab-pygments.rb","0.5.4"],["mime-types","1.19.0 || 2.0.0"],["escape-utils","0.2.4 || 1.0.0"],["charlock-holmes","0.6.6"]]},
  {"name":"gitlab-linguist","number":"2.9.5","dependencies":[["gitlab-pygments.rb","0.5.4"],["mime-types","1.19.0 || 2.0.0"],["escape-utils","0.3.1 || 1.0.0"],["charlock-holmes","0.6.6"]]},
  {"name":"gitlab-emoji","number":"0.0.1","dependencies":[["emoji","1.0.1"]]},
  {"name":"gitlab-git","number":"5.7.1","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.7.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.6.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.5.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.4.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.3.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.2.0","dependencies":[["charlock-holmes","0.6.9"],["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.1.0","dependencies":[["rugged","0.19.0"],["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"5.0.0","dependencies":[["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","3.0.0"]]},
  {"name":"gitlab-git","number":"4.1.0","dependencies":[["activesupport","4.0.0"],["gitlab-grit","2.6.1"],["gitlab-linguist","2.9.5 || 3.0.0"]]},
  {"name":"gitlab-git","number":"4.0.0","dependencies":[["activesupport","4.0.0"],["gitlab-pygments.rb","0.5.4"],["gitlab-grit","2.6.1"],["gitlab-linguist","2.9.5 || 3.0.0"]]},
  {"name":"gitlab-git","number":"3.1.0","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-pygments.rb","0.5.4"],["gitlab-grit","2.6.1"],["gitlab-linguist","2.9.5 || 3.0.0"]]},
  {"name":"gitlab-git","number":"3.0.1","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-grit","2.6.1"],["github-linguist","2.3.4"]]},
  {"name":"gitlab-git","number":"3.0.0","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-pygments.rb","0.5.4"],["gitlab-grit","2.6.1"],["gitlab-linguist","2.9.5 || 3.0.0"]]},
  {"name":"gitlab-git","number":"1.3.1","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-grit","2.5.2"],["github-linguist","2.3.4"]]},
  {"name":"gitlab-git","number":"2.3.1","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-grit","2.6.0"],["github-linguist","2.3.4"]]},
  {"name":"gitlab-git","number":"2.3.0","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-grit","2.6.0"],["github-linguist","2.9.4"]]},
  {"name":"gitlab-git","number":"2.2.0","dependencies":[["activesupport","3.2.13 || 4.0.0"],["gitlab-grit","2.6.0"],["github-linguist","2.3.4"]]},
  {"name":"gitlab-git","number":"1.0.2","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.1","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.3","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.0","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.4","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.5","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.0.6","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.1.0","dependencies":[["github-linguist","2.3.4"],["grit","2.5.0"],["grit-ext","0.8.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.2.1","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.5.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.2.0","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.5.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.3.0","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.5.1"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.4.0","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"1.4.1","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"2.0.1","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"2.0.0","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"2.1.0","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-git","number":"2.1.1","dependencies":[["github-linguist","2.3.4"],["gitlab-grit","2.6.0"],["activesupport","3.2.13 || 4.0.0"]]},
  {"name":"gitlab-meta","number":"4.0.0","dependencies":[]},
  {"name":"gitlab-meta","number":"2.8.0","dependencies":[]},
  {"name":"gitlab-meta","number":"2.9.0","dependencies":[]},
  {"name":"gitlab-meta","number":"3.0.0","dependencies":[]},
  {"name":"gitlab-meta","number":"3.1.0","dependencies":[]},
  {"name":"gitlab-meta","number":"5.0.0","dependencies":[]},
  {"name":"gitlab-meta","number":"6.0.0","dependencies":[]},
  {"name":"gitlab-omniauth-ldap","number":"1.0.4","dependencies":[["rubyntlm","0.1.1"],["pyu-ruby-sasl","0.3.1"],["net-ldap","0.3.1"],["omniauth","1.0.0"]]},
  {"name":"gitlab-omniauth-ldap","number":"1.0.2","dependencies":[["omniauth","1.0.0"],["net-ldap","0.2.2"],["pyu-ruby-sasl","0.3.1"],["rubyntlm","0.1.1"]]},
  {"name":"gitlab-omniauth-ldap","number":"1.0.3","dependencies":[["omniauth","1.0.0"],["net-ldap","0.3.1"],["pyu-ruby-sasl","0.3.1"],["rubyntlm","0.1.1"]]},
  {"name":"gon","number":"5.0.4","dependencies":[["json",null]]},
  {"name":"gon","number":"5.0.3","dependencies":[["json",null]]},
  {"name":"gon","number":"5.0.2","dependencies":[["json","0.0.0 || 1.0.0"]]},
  {"name":"gon","number":"5.0.1","dependencies":[["json",null]]},
  {"name":"gon","number":"5.0.0","dependencies":[["json",null]]},
  {"name":"gon","number":"3.0.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"2.0.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"2.1.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"0.2.2","dependencies":[]},
  {"name":"gon","number":"0.3.0","dependencies":[]},
  {"name":"gon","number":"2.0.4","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["jbuilder",null],["json",null]]},
  {"name":"gon","number":"1.1.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"]]},
  {"name":"gon","number":"1.1.1","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"]]},
  {"name":"gon","number":"0.1.0","dependencies":[]},
  {"name":"gon","number":"2.2.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"2.0.6","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"2.0.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"0.2.1","dependencies":[]},
  {"name":"gon","number":"1.0.0","dependencies":[]},
  {"name":"gon","number":"2.0.1","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"0.1.1","dependencies":[]},
  {"name":"gon","number":"1.1.3","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"]]},
  {"name":"gon","number":"1.1.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"]]},
  {"name":"gon","number":"0.2.0","dependencies":[]},
  {"name":"gon","number":"2.0.3","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"2.0.5","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["rabl",null],["json",null]]},
  {"name":"gon","number":"2.1.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"2.2.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"2.3.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"3.0.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"3.0.4","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"3.0.5","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.0.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"3.0.3","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.0.1","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.0.2","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.0.3","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.1.0","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"gon","number":"4.1.1","dependencies":[["actionpack","2.3.0 || 3.0.0 || 4.0.0"],["json",null]]},
  {"name":"grape","number":"0.6.1","dependencies":[["builder",null],["virtus","1.0.0"],["hashie","1.2.0 || 2.0.0"],["multi-xml",null],["multi-json","1.3.2"],["activesupport",null],["rack-accept",null],["rack-mount",null],["rack","1.3.0"]]},
  {"name":"grape","number":"0.6.0","dependencies":[["builder",null],["virtus",null],["hashie","1.2.0 || 2.0.0"],["multi-xml",null],["multi-json","1.3.2"],["activesupport",null],["rack-accept",null],["rack-mount",null],["rack","1.3.0"]]},
  {"name":"grape","number":"0.1.5","dependencies":[["rack",null],["rack-mount",null],["rack-jsonp",null],["multi-json",null],["multi-xml",null]]},
  {"name":"grape","number":"0.2.1","dependencies":[["rack",null],["rack-mount",null],["multi-json",null],["multi-xml",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"grape","number":"0.1.0","dependencies":[["rack",null],["rack-mount","0.6.13"],["rack-jsonp",null],["json",null],["multi-json",null],["multi-xml",null]]},
  {"name":"grape","number":"0.1.4","dependencies":[["rack",null],["rack-mount",null],["rack-jsonp",null],["multi-json",null],["multi-xml",null]]},
  {"name":"grape","number":"0.1.3","dependencies":[["rack",null],["rack-mount","0.6.13"],["rack-jsonp",null],["json",null],["multi-json",null],["multi-xml",null]]},
  {"name":"grape","number":"0.1.1","dependencies":[["rack",null],["rack-mount","0.6.13"],["rack-jsonp",null],["json",null],["multi-json",null],["multi-xml",null]]},
  {"name":"grape","number":"0.2.0","dependencies":[["rack",null],["rack-mount",null],["multi-json",null],["multi-xml",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"grape","number":"0.2.2","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null]]},
  {"name":"grape","number":"0.2.3","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.2.4","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.2.5","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.2.6","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.3.0","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.3.1","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.3.2","dependencies":[["rack",null],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.4.0","dependencies":[["rack","1.3.0"],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.4.1","dependencies":[["rack","1.3.0"],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"grape","number":"0.5.0","dependencies":[["rack","1.3.0"],["rack-mount",null],["rack-accept",null],["activesupport",null],["multi-json","1.3.2"],["multi-xml",null],["hashie","1.2.0 || 2.0.0"],["virtus",null],["builder",null]]},
  {"name":"growl","number":"1.0.3","dependencies":[]},
  {"name":"guard","number":"2.6.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.7.0"],["thor",null]]},
  {"name":"guard","number":"2.5.1","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.6.0"],["thor",null]]},
  {"name":"guard","number":"2.5.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.6.0"],["thor",null]]},
  {"name":"guard","number":"2.4.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.3.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.5","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.4","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.3","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.2","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.1","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.2.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.1.1","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.1.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.1.0"],["thor",null]]},
  {"name":"guard","number":"2.0.5","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"2.0.4","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"2.0.3","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"2.0.2","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"2.0.1","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"2.0.0","dependencies":[["formatador",null],["lumberjack","1.0.0"],["pry",null],["listen","2.0.0"],["thor",null]]},
  {"name":"guard","number":"1.8.3","dependencies":[["formatador",null],["lumberjack","1.0.2"],["pry",null],["listen","1.3.0 || 2.0.0"],["thor",null]]},
  {"name":"guard","number":"0.3.2","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.5.1","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"1.2.3","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.1.0","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"0.3.1","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"1.3.2","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"0.6.3","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.8.0","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.6.1","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.2.0","dependencies":[["thor","0.14.3"],["open-gem","1.4.2"]]},
  {"name":"guard","number":"0.9.2","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.5.0","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.9.3","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.8.7","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.8.4","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"1.0.3","dependencies":[["thor",null],["ffi",null]]},
  {"name":"guard","number":"1.1.1","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.3.0","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.3.1","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"0.8.2","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.1.0","dependencies":[["bundler","1.0.2 || 2.0.0"],["thor","0.14.3"],["sys-uname","0.8.4"],["growl","1.0.3"],["rb-inotify","0.8.1"],["libnotify","0.1.3"]]},
  {"name":"guard","number":"0.8.8","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.8.1","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.1.1","dependencies":[["bundler","1.0.2 || 2.0.0"],["thor","0.14.3"],["sys-uname","0.8.4"],["growl","1.0.3"],["rb-inotify","0.8.1"],["libnotify","0.1.3"]]},
  {"name":"guard","number":"0.3.4","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.6.0","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.10.0","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.2.2","dependencies":[["thor","0.14.3"],["open-gem","1.4.2"]]},
  {"name":"guard","number":"0.4.1","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.2.1","dependencies":[["thor","0.14.3"],["open-gem","1.4.2"]]},
  {"name":"guard","number":"0.4.0","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"1.0.2","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.8.6","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.6.2","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.9.4","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.9.1","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.7.0","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.8.3","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"1.0.0","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"1.0.1","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"0.8.5","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.3.3","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.4.2","dependencies":[["thor","0.14.6"]]},
  {"name":"guard","number":"0.9.0","dependencies":[["thor","0.14.6"],["ffi",null]]},
  {"name":"guard","number":"1.2.0","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.2.2","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.3.3","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.4.0","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"0.3.0","dependencies":[["thor","0.14.6"],["open-gem","1.4.2"]]},
  {"name":"guard","number":"1.2.1","dependencies":[["thor",null],["listen",null]]},
  {"name":"guard","number":"1.5.0","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.5.1","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.5.2","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.5.3","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.5.4","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.6.0","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.6.1","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"]]},
  {"name":"guard","number":"1.6.2","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"],["terminal-table","1.4.3"]]},
  {"name":"guard","number":"1.7.0","dependencies":[["thor",null],["listen",null],["pry",null],["lumberjack","1.0.2"],["formatador",null]]},
  {"name":"guard","number":"1.8.0","dependencies":[["thor",null],["listen","1.0.0 || 2.0.0"],["pry",null],["lumberjack","1.0.2"],["formatador",null]]},
  {"name":"guard","number":"1.8.1","dependencies":[["thor",null],["listen","1.0.0 || 2.0.0"],["pry",null],["lumberjack","1.0.2"],["formatador",null]]},
  {"name":"guard","number":"1.8.2","dependencies":[["thor",null],["listen","1.0.0 || 2.0.0"],["pry",null],["lumberjack","1.0.2"],["formatador",null]]},
  {"name":"guard-rspec","number":"4.2.8","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.7","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.6","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.5","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.4","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.3","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.2","dependencies":[["rspec","2.14.0"],["guard","2.1.0"]]},
  {"name":"guard-rspec","number":"4.2.1","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.2.0","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.1.1","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.1.0","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.0.4","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.0.3","dependencies":[["rspec","2.14.0"],["guard","2.1.1"]]},
  {"name":"guard-rspec","number":"4.0.2","dependencies":[["rspec","2.14.0"],["guard","2.0.0"]]},
  {"name":"guard-rspec","number":"4.0.1","dependencies":[["rspec","2.14.0"],["guard","2.0.0"]]},
  {"name":"guard-rspec","number":"4.0.0","dependencies":[["rspec","2.14.0"],["guard","2.0.0"]]},
  {"name":"guard-rspec","number":"3.1.0","dependencies":[["rspec","2.13.0"],["guard","1.8.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"0.5.10","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"1.0.1","dependencies":[["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"0.1.6","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.7.2","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.7.1","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.11","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.3","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.1","dependencies":[["guard","0.1.0 || 1.0.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"0.1.4","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.7.3","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"1.1.0","dependencies":[["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"1.2.0","dependencies":[["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"1.0.0","dependencies":[["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"0.7.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.6","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.4","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.9","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.3","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.5","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.1","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.2","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.2","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.4","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.3.1","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.5","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.5.8","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.7","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.2","dependencies":[["guard","0.1.0 || 1.0.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"0.1.8","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.3.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.0","dependencies":[["guard","0.1.0 || 1.0.0 || 2.0.0"],["rspec","2.0.0"]]},
  {"name":"guard-rspec","number":"0.2.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.5","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.1","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.4.3","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.6.0","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"1.2.1","dependencies":[["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-rspec","number":"2.0.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.1.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"0.5.7","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"0.1.9","dependencies":[["guard",null]]},
  {"name":"guard-rspec","number":"2.1.1","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.1.2","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.2.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.2.1","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.2.2","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.3.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.3.1","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"3.0.3","dependencies":[["guard","1.8.0 || 2.0.0"],["rspec","2.13.0"]]},
  {"name":"guard-rspec","number":"2.3.2","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.3.3","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.4.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.4.1","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.5.0","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.5.1","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.5.2","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.5.3","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.5.4","dependencies":[["guard","1.1.0 || 2.0.0"],["rspec","2.11.0"]]},
  {"name":"guard-rspec","number":"2.6.0","dependencies":[["guard","1.8.0 || 2.0.0"],["rspec","2.13.0"]]},
  {"name":"guard-rspec","number":"3.0.0","dependencies":[["guard","1.8.0 || 2.0.0"],["rspec","2.13.0"]]},
  {"name":"guard-rspec","number":"3.0.1","dependencies":[["guard","1.8.0 || 2.0.0"],["rspec","2.13.0"]]},
  {"name":"guard-rspec","number":"3.0.2","dependencies":[["guard","1.8.0 || 2.0.0"],["rspec","2.13.0"]]},
  {"name":"guard-spinach","number":"0.0.3","dependencies":[["spinach",null],["guard","1.1.0 || 2.0.0"]]},
  {"name":"guard-spinach","number":"0.0.2","dependencies":[["guard","1.1.0 || 2.0.0"],["spinach",null]]},
  {"name":"guard-spinach","number":"0.0.1","dependencies":[["guard",null],["spinach",null]]},
  {"name":"haml","number":"4.0.5","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.4","dependencies":[["tilt",null]]},
  {"name":"haml","number":"3.0.23","dependencies":[]},
  {"name":"haml","number":"2.2.13","dependencies":[]},
  {"name":"haml","number":"3.1.6","dependencies":[]},
  {"name":"haml","number":"1.8.2","dependencies":[]},
  {"name":"haml","number":"1.0.4","dependencies":[]},
  {"name":"haml","number":"2.2.4","dependencies":[]},
  {"name":"haml","number":"3.0.18","dependencies":[]},
  {"name":"haml","number":"3.0.2","dependencies":[]},
  {"name":"haml","number":"3.1.2","dependencies":[]},
  {"name":"haml","number":"2.0.9","dependencies":[]},
  {"name":"haml","number":"3.0.9","dependencies":[]},
  {"name":"haml","number":"2.2.12","dependencies":[]},
  {"name":"haml","number":"2.2.18","dependencies":[]},
  {"name":"haml","number":"2.2.1","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"1.0.0","dependencies":[]},
  {"name":"haml","number":"3.0.3","dependencies":[]},
  {"name":"haml","number":"3.0.13","dependencies":[]},
  {"name":"haml","number":"2.2.16","dependencies":[]},
  {"name":"haml","number":"1.5.2","dependencies":[]},
  {"name":"haml","number":"1.8.0","dependencies":[]},
  {"name":"haml","number":"3.0.16","dependencies":[]},
  {"name":"haml","number":"1.7.0","dependencies":[]},
  {"name":"haml","number":"2.2.17","dependencies":[]},
  {"name":"haml","number":"3.1.3","dependencies":[]},
  {"name":"haml","number":"2.0.4","dependencies":[]},
  {"name":"haml","number":"3.1.4","dependencies":[]},
  {"name":"haml","number":"1.0.5","dependencies":[]},
  {"name":"haml","number":"2.0.7","dependencies":[]},
  {"name":"haml","number":"2.2.24","dependencies":[]},
  {"name":"haml","number":"2.2.11","dependencies":[]},
  {"name":"haml","number":"3.0.14","dependencies":[]},
  {"name":"haml","number":"1.0.1","dependencies":[]},
  {"name":"haml","number":"2.2.20","dependencies":[]},
  {"name":"haml","number":"1.7.1","dependencies":[]},
  {"name":"haml","number":"2.2.9","dependencies":[]},
  {"name":"haml","number":"3.0.5","dependencies":[]},
  {"name":"haml","number":"3.0.7","dependencies":[]},
  {"name":"haml","number":"2.2.8","dependencies":[]},
  {"name":"haml","number":"3.0.4","dependencies":[]},
  {"name":"haml","number":"2.2.2","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"3.0.1","dependencies":[]},
  {"name":"haml","number":"2.0.8","dependencies":[]},
  {"name":"haml","number":"3.0.10","dependencies":[]},
  {"name":"haml","number":"2.0.6","dependencies":[]},
  {"name":"haml","number":"2.0.3","dependencies":[]},
  {"name":"haml","number":"3.0.24","dependencies":[]},
  {"name":"haml","number":"2.0.2","dependencies":[]},
  {"name":"haml","number":"1.5.0","dependencies":[]},
  {"name":"haml","number":"2.0.1","dependencies":[]},
  {"name":"haml","number":"3.1.1","dependencies":[]},
  {"name":"haml","number":"2.2.5","dependencies":[]},
  {"name":"haml","number":"2.2.3","dependencies":[]},
  {"name":"haml","number":"2.2.14","dependencies":[]},
  {"name":"haml","number":"3.1.5","dependencies":[]},
  {"name":"haml","number":"2.2.0","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"2.2.22","dependencies":[]},
  {"name":"haml","number":"2.2.23","dependencies":[]},
  {"name":"haml","number":"2.2.21","dependencies":[]},
  {"name":"haml","number":"2.2.15","dependencies":[]},
  {"name":"haml","number":"3.0.11","dependencies":[]},
  {"name":"haml","number":"3.0.25","dependencies":[]},
  {"name":"haml","number":"1.0.2","dependencies":[]},
  {"name":"haml","number":"3.0.17","dependencies":[]},
  {"name":"haml","number":"3.0.0","dependencies":[]},
  {"name":"haml","number":"2.0.0","dependencies":[]},
  {"name":"haml","number":"3.0.21","dependencies":[]},
  {"name":"haml","number":"2.2.6","dependencies":[]},
  {"name":"haml","number":"2.2.10","dependencies":[]},
  {"name":"haml","number":"2.0.5","dependencies":[]},
  {"name":"haml","number":"2.2.19","dependencies":[]},
  {"name":"haml","number":"3.0.22","dependencies":[]},
  {"name":"haml","number":"3.0.15","dependencies":[]},
  {"name":"haml","number":"3.0.12","dependencies":[]},
  {"name":"haml","number":"3.0.6","dependencies":[]},
  {"name":"haml","number":"3.1.0","dependencies":[]},
  {"name":"haml","number":"3.1.7","dependencies":[]},
  {"name":"haml","number":"1.8.1","dependencies":[]},
  {"name":"haml","number":"1.0.3","dependencies":[]},
  {"name":"haml","number":"1.5.1","dependencies":[]},
  {"name":"haml","number":"1.7.2","dependencies":[]},
  {"name":"haml","number":"2.0.10","dependencies":[]},
  {"name":"haml","number":"3.1.8","dependencies":[]},
  {"name":"haml","number":"4.0.0","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.1","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.2","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.3","dependencies":[["tilt",null]]},
  {"name":"haml-rails","number":"0.5.3","dependencies":[["railties","4.0.1"],["actionpack","4.0.1"],["activesupport","4.0.1"],["haml","3.1.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.5.2","dependencies":[["railties","4.0.1"],["actionpack","4.0.1"],["activesupport","4.0.1"],["haml","3.1.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.5.1","dependencies":[["railties","4.0.0"],["actionpack","4.0.0"],["activesupport","4.0.0"],["haml","3.1.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.1.0","dependencies":[]},
  {"name":"haml-rails","number":"0.3.2","dependencies":[["haml","3.0.18 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.3.1","dependencies":[["haml","3.0.18 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.2.0","dependencies":[["rails","3.0.0 || 4.0.0"],["haml","3.0.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.3.0","dependencies":[["rails","3.0.0 || 4.0.0"],["haml","3.0.18 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.3.3","dependencies":[["haml","3.0.18 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.3.4","dependencies":[["haml","3.0.0 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.3.5","dependencies":[["haml","3.1.0 || 4.0.0"],["activesupport","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"haml-rails","number":"0.4.0","dependencies":[["haml","3.1.0 || 4.0.0"],["activesupport","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["railties","3.1.0 || 4.0.0"]]},
  {"name":"hashie","number":"0.1.5","dependencies":[]},
  {"name":"hashie","number":"0.1.4","dependencies":[]},
  {"name":"hashie","number":"0.1.0","dependencies":[]},
  {"name":"hashie","number":"0.3.0","dependencies":[]},
  {"name":"hashie","number":"0.2.1","dependencies":[]},
  {"name":"hashie","number":"0.4.0","dependencies":[]},
  {"name":"hashie","number":"0.2.2","dependencies":[]},
  {"name":"hashie","number":"0.1.2","dependencies":[]},
  {"name":"hashie","number":"0.3.1","dependencies":[]},
  {"name":"hashie","number":"0.1.3","dependencies":[]},
  {"name":"hashie","number":"0.1.6","dependencies":[]},
  {"name":"hashie","number":"0.1.8","dependencies":[]},
  {"name":"hashie","number":"0.2.0","dependencies":[]},
  {"name":"hashie","number":"1.0.0","dependencies":[]},
  {"name":"hashie","number":"1.1.0","dependencies":[]},
  {"name":"hashie","number":"1.2.0","dependencies":[]},
  {"name":"hashie","number":"2.0.0","dependencies":[]},
  {"name":"hashie","number":"2.0.1","dependencies":[]},
  {"name":"hashie","number":"2.0.2","dependencies":[]},
  {"name":"hashie","number":"2.0.3","dependencies":[]},
  {"name":"hashie","number":"2.0.4","dependencies":[]},
  {"name":"hashie","number":"2.0.5","dependencies":[]},
  {"name":"hike","number":"0.1.3","dependencies":[]},
  {"name":"hike","number":"0.1.2","dependencies":[]},
  {"name":"hike","number":"0.1.1","dependencies":[]},
  {"name":"hike","number":"0.5.1","dependencies":[]},
  {"name":"hike","number":"0.1.4","dependencies":[]},
  {"name":"hike","number":"0.3.0","dependencies":[]},
  {"name":"hike","number":"0.1.0","dependencies":[]},
  {"name":"hike","number":"0.2.0","dependencies":[]},
  {"name":"hike","number":"0.4.0","dependencies":[]},
  {"name":"hike","number":"0.5.0","dependencies":[]},
  {"name":"hike","number":"0.6.0","dependencies":[]},
  {"name":"hike","number":"0.7.0","dependencies":[]},
  {"name":"hike","number":"0.7.1","dependencies":[]},
  {"name":"hike","number":"1.0.0","dependencies":[]},
  {"name":"hike","number":"1.1.0","dependencies":[]},
  {"name":"hike","number":"1.2.0","dependencies":[]},
  {"name":"hike","number":"1.2.1","dependencies":[]},
  {"name":"hike","number":"0.1.5","dependencies":[]},
  {"name":"hike","number":"1.2.2","dependencies":[]},
  {"name":"hike","number":"1.2.3","dependencies":[]},
  {"name":"hipchat","number":"1.1.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"1.0.1","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"1.0.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.14.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.13.0","dependencies":[["httparty","0.11.0"]]},
  {"name":"hipchat","number":"0.2.2","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.0.3","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.4.1","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.0.2","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.2.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.0.1","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.1.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.2.1","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.3.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.4.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.5.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.6.0","dependencies":[["httparty",null],["httparty",null]]},
  {"name":"hipchat","number":"0.6.1","dependencies":[["httparty",null],["httparty",null]]},
  {"name":"hipchat","number":"0.7.0","dependencies":[["httparty",null],["httparty",null]]},
  {"name":"hipchat","number":"0.12.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.8.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.9.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.10.0","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.10.1","dependencies":[["httparty",null]]},
  {"name":"hipchat","number":"0.11.0","dependencies":[["httparty",null]]},
  {"name":"http-parser.rb","number":"0.6.0","dependencies":[]},
  {"name":"http-parser.rb","number":"0.5.0","dependencies":[]},
  {"name":"http-parser.rb","number":"0.5.1","dependencies":[]},
  {"name":"http-parser.rb","number":"0.5.2","dependencies":[]},
  {"name":"http-parser.rb","number":"0.5.3","dependencies":[]},
  {"name":"httparty","number":"0.13.0","dependencies":[["multi-xml",null],["json","1.8.0"]]},
  {"name":"httparty","number":"0.12.0","dependencies":[["multi-xml",null],["json","1.8.0"]]},
  {"name":"httparty","number":"0.8.1","dependencies":[["multi-json",null],["multi-xml",null]]},
  {"name":"httparty","number":"0.7.3","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.6.0","dependencies":[["crack","=0.1.7"]]},
  {"name":"httparty","number":"0.2.6","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.4.4","dependencies":[["crack",null],["echoe",null]]},
  {"name":"httparty","number":"0.2.7","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.4.3","dependencies":[["crack",null],["echoe",null]]},
  {"name":"httparty","number":"0.2.8","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.7.4","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.5.0","dependencies":[["crack",null]]},
  {"name":"httparty","number":"0.7.6","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.7.7","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.2.1","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.2.9","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.5.2","dependencies":[["crack","=0.1.6"]]},
  {"name":"httparty","number":"0.2.2","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.2.4","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.3.0","dependencies":[["echoe",null]]},
  {"name":"httparty","number":"0.2.5","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.1.1","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"httparty","number":"0.1.2","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"httparty","number":"0.2.0","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.1.0","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"httparty","number":"0.1.6","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"httparty","number":"0.4.0","dependencies":[["jnunemaker-crack",null],["echoe",null]]},
  {"name":"httparty","number":"0.7.2","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.2.3","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.7.0","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.7.8","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.8.0","dependencies":[["multi-json",null],["multi-xml",null]]},
  {"name":"httparty","number":"0.8.3","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httparty","number":"0.9.0","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httparty","number":"0.2.10","dependencies":[["json","1.1.0"],["echoe",null]]},
  {"name":"httparty","number":"0.1.8","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"],["echoe",null]]},
  {"name":"httparty","number":"0.4.1","dependencies":[["jnunemaker-crack",null],["echoe",null]]},
  {"name":"httparty","number":"0.4.5","dependencies":[["crack",null]]},
  {"name":"httparty","number":"0.1.5","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"httparty","number":"0.4.2","dependencies":[["crack",null],["echoe",null]]},
  {"name":"httparty","number":"0.3.1","dependencies":[["echoe",null]]},
  {"name":"httparty","number":"0.1.3","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"httparty","number":"0.6.1","dependencies":[["crack","=0.1.8"]]},
  {"name":"httparty","number":"0.1.7","dependencies":[["activesupport","2.1.0 || 3.0.0 || 4.0.0"],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"httparty","number":"0.5.1","dependencies":[["crack","=0.1.5"]]},
  {"name":"httparty","number":"0.8.2","dependencies":[["multi-json",null],["multi-xml",null]]},
  {"name":"httparty","number":"0.10.0","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httparty","number":"0.10.1","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httparty","number":"0.10.2","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httparty","number":"0.11.0","dependencies":[["multi-json","1.0.0"],["multi-xml",null]]},
  {"name":"httpauth","number":"0.2.1","dependencies":[]},
  {"name":"httpauth","number":"0.1.0","dependencies":[]},
  {"name":"httpauth","number":"0.2.0","dependencies":[]},
  {"name":"i18n","number":"0.5.3","dependencies":[]},
  {"name":"i18n","number":"0.6.9","dependencies":[]},
  {"name":"i18n","number":"0.5.2","dependencies":[]},
  {"name":"i18n","number":"0.6.8","dependencies":[]},
  {"name":"i18n","number":"0.1.0","dependencies":[]},
  {"name":"i18n","number":"0.2.1","dependencies":[]},
  {"name":"i18n","number":"0.3.3","dependencies":[]},
  {"name":"i18n","number":"0.3.1","dependencies":[]},
  {"name":"i18n","number":"0.3.7","dependencies":[]},
  {"name":"i18n","number":"0.3.6","dependencies":[]},
  {"name":"i18n","number":"0.4.2","dependencies":[]},
  {"name":"i18n","number":"0.3.2","dependencies":[]},
  {"name":"i18n","number":"0.3.4","dependencies":[]},
  {"name":"i18n","number":"0.4.1","dependencies":[]},
  {"name":"i18n","number":"0.2.0","dependencies":[]},
  {"name":"i18n","number":"0.3.0","dependencies":[]},
  {"name":"i18n","number":"0.3.5","dependencies":[]},
  {"name":"i18n","number":"0.4.0","dependencies":[]},
  {"name":"i18n","number":"0.5.0","dependencies":[]},
  {"name":"i18n","number":"0.6.0","dependencies":[]},
  {"name":"i18n","number":"0.6.1","dependencies":[]},
  {"name":"i18n","number":"0.6.2","dependencies":[]},
  {"name":"i18n","number":"0.6.3","dependencies":[]},
  {"name":"i18n","number":"0.6.4","dependencies":[]},
  {"name":"i18n","number":"0.6.5","dependencies":[]},
  {"name":"ice-nine","number":"0.11.0","dependencies":[]},
  {"name":"ice-nine","number":"0.10.0","dependencies":[]},
  {"name":"ice-nine","number":"0.2.0","dependencies":[]},
  {"name":"ice-nine","number":"0.3.0","dependencies":[]},
  {"name":"ice-nine","number":"0.1.0","dependencies":[]},
  {"name":"ice-nine","number":"0.4.0","dependencies":[]},
  {"name":"ice-nine","number":"0.5.0","dependencies":[]},
  {"name":"ice-nine","number":"0.7.0","dependencies":[]},
  {"name":"ice-nine","number":"0.6.0","dependencies":[]},
  {"name":"ice-nine","number":"0.8.0","dependencies":[]},
  {"name":"ice-nine","number":"0.9.0","dependencies":[]},
  {"name":"jasmine","number":"2.0.0","dependencies":[["phantomjs",null],["rake",null],["rack","1.2.1"],["jasmine-core","2.0.0"]]},
  {"name":"jasmine","number":"1.0.0","dependencies":[["rake",null],["rspec","1.1.5 || 2.0.0"],["rack","1.0.0"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"],["json-pure","1.4.3"]]},
  {"name":"jasmine","number":"1.0.2","dependencies":[["rack","1.1.0"],["rspec","1.3.1 || 2.0.0"],["json-pure","1.4.3"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"0.10.2","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.11.0","dependencies":[["rspec","1.1.5 || 2.0.0"],["rack","1.0.0"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.3","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.0","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"1.0.1","dependencies":[["rake",null],["rspec","1.1.5 || 2.0.0"],["rack","1.0.0"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"],["json-pure","1.4.3"]]},
  {"name":"jasmine","number":"0.4.1","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.11.1","dependencies":[["rspec","1.1.5 || 2.0.0"],["rack","1.0.0"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.5","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.6","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.4","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.10.4","dependencies":[["rspec","1.1.5 || 2.0.0"],["rack","1.0.0"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.4.2","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"0.10.3","dependencies":[["rspec","1.1.5 || 2.0.0"],["json","1.1.9"],["rack","1.0.0"],["thin","1.2.4"],["selenium-rc","2.1.0"],["selenium-client","1.2.17"]]},
  {"name":"jasmine","number":"1.1.0","dependencies":[["jasmine-core","1.1.0 || 2.0.0"],["rack","1.1.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.1.2","dependencies":[["jasmine-core","1.1.0 || 2.0.0"],["rack","1.1.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.2.0","dependencies":[["jasmine-core","1.2.0 || 2.0.0"],["rack","1.0.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.2.1","dependencies":[["jasmine-core","1.2.0 || 2.0.0"],["rack","1.0.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.3.0","dependencies":[["jasmine-core","1.3.0 || 2.0.0"],["rack","1.0.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.3.1","dependencies":[["jasmine-core","1.3.1 || 2.0.0"],["rack","1.0.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine","number":"1.3.2","dependencies":[["jasmine-core","1.3.1 || 2.0.0"],["rack","1.0.0"],["rspec","1.3.1 || 2.0.0"],["selenium-webdriver",null]]},
  {"name":"jasmine-core","number":"2.0.0","dependencies":[]},
  {"name":"jasmine-core","number":"1.1.0","dependencies":[]},
  {"name":"jasmine-core","number":"1.2.0","dependencies":[]},
  {"name":"jasmine-core","number":"1.3.0","dependencies":[]},
  {"name":"jasmine-core","number":"1.3.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.4.7","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.4.5","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.4.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.4","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.6","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.2","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.3","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.0.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.5","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.0","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.1.7","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.2.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.2.2","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.2.3","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.2.4","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.2.5","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.3.0","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.3.1","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.3.2","dependencies":[]},
  {"name":"jquery-atwho-rails","number":"0.3.3","dependencies":[]},
  {"name":"jquery-rails","number":"3.1.0","dependencies":[["thor",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.5","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.17","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.19","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.0.1","dependencies":[["railties","3.2.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.1.1","dependencies":[["railties","3.1.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.14","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.18","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.1.0","dependencies":[["railties","3.1.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.16","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.0.3","dependencies":[["railties","3.1.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.1","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.4","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.2","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.0.2","dependencies":[["railties","3.2.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.6","dependencies":[["rails","3.0.0 || 4.0.0"],["thor","0.14.4"]]},
  {"name":"jquery-rails","number":"1.0.6","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.1.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"0.2.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"0.1.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.7","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.0","dependencies":[["rails","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.10","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.4","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.13","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.5","dependencies":[["rails","3.0.0 || 4.0.0"],["thor","0.14.4"]]},
  {"name":"jquery-rails","number":"1.0.11","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.12","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"1.0.9","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.3","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.8","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.1.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"jquery-rails","number":"1.0.15","dependencies":[["railties","3.0.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"0.2.7","dependencies":[["rails","3.0.0 || 4.0.0"],["thor","0.14.4"]]},
  {"name":"jquery-rails","number":"2.1.2","dependencies":[["railties","3.1.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.1.3","dependencies":[["railties","3.1.0 || 4.0.0"],["thor","0.14.0"]]},
  {"name":"jquery-rails","number":"2.1.4","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"2.2.0","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"2.2.1","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"3.0.0","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"2.2.2","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"2.3.0","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"3.0.1","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"3.0.2","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"3.0.3","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-rails","number":"3.0.4","dependencies":[["railties","3.0.0 || 4.0.0"],["thor",null]]},
  {"name":"jquery-turbolinks","number":"2.0.2","dependencies":[["turbolinks",null],["railties","3.1.0 || 4.0.0"]]},
  {"name":"jquery-turbolinks","number":"0.1.1","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"jquery-turbolinks","number":"0.2.0","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"jquery-turbolinks","number":"0.2.1","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"jquery-turbolinks","number":"1.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["turbolinks",null]]},
  {"name":"jquery-turbolinks","number":"2.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["turbolinks",null]]},
  {"name":"jquery-turbolinks","number":"2.0.1","dependencies":[["railties","3.1.0 || 4.0.0"],["turbolinks",null]]},
  {"name":"jquery-ui-rails","number":"4.2.0","dependencies":[["railties","3.2.16 || 4.0.0"]]},
  {"name":"jquery-ui-rails","number":"4.1.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"jquery-ui-rails","number":"4.1.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"jquery-ui-rails","number":"4.1.0","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"jquery-ui-rails","number":"4.0.5","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"jquery-ui-rails","number":"0.4.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"2.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.1.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.2.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.0.2","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.0.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.2.2","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.5.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"1.1.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.2.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.3.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"0.4.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"1.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"1.1.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"2.0.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"2.0.2","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"3.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"3.0.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"4.0.0","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"4.0.1","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"4.0.2","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"4.0.3","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"jquery-ui-rails","number":"4.0.4","dependencies":[["railties","3.1.0 || 4.0.0"],["jquery-rails",null]]},
  {"name":"json","number":"1.8.1","dependencies":[]},
  {"name":"json","number":"1.1.0","dependencies":[]},
  {"name":"json","number":"0.4.3","dependencies":[]},
  {"name":"json","number":"1.1.5","dependencies":[]},
  {"name":"json","number":"1.0.1","dependencies":[]},
  {"name":"json","number":"1.6.1","dependencies":[]},
  {"name":"json","number":"1.2.0","dependencies":[]},
  {"name":"json","number":"0.4.2","dependencies":[]},
  {"name":"json","number":"1.0.3","dependencies":[]},
  {"name":"json","number":"1.2.1","dependencies":[]},
  {"name":"json","number":"1.1.2","dependencies":[]},
  {"name":"json","number":"1.7.2","dependencies":[]},
  {"name":"json","number":"1.6.4","dependencies":[]},
  {"name":"json","number":"1.6.5","dependencies":[]},
  {"name":"json","number":"1.5.3","dependencies":[]},
  {"name":"json","number":"1.4.4","dependencies":[]},
  {"name":"json","number":"1.6.0","dependencies":[]},
  {"name":"json","number":"1.4.2","dependencies":[]},
  {"name":"json","number":"1.0.0","dependencies":[]},
  {"name":"json","number":"1.0.4","dependencies":[]},
  {"name":"json","number":"1.4.0","dependencies":[]},
  {"name":"json","number":"1.1.4","dependencies":[]},
  {"name":"json","number":"1.1.6","dependencies":[]},
  {"name":"json","number":"1.2.3","dependencies":[]},
  {"name":"json","number":"1.2.4","dependencies":[]},
  {"name":"json","number":"1.5.1","dependencies":[]},
  {"name":"json","number":"1.7.0","dependencies":[]},
  {"name":"json","number":"1.5.2","dependencies":[]},
  {"name":"json","number":"1.6.2","dependencies":[]},
  {"name":"json","number":"1.4.6","dependencies":[]},
  {"name":"json","number":"1.6.7","dependencies":[]},
  {"name":"json","number":"1.1.9","dependencies":[]},
  {"name":"json","number":"1.5.4","dependencies":[]},
  {"name":"json","number":"1.1.8","dependencies":[]},
  {"name":"json","number":"1.1.7","dependencies":[]},
  {"name":"json","number":"1.7.1","dependencies":[]},
  {"name":"json","number":"0.4.1","dependencies":[]},
  {"name":"json","number":"1.7.3","dependencies":[]},
  {"name":"json","number":"1.6.3","dependencies":[]},
  {"name":"json","number":"1.7.4","dependencies":[]},
  {"name":"json","number":"1.1.3","dependencies":[]},
  {"name":"json","number":"1.4.5","dependencies":[]},
  {"name":"json","number":"1.5.0","dependencies":[]},
  {"name":"json","number":"1.4.1","dependencies":[]},
  {"name":"json","number":"0.4.0","dependencies":[]},
  {"name":"json","number":"1.2.2","dependencies":[]},
  {"name":"json","number":"1.7.5","dependencies":[]},
  {"name":"json","number":"1.0.2","dependencies":[]},
  {"name":"json","number":"1.1.1","dependencies":[]},
  {"name":"json","number":"1.6.6","dependencies":[]},
  {"name":"json","number":"1.4.3","dependencies":[]},
  {"name":"json","number":"1.7.6","dependencies":[]},
  {"name":"json","number":"1.5.5","dependencies":[]},
  {"name":"json","number":"1.6.8","dependencies":[]},
  {"name":"json","number":"1.7.7","dependencies":[]},
  {"name":"json","number":"1.8.0","dependencies":[]},
  {"name":"jwt","number":"0.1.11","dependencies":[["multi-json","1.5.0"]]},
  {"name":"jwt","number":"0.1.10","dependencies":[["multi-json","1.5.0"]]},
  {"name":"jwt","number":"0.1.2","dependencies":[["json","1.2.4"]]},
  {"name":"jwt","number":"0.1.3","dependencies":[["json","1.2.4"]]},
  {"name":"jwt","number":"0.1.1","dependencies":[["json","1.2.4"]]},
  {"name":"jwt","number":"0.1.4","dependencies":[["json","1.2.4"]]},
  {"name":"jwt","number":"0.1.5","dependencies":[["multi-json","1.0.0"]]},
  {"name":"jwt","number":"0.1.6","dependencies":[["multi-json","1.0.0"]]},
  {"name":"jwt","number":"0.1.7","dependencies":[["multi-json","1.5.0"]]},
  {"name":"jwt","number":"0.1.8","dependencies":[["multi-json","1.5.0"]]},
  {"name":"kaminari","number":"0.15.1","dependencies":[["actionpack","3.0.0 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.15.0","dependencies":[["actionpack","3.0.0 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.12.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.8","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.14.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.6.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.4.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.3.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.10.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.10.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.13.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.12.4","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.3","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.8.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.12.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.12.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.11.0","dependencies":[["kaminari",null]]},
  {"name":"kaminari","number":"0.10.4","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.10.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.13","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.7","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.12","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.6.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.2.1","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.10","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.10.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.5","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.2.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.7.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.4","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.9","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.5.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.1.0","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.9.6","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.12.2","dependencies":[["rails","3.0.0 || 4.0.0"]]},
  {"name":"kaminari","number":"0.14.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"]]},
  {"name":"kgio","number":"2.9.2","dependencies":[]},
  {"name":"kgio","number":"2.9.1","dependencies":[]},
  {"name":"kgio","number":"2.9.0","dependencies":[]},
  {"name":"kgio","number":"2.8.1","dependencies":[]},
  {"name":"kgio","number":"2.4.1","dependencies":[]},
  {"name":"kgio","number":"1.0.1","dependencies":[]},
  {"name":"kgio","number":"2.0.0","dependencies":[]},
  {"name":"kgio","number":"1.1.0","dependencies":[]},
  {"name":"kgio","number":"1.2.0","dependencies":[]},
  {"name":"kgio","number":"2.6.0","dependencies":[]},
  {"name":"kgio","number":"2.3.3","dependencies":[]},
  {"name":"kgio","number":"2.5.0","dependencies":[]},
  {"name":"kgio","number":"2.4.0","dependencies":[]},
  {"name":"kgio","number":"2.4.2","dependencies":[]},
  {"name":"kgio","number":"1.2.1","dependencies":[]},
  {"name":"kgio","number":"2.7.0","dependencies":[]},
  {"name":"kgio","number":"1.3.1","dependencies":[]},
  {"name":"kgio","number":"2.1.1","dependencies":[]},
  {"name":"kgio","number":"2.3.2","dependencies":[]},
  {"name":"kgio","number":"2.1.0","dependencies":[]},
  {"name":"kgio","number":"2.2.0","dependencies":[]},
  {"name":"kgio","number":"2.3.0","dependencies":[]},
  {"name":"kgio","number":"2.3.1","dependencies":[]},
  {"name":"kgio","number":"1.3.0","dependencies":[]},
  {"name":"kgio","number":"2.7.1","dependencies":[]},
  {"name":"kgio","number":"2.7.2","dependencies":[]},
  {"name":"kgio","number":"2.7.3","dependencies":[]},
  {"name":"kgio","number":"2.7.4","dependencies":[]},
  {"name":"kgio","number":"2.8.0","dependencies":[]},
  {"name":"launchy","number":"2.4.2","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.4.1","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.4.0","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.0.0","dependencies":[]},
  {"name":"launchy","number":"0.3.7","dependencies":[["rake",null],["configuration",null]]},
  {"name":"launchy","number":"0.3.5","dependencies":[["rake",null],["configuration",null]]},
  {"name":"launchy","number":"0.2.1","dependencies":[]},
  {"name":"launchy","number":"2.0.5","dependencies":[["addressable","2.2.6"]]},
  {"name":"launchy","number":"0.2.0","dependencies":[]},
  {"name":"launchy","number":"0.1.1","dependencies":[]},
  {"name":"launchy","number":"0.3.3","dependencies":[["rake",null],["configuration",null]]},
  {"name":"launchy","number":"0.3.2","dependencies":[]},
  {"name":"launchy","number":"2.0.2","dependencies":[]},
  {"name":"launchy","number":"2.0.3","dependencies":[]},
  {"name":"launchy","number":"0.3.0","dependencies":[]},
  {"name":"launchy","number":"0.4.0","dependencies":[["rake",null],["configuration",null]]},
  {"name":"launchy","number":"0.1.0","dependencies":[]},
  {"name":"launchy","number":"0.1.2","dependencies":[]},
  {"name":"launchy","number":"0.3.1","dependencies":[]},
  {"name":"launchy","number":"2.0.1","dependencies":[]},
  {"name":"launchy","number":"2.0.4","dependencies":[["addressable","2.2.6"]]},
  {"name":"launchy","number":"2.1.2","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.1.0","dependencies":[["addressable","2.2.6"]]},
  {"name":"launchy","number":"2.1.1","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.2.0","dependencies":[["addressable","2.3.0"]]},
  {"name":"launchy","number":"2.3.0","dependencies":[["addressable","2.3.0"]]},
  {"name":"letter-opener","number":"1.2.0","dependencies":[["launchy","2.2.0"]]},
  {"name":"letter-opener","number":"0.0.2","dependencies":[["launchy",null]]},
  {"name":"letter-opener","number":"0.1.0","dependencies":[["launchy","2.0.4"]]},
  {"name":"letter-opener","number":"0.0.1","dependencies":[["launchy",null]]},
  {"name":"letter-opener","number":"1.0.0","dependencies":[["launchy","2.0.4"]]},
  {"name":"letter-opener","number":"1.1.0","dependencies":[["launchy","2.2.0"]]},
  {"name":"letter-opener","number":"1.1.1","dependencies":[["launchy","2.2.0"]]},
  {"name":"letter-opener","number":"1.1.2","dependencies":[["launchy","2.2.0"]]},
  {"name":"libv8","number":"3.10.8","dependencies":[]},
  {"name":"libv8","number":"3.11.8","dependencies":[]},
  {"name":"libv8","number":"3.16.14","dependencies":[]},
  {"name":"listen","number":"2.7.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.7.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.6.2","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.6.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.6.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.5.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid-io",null],["celluloid",null]]},
  {"name":"listen","number":"2.4.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.4.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.3.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.2.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.1.2","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.1.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.1.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.0.4","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.0.3","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.0.2","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.0.1","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"2.0.0","dependencies":[["rb-inotify",null],["rb-fsevent",null],["celluloid",null]]},
  {"name":"listen","number":"0.4.4","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.2","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.3.3","dependencies":[["rb-fsevent","0.9.0"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.0","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.3.1","dependencies":[["rb-fsevent","0.9.0"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.1.0","dependencies":[]},
  {"name":"listen","number":"0.3.0","dependencies":[["rb-fsevent","0.9.0"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.3.2","dependencies":[["rb-fsevent","0.9.0"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.5","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.5.0","dependencies":[]},
  {"name":"listen","number":"0.5.1","dependencies":[]},
  {"name":"listen","number":"0.5.2","dependencies":[]},
  {"name":"listen","number":"0.5.3","dependencies":[]},
  {"name":"listen","number":"0.4.6","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.2.0","dependencies":[["rb-fsevent","0.9.0"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.1","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.3","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.4.7","dependencies":[["rb-fsevent","0.9.1"],["rb-inotify","0.8.8"],["rb-fchange","0.0.5"]]},
  {"name":"listen","number":"0.6.0","dependencies":[]},
  {"name":"listen","number":"0.7.0","dependencies":[]},
  {"name":"listen","number":"0.7.1","dependencies":[]},
  {"name":"listen","number":"0.7.2","dependencies":[]},
  {"name":"listen","number":"1.3.1","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"0.7.3","dependencies":[]},
  {"name":"listen","number":"1.0.0","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.0.2","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.0.1","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.0.3","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.0","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.1","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.2","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.3","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.4","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.5","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.1.6","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.2.0","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.2.1","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.2.2","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.2.3","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"listen","number":"1.3.0","dependencies":[["rb-fsevent",null],["rb-inotify",null],["rb-kqueue",null]]},
  {"name":"lumberjack","number":"1.0.5","dependencies":[]},
  {"name":"lumberjack","number":"1.0.1","dependencies":[]},
  {"name":"lumberjack","number":"1.0.0","dependencies":[]},
  {"name":"lumberjack","number":"1.0.2","dependencies":[]},
  {"name":"lumberjack","number":"1.0.3","dependencies":[]},
  {"name":"lumberjack","number":"1.0.4","dependencies":[]},
  {"name":"mail","number":"2.1.5","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.3.0","dependencies":[["tlsmail",null],["treetop","1.4.0"],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.5","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"2.2.14","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.4.1","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"1.5.3","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.2.5","dependencies":[["treetop","1.4.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["mime-types","1.0.0 || 2.0.0"]]},
  {"name":"mail","number":"2.2.15","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.17","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.18","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.4","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"1.3.2","dependencies":[["tlsmail",null],["treetop","1.4.0"],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.2.1","dependencies":[["treetop","1.4.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["mime-types","1.0.0 || 2.0.0"]]},
  {"name":"mail","number":"1.4.3","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.13","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.11","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n","0.5.0"]]},
  {"name":"mail","number":"2.2.6","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"2.2.16","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.7","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"2.4.0","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.10","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n","0.4.1"]]},
  {"name":"mail","number":"2.1.1","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.1.2","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.5.2","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.2.9","dependencies":[["tlsmail",null],["treetop","1.4.0"],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.9","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n","0.4.1"]]},
  {"name":"mail","number":"1.3.4","dependencies":[["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.3","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"1.3.5","dependencies":[["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.2.8","dependencies":[["tlsmail",null],["treetop","1.4.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.2","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"2.1.0","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.12","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.3.2","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.4.3","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.3.3","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.2.0","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"1.5.4","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.5.1","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.4.1","dependencies":[["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.2.1","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null],["treetop","1.4.5"]]},
  {"name":"mail","number":"2.1.3","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.0.0","dependencies":[["treetop","1.4.0"],["mime-types","1.0.0 || 2.0.0"]]},
  {"name":"mail","number":"2.3.0","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"1.1.0","dependencies":[["treetop","1.4.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["mime-types","1.0.0 || 2.0.0"]]},
  {"name":"mail","number":"2.2.19","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"1.3.1","dependencies":[["tlsmail",null],["treetop","1.4.0"],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.2.6","dependencies":[["tlsmail",null],["treetop",null],["activesupport",null],["mime-types",null]]},
  {"name":"mail","number":"1.3.3","dependencies":[["treetop",null],["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.4.2","dependencies":[["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.4.0","dependencies":[["tlsmail",null],["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.0.3","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.5.0","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.0.5","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"1.6.0","dependencies":[["activesupport","2.3.4 || 3.0.0 || 4.0.0"],["mime-types",null]]},
  {"name":"mail","number":"2.4.4","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.5.2","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.5.3","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"mail","number":"2.5.4","dependencies":[["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"]]},
  {"name":"mail","number":"2.2.20","dependencies":[["activesupport","2.3.6 || 3.0.0 || 4.0.0"],["mime-types","1.16.0 || 2.0.0"],["treetop","1.4.8"],["i18n",null]]},
  {"name":"method-source","number":"0.6.7","dependencies":[["ruby-parser","2.3.1"]]},
  {"name":"method-source","number":"0.6.5","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.3.5","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.1.1","dependencies":[]},
  {"name":"method-source","number":"0.3.2","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.6.0","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.3.3","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.2.0","dependencies":[]},
  {"name":"method-source","number":"0.1.4","dependencies":[]},
  {"name":"method-source","number":"0.7.0","dependencies":[]},
  {"name":"method-source","number":"0.8.1","dependencies":[]},
  {"name":"method-source","number":"0.4.0","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.3.4","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.1.0","dependencies":[]},
  {"name":"method-source","number":"0.4.1","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.6.6","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"method-source","number":"0.7.1","dependencies":[]},
  {"name":"method-source","number":"0.8.0","dependencies":[]},
  {"name":"method-source","number":"0.8.2","dependencies":[]},
  {"name":"mime-types","number":"2.2.0","dependencies":[]},
  {"name":"mime-types","number":"2.1.0","dependencies":[]},
  {"name":"mime-types","number":"1.25.1","dependencies":[]},
  {"name":"mime-types","number":"2.0.0","dependencies":[]},
  {"name":"mime-types","number":"1.17.2","dependencies":[]},
  {"name":"mime-types","number":"1.15.0","dependencies":[]},
  {"name":"mime-types","number":"1.18.0","dependencies":[]},
  {"name":"mime-types","number":"1.17.0","dependencies":[]},
  {"name":"mime-types","number":"1.17.1","dependencies":[]},
  {"name":"mime-types","number":"1.19.0","dependencies":[]},
  {"name":"mime-types","number":"1.20.0","dependencies":[]},
  {"name":"mime-types","number":"1.20.1","dependencies":[]},
  {"name":"mime-types","number":"1.21.0","dependencies":[]},
  {"name":"mime-types","number":"1.22.0","dependencies":[]},
  {"name":"mime-types","number":"1.23.0","dependencies":[]},
  {"name":"mime-types","number":"1.24.0","dependencies":[]},
  {"name":"mime-types","number":"1.25.0","dependencies":[]},
  {"name":"minitest","number":"5.3.1","dependencies":[]},
  {"name":"minitest","number":"5.3.0","dependencies":[]},
  {"name":"minitest","number":"5.2.3","dependencies":[]},
  {"name":"minitest","number":"5.2.2","dependencies":[]},
  {"name":"minitest","number":"5.2.1","dependencies":[]},
  {"name":"minitest","number":"5.2.0","dependencies":[]},
  {"name":"minitest","number":"5.1.0","dependencies":[]},
  {"name":"minitest","number":"5.0.8","dependencies":[]},
  {"name":"minitest","number":"1.7.1","dependencies":[]},
  {"name":"minitest","number":"1.4.1","dependencies":[["hoe","2.3.0"]]},
  {"name":"minitest","number":"1.7.2","dependencies":[]},
  {"name":"minitest","number":"2.12.1","dependencies":[]},
  {"name":"minitest","number":"1.4.0","dependencies":[["hoe","2.1.0"]]},
  {"name":"minitest","number":"1.7.0","dependencies":[]},
  {"name":"minitest","number":"4.0.0","dependencies":[]},
  {"name":"minitest","number":"1.5.0","dependencies":[]},
  {"name":"minitest","number":"2.9.0","dependencies":[]},
  {"name":"minitest","number":"1.6.0","dependencies":[]},
  {"name":"minitest","number":"1.3.1","dependencies":[["hoe","1.8.2 || 2.0.0"]]},
  {"name":"minitest","number":"1.4.2","dependencies":[["hoe","2.3.1"]]},
  {"name":"minitest","number":"1.3.0","dependencies":[["hoe","1.8.0 || 2.0.0"]]},
  {"name":"minitest","number":"2.10.1","dependencies":[]},
  {"name":"minitest","number":"2.6.0","dependencies":[]},
  {"name":"minitest","number":"2.4.0","dependencies":[]},
  {"name":"minitest","number":"2.11.2","dependencies":[]},
  {"name":"minitest","number":"2.1.0","dependencies":[]},
  {"name":"minitest","number":"2.0.1","dependencies":[]},
  {"name":"minitest","number":"2.5.0","dependencies":[]},
  {"name":"minitest","number":"3.0.1","dependencies":[]},
  {"name":"minitest","number":"2.11.1","dependencies":[]},
  {"name":"minitest","number":"2.0.0","dependencies":[]},
  {"name":"minitest","number":"2.2.1","dependencies":[]},
  {"name":"minitest","number":"2.3.0","dependencies":[]},
  {"name":"minitest","number":"2.11.0","dependencies":[]},
  {"name":"minitest","number":"2.6.2","dependencies":[]},
  {"name":"minitest","number":"2.2.2","dependencies":[]},
  {"name":"minitest","number":"2.0.2","dependencies":[]},
  {"name":"minitest","number":"2.5.1","dependencies":[]},
  {"name":"minitest","number":"2.2.0","dependencies":[]},
  {"name":"minitest","number":"3.3.0","dependencies":[]},
  {"name":"minitest","number":"2.3.1","dependencies":[]},
  {"name":"minitest","number":"3.1.0","dependencies":[]},
  {"name":"minitest","number":"2.10.0","dependencies":[]},
  {"name":"minitest","number":"2.6.1","dependencies":[]},
  {"name":"minitest","number":"2.7.0","dependencies":[]},
  {"name":"minitest","number":"2.8.0","dependencies":[]},
  {"name":"minitest","number":"2.8.1","dependencies":[]},
  {"name":"minitest","number":"2.9.1","dependencies":[]},
  {"name":"minitest","number":"2.11.3","dependencies":[]},
  {"name":"minitest","number":"2.11.4","dependencies":[]},
  {"name":"minitest","number":"2.12.0","dependencies":[]},
  {"name":"minitest","number":"3.0.0","dependencies":[]},
  {"name":"minitest","number":"3.2.0","dependencies":[]},
  {"name":"minitest","number":"3.4.0","dependencies":[]},
  {"name":"minitest","number":"3.5.0","dependencies":[]},
  {"name":"minitest","number":"4.1.0","dependencies":[]},
  {"name":"minitest","number":"4.2.0","dependencies":[]},
  {"name":"minitest","number":"4.3.0","dependencies":[]},
  {"name":"minitest","number":"4.3.1","dependencies":[]},
  {"name":"minitest","number":"4.3.2","dependencies":[]},
  {"name":"minitest","number":"4.3.3","dependencies":[]},
  {"name":"minitest","number":"4.4.0","dependencies":[]},
  {"name":"minitest","number":"4.5.0","dependencies":[]},
  {"name":"minitest","number":"4.6.0","dependencies":[]},
  {"name":"minitest","number":"4.6.1","dependencies":[]},
  {"name":"minitest","number":"4.6.2","dependencies":[]},
  {"name":"minitest","number":"4.7.0","dependencies":[]},
  {"name":"minitest","number":"4.7.1","dependencies":[]},
  {"name":"minitest","number":"4.7.2","dependencies":[]},
  {"name":"minitest","number":"4.7.3","dependencies":[]},
  {"name":"minitest","number":"4.7.4","dependencies":[]},
  {"name":"minitest","number":"5.0.0","dependencies":[]},
  {"name":"minitest","number":"5.0.1","dependencies":[]},
  {"name":"minitest","number":"5.0.2","dependencies":[]},
  {"name":"minitest","number":"5.0.3","dependencies":[]},
  {"name":"minitest","number":"5.0.4","dependencies":[]},
  {"name":"minitest","number":"5.0.5","dependencies":[]},
  {"name":"minitest","number":"4.7.5","dependencies":[]},
  {"name":"minitest","number":"5.0.6","dependencies":[]},
  {"name":"minitest","number":"5.0.7","dependencies":[]},
  {"name":"modernizr","number":"2.5.3","dependencies":[["sprockets","2.0.0"]]},
  {"name":"modernizr","number":"2.6.1","dependencies":[["sprockets","2.0.0"]]},
  {"name":"modernizr","number":"2.5.2","dependencies":[["sprockets","2.0.0"]]},
  {"name":"modernizr","number":"2.6.2","dependencies":[["sprockets","2.0.0"]]},
  {"name":"multi-json","number":"1.9.2","dependencies":[]},
  {"name":"multi-json","number":"1.9.1","dependencies":[]},
  {"name":"multi-json","number":"1.9.0","dependencies":[]},
  {"name":"multi-json","number":"1.8.4","dependencies":[]},
  {"name":"multi-json","number":"1.8.3","dependencies":[]},
  {"name":"multi-json","number":"1.8.2","dependencies":[]},
  {"name":"multi-json","number":"1.8.1","dependencies":[]},
  {"name":"multi-json","number":"1.3.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.2","dependencies":[]},
  {"name":"multi-json","number":"0.0.5","dependencies":[]},
  {"name":"multi-json","number":"1.1.0","dependencies":[]},
  {"name":"multi-json","number":"1.2.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.2","dependencies":[]},
  {"name":"multi-json","number":"1.0.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.5","dependencies":[]},
  {"name":"multi-json","number":"1.3.6","dependencies":[]},
  {"name":"multi-json","number":"0.0.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.1","dependencies":[]},
  {"name":"multi-json","number":"0.0.2","dependencies":[]},
  {"name":"multi-json","number":"0.0.3","dependencies":[]},
  {"name":"multi-json","number":"1.0.3","dependencies":[]},
  {"name":"multi-json","number":"1.3.7","dependencies":[]},
  {"name":"multi-json","number":"1.4.0","dependencies":[]},
  {"name":"multi-json","number":"1.5.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.1","dependencies":[]},
  {"name":"multi-json","number":"1.3.3","dependencies":[]},
  {"name":"multi-json","number":"1.3.0","dependencies":[]},
  {"name":"multi-json","number":"1.5.1","dependencies":[]},
  {"name":"multi-json","number":"1.6.0","dependencies":[]},
  {"name":"multi-json","number":"1.6.1","dependencies":[]},
  {"name":"multi-json","number":"1.8.0","dependencies":[]},
  {"name":"multi-json","number":"1.7.0","dependencies":[]},
  {"name":"multi-json","number":"1.7.1","dependencies":[]},
  {"name":"multi-json","number":"1.7.2","dependencies":[]},
  {"name":"multi-json","number":"1.7.3","dependencies":[]},
  {"name":"multi-json","number":"1.7.4","dependencies":[]},
  {"name":"multi-json","number":"1.7.5","dependencies":[]},
  {"name":"multi-json","number":"1.7.6","dependencies":[]},
  {"name":"multi-json","number":"1.7.7","dependencies":[]},
  {"name":"multi-json","number":"1.7.8","dependencies":[]},
  {"name":"multi-json","number":"1.7.9","dependencies":[]},
  {"name":"multi-xml","number":"0.1.1","dependencies":[]},
  {"name":"multi-xml","number":"0.3.0","dependencies":[]},
  {"name":"multi-xml","number":"0.2.1","dependencies":[]},
  {"name":"multi-xml","number":"0.1.4","dependencies":[]},
  {"name":"multi-xml","number":"0.4.4","dependencies":[]},
  {"name":"multi-xml","number":"0.4.2","dependencies":[]},
  {"name":"multi-xml","number":"0.1.2","dependencies":[]},
  {"name":"multi-xml","number":"0.5.0","dependencies":[]},
  {"name":"multi-xml","number":"0.1.0","dependencies":[]},
  {"name":"multi-xml","number":"0.1.3","dependencies":[]},
  {"name":"multi-xml","number":"0.2.2","dependencies":[]},
  {"name":"multi-xml","number":"0.4.0","dependencies":[]},
  {"name":"multi-xml","number":"0.4.1","dependencies":[]},
  {"name":"multi-xml","number":"0.0.1","dependencies":[]},
  {"name":"multi-xml","number":"0.2.0","dependencies":[]},
  {"name":"multi-xml","number":"0.5.1","dependencies":[]},
  {"name":"multi-xml","number":"0.4.3","dependencies":[]},
  {"name":"multi-xml","number":"0.5.2","dependencies":[]},
  {"name":"multi-xml","number":"0.5.3","dependencies":[]},
  {"name":"multi-xml","number":"0.5.4","dependencies":[]},
  {"name":"multi-xml","number":"0.5.5","dependencies":[]},
  {"name":"multipart-post","number":"2.0.0","dependencies":[]},
  {"name":"multipart-post","number":"1.1.0","dependencies":[]},
  {"name":"multipart-post","number":"1.0.0","dependencies":[["hoe","1.8.2 || 2.0.0"]]},
  {"name":"multipart-post","number":"0.1.0","dependencies":[["hoe","1.5.3 || 2.0.0"]]},
  {"name":"multipart-post","number":"1.0.1","dependencies":[]},
  {"name":"multipart-post","number":"1.1.1","dependencies":[]},
  {"name":"multipart-post","number":"1.1.4","dependencies":[]},
  {"name":"multipart-post","number":"1.1.5","dependencies":[]},
  {"name":"multipart-post","number":"1.1.2","dependencies":[]},
  {"name":"multipart-post","number":"1.1.3","dependencies":[]},
  {"name":"multipart-post","number":"1.2.0","dependencies":[]},
  {"name":"mysql2","number":"0.3.15","dependencies":[]},
  {"name":"mysql2","number":"0.2.22","dependencies":[]},
  {"name":"mysql2","number":"0.2.21","dependencies":[]},
  {"name":"mysql2","number":"0.3.14","dependencies":[]},
  {"name":"mysql2","number":"0.2.8","dependencies":[]},
  {"name":"mysql2","number":"0.3.0","dependencies":[]},
  {"name":"mysql2","number":"0.2.5","dependencies":[]},
  {"name":"mysql2","number":"0.2.14","dependencies":[]},
  {"name":"mysql2","number":"0.1.7","dependencies":[]},
  {"name":"mysql2","number":"0.2.6","dependencies":[]},
  {"name":"mysql2","number":"0.2.7","dependencies":[]},
  {"name":"mysql2","number":"0.3.1","dependencies":[]},
  {"name":"mysql2","number":"0.1.0","dependencies":[]},
  {"name":"mysql2","number":"0.3.6","dependencies":[]},
  {"name":"mysql2","number":"0.2.2","dependencies":[]},
  {"name":"mysql2","number":"0.2.10","dependencies":[]},
  {"name":"mysql2","number":"0.1.9","dependencies":[]},
  {"name":"mysql2","number":"0.1.8","dependencies":[]},
  {"name":"mysql2","number":"0.3.9","dependencies":[]},
  {"name":"mysql2","number":"0.3.10","dependencies":[]},
  {"name":"mysql2","number":"0.1.1","dependencies":[]},
  {"name":"mysql2","number":"0.2.1","dependencies":[]},
  {"name":"mysql2","number":"0.2.0","dependencies":[]},
  {"name":"mysql2","number":"0.2.13","dependencies":[]},
  {"name":"mysql2","number":"0.3.8","dependencies":[]},
  {"name":"mysql2","number":"0.1.3","dependencies":[]},
  {"name":"mysql2","number":"0.1.4","dependencies":[]},
  {"name":"mysql2","number":"0.1.6","dependencies":[]},
  {"name":"mysql2","number":"0.1.5","dependencies":[]},
  {"name":"mysql2","number":"0.2.11","dependencies":[]},
  {"name":"mysql2","number":"0.3.4","dependencies":[]},
  {"name":"mysql2","number":"0.2.18","dependencies":[]},
  {"name":"mysql2","number":"0.3.3","dependencies":[]},
  {"name":"mysql2","number":"0.3.2","dependencies":[]},
  {"name":"mysql2","number":"0.3.7","dependencies":[]},
  {"name":"mysql2","number":"0.3.11","dependencies":[]},
  {"name":"mysql2","number":"0.3.5","dependencies":[]},
  {"name":"mysql2","number":"0.2.4","dependencies":[]},
  {"name":"mysql2","number":"0.2.17","dependencies":[]},
  {"name":"mysql2","number":"0.2.16","dependencies":[]},
  {"name":"mysql2","number":"0.1.2","dependencies":[]},
  {"name":"mysql2","number":"0.2.3","dependencies":[]},
  {"name":"mysql2","number":"0.2.12","dependencies":[]},
  {"name":"mysql2","number":"0.2.9","dependencies":[]},
  {"name":"mysql2","number":"0.2.19","dependencies":[]},
  {"name":"mysql2","number":"0.3.12","dependencies":[]},
  {"name":"mysql2","number":"0.2.20","dependencies":[]},
  {"name":"mysql2","number":"0.3.13","dependencies":[]},
  {"name":"net-ldap","number":"0.5.1","dependencies":[]},
  {"name":"net-ldap","number":"0.2.2","dependencies":[]},
  {"name":"net-ldap","number":"0.2.0","dependencies":[]},
  {"name":"net-ldap","number":"0.2.1","dependencies":[]},
  {"name":"net-ldap","number":"0.3.1","dependencies":[]},
  {"name":"net-ldap","number":"0.1.1","dependencies":[]},
  {"name":"net-ldap","number":"0.0.5","dependencies":[]},
  {"name":"net-ldap","number":"0.1.0","dependencies":[]},
  {"name":"net-ldap","number":"0.3.0","dependencies":[]},
  {"name":"net-scp","number":"1.0.2","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.3","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.1","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.0","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.4","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.1.0","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-scp","number":"1.1.1","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-scp","number":"1.1.2","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-ssh","number":"2.8.0","dependencies":[]},
  {"name":"net-ssh","number":"2.7.0","dependencies":[]},
  {"name":"net-ssh","number":"2.0.23","dependencies":[]},
  {"name":"net-ssh","number":"1.0.5","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.1.4","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.1.1","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.1","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.22","dependencies":[]},
  {"name":"net-ssh","number":"2.0.18","dependencies":[]},
  {"name":"net-ssh","number":"1.1.3","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"0.9.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"0.5.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.8","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.11","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.0","dependencies":[]},
  {"name":"net-ssh","number":"1.0.7","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.20","dependencies":[]},
  {"name":"net-ssh","number":"2.0.6","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.1.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.1.3","dependencies":[]},
  {"name":"net-ssh","number":"2.0.13","dependencies":[]},
  {"name":"net-ssh","number":"2.0.7","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.2","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.2.1","dependencies":[]},
  {"name":"net-ssh","number":"2.3.0","dependencies":[]},
  {"name":"net-ssh","number":"2.0.24","dependencies":[]},
  {"name":"net-ssh","number":"2.0.1","dependencies":[]},
  {"name":"net-ssh","number":"2.0.2","dependencies":[]},
  {"name":"net-ssh","number":"1.0.9","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.1.0","dependencies":[]},
  {"name":"net-ssh","number":"1.1.2","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.10","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.6","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.19","dependencies":[]},
  {"name":"net-ssh","number":"2.0.5","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.3","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.10","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.2.2","dependencies":[]},
  {"name":"net-ssh","number":"2.0.14","dependencies":[]},
  {"name":"net-ssh","number":"2.0.8","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.16","dependencies":[]},
  {"name":"net-ssh","number":"2.0.15","dependencies":[]},
  {"name":"net-ssh","number":"2.0.17","dependencies":[]},
  {"name":"net-ssh","number":"2.0.21","dependencies":[]},
  {"name":"net-ssh","number":"0.6.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.4","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.9","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.3","dependencies":[]},
  {"name":"net-ssh","number":"2.0.4","dependencies":[]},
  {"name":"net-ssh","number":"2.1.4","dependencies":[]},
  {"name":"net-ssh","number":"2.2.0","dependencies":[]},
  {"name":"net-ssh","number":"2.5.2","dependencies":[]},
  {"name":"net-ssh","number":"2.6.1","dependencies":[]},
  {"name":"net-ssh","number":"2.6.2","dependencies":[]},
  {"name":"net-ssh","number":"2.6.3","dependencies":[]},
  {"name":"net-ssh","number":"2.6.4","dependencies":[]},
  {"name":"net-ssh","number":"2.6.5","dependencies":[]},
  {"name":"net-ssh","number":"2.6.6","dependencies":[]},
  {"name":"net-ssh","number":"2.6.7","dependencies":[]},
  {"name":"net-ssh","number":"2.6.8","dependencies":[]},
  {"name":"nokogiri","number":"1.6.1","dependencies":[["mini-portile","0.5.0"]]},
  {"name":"nokogiri","number":"1.5.11","dependencies":[]},
  {"name":"nokogiri","number":"1.1.0","dependencies":[]},
  {"name":"nokogiri","number":"1.2.2","dependencies":[["hoe","1.9.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.3.0","dependencies":[["racc",null],["tenderlove-frex",null],["rake-compiler",null],["hoe","1.12.2 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.0.6","dependencies":[]},
  {"name":"nokogiri","number":"1.2.0","dependencies":[]},
  {"name":"nokogiri","number":"1.2.1","dependencies":[]},
  {"name":"nokogiri","number":"1.4.1","dependencies":[]},
  {"name":"nokogiri","number":"1.0.1","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.4.7","dependencies":[]},
  {"name":"nokogiri","number":"1.1.1","dependencies":[]},
  {"name":"nokogiri","number":"1.5.0","dependencies":[]},
  {"name":"nokogiri","number":"1.0.5","dependencies":[]},
  {"name":"nokogiri","number":"1.0.4","dependencies":[]},
  {"name":"nokogiri","number":"1.0.3","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.4.3","dependencies":[]},
  {"name":"nokogiri","number":"1.3.2","dependencies":[["racc",null],["rexical",null],["rake-compiler",null],["hoe","2.2.0"]]},
  {"name":"nokogiri","number":"1.2.3","dependencies":[["hoe","1.9.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.4.6","dependencies":[]},
  {"name":"nokogiri","number":"1.4.0","dependencies":[]},
  {"name":"nokogiri","number":"1.4.2","dependencies":[]},
  {"name":"nokogiri","number":"1.5.2","dependencies":[]},
  {"name":"nokogiri","number":"1.5.4","dependencies":[]},
  {"name":"nokogiri","number":"1.3.3","dependencies":[["racc",null],["rexical",null],["rake-compiler",null],["hoe","2.3.2"]]},
  {"name":"nokogiri","number":"1.0.7","dependencies":[]},
  {"name":"nokogiri","number":"1.3.1","dependencies":[["racc",null],["rexical",null],["rake-compiler",null],["hoe","1.12.2 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.4.5","dependencies":[]},
  {"name":"nokogiri","number":"1.5.3","dependencies":[]},
  {"name":"nokogiri","number":"1.5.5","dependencies":[]},
  {"name":"nokogiri","number":"1.4.4","dependencies":[]},
  {"name":"nokogiri","number":"1.0.0","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.5.1","dependencies":[]},
  {"name":"nokogiri","number":"1.0.2","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"nokogiri","number":"1.5.6","dependencies":[]},
  {"name":"nokogiri","number":"1.5.7","dependencies":[]},
  {"name":"nokogiri","number":"1.5.8","dependencies":[]},
  {"name":"nokogiri","number":"1.5.9","dependencies":[]},
  {"name":"nokogiri","number":"1.5.10","dependencies":[]},
  {"name":"nokogiri","number":"1.6.0","dependencies":[["mini-portile","0.5.0"]]},
  {"name":"oauth","number":"0.2.0","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.4.5","dependencies":[]},
  {"name":"oauth","number":"0.2.6","dependencies":[["ruby-hmac",null],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.2.1","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.3.2","dependencies":[["ruby-hmac",null],["actionpack",null],["rack",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.3.4","dependencies":[["ruby-hmac",null],["actionpack",null],["rack",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.3.0","dependencies":[["ruby-hmac",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.2.4","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.2.2","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.4.6","dependencies":[]},
  {"name":"oauth","number":"0.1.1","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.4.3","dependencies":[]},
  {"name":"oauth","number":"0.4.0","dependencies":[]},
  {"name":"oauth","number":"0.3.1","dependencies":[["ruby-hmac",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.3.5","dependencies":[["ruby-hmac",null],["actionpack",null],["rack",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.3.3","dependencies":[["ruby-hmac",null],["actionpack",null],["rack",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.3.6","dependencies":[["ruby-hmac",null]]},
  {"name":"oauth","number":"0.4.1","dependencies":[]},
  {"name":"oauth","number":"0.4.2","dependencies":[]},
  {"name":"oauth","number":"0.4.4","dependencies":[]},
  {"name":"oauth","number":"0.2.7","dependencies":[["ruby-hmac",null],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"oauth","number":"0.4.7","dependencies":[]},
  {"name":"oauth2","number":"0.9.3","dependencies":[["jwt","0.1.8"],["rack","1.2.0"],["multi-xml","0.5.0"],["multi-json","1.3.0"],["faraday",null]]},
  {"name":"oauth2","number":"0.0.12","dependencies":[["faraday","0.4.1"],["multi-json",null]]},
  {"name":"oauth2","number":"0.6.0","dependencies":[["faraday","0.7.0"],["multi-json","1.0.0"],["httpauth","0.1.0"]]},
  {"name":"oauth2","number":"0.5.1","dependencies":[["faraday","0.7.4"],["multi-json","1.0.3"]]},
  {"name":"oauth2","number":"0.0.2","dependencies":[]},
  {"name":"oauth2","number":"0.3.0","dependencies":[["faraday","0.6.0"],["multi-json","0.0.4 || 1.0.0"]]},
  {"name":"oauth2","number":"0.0.10","dependencies":[["faraday","0.4.1"],["multi-json",null]]},
  {"name":"oauth2","number":"0.1.0","dependencies":[["faraday","0.5.0"],["multi-json","0.0.4 || 1.0.0"]]},
  {"name":"oauth2","number":"0.0.5","dependencies":[["faraday","0.3.0"]]},
  {"name":"oauth2","number":"0.5.2","dependencies":[["faraday","0.7.0"],["multi-json","1.0.0"]]},
  {"name":"oauth2","number":"0.0.1","dependencies":[]},
  {"name":"oauth2","number":"0.4.1","dependencies":[["faraday","0.6.1"],["multi-json",null]]},
  {"name":"oauth2","number":"0.0.4","dependencies":[["faraday","0.3.0"]]},
  {"name":"oauth2","number":"0.0.3","dependencies":[]},
  {"name":"oauth2","number":"0.0.8","dependencies":[["faraday","0.4.1"]]},
  {"name":"oauth2","number":"0.0.9","dependencies":[["faraday","0.4.1"],["multi-json",null]]},
  {"name":"oauth2","number":"0.2.0","dependencies":[["faraday","0.6.0"],["multi-json","0.0.4 || 1.0.0"]]},
  {"name":"oauth2","number":"0.6.1","dependencies":[["faraday","0.7.0"],["multi-json","1.3.0"],["httpauth","0.1.0"]]},
  {"name":"oauth2","number":"0.7.0","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.3.0"],["rack","1.4.0"]]},
  {"name":"oauth2","number":"0.8.0","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.0.0"],["rack","1.2.0"],["jwt","0.1.4"]]},
  {"name":"oauth2","number":"0.0.11","dependencies":[["faraday","0.4.1"],["faraday-middleware",null],["multi-json",null]]},
  {"name":"oauth2","number":"0.1.1","dependencies":[["faraday","0.5.0"],["multi-json","0.0.4 || 1.0.0"]]},
  {"name":"oauth2","number":"0.4.0","dependencies":[["faraday","0.6.0"],["multi-json","0.0.4 || 1.0.0"]]},
  {"name":"oauth2","number":"0.0.7","dependencies":[["faraday","0.4.1"]]},
  {"name":"oauth2","number":"0.0.6","dependencies":[["faraday","0.3.0"]]},
  {"name":"oauth2","number":"0.0.13","dependencies":[["faraday","0.4.1"],["multi-json",null]]},
  {"name":"oauth2","number":"0.5.0","dependencies":[["faraday",null],["multi-json","1.0.0"],["faraday",null]]},
  {"name":"oauth2","number":"0.7.1","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.0.0"],["rack","1.4.0"]]},
  {"name":"oauth2","number":"0.9.0","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.0.0"],["multi-xml","0.5.0"],["rack","1.2.0"],["jwt","0.1.4"]]},
  {"name":"oauth2","number":"0.9.1","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.0.0"],["multi-xml","0.5.0"],["rack","1.2.0"],["jwt","0.1.4"]]},
  {"name":"oauth2","number":"0.8.1","dependencies":[["faraday","0.8.0"],["httpauth","0.1.0"],["multi-json","1.0.0"],["rack","1.2.0"],["jwt","0.1.4"]]},
  {"name":"oauth2","number":"0.9.2","dependencies":[["faraday","0.8.0"],["httpauth","0.2.0"],["multi-json","1.0.0"],["multi-xml","0.5.0"],["rack","1.2.0"],["jwt","0.1.4"]]},
  {"name":"omniauth","number":"1.2.1","dependencies":[["rack","1.0.0"],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"1.0.2","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"0.2.5","dependencies":[["oa-core","=0.2.5"],["oa-oauth","=0.2.5"],["oa-basic","=0.2.5"],["oa-openid","=0.2.5"],["oa-enterprise","=0.2.5"],["oa-more","=0.2.5"]]},
  {"name":"omniauth","number":"0.2.1","dependencies":[["oa-core","=0.2.1"],["oa-oauth","=0.2.1"],["oa-basic","=0.2.1"],["oa-openid","=0.2.1"],["oa-enterprise","=0.2.1"],["oa-more","=0.2.1"]]},
  {"name":"omniauth","number":"0.2.3","dependencies":[["oa-core","=0.2.3"],["oa-oauth","=0.2.3"],["oa-basic","=0.2.3"],["oa-openid","=0.2.3"],["oa-enterprise","=0.2.3"],["oa-more","=0.2.3"]]},
  {"name":"omniauth","number":"1.1.0","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"1.0.0","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"0.1.2","dependencies":[["oa-core","=0.1.2"],["oa-oauth","=0.1.2"],["oa-basic","=0.1.2"],["oa-openid","=0.1.2"],["oa-enterprise","=0.1.2"]]},
  {"name":"omniauth","number":"0.2.2","dependencies":[["oa-core","=0.2.2"],["oa-oauth","=0.2.2"],["oa-basic","=0.2.2"],["oa-openid","=0.2.2"],["oa-enterprise","=0.2.2"],["oa-more","=0.2.2"]]},
  {"name":"omniauth","number":"0.3.0","dependencies":[["oa-basic","=0.3.0"],["oa-enterprise","=0.3.0"],["oa-core","=0.3.0"],["oa-more","=0.3.0"],["oa-oauth","=0.3.0"],["oa-openid","=0.3.0"]]},
  {"name":"omniauth","number":"0.0.1","dependencies":[["oa-core","0.0.0"],["oa-oauth","0.0.0"],["oa-openid","0.0.0"]]},
  {"name":"omniauth","number":"0.2.0","dependencies":[["oa-core","=0.2.0"],["oa-oauth","=0.2.0"],["oa-basic","=0.2.0"],["oa-openid","=0.2.0"],["oa-enterprise","=0.2.0"],["oa-more","=0.2.0"]]},
  {"name":"omniauth","number":"0.1.6","dependencies":[["oa-core","=0.1.6"],["oa-oauth","=0.1.6"],["oa-basic","=0.1.6"],["oa-openid","=0.1.6"],["oa-enterprise","=0.1.6"]]},
  {"name":"omniauth","number":"0.0.5","dependencies":[["oa-core","=0.0.5"],["oa-oauth","=0.0.5"],["oa-basic","=0.0.5"],["oa-openid","=0.0.5"],["oa-enterprise","=0.0.5"]]},
  {"name":"omniauth","number":"0.1.4","dependencies":[["oa-core","=0.1.4"],["oa-oauth","=0.1.4"],["oa-basic","=0.1.4"],["oa-openid","=0.1.4"],["oa-enterprise","=0.1.4"]]},
  {"name":"omniauth","number":"0.2.4","dependencies":[["oa-core","=0.2.4"],["oa-oauth","=0.2.4"],["oa-basic","=0.2.4"],["oa-openid","=0.2.4"],["oa-enterprise","=0.2.4"],["oa-more","=0.2.4"]]},
  {"name":"omniauth","number":"0.0.4","dependencies":[["oa-core","=0.0.4"],["oa-oauth","=0.0.4"],["oa-basic","=0.0.4"],["oa-openid","=0.0.4"],["oa-enterprise","=0.0.4"]]},
  {"name":"omniauth","number":"0.1.5","dependencies":[["oa-core","=0.1.5"],["oa-oauth","=0.1.5"],["oa-basic","=0.1.5"],["oa-openid","=0.1.5"],["oa-enterprise","=0.1.5"]]},
  {"name":"omniauth","number":"0.1.3","dependencies":[["oa-core","=0.1.3"],["oa-oauth","=0.1.3"],["oa-basic","=0.1.3"],["oa-openid","=0.1.3"],["oa-enterprise","=0.1.3"]]},
  {"name":"omniauth","number":"0.0.3","dependencies":[["oa-core","=0.0.3"],["oa-oauth","=0.0.3"],["oa-basic","=0.0.3"],["oa-openid","=0.0.3"]]},
  {"name":"omniauth","number":"0.1.0","dependencies":[["oa-core","=0.1.0"],["oa-oauth","=0.1.0"],["oa-basic","=0.1.0"],["oa-openid","=0.1.0"],["oa-enterprise","=0.1.0"]]},
  {"name":"omniauth","number":"0.2.6","dependencies":[["oa-basic","=0.2.6"],["oa-enterprise","=0.2.6"],["oa-core","=0.2.6"],["oa-more","=0.2.6"],["oa-oauth","=0.2.6"],["oa-openid","=0.2.6"]]},
  {"name":"omniauth","number":"0.1.1","dependencies":[["oa-core","=0.1.1"],["oa-oauth","=0.1.1"],["oa-basic","=0.1.1"],["oa-openid","=0.1.1"],["oa-enterprise","=0.1.1"]]},
  {"name":"omniauth","number":"0.3.2","dependencies":[["oa-basic","=0.3.2"],["oa-enterprise","=0.3.2"],["oa-core","=0.3.2"],["oa-more","=0.3.2"],["oa-oauth","=0.3.2"],["oa-openid","=0.3.2"]]},
  {"name":"omniauth","number":"1.0.1","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"1.0.3","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"1.1.1","dependencies":[["rack",null],["hashie","1.2.0 || 2.0.0"]]},
  {"name":"omniauth","number":"1.1.2","dependencies":[["hashie","1.2.0 || 2.0.0"],["rack",null]]},
  {"name":"omniauth","number":"1.1.3","dependencies":[["hashie","1.2.0 || 2.0.0"],["rack",null]]},
  {"name":"omniauth","number":"1.1.4","dependencies":[["hashie","1.2.0 || 2.0.0"],["rack",null]]},
  {"name":"omniauth-github","number":"1.0.0","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.0.0"]]},
  {"name":"omniauth-github","number":"1.0.1","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.0.0"]]},
  {"name":"omniauth-github","number":"1.0.2","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.1.0"]]},
  {"name":"omniauth-github","number":"1.0.3","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.1.0"]]},
  {"name":"omniauth-github","number":"1.1.0","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.1.0"]]},
  {"name":"omniauth-github","number":"1.1.1","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.1.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.2.2","dependencies":[["omniauth-oauth2",null],["omniauth","1.0.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.1.11","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.3","dependencies":[["omniauth","1.0.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.1.2","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.8","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.6","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.4","dependencies":[["omniauth","1.0.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.1.8","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.13","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.1","dependencies":[["omniauth","1.0.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.0.5","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.7","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.9","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.10","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.0","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.1","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.3","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.6","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.12","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.10","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.9","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.0.2","dependencies":[["omniauth","1.0.0"]]},
  {"name":"omniauth-google-oauth2","number":"0.1.4","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.7","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.15","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.16","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.17","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.18","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.1.19","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.2.0","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-google-oauth2","number":"0.2.1","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2",null]]},
  {"name":"omniauth-oauth","number":"1.0.0","dependencies":[["omniauth","1.0.0"],["oauth",null]]},
  {"name":"omniauth-oauth","number":"1.0.1","dependencies":[["omniauth","1.0.0"],["oauth",null]]},
  {"name":"omniauth-oauth2","number":"1.1.2","dependencies":[["omniauth","1.2.0"],["oauth2","0.9.3"],["multi-json","1.3.0"],["faraday",null]]},
  {"name":"omniauth-oauth2","number":"1.1.0","dependencies":[["omniauth","1.0.0"],["oauth2","0.8.0"]]},
  {"name":"omniauth-oauth2","number":"1.0.2","dependencies":[["omniauth","1.0.0"],["oauth2","0.6.0"]]},
  {"name":"omniauth-oauth2","number":"1.0.0","dependencies":[["omniauth","1.0.0"],["oauth2","0.5.0"]]},
  {"name":"omniauth-oauth2","number":"1.0.1","dependencies":[["omniauth","1.0.0"],["oauth2","0.6.0"]]},
  {"name":"omniauth-oauth2","number":"1.1.1","dependencies":[["omniauth","1.0.0"],["oauth2","0.8.0"]]},
  {"name":"omniauth-oauth2","number":"1.0.3","dependencies":[["omniauth","1.0.0"],["oauth2","0.8.0"]]},
  {"name":"omniauth-twitter","number":"1.0.1","dependencies":[["omniauth-oauth","1.0.0"],["multi-json","1.3.0"]]},
  {"name":"omniauth-twitter","number":"0.0.10","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.11","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.9","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.8","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.1","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.2","dependencies":[["omniauth","1.0.0"],["omniauth-oauth2","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.7","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.5","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.3","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.4","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.6","dependencies":[["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.12","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.13","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.14","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.15","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.16","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.17","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"0.0.18","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"omniauth-twitter","number":"1.0.0","dependencies":[["multi-json","1.3.0"],["omniauth-oauth","1.0.0"]]},
  {"name":"orm-adapter","number":"0.5.0","dependencies":[]},
  {"name":"orm-adapter","number":"0.4.1","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.2","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.4","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.1","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.6","dependencies":[]},
  {"name":"orm-adapter","number":"0.1.0","dependencies":[]},
  {"name":"orm-adapter","number":"0.3.0","dependencies":[]},
  {"name":"orm-adapter","number":"0.4.0","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.3","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.5","dependencies":[]},
  {"name":"orm-adapter","number":"0.2.0","dependencies":[]},
  {"name":"orm-adapter","number":"0.0.7","dependencies":[]},
  {"name":"pg","number":"0.17.1","dependencies":[]},
  {"name":"pg","number":"0.17.0","dependencies":[]},
  {"name":"pg","number":"0.8.0","dependencies":[]},
  {"name":"pg","number":"0.10.0","dependencies":[]},
  {"name":"pg","number":"0.10.1","dependencies":[]},
  {"name":"pg","number":"0.9.0","dependencies":[]},
  {"name":"pg","number":"0.13.0","dependencies":[]},
  {"name":"pg","number":"0.12.2","dependencies":[]},
  {"name":"pg","number":"0.11.0","dependencies":[]},
  {"name":"pg","number":"0.12.0","dependencies":[["rake-compiler","0.7.0"]]},
  {"name":"pg","number":"0.13.1","dependencies":[]},
  {"name":"pg","number":"0.13.2","dependencies":[]},
  {"name":"pg","number":"0.12.1","dependencies":[]},
  {"name":"pg","number":"0.14.0","dependencies":[]},
  {"name":"pg","number":"0.14.1","dependencies":[]},
  {"name":"pg","number":"0.15.0","dependencies":[]},
  {"name":"pg","number":"0.15.1","dependencies":[]},
  {"name":"pg","number":"0.16.0","dependencies":[]},
  {"name":"phantomjs","number":"1.9.7","dependencies":[]},
  {"name":"phantomjs","number":"1.9.2","dependencies":[]},
  {"name":"phantomjs","number":"1.6.0","dependencies":[]},
  {"name":"phantomjs","number":"1.8.1","dependencies":[["poltergeist",null]]},
  {"name":"poltergeist","number":"1.5.0","dependencies":[["cliver","0.3.1"],["multi-json","1.0.0"],["websocket-driver",null],["capybara","2.1.0"]]},
  {"name":"poltergeist","number":"1.0.1","dependencies":[["capybara","1.1.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"0.2.0","dependencies":[["capybara","1.0.0 || 2.0.0"],["em-websocket","0.3.1"],["json","1.6.0"],["sfl","2.0.0"]]},
  {"name":"poltergeist","number":"0.1.0","dependencies":[["capybara","1.1.0 || 2.0.0"],["em-websocket","0.3.1"],["json","1.6.0"]]},
  {"name":"poltergeist","number":"0.5.0","dependencies":[["capybara","1.0.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.0.0","dependencies":[["capybara","1.1.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"0.4.0","dependencies":[["capybara","1.0.0 || 2.0.0"],["json","1.6.0"],["sfl","2.0.0"],["http-parser.rb","0.5.3"],["faye-websocket","0.2.0"]]},
  {"name":"poltergeist","number":"0.3.0","dependencies":[["capybara","1.0.0 || 2.0.0"],["json","1.6.0"],["sfl","2.0.0"],["http-parser.rb","0.5.3"],["faye-websocket","0.2.0"]]},
  {"name":"poltergeist","number":"0.6.0","dependencies":[["capybara","1.0.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"0.7.0","dependencies":[["capybara","1.1.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.0.2","dependencies":[["capybara","1.1.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.1.0","dependencies":[["capybara","2.0.1"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.1.1","dependencies":[["capybara","2.0.1"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.2.0","dependencies":[["capybara","2.1.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.3.0","dependencies":[["capybara","2.1.0"],["http-parser.rb","0.5.3"],["faye-websocket",null]]},
  {"name":"poltergeist","number":"1.1.2","dependencies":[["capybara","2.0.1"],["http-parser.rb","0.5.3"],["faye-websocket","0.4.4"]]},
  {"name":"poltergeist","number":"1.0.3","dependencies":[["capybara","1.1.0 || 2.0.0"],["multi-json","1.0.0"],["childprocess","0.3.0"],["http-parser.rb","0.5.3"],["faye-websocket","0.4.4"]]},
  {"name":"poltergeist","number":"1.4.0","dependencies":[["capybara","2.1.0"],["websocket-driver",null],["multi-json","1.0.0"],["cliver","0.2.1"]]},
  {"name":"poltergeist","number":"1.4.1","dependencies":[["capybara","2.1.0"],["websocket-driver",null],["multi-json","1.0.0"],["cliver","0.2.1"]]},
  {"name":"polyglot","number":"0.3.4","dependencies":[]},
  {"name":"polyglot","number":"0.2.5","dependencies":[["hoe","1.8.0 || 2.0.0"]]},
  {"name":"polyglot","number":"0.2.9","dependencies":[]},
  {"name":"polyglot","number":"0.2.1","dependencies":[]},
  {"name":"polyglot","number":"0.2.3","dependencies":[]},
  {"name":"polyglot","number":"0.3.0","dependencies":[]},
  {"name":"polyglot","number":"0.1.0","dependencies":[]},
  {"name":"polyglot","number":"0.2.8","dependencies":[["hoe","2.3.2"]]},
  {"name":"polyglot","number":"0.3.2","dependencies":[]},
  {"name":"polyglot","number":"0.2.6","dependencies":[["hoe","1.8.0 || 2.0.0"]]},
  {"name":"polyglot","number":"0.3.1","dependencies":[]},
  {"name":"polyglot","number":"0.2.0","dependencies":[]},
  {"name":"polyglot","number":"0.2.7","dependencies":[["hoe","2.3.2"]]},
  {"name":"polyglot","number":"0.2.4","dependencies":[["hoe","1.8.0 || 2.0.0"]]},
  {"name":"polyglot","number":"0.2.2","dependencies":[]},
  {"name":"polyglot","number":"0.3.3","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.8","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.0","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.5","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.2","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.3","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.1","dependencies":[]},
  {"name":"posix-spawn","number":"0.3.6","dependencies":[]},
  {"name":"protected-attributes","number":"1.0.7","dependencies":[["activemodel","4.0.1"]]},
  {"name":"protected-attributes","number":"1.0.6","dependencies":[["activemodel","4.0.1"]]},
  {"name":"protected-attributes","number":"1.0.5","dependencies":[["activemodel","4.0.1"]]},
  {"name":"protected-attributes","number":"1.0.4","dependencies":[["activemodel","4.0.1"]]},
  {"name":"protected-attributes","number":"1.0.0","dependencies":[["activemodel","4.0.0"]]},
  {"name":"protected-attributes","number":"1.0.1","dependencies":[["activemodel","4.0.0"]]},
  {"name":"protected-attributes","number":"1.0.2","dependencies":[["activemodel","4.0.0"]]},
  {"name":"protected-attributes","number":"1.0.3","dependencies":[["activemodel","4.0.0"]]},
  {"name":"pry","number":"0.5.6","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.1.2","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"pry","number":"0.6.6","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.5.2","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.7.1","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.6.2","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.6.3","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.6","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","2.1.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.8.1","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.5.2 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.9.9","dependencies":[["coderay","1.0.5"],["slop","2.4.4 || 3.0.0"],["method-source","0.7.1"]]},
  {"name":"pry","number":"0.9.3","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.9.0 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.4.8","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.7.7","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.4.6","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.5","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","2.1.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.3.0","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.2.8","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.2.0","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"pry","number":"0.5.7","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.4.2","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.4.4","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.5.4","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.5.0","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.6.5","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.2","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.9.0 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.9.10","dependencies":[["coderay","1.0.5"],["slop","3.3.1"],["method-source","0.8.0"]]},
  {"name":"pry","number":"0.4.1","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.8.2","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.5.2 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.7.3","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.6.7","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.2.6","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.4.7","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.8.0","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.5.2 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.8.3","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.5.3 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.5.5","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.7.0","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.4.3","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.7","dependencies":[["ruby-parser","2.3.1"],["coderay","0.9.8 || 1.0.0"],["slop","2.1.0 || 3.0.0"],["method-source","0.6.5"]]},
  {"name":"pry","number":"0.5.9","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.8","dependencies":[["coderay","1.0.5"],["slop","2.4.3 || 3.0.0"],["method-source","0.7.0"]]},
  {"name":"pry","number":"0.9.1","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.9.0 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.6.1","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.5.8","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.6.0","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.4.5","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.6.4","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.4.0","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.7.4","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.6.8","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.9.0","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["slop","1.9.0 || 2.0.0 || 3.0.0"],["method-source",null]]},
  {"name":"pry","number":"0.1.0","dependencies":[["ruby-parser","2.0.5"]]},
  {"name":"pry","number":"0.7.6","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.7.2","dependencies":[["ruby-parser","2.0.5"],["coderay",null],["method-source",null]]},
  {"name":"pry","number":"0.5.1","dependencies":[["ruby-parser","2.0.5"],["method-source",null]]},
  {"name":"pry","number":"0.9.11","dependencies":[["coderay","1.0.5"],["slop","3.4.0"],["method-source","0.8.0"]]},
  {"name":"pry","number":"0.9.12","dependencies":[["coderay","1.0.5"],["slop","3.4.0"],["method-source","0.8.0"]]},
  {"name":"pyu-ruby-sasl","number":"0.3.2","dependencies":[]},
  {"name":"pyu-ruby-sasl","number":"0.3.3","dependencies":[]},
  {"name":"quiet-assets","number":"1.0.1","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"quiet-assets","number":"1.0.0","dependencies":[["rails","3.1.0 || 4.0.0"]]},
  {"name":"quiet-assets","number":"1.0.2","dependencies":[["railties","3.1.0 || 4.0.0"]]},
  {"name":"racc","number":"1.4.11","dependencies":[]},
  {"name":"racc","number":"1.4.10","dependencies":[]},
  {"name":"racc","number":"1.4.6","dependencies":[]},
  {"name":"racc","number":"1.4.8","dependencies":[]},
  {"name":"racc","number":"1.4.7","dependencies":[]},
  {"name":"racc","number":"1.4.9","dependencies":[]},
  {"name":"rack","number":"0.9.0","dependencies":[["test-spec",null],["camping",null],["fcgi",null],["memcache-client",null],["mongrel",null],["ruby-openid","2.0.0"],["thin",null]]},
  {"name":"rack","number":"1.1.3","dependencies":[]},
  {"name":"rack","number":"1.1.0","dependencies":[]},
  {"name":"rack","number":"1.2.3","dependencies":[]},
  {"name":"rack","number":"1.2.2","dependencies":[]},
  {"name":"rack","number":"0.2.0","dependencies":[]},
  {"name":"rack","number":"0.4.0","dependencies":[]},
  {"name":"rack","number":"1.1.1","dependencies":[]},
  {"name":"rack","number":"1.2.0","dependencies":[]},
  {"name":"rack","number":"1.2.1","dependencies":[]},
  {"name":"rack","number":"1.0.0","dependencies":[["test-spec",null],["camping",null],["fcgi",null],["memcache-client",null],["mongrel",null],["ruby-openid","2.0.0"],["thin",null]]},
  {"name":"rack","number":"1.3.2","dependencies":[]},
  {"name":"rack","number":"1.3.3","dependencies":[]},
  {"name":"rack","number":"1.0.1","dependencies":[]},
  {"name":"rack","number":"0.3.0","dependencies":[]},
  {"name":"rack","number":"0.1.0","dependencies":[]},
  {"name":"rack","number":"0.9.1","dependencies":[]},
  {"name":"rack","number":"1.1.2","dependencies":[]},
  {"name":"rack","number":"1.2.4","dependencies":[]},
  {"name":"rack","number":"1.2.5","dependencies":[]},
  {"name":"rack","number":"1.3.5","dependencies":[]},
  {"name":"rack","number":"1.3.0","dependencies":[]},
  {"name":"rack","number":"1.3.1","dependencies":[]},
  {"name":"rack","number":"1.3.4","dependencies":[]},
  {"name":"rack","number":"1.3.6","dependencies":[]},
  {"name":"rack","number":"1.4.0","dependencies":[]},
  {"name":"rack","number":"1.4.1","dependencies":[]},
  {"name":"rack","number":"1.3.7","dependencies":[]},
  {"name":"rack","number":"1.4.2","dependencies":[]},
  {"name":"rack","number":"1.1.4","dependencies":[]},
  {"name":"rack","number":"1.2.6","dependencies":[]},
  {"name":"rack","number":"1.3.8","dependencies":[]},
  {"name":"rack","number":"1.4.3","dependencies":[]},
  {"name":"rack","number":"1.2.7","dependencies":[]},
  {"name":"rack","number":"1.4.4","dependencies":[]},
  {"name":"rack","number":"1.1.5","dependencies":[]},
  {"name":"rack","number":"1.3.9","dependencies":[]},
  {"name":"rack","number":"1.5.0","dependencies":[]},
  {"name":"rack","number":"1.5.1","dependencies":[]},
  {"name":"rack","number":"1.2.8","dependencies":[]},
  {"name":"rack","number":"1.4.5","dependencies":[]},
  {"name":"rack","number":"1.1.6","dependencies":[]},
  {"name":"rack","number":"1.3.10","dependencies":[]},
  {"name":"rack","number":"1.5.2","dependencies":[]},
  {"name":"rack-accept","number":"0.3.0","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.1.1","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.1.0","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.2.0","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.4.1","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.4.5","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.4.3","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.4.4","dependencies":[["rack",null]]},
  {"name":"rack-accept","number":"0.4.2","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"3.0.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.3.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"0.0.1","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"0.1.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.3.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.3.1","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.3.2","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"0.2.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"0.0.3","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.0.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.1.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"1.2.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.0.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.1.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.1.1","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.2.0","dependencies":[["rack",null]]},
  {"name":"rack-attack","number":"2.2.1","dependencies":[["rack",null]]},
  {"name":"rack-cors","number":"0.2.9","dependencies":[]},
  {"name":"rack-cors","number":"0.2.0","dependencies":[]},
  {"name":"rack-cors","number":"0.2.2","dependencies":[]},
  {"name":"rack-cors","number":"0.2.4","dependencies":[["rack",null]]},
  {"name":"rack-cors","number":"0.1.1","dependencies":[]},
  {"name":"rack-cors","number":"0.1.0","dependencies":[]},
  {"name":"rack-cors","number":"0.2.5","dependencies":[["rack-cors",null],["rack",null]]},
  {"name":"rack-cors","number":"0.2.6","dependencies":[["rack",null]]},
  {"name":"rack-cors","number":"0.2.7","dependencies":[["rack",null]]},
  {"name":"rack-cors","number":"0.2.8","dependencies":[["rack",null]]},
  {"name":"rack-mini-profiler","number":"0.9.1","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.9.0","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.5","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.7","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.8","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.17","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.18","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.10","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.19","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.20","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.21","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.22","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.2","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.0","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.3","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.6","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.1","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.9","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.4","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.16","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.23","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.24","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.25","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.26","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.27","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.28","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.29","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.30","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mini-profiler","number":"0.1.31","dependencies":[["rack","1.1.3"]]},
  {"name":"rack-mount","number":"0.6.6","dependencies":[["rack",null]]},
  {"name":"rack-mount","number":"0.7.4","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.8.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.7.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.2.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.8.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.2.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.5.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.0.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.4","dependencies":[]},
  {"name":"rack-mount","number":"0.6.3","dependencies":[]},
  {"name":"rack-mount","number":"0.2.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.2","dependencies":[]},
  {"name":"rack-mount","number":"0.4.5","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.6","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.7","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.5.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.7","dependencies":[["rack",null]]},
  {"name":"rack-mount","number":"0.6.8","dependencies":[["rack",null]]},
  {"name":"rack-mount","number":"0.6.9","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.10","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.11","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.12","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.5.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.5","dependencies":[["rack",null]]},
  {"name":"rack-mount","number":"0.6.1","dependencies":[]},
  {"name":"rack-mount","number":"0.6.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.4","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.7.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.8.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.8.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.13","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.6.14","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.4.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.3.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.3.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.3.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.3.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.2.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.0.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-mount","number":"0.7.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-protection","number":"1.5.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.5.1","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.3","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.4","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"0.1.0","dependencies":[["rack",null],["escape-utils",null]]},
  {"name":"rack-protection","number":"1.2.0","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.0.0","dependencies":[["rack",null],["escape-utils",null]]},
  {"name":"rack-protection","number":"1.3.1","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.3.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.4.0","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.5.0","dependencies":[["rack",null]]},
  {"name":"rack-test","number":"0.5.4","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.5.5","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.4.1","dependencies":[]},
  {"name":"rack-test","number":"0.4.2","dependencies":[]},
  {"name":"rack-test","number":"0.5.3","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.5.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.4.0","dependencies":[]},
  {"name":"rack-test","number":"0.2.0","dependencies":[]},
  {"name":"rack-test","number":"0.1.0","dependencies":[]},
  {"name":"rack-test","number":"0.5.0","dependencies":[]},
  {"name":"rack-test","number":"0.5.7","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.3.0","dependencies":[]},
  {"name":"rack-test","number":"0.5.6","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.5.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.6.0","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.6.1","dependencies":[["rack","1.0.0"]]},
  {"name":"rack-test","number":"0.6.2","dependencies":[["rack","1.0.0"]]},
  {"name":"rails","number":"4.0.4","dependencies":[["sprockets-rails","2.0.0"],["bundler","1.3.0 || 2.0.0"],["railties","=4.0.4"],["actionmailer","=4.0.4"],["activerecord","=4.0.4"],["actionpack","=4.0.4"],["activesupport","=4.0.4"]]},
  {"name":"rails","number":"3.2.17","dependencies":[["bundler","1.0.0 || 2.0.0"],["railties","=3.2.17"],["actionmailer","=3.2.17"],["activeresource","=3.2.17"],["activerecord","=3.2.17"],["actionpack","=3.2.17"],["activesupport","=3.2.17"]]},
  {"name":"rails","number":"4.0.3","dependencies":[["sprockets-rails","2.0.0"],["bundler","1.3.0 || 2.0.0"],["railties","=4.0.3"],["actionmailer","=4.0.3"],["activerecord","=4.0.3"],["actionpack","=4.0.3"],["activesupport","=4.0.3"]]},
  {"name":"rails","number":"4.0.2","dependencies":[["sprockets-rails","2.0.0"],["bundler","1.3.0 || 2.0.0"],["railties","=4.0.2"],["actionmailer","=4.0.2"],["activerecord","=4.0.2"],["actionpack","=4.0.2"],["activesupport","=4.0.2"]]},
  {"name":"rails","number":"3.2.16","dependencies":[["bundler","1.0.0 || 2.0.0"],["railties","=3.2.16"],["actionmailer","=3.2.16"],["activeresource","=3.2.16"],["activerecord","=3.2.16"],["actionpack","=3.2.16"],["activesupport","=3.2.16"]]},
  {"name":"rails","number":"4.0.1","dependencies":[["sprockets-rails","2.0.0"],["bundler","1.3.0 || 2.0.0"],["railties","=4.0.1"],["actionmailer","=4.0.1"],["activerecord","=4.0.1"],["actionpack","=4.0.1"],["activesupport","=4.0.1"]]},
  {"name":"rails","number":"3.2.15","dependencies":[["bundler","1.0.0 || 2.0.0"],["railties","=3.2.15"],["actionmailer","=3.2.15"],["activeresource","=3.2.15"],["activerecord","=3.2.15"],["actionpack","=3.2.15"],["activesupport","=3.2.15"]]},
  {"name":"rails","number":"0.11.0","dependencies":[["rake",null],["activesupport","=1.0.2"],["activerecord","=1.9.0"],["actionpack","=1.6.0"],["actionmailer","=0.8.0"],["actionwebservice","=0.6.1"]]},
  {"name":"rails","number":"3.0.2","dependencies":[["activesupport","=3.0.2"],["actionpack","=3.0.2"],["activerecord","=3.0.2"],["activeresource","=3.0.2"],["actionmailer","=3.0.2"],["railties","=3.0.2"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.0","dependencies":[["activesupport","=3.2.0"],["actionpack","=3.2.0"],["activerecord","=3.2.0"],["activeresource","=3.2.0"],["actionmailer","=3.2.0"],["railties","=3.2.0"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.5","dependencies":[["activesupport","=3.1.5"],["actionpack","=3.1.5"],["activerecord","=3.1.5"],["activeresource","=3.1.5"],["actionmailer","=3.1.5"],["railties","=3.1.5"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.13.0","dependencies":[["rake",null],["activesupport","=1.1.0"],["activerecord","=1.11.0"],["actionpack","=1.9.0"],["actionmailer","=1.0.0"],["actionwebservice","=0.8.0"]]},
  {"name":"rails","number":"0.8.5","dependencies":[["rake",null],["activerecord","1.1.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack",null],["actionmailer",null]]},
  {"name":"rails","number":"3.2.5","dependencies":[["activesupport","=3.2.5"],["actionpack","=3.2.5"],["activerecord","=3.2.5"],["activeresource","=3.2.5"],["actionmailer","=3.2.5"],["railties","=3.2.5"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.7","dependencies":[["activesupport","=3.2.7"],["actionpack","=3.2.7"],["activerecord","=3.2.7"],["activeresource","=3.2.7"],["actionmailer","=3.2.7"],["railties","=3.2.7"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.2","dependencies":[["activesupport","=3.2.2"],["actionpack","=3.2.2"],["activerecord","=3.2.2"],["activeresource","=3.2.2"],["actionmailer","=3.2.2"],["railties","=3.2.2"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.5","dependencies":[["activesupport","=3.0.5"],["actionpack","=3.0.5"],["activerecord","=3.0.5"],["activeresource","=3.0.5"],["actionmailer","=3.0.5"],["railties","=3.0.5"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"1.2.1","dependencies":[["rake",null],["activesupport","=1.4.0"],["activerecord","=1.15.1"],["actionpack","=1.13.1"],["actionmailer","=1.3.1"],["actionwebservice","=1.2.1"]]},
  {"name":"rails","number":"2.2.3","dependencies":[["rake",null],["activesupport","=2.2.3"],["activerecord","=2.2.3"],["actionpack","=2.2.3"],["actionmailer","=2.2.3"],["activeresource","=2.2.3"]]},
  {"name":"rails","number":"3.0.7","dependencies":[["activesupport","=3.0.7"],["actionpack","=3.0.7"],["activerecord","=3.0.7"],["activeresource","=3.0.7"],["actionmailer","=3.0.7"],["railties","=3.0.7"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.9.2","dependencies":[["rake",null],["activerecord","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack","1.1.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionmailer",null]]},
  {"name":"rails","number":"2.3.10","dependencies":[["rake",null],["activesupport","=2.3.10"],["activerecord","=2.3.10"],["actionpack","=2.3.10"],["actionmailer","=2.3.10"],["activeresource","=2.3.10"]]},
  {"name":"rails","number":"2.3.7","dependencies":[["rake",null],["activesupport","=2.3.7"],["activerecord","=2.3.7"],["actionpack","=2.3.7"],["actionmailer","=2.3.7"],["activeresource","=2.3.7"]]},
  {"name":"rails","number":"0.10.1","dependencies":[["rake",null],["activesupport","=1.0.1"],["activerecord","=1.8.0"],["actionpack","=1.5.1"],["actionmailer","=0.7.1"],["actionwebservice","=0.6.0"]]},
  {"name":"rails","number":"1.2.5","dependencies":[["rake",null],["activesupport","=1.4.4"],["activerecord","=1.15.5"],["actionpack","=1.13.5"],["actionmailer","=1.3.5"],["actionwebservice","=1.2.5"]]},
  {"name":"rails","number":"1.1.1","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.1"],["actionpack","=1.12.1"],["actionmailer","=1.2.1"],["actionwebservice","=1.1.1"]]},
  {"name":"rails","number":"0.12.0","dependencies":[["rake",null],["activesupport","=1.0.4"],["activerecord","=1.10.0"],["actionpack","=1.8.0"],["actionmailer","=0.9.0"],["actionwebservice","=0.7.0"]]},
  {"name":"rails","number":"1.2.4","dependencies":[["rake",null],["activesupport","=1.4.3"],["activerecord","=1.15.4"],["actionpack","=1.13.4"],["actionmailer","=1.3.4"],["actionwebservice","=1.2.4"]]},
  {"name":"rails","number":"1.2.3","dependencies":[["rake",null],["activesupport","=1.4.2"],["activerecord","=1.15.3"],["actionpack","=1.13.3"],["actionmailer","=1.3.3"],["actionwebservice","=1.2.3"]]},
  {"name":"rails","number":"2.3.2","dependencies":[["rake",null],["activesupport","=2.3.2"],["activerecord","=2.3.2"],["actionpack","=2.3.2"],["actionmailer","=2.3.2"],["activeresource","=2.3.2"]]},
  {"name":"rails","number":"0.13.1","dependencies":[["rake",null],["activesupport","=1.1.1"],["activerecord","=1.11.1"],["actionpack","=1.9.1"],["actionmailer","=1.0.1"],["actionwebservice","=0.8.1"]]},
  {"name":"rails","number":"3.0.16","dependencies":[["activesupport","=3.0.16"],["actionpack","=3.0.16"],["activerecord","=3.0.16"],["activeresource","=3.0.16"],["actionmailer","=3.0.16"],["railties","=3.0.16"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.1","dependencies":[["activesupport","=3.1.1"],["actionpack","=3.1.1"],["activerecord","=3.1.1"],["activeresource","=3.1.1"],["actionmailer","=3.1.1"],["railties","=3.1.1"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.6","dependencies":[["activesupport","=3.1.6"],["actionpack","=3.1.6"],["activerecord","=3.1.6"],["activeresource","=3.1.6"],["actionmailer","=3.1.6"],["railties","=3.1.6"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.1","dependencies":[["activesupport","=3.2.1"],["actionpack","=3.2.1"],["activerecord","=3.2.1"],["activeresource","=3.2.1"],["actionmailer","=3.2.1"],["railties","=3.2.1"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.0.5","dependencies":[["rake",null],["activesupport","=2.0.5"],["activerecord","=2.0.5"],["actionpack","=2.0.5"],["actionmailer","=2.0.5"],["activeresource","=2.0.5"]]},
  {"name":"rails","number":"2.3.11","dependencies":[["rake",null],["activesupport","=2.3.11"],["activerecord","=2.3.11"],["actionpack","=2.3.11"],["actionmailer","=2.3.11"],["activeresource","=2.3.11"]]},
  {"name":"rails","number":"3.0.12","dependencies":[["activesupport","=3.0.12"],["actionpack","=3.0.12"],["activerecord","=3.0.12"],["activeresource","=3.0.12"],["actionmailer","=3.0.12"],["railties","=3.0.12"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.1","dependencies":[["activesupport","=3.0.1"],["actionpack","=3.0.1"],["activerecord","=3.0.1"],["activeresource","=3.0.1"],["actionmailer","=3.0.1"],["railties","=3.0.1"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.14","dependencies":[["rake",null],["activesupport","=2.3.14"],["activerecord","=2.3.14"],["actionpack","=2.3.14"],["actionmailer","=2.3.14"],["activeresource","=2.3.14"]]},
  {"name":"rails","number":"0.14.1","dependencies":[["rake",null],["activesupport","=1.2.1"],["activerecord","=1.12.1"],["actionpack","=1.10.1"],["actionmailer","=1.1.1"],["actionwebservice","=0.9.1"]]},
  {"name":"rails","number":"2.1.1","dependencies":[["rake",null],["activesupport","=2.1.1"],["activerecord","=2.1.1"],["actionpack","=2.1.1"],["actionmailer","=2.1.1"],["activeresource","=2.1.1"]]},
  {"name":"rails","number":"2.0.0","dependencies":[["rake",null],["activesupport","=2.0.0"],["activerecord","=2.0.0"],["actionpack","=2.0.0"],["actionmailer","=2.0.0"],["activeresource","=2.0.0"]]},
  {"name":"rails","number":"0.14.4","dependencies":[["rake",null],["activesupport","=1.2.4"],["activerecord","=1.13.1"],["actionpack","=1.11.1"],["actionmailer","=1.1.4"],["actionwebservice","=0.9.4"]]},
  {"name":"rails","number":"1.1.4","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.3"],["actionpack","=1.12.3"],["actionmailer","=1.2.3"],["actionwebservice","=1.1.4"]]},
  {"name":"rails","number":"2.3.8","dependencies":[["rake",null],["activesupport","=2.3.8"],["activerecord","=2.3.8"],["actionpack","=2.3.8"],["actionmailer","=2.3.8"],["activeresource","=2.3.8"]]},
  {"name":"rails","number":"3.0.14","dependencies":[["activesupport","=3.0.14"],["actionpack","=3.0.14"],["activerecord","=3.0.14"],["activeresource","=3.0.14"],["actionmailer","=3.0.14"],["railties","=3.0.14"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.8","dependencies":[["activesupport","=3.1.8"],["actionpack","=3.1.8"],["activerecord","=3.1.8"],["activeresource","=3.1.8"],["actionmailer","=3.1.8"],["railties","=3.1.8"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.6","dependencies":[["activesupport","=3.2.6"],["actionpack","=3.2.6"],["activerecord","=3.2.6"],["activeresource","=3.2.6"],["actionmailer","=3.2.6"],["railties","=3.2.6"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.12.1","dependencies":[["rake",null],["activesupport","=1.0.4"],["activerecord","=1.10.1"],["actionpack","=1.8.1"],["actionmailer","=0.9.1"],["actionwebservice","=0.7.1"]]},
  {"name":"rails","number":"3.1.7","dependencies":[["activesupport","=3.1.7"],["actionpack","=3.1.7"],["activerecord","=3.1.7"],["activeresource","=3.1.7"],["actionmailer","=3.1.7"],["railties","=3.1.7"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.9.0","dependencies":[["rake",null],["activerecord","1.1.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack",null],["actionmailer",null]]},
  {"name":"rails","number":"0.14.3","dependencies":[["rake",null],["activesupport","=1.2.3"],["activerecord","=1.13.0"],["actionpack","=1.11.0"],["actionmailer","=1.1.3"],["actionwebservice","=0.9.3"]]},
  {"name":"rails","number":"1.2.6","dependencies":[["rake",null],["activesupport","=1.4.4"],["activerecord","=1.15.6"],["actionpack","=1.13.6"],["actionmailer","=1.3.6"],["actionwebservice","=1.2.6"]]},
  {"name":"rails","number":"3.0.6","dependencies":[["activesupport","=3.0.6"],["actionpack","=3.0.6"],["activerecord","=3.0.6"],["activeresource","=3.0.6"],["actionmailer","=3.0.6"],["railties","=3.0.6"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.3","dependencies":[["activesupport","=3.0.3"],["actionpack","=3.0.3"],["activerecord","=3.0.3"],["activeresource","=3.0.3"],["actionmailer","=3.0.3"],["railties","=3.0.3"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.6","dependencies":[["rake",null],["activesupport","=2.3.6"],["activerecord","=2.3.6"],["actionpack","=2.3.6"],["actionmailer","=2.3.6"],["activeresource","=2.3.6"]]},
  {"name":"rails","number":"1.1.5","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.4"],["actionpack","=1.12.4"],["actionmailer","=1.2.4"],["actionwebservice","=1.1.5"]]},
  {"name":"rails","number":"3.0.9","dependencies":[["activesupport","=3.0.9"],["actionpack","=3.0.9"],["activerecord","=3.0.9"],["activeresource","=3.0.9"],["actionmailer","=3.0.9"],["railties","=3.0.9"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"1.1.2","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.2"],["actionpack","=1.12.1"],["actionmailer","=1.2.1"],["actionwebservice","=1.1.2"]]},
  {"name":"rails","number":"0.9.1","dependencies":[["rake",null],["activerecord","1.2.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack","1.0.1 || 2.0.0 || 3.0.0 || 4.0.0"],["actionmailer",null]]},
  {"name":"rails","number":"2.2.2","dependencies":[["rake",null],["activesupport","=2.2.2"],["activerecord","=2.2.2"],["actionpack","=2.2.2"],["actionmailer","=2.2.2"],["activeresource","=2.2.2"]]},
  {"name":"rails","number":"1.1.0","dependencies":[["rake",null],["activesupport","=1.3.0"],["activerecord","=1.14.0"],["actionpack","=1.12.0"],["actionmailer","=1.2.0"],["actionwebservice","=1.1.0"]]},
  {"name":"rails","number":"3.1.4","dependencies":[["activesupport","=3.1.4"],["actionpack","=3.1.4"],["activerecord","=3.1.4"],["activeresource","=3.1.4"],["actionmailer","=3.1.4"],["railties","=3.1.4"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.17","dependencies":[["activesupport","=3.0.17"],["actionpack","=3.0.17"],["activerecord","=3.0.17"],["activeresource","=3.0.17"],["actionmailer","=3.0.17"],["railties","=3.0.17"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.13","dependencies":[["activesupport","=3.0.13"],["actionpack","=3.0.13"],["activerecord","=3.0.13"],["activeresource","=3.0.13"],["actionmailer","=3.0.13"],["railties","=3.0.13"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.10.0","dependencies":[["rake",null],["activesupport","=1.0.0"],["activerecord","=1.7.0"],["actionpack","=1.5.0"],["actionmailer","=0.7.0"],["actionwebservice","=0.5.0"]]},
  {"name":"rails","number":"0.14.2","dependencies":[["rake",null],["activesupport","=1.2.2"],["activerecord","=1.12.2"],["actionpack","=1.10.2"],["actionmailer","=1.1.2"],["actionwebservice","=0.9.2"]]},
  {"name":"rails","number":"1.2.0","dependencies":[["rake",null],["activesupport","=1.4.0"],["activerecord","=1.15.0"],["actionpack","=1.13.0"],["actionmailer","=1.3.0"],["actionwebservice","=1.2.0"]]},
  {"name":"rails","number":"2.3.3","dependencies":[["rake",null],["activesupport","=2.3.3"],["activerecord","=2.3.3"],["actionpack","=2.3.3"],["actionmailer","=2.3.3"],["activeresource","=2.3.3"]]},
  {"name":"rails","number":"2.0.4","dependencies":[["rake",null],["activesupport","=2.0.4"],["activerecord","=2.0.4"],["actionpack","=2.0.4"],["actionmailer","=2.0.4"],["activeresource","=2.0.4"]]},
  {"name":"rails","number":"1.2.2","dependencies":[["rake",null],["activesupport","=1.4.1"],["activerecord","=1.15.2"],["actionpack","=1.13.2"],["actionmailer","=1.3.2"],["actionwebservice","=1.2.2"]]},
  {"name":"rails","number":"3.0.8","dependencies":[["activesupport","=3.0.8"],["actionpack","=3.0.8"],["activerecord","=3.0.8"],["activeresource","=3.0.8"],["actionmailer","=3.0.8"],["railties","=3.0.8"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.9.3","dependencies":[["rake",null],["activerecord","1.4.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack","1.2.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionmailer",null]]},
  {"name":"rails","number":"3.0.15","dependencies":[["activesupport","=3.0.15"],["actionpack","=3.0.15"],["activerecord","=3.0.15"],["activeresource","=3.0.15"],["actionmailer","=3.0.15"],["railties","=3.0.15"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.0","dependencies":[["activesupport","=3.0.0"],["actionpack","=3.0.0"],["activerecord","=3.0.0"],["activeresource","=3.0.0"],["actionmailer","=3.0.0"],["railties","=3.0.0"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.9.5","dependencies":[["rake",null],["activerecord","1.6.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack","1.4.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionmailer",null]]},
  {"name":"rails","number":"0.11.1","dependencies":[["rake",null],["activesupport","=1.0.3"],["activerecord","=1.9.1"],["actionpack","=1.7.0"],["actionmailer","=0.8.1"],["actionwebservice","=0.6.2"]]},
  {"name":"rails","number":"3.0.11","dependencies":[["activesupport","=3.0.11"],["actionpack","=3.0.11"],["activerecord","=3.0.11"],["activeresource","=3.0.11"],["actionmailer","=3.0.11"],["railties","=3.0.11"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"0.8.0","dependencies":[["rake",null],["activerecord","1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack",null],["actionmailer",null]]},
  {"name":"rails","number":"2.3.9","dependencies":[["rake",null],["activesupport","=2.3.9"],["activerecord","=2.3.9"],["actionpack","=2.3.9"],["actionmailer","=2.3.9"],["activeresource","=2.3.9"]]},
  {"name":"rails","number":"3.2.8","dependencies":[["activesupport","=3.2.8"],["actionpack","=3.2.8"],["activerecord","=3.2.8"],["activeresource","=3.2.8"],["actionmailer","=3.2.8"],["railties","=3.2.8"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"1.0.0","dependencies":[["rake",null],["activesupport","=1.2.5"],["activerecord","=1.13.2"],["actionpack","=1.11.2"],["actionmailer","=1.1.5"],["actionwebservice","=1.0.0"]]},
  {"name":"rails","number":"0.9.4","dependencies":[["rake",null],["activerecord","1.5.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionpack","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0"],["actionmailer",null]]},
  {"name":"rails","number":"2.3.12","dependencies":[["rake",null],["activesupport","=2.3.12"],["activerecord","=2.3.12"],["actionpack","=2.3.12"],["actionmailer","=2.3.12"],["activeresource","=2.3.12"]]},
  {"name":"rails","number":"3.0.10","dependencies":[["activesupport","=3.0.10"],["actionpack","=3.0.10"],["activerecord","=3.0.10"],["activeresource","=3.0.10"],["actionmailer","=3.0.10"],["railties","=3.0.10"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.2","dependencies":[["activesupport","=3.1.2"],["actionpack","=3.1.2"],["activerecord","=3.1.2"],["activeresource","=3.1.2"],["actionmailer","=3.1.2"],["railties","=3.1.2"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.0.1","dependencies":[["rake",null],["activesupport","=2.0.1"],["activerecord","=2.0.1"],["actionpack","=2.0.1"],["actionmailer","=2.0.1"],["activeresource","=2.0.1"]]},
  {"name":"rails","number":"3.2.3","dependencies":[["activesupport","=3.2.3"],["actionpack","=3.2.3"],["activerecord","=3.2.3"],["activeresource","=3.2.3"],["actionmailer","=3.2.3"],["railties","=3.2.3"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.4","dependencies":[["activesupport","=3.2.4"],["actionpack","=3.2.4"],["activerecord","=3.2.4"],["activeresource","=3.2.4"],["actionmailer","=3.2.4"],["railties","=3.2.4"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.0","dependencies":[["activesupport","=3.1.0"],["actionpack","=3.1.0"],["activerecord","=3.1.0"],["activeresource","=3.1.0"],["actionmailer","=3.1.0"],["railties","=3.1.0"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.3","dependencies":[["activesupport","=3.1.3"],["actionpack","=3.1.3"],["activerecord","=3.1.3"],["activeresource","=3.1.3"],["actionmailer","=3.1.3"],["railties","=3.1.3"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.4","dependencies":[["activesupport","=3.0.4"],["actionpack","=3.0.4"],["activerecord","=3.0.4"],["activeresource","=3.0.4"],["actionmailer","=3.0.4"],["railties","=3.0.4"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"1.1.3","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.3"],["actionpack","=1.12.2"],["actionmailer","=1.2.2"],["actionwebservice","=1.1.3"]]},
  {"name":"rails","number":"2.1.2","dependencies":[["rake",null],["activesupport","=2.1.2"],["activerecord","=2.1.2"],["actionpack","=2.1.2"],["actionmailer","=2.1.2"],["activeresource","=2.1.2"]]},
  {"name":"rails","number":"2.3.4","dependencies":[["rake",null],["activesupport","=2.3.4"],["activerecord","=2.3.4"],["actionpack","=2.3.4"],["actionmailer","=2.3.4"],["activeresource","=2.3.4"]]},
  {"name":"rails","number":"2.3.5","dependencies":[["rake",null],["activesupport","=2.3.5"],["activerecord","=2.3.5"],["actionpack","=2.3.5"],["actionmailer","=2.3.5"],["activeresource","=2.3.5"]]},
  {"name":"rails","number":"1.1.6","dependencies":[["rake",null],["activesupport","=1.3.1"],["activerecord","=1.14.4"],["actionpack","=1.12.5"],["actionmailer","=1.2.5"],["actionwebservice","=1.1.6"]]},
  {"name":"rails","number":"2.1.0","dependencies":[["rake",null],["activesupport","=2.1.0"],["activerecord","=2.1.0"],["actionpack","=2.1.0"],["actionmailer","=2.1.0"],["activeresource","=2.1.0"]]},
  {"name":"rails","number":"2.0.2","dependencies":[["rake",null],["activesupport","=2.0.2"],["activerecord","=2.0.2"],["actionpack","=2.0.2"],["actionmailer","=2.0.2"],["activeresource","=2.0.2"]]},
  {"name":"rails","number":"3.2.9","dependencies":[["activesupport","=3.2.9"],["actionpack","=3.2.9"],["activerecord","=3.2.9"],["activeresource","=3.2.9"],["actionmailer","=3.2.9"],["railties","=3.2.9"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.10","dependencies":[["activesupport","=3.2.10"],["actionpack","=3.2.10"],["activerecord","=3.2.10"],["activeresource","=3.2.10"],["actionmailer","=3.2.10"],["railties","=3.2.10"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.0.18","dependencies":[["activesupport","=3.0.18"],["actionpack","=3.0.18"],["activerecord","=3.0.18"],["activeresource","=3.0.18"],["actionmailer","=3.0.18"],["railties","=3.0.18"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.9","dependencies":[["activesupport","=3.1.9"],["actionpack","=3.1.9"],["activerecord","=3.1.9"],["activeresource","=3.1.9"],["actionmailer","=3.1.9"],["railties","=3.1.9"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.11","dependencies":[["activesupport","=3.2.11"],["actionpack","=3.2.11"],["activerecord","=3.2.11"],["activeresource","=3.2.11"],["actionmailer","=3.2.11"],["railties","=3.2.11"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.10","dependencies":[["activesupport","=3.1.10"],["actionpack","=3.1.10"],["activerecord","=3.1.10"],["activeresource","=3.1.10"],["actionmailer","=3.1.10"],["railties","=3.1.10"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.15","dependencies":[["rake",null],["activesupport","=2.3.15"],["activerecord","=2.3.15"],["actionpack","=2.3.15"],["actionmailer","=2.3.15"],["activeresource","=2.3.15"]]},
  {"name":"rails","number":"3.0.19","dependencies":[["activesupport","=3.0.19"],["actionpack","=3.0.19"],["activerecord","=3.0.19"],["activeresource","=3.0.19"],["actionmailer","=3.0.19"],["railties","=3.0.19"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.16","dependencies":[["rake",null],["activesupport","=2.3.16"],["activerecord","=2.3.16"],["actionpack","=2.3.16"],["actionmailer","=2.3.16"],["activeresource","=2.3.16"]]},
  {"name":"rails","number":"3.0.20","dependencies":[["activesupport","=3.0.20"],["actionpack","=3.0.20"],["activerecord","=3.0.20"],["activeresource","=3.0.20"],["actionmailer","=3.0.20"],["railties","=3.0.20"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.17","dependencies":[["rake",null],["activesupport","=2.3.17"],["activerecord","=2.3.17"],["actionpack","=2.3.17"],["actionmailer","=2.3.17"],["activeresource","=2.3.17"]]},
  {"name":"rails","number":"3.2.12","dependencies":[["activesupport","=3.2.12"],["actionpack","=3.2.12"],["activerecord","=3.2.12"],["activeresource","=3.2.12"],["actionmailer","=3.2.12"],["railties","=3.2.12"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.11","dependencies":[["activesupport","=3.1.11"],["actionpack","=3.1.11"],["activerecord","=3.1.11"],["activeresource","=3.1.11"],["actionmailer","=3.1.11"],["railties","=3.1.11"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.1.12","dependencies":[["activesupport","=3.1.12"],["actionpack","=3.1.12"],["activerecord","=3.1.12"],["activeresource","=3.1.12"],["actionmailer","=3.1.12"],["railties","=3.1.12"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"3.2.13","dependencies":[["activesupport","=3.2.13"],["actionpack","=3.2.13"],["activerecord","=3.2.13"],["activeresource","=3.2.13"],["actionmailer","=3.2.13"],["railties","=3.2.13"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails","number":"2.3.18","dependencies":[["rake",null],["activesupport","=2.3.18"],["activerecord","=2.3.18"],["actionpack","=2.3.18"],["actionmailer","=2.3.18"],["activeresource","=2.3.18"]]},
  {"name":"rails","number":"4.0.0","dependencies":[["activesupport","=4.0.0"],["actionpack","=4.0.0"],["activerecord","=4.0.0"],["actionmailer","=4.0.0"],["railties","=4.0.0"],["bundler","1.3.0 || 2.0.0"],["sprockets-rails","2.0.0"]]},
  {"name":"rails","number":"3.2.14","dependencies":[["activesupport","=3.2.14"],["actionpack","=3.2.14"],["activerecord","=3.2.14"],["activeresource","=3.2.14"],["actionmailer","=3.2.14"],["railties","=3.2.14"],["bundler","1.0.0 || 2.0.0"]]},
  {"name":"rails-observers","number":"0.1.0","dependencies":[["railties","4.0.0"]]},
  {"name":"rails-observers","number":"0.1.1","dependencies":[["railties","4.0.0"]]},
  {"name":"rails-observers","number":"0.1.2","dependencies":[["activemodel","4.0.0"]]},
  {"name":"rails-best-practices","number":"1.15.2","dependencies":[["ruby-progressbar",null],["require-all",null],["i18n",null],["erubis",null],["colored",null],["code-analyzer",null],["awesome-print",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.15.1","dependencies":[["ruby-progressbar",null],["require-all",null],["i18n",null],["erubis",null],["colored",null],["code-analyzer",null],["awesome-print",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.14.4","dependencies":[["ruby-progressbar",null],["require-all",null],["i18n",null],["erubis",null],["colored",null],["code-analyzer",null],["awesome-print",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.5.1","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.2.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.3","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.1.1","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.25","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.13","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"1.5.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.2.14","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.4","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.2.6","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.9","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.6.5","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.24","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"1.0.0","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.5.3","dependencies":[["ruby-parser","2.0.4"],["progressbar","0.9.0"],["colored","1.2.0"],["erubis","2.6.6"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.11.0","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.5.3","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.4.2","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"1.8.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.9.1","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.10.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.9.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.7.2","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.6.1","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.6","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.9","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.7.0","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.8.0","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.8","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.9.0","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.5.5","dependencies":[["ruby-parser","2.0.4"],["progressbar","0.9.0"],["colored","1.2.0"],["erubis","2.6.6"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.4.4","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"0.2.10","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.5.0","dependencies":[["ruby-parser","2.0.4"],["progressbar","0.9.0"],["colored","1.2.0"],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.22","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.5.1","dependencies":[["ruby-parser","2.0.4"],["progressbar","0.9.0"],["colored","1.2.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.7.4","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.4.0","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.1.2","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.19","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.15","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.5","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.8.2","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.6.7","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.10","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"1.4.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.7","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.5.2","dependencies":[["ruby-parser","2.0.4"],["progressbar","0.9.0"],["colored","1.2.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.4.6","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"0.4.5","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"0.2.8","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.10.1","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.23","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.12","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.7.5","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.7.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.7.1","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.5.2","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.7.1","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.2.0","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.20","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.2","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.2","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.21","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.3","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.12","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.16","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.1","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.6.6","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.2.5","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.3.18","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.14","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.15","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"1.1.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.17","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.11","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.13","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.0","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.3.4","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.2.11","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.7.3","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.3.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.0.1","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.7.2","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.10.0","dependencies":[["ruby-parser",null],["ruby-progressbar",null],["colored",null],["erubis",null],["haml",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.10.1","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.11.1","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"0.2.1","dependencies":[["ruby-parser",null],["ruby2ruby",null]]},
  {"name":"rails-best-practices","number":"0.8.1","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["haml","3.0.18 || 4.0.0"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.3.26","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.1.0","dependencies":[]},
  {"name":"rails-best-practices","number":"0.3.16","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"0.4.3","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"0.4.1","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"],["progressbar","0.9.0"],["colored","1.2.0"]]},
  {"name":"rails-best-practices","number":"0.3.27","dependencies":[["ruby-parser","2.0.4"],["ruby2ruby","1.2.4"]]},
  {"name":"rails-best-practices","number":"1.6.0","dependencies":[["sexp-processor",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"0.5.6","dependencies":[["ruby-parser","2.0.4"],["ruby-progressbar","0.0.9 || 1.0.0"],["colored","1.2.0"],["erubis","2.6.6"],["i18n",null],["activesupport",null]]},
  {"name":"rails-best-practices","number":"1.12.0","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.0","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.1","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.2","dependencies":[["code-analyzer",null],["progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.3","dependencies":[["code-analyzer",null],["ruby-progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.4","dependencies":[["code-analyzer",null],["ruby-progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.5","dependencies":[["code-analyzer",null],["ruby-progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.13.8","dependencies":[["code-analyzer",null],["ruby-progressbar",null],["colored",null],["erubis",null],["i18n",null],["activesupport",null],["awesome-print",null]]},
  {"name":"rails-best-practices","number":"1.14.0","dependencies":[["activesupport",null],["awesome-print",null],["code-analyzer",null],["colored",null],["erubis",null],["i18n",null],["require-all",null],["ruby-progressbar",null]]},
  {"name":"rails-best-practices","number":"1.14.1","dependencies":[["activesupport",null],["awesome-print",null],["code-analyzer",null],["colored",null],["erubis",null],["i18n",null],["require-all",null],["ruby-progressbar",null]]},
  {"name":"rails-best-practices","number":"1.14.3","dependencies":[["activesupport",null],["awesome-print",null],["code-analyzer",null],["colored",null],["erubis",null],["i18n",null],["require-all",null],["ruby-progressbar",null]]},
  {"name":"rails-best-practices","number":"1.14.2","dependencies":[["activesupport",null],["awesome-print",null],["code-analyzer",null],["colored",null],["erubis",null],["i18n",null],["require-all",null],["ruby-progressbar",null]]},
  {"name":"railties","number":"4.0.4","dependencies":[["thor",null],["rake",null],["actionpack","=4.0.4"],["activesupport","=4.0.4"]]},
  {"name":"railties","number":"3.2.17","dependencies":[["actionpack","=3.2.17"],["activesupport","=3.2.17"],["rdoc","3.4.0 || 4.0.0"],["thor",null],["rack-ssl","1.3.2"],["rake",null]]},
  {"name":"railties","number":"4.0.3","dependencies":[["thor",null],["rake",null],["actionpack","=4.0.3"],["activesupport","=4.0.3"]]},
  {"name":"railties","number":"4.0.2","dependencies":[["thor",null],["rake",null],["actionpack","=4.0.2"],["activesupport","=4.0.2"]]},
  {"name":"railties","number":"3.2.16","dependencies":[["actionpack","=3.2.16"],["activesupport","=3.2.16"],["rdoc","3.4.0 || 4.0.0"],["thor",null],["rack-ssl","1.3.2"],["rake",null]]},
  {"name":"railties","number":"4.0.1","dependencies":[["thor",null],["rake",null],["actionpack","=4.0.1"],["activesupport","=4.0.1"]]},
  {"name":"railties","number":"3.2.15","dependencies":[["actionpack","=3.2.15"],["activesupport","=3.2.15"],["rdoc","3.4.0 || 4.0.0"],["thor",null],["rack-ssl","1.3.2"],["rake",null]]},
  {"name":"railties","number":"3.0.6","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.6"],["actionpack","=3.0.6"]]},
  {"name":"railties","number":"3.0.11","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.11"],["actionpack","=3.0.11"]]},
  {"name":"railties","number":"3.2.3","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.3"],["actionpack","=3.2.3"]]},
  {"name":"railties","number":"3.2.6","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.6"],["actionpack","=3.2.6"]]},
  {"name":"railties","number":"3.2.2","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.2"],["actionpack","=3.2.2"]]},
  {"name":"railties","number":"3.0.1","dependencies":[["rake",null],["thor","0.14.0"],["activesupport","=3.0.1"],["actionpack","=3.0.1"]]},
  {"name":"railties","number":"3.1.7","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.7"],["actionpack","=3.1.7"]]},
  {"name":"railties","number":"3.0.2","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.2"],["actionpack","=3.0.2"]]},
  {"name":"railties","number":"3.0.9","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.9"],["actionpack","=3.0.9"]]},
  {"name":"railties","number":"3.1.3","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.3"],["actionpack","=3.1.3"]]},
  {"name":"railties","number":"3.0.5","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.5"],["actionpack","=3.0.5"]]},
  {"name":"railties","number":"3.0.4","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.4"],["actionpack","=3.0.4"]]},
  {"name":"railties","number":"3.0.3","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.3"],["actionpack","=3.0.3"]]},
  {"name":"railties","number":"3.0.0","dependencies":[["rake",null],["thor","0.14.0"],["activesupport","=3.0.0"],["actionpack","=3.0.0"]]},
  {"name":"railties","number":"3.0.16","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.16"],["actionpack","=3.0.16"]]},
  {"name":"railties","number":"3.0.7","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.7"],["actionpack","=3.0.7"]]},
  {"name":"railties","number":"3.0.14","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.14"],["actionpack","=3.0.14"]]},
  {"name":"railties","number":"3.0.15","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.15"],["actionpack","=3.0.15"]]},
  {"name":"railties","number":"3.0.17","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.17"],["actionpack","=3.0.17"]]},
  {"name":"railties","number":"3.1.6","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.6"],["actionpack","=3.1.6"]]},
  {"name":"railties","number":"3.2.4","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.4"],["actionpack","=3.2.4"]]},
  {"name":"railties","number":"3.1.5","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.5"],["actionpack","=3.1.5"]]},
  {"name":"railties","number":"3.1.8","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.8"],["actionpack","=3.1.8"]]},
  {"name":"railties","number":"3.2.7","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.7"],["actionpack","=3.2.7"]]},
  {"name":"railties","number":"3.2.8","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.8"],["actionpack","=3.2.8"]]},
  {"name":"railties","number":"3.0.12","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.12"],["actionpack","=3.0.12"]]},
  {"name":"railties","number":"3.2.1","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.1"],["actionpack","=3.2.1"]]},
  {"name":"railties","number":"3.1.0","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.0"],["actionpack","=3.1.0"]]},
  {"name":"railties","number":"3.1.2","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.2"],["actionpack","=3.1.2"]]},
  {"name":"railties","number":"3.0.8","dependencies":[["rake",null],["thor","0.14.4"],["activesupport","=3.0.8"],["actionpack","=3.0.8"]]},
  {"name":"railties","number":"3.0.13","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.13"],["actionpack","=3.0.13"]]},
  {"name":"railties","number":"3.2.5","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.5"],["actionpack","=3.2.5"]]},
  {"name":"railties","number":"3.2.0","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.0"],["actionpack","=3.2.0"]]},
  {"name":"railties","number":"3.1.4","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.4"],["actionpack","=3.1.4"]]},
  {"name":"railties","number":"3.1.1","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.1"],["actionpack","=3.1.1"]]},
  {"name":"railties","number":"3.0.10","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.10"],["actionpack","=3.0.10"]]},
  {"name":"railties","number":"3.2.9","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.9"],["actionpack","=3.2.9"]]},
  {"name":"railties","number":"3.2.10","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.10"],["actionpack","=3.2.10"]]},
  {"name":"railties","number":"3.1.9","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.9"],["actionpack","=3.1.9"]]},
  {"name":"railties","number":"3.0.18","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.18"],["actionpack","=3.0.18"]]},
  {"name":"railties","number":"3.0.19","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.19"],["actionpack","=3.0.19"]]},
  {"name":"railties","number":"3.2.11","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.11"],["actionpack","=3.2.11"]]},
  {"name":"railties","number":"3.1.10","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.10"],["actionpack","=3.1.10"]]},
  {"name":"railties","number":"3.0.20","dependencies":[["rake",null],["thor","0.14.4"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.0.20"],["actionpack","=3.0.20"]]},
  {"name":"railties","number":"3.2.12","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.12"],["actionpack","=3.2.12"]]},
  {"name":"railties","number":"3.1.11","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.11"],["actionpack","=3.1.11"]]},
  {"name":"railties","number":"3.2.13","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.13"],["actionpack","=3.2.13"]]},
  {"name":"railties","number":"3.1.12","dependencies":[["rake",null],["thor","0.14.6"],["rack-ssl","1.3.2"],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.1.12"],["actionpack","=3.1.12"]]},
  {"name":"railties","number":"4.0.0","dependencies":[["activesupport","=4.0.0"],["actionpack","=4.0.0"],["rake",null],["thor",null]]},
  {"name":"railties","number":"3.2.14","dependencies":[["rake",null],["rack-ssl","1.3.2"],["thor",null],["rdoc","3.4.0 || 4.0.0"],["activesupport","=3.2.14"],["actionpack","=3.2.14"]]},
  {"name":"raindrops","number":"0.13.0","dependencies":[]},
  {"name":"raindrops","number":"0.8.1","dependencies":[]},
  {"name":"raindrops","number":"0.7.0","dependencies":[]},
  {"name":"raindrops","number":"0.1.0","dependencies":[]},
  {"name":"raindrops","number":"0.4.0","dependencies":[]},
  {"name":"raindrops","number":"0.3.0","dependencies":[]},
  {"name":"raindrops","number":"0.4.1","dependencies":[]},
  {"name":"raindrops","number":"0.6.1","dependencies":[]},
  {"name":"raindrops","number":"0.5.0","dependencies":[]},
  {"name":"raindrops","number":"0.6.0","dependencies":[]},
  {"name":"raindrops","number":"0.2.0","dependencies":[]},
  {"name":"raindrops","number":"0.8.0","dependencies":[]},
  {"name":"raindrops","number":"0.9.0","dependencies":[]},
  {"name":"raindrops","number":"0.10.0","dependencies":[]},
  {"name":"raindrops","number":"0.11.0","dependencies":[]},
  {"name":"raindrops","number":"0.12.0","dependencies":[]},
  {"name":"rake","number":"10.2.0","dependencies":[]},
  {"name":"rake","number":"10.1.1","dependencies":[]},
  {"name":"rake","number":"0.8.4","dependencies":[]},
  {"name":"rake","number":"0.8.2","dependencies":[]},
  {"name":"rake","number":"0.4.10","dependencies":[]},
  {"name":"rake","number":"0.7.2","dependencies":[]},
  {"name":"rake","number":"0.9.2","dependencies":[]},
  {"name":"rake","number":"0.6.2","dependencies":[]},
  {"name":"rake","number":"0.4.9","dependencies":[]},
  {"name":"rake","number":"0.8.1","dependencies":[]},
  {"name":"rake","number":"0.4.14","dependencies":[]},
  {"name":"rake","number":"0.7.1","dependencies":[]},
  {"name":"rake","number":"0.8.0","dependencies":[]},
  {"name":"rake","number":"0.4.13","dependencies":[]},
  {"name":"rake","number":"0.5.3","dependencies":[]},
  {"name":"rake","number":"0.9.0","dependencies":[]},
  {"name":"rake","number":"0.8.3","dependencies":[]},
  {"name":"rake","number":"0.5.0","dependencies":[]},
  {"name":"rake","number":"0.4.12","dependencies":[]},
  {"name":"rake","number":"0.4.11","dependencies":[]},
  {"name":"rake","number":"0.7.0","dependencies":[]},
  {"name":"rake","number":"0.8.6","dependencies":[]},
  {"name":"rake","number":"0.8.7","dependencies":[]},
  {"name":"rake","number":"0.4.15","dependencies":[]},
  {"name":"rake","number":"0.7.3","dependencies":[]},
  {"name":"rake","number":"0.9.1","dependencies":[]},
  {"name":"rake","number":"0.5.4","dependencies":[]},
  {"name":"rake","number":"0.8.5","dependencies":[]},
  {"name":"rake","number":"0.6.0","dependencies":[]},
  {"name":"rake","number":"0.4.8","dependencies":[]},
  {"name":"rake","number":"10.0.0","dependencies":[]},
  {"name":"rake","number":"0.9.3","dependencies":[]},
  {"name":"rake","number":"0.9.4","dependencies":[]},
  {"name":"rake","number":"10.0.1","dependencies":[]},
  {"name":"rake","number":"0.9.5","dependencies":[]},
  {"name":"rake","number":"10.0.2","dependencies":[]},
  {"name":"rake","number":"0.9.6","dependencies":[]},
  {"name":"rake","number":"10.0.3","dependencies":[]},
  {"name":"rake","number":"10.0.4","dependencies":[]},
  {"name":"rake","number":"10.1.0","dependencies":[]},
  {"name":"raphael-rails","number":"1.5.2","dependencies":[]},
  {"name":"raphael-rails","number":"2.1.0","dependencies":[]},
  {"name":"raphael-rails","number":"2.1.1","dependencies":[]},
  {"name":"raphael-rails","number":"2.1.2","dependencies":[]},
  {"name":"rb-fsevent","number":"0.9.4","dependencies":[]},
  {"name":"rb-fsevent","number":"0.2.0","dependencies":[["ffi","0.6.3 || 1.0.0"]]},
  {"name":"rb-fsevent","number":"0.9.1","dependencies":[]},
  {"name":"rb-fsevent","number":"0.9.0","dependencies":[]},
  {"name":"rb-fsevent","number":"0.4.2","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.0","dependencies":[]},
  {"name":"rb-fsevent","number":"0.2.1","dependencies":[["ffi","0.6.3 || 1.0.0"]]},
  {"name":"rb-fsevent","number":"0.3.8","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.3","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.10","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.6","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.9","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.5","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.2","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.1","dependencies":[]},
  {"name":"rb-fsevent","number":"0.4.0","dependencies":[]},
  {"name":"rb-fsevent","number":"0.4.1","dependencies":[]},
  {"name":"rb-fsevent","number":"0.3.4","dependencies":[]},
  {"name":"rb-fsevent","number":"0.4.3","dependencies":[]},
  {"name":"rb-fsevent","number":"0.9.2","dependencies":[]},
  {"name":"rb-fsevent","number":"0.9.3","dependencies":[]},
  {"name":"rb-inotify","number":"0.9.3","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.9.2","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.5.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.3.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.5","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.1","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.5.1","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.4.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.7.1","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.7.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.6.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.1.0","dependencies":[]},
  {"name":"rb-inotify","number":"0.2.1","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.3","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.6","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.8","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.7","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.2","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.2.0","dependencies":[]},
  {"name":"rb-inotify","number":"0.7.2","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.8.4","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.9.0","dependencies":[["ffi",null]]},
  {"name":"rb-inotify","number":"0.9.1","dependencies":[["ffi",null]]},
  {"name":"rdoc","number":"4.1.1","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"4.1.0","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"3.7.0","dependencies":[]},
  {"name":"rdoc","number":"2.5.10","dependencies":[]},
  {"name":"rdoc","number":"2.5.11","dependencies":[]},
  {"name":"rdoc","number":"2.5.8","dependencies":[]},
  {"name":"rdoc","number":"3.9.0","dependencies":[]},
  {"name":"rdoc","number":"3.11.0","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"2.5.3","dependencies":[]},
  {"name":"rdoc","number":"2.4.1","dependencies":[["minitest","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["hoe","1.9.0 || 2.0.0"]]},
  {"name":"rdoc","number":"2.2.1","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rdoc","number":"2.2.0","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rdoc","number":"2.5.2","dependencies":[]},
  {"name":"rdoc","number":"2.0.0","dependencies":[["hoe","1.5.1 || 2.0.0"]]},
  {"name":"rdoc","number":"3.5.0","dependencies":[]},
  {"name":"rdoc","number":"3.6.0","dependencies":[]},
  {"name":"rdoc","number":"3.8.0","dependencies":[]},
  {"name":"rdoc","number":"2.5.1","dependencies":[]},
  {"name":"rdoc","number":"3.1.0","dependencies":[]},
  {"name":"rdoc","number":"2.4.2","dependencies":[["minitest","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["hoe","1.11.0 || 2.0.0"]]},
  {"name":"rdoc","number":"3.9.2","dependencies":[]},
  {"name":"rdoc","number":"3.5.3","dependencies":[]},
  {"name":"rdoc","number":"3.5.1","dependencies":[]},
  {"name":"rdoc","number":"3.9.3","dependencies":[]},
  {"name":"rdoc","number":"2.4.0","dependencies":[["minitest","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["hoe","1.8.3 || 2.0.0"]]},
  {"name":"rdoc","number":"2.5.9","dependencies":[]},
  {"name":"rdoc","number":"3.5.2","dependencies":[]},
  {"name":"rdoc","number":"2.5.7","dependencies":[]},
  {"name":"rdoc","number":"2.5.4","dependencies":[]},
  {"name":"rdoc","number":"3.2.0","dependencies":[]},
  {"name":"rdoc","number":"3.9.1","dependencies":[]},
  {"name":"rdoc","number":"3.4.0","dependencies":[]},
  {"name":"rdoc","number":"2.4.3","dependencies":[["minitest","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rdoc","number":"2.5.0","dependencies":[]},
  {"name":"rdoc","number":"3.6.1","dependencies":[]},
  {"name":"rdoc","number":"3.3.0","dependencies":[]},
  {"name":"rdoc","number":"2.1.0","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rdoc","number":"3.0.1","dependencies":[]},
  {"name":"rdoc","number":"2.5.5","dependencies":[]},
  {"name":"rdoc","number":"3.0.0","dependencies":[]},
  {"name":"rdoc","number":"2.3.0","dependencies":[["minitest","1.3.0 || 2.0.0 || 3.0.0 || 4.0.0 || 5.0.0"],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"rdoc","number":"2.5.6","dependencies":[]},
  {"name":"rdoc","number":"3.9.4","dependencies":[]},
  {"name":"rdoc","number":"3.10.0","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"3.12.0","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"3.9.5","dependencies":[]},
  {"name":"rdoc","number":"3.12.1","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"4.0.0","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"3.12.2","dependencies":[["json","1.4.0"]]},
  {"name":"rdoc","number":"4.0.1","dependencies":[["json","1.4.0"]]},
  {"name":"redcarpet","number":"3.1.1","dependencies":[]},
  {"name":"redcarpet","number":"3.1.0","dependencies":[]},
  {"name":"redcarpet","number":"1.6.0","dependencies":[]},
  {"name":"redcarpet","number":"1.13.2","dependencies":[]},
  {"name":"redcarpet","number":"1.11.1","dependencies":[]},
  {"name":"redcarpet","number":"1.3.0","dependencies":[]},
  {"name":"redcarpet","number":"1.1.1","dependencies":[]},
  {"name":"redcarpet","number":"1.7.0","dependencies":[]},
  {"name":"redcarpet","number":"1.14.1","dependencies":[]},
  {"name":"redcarpet","number":"1.2.2","dependencies":[]},
  {"name":"redcarpet","number":"2.2.0","dependencies":[]},
  {"name":"redcarpet","number":"1.8.0","dependencies":[]},
  {"name":"redcarpet","number":"1.3.3","dependencies":[]},
  {"name":"redcarpet","number":"1.7.1","dependencies":[]},
  {"name":"redcarpet","number":"1.2.0","dependencies":[]},
  {"name":"redcarpet","number":"1.2.1","dependencies":[]},
  {"name":"redcarpet","number":"1.14.0","dependencies":[]},
  {"name":"redcarpet","number":"1.3.1","dependencies":[]},
  {"name":"redcarpet","number":"1.17.0","dependencies":[]},
  {"name":"redcarpet","number":"1.11.0","dependencies":[]},
  {"name":"redcarpet","number":"1.10.1","dependencies":[]},
  {"name":"redcarpet","number":"1.3.2","dependencies":[]},
  {"name":"redcarpet","number":"1.8.1","dependencies":[]},
  {"name":"redcarpet","number":"1.5.0","dependencies":[]},
  {"name":"redcarpet","number":"1.11.2","dependencies":[]},
  {"name":"redcarpet","number":"2.1.0","dependencies":[]},
  {"name":"redcarpet","number":"1.13.0","dependencies":[]},
  {"name":"redcarpet","number":"1.5.3","dependencies":[]},
  {"name":"redcarpet","number":"1.11.3","dependencies":[]},
  {"name":"redcarpet","number":"1.10.0","dependencies":[]},
  {"name":"redcarpet","number":"2.0.1","dependencies":[]},
  {"name":"redcarpet","number":"2.0.0","dependencies":[]},
  {"name":"redcarpet","number":"1.13.1","dependencies":[]},
  {"name":"redcarpet","number":"1.5.2","dependencies":[]},
  {"name":"redcarpet","number":"1.9.0","dependencies":[]},
  {"name":"redcarpet","number":"1.8.2","dependencies":[]},
  {"name":"redcarpet","number":"1.0.1","dependencies":[]},
  {"name":"redcarpet","number":"1.14.2","dependencies":[]},
  {"name":"redcarpet","number":"1.15.0","dependencies":[]},
  {"name":"redcarpet","number":"1.15.1","dependencies":[]},
  {"name":"redcarpet","number":"1.17.1","dependencies":[]},
  {"name":"redcarpet","number":"1.16.0","dependencies":[]},
  {"name":"redcarpet","number":"1.11.4","dependencies":[]},
  {"name":"redcarpet","number":"1.12.1","dependencies":[]},
  {"name":"redcarpet","number":"1.15.2","dependencies":[]},
  {"name":"redcarpet","number":"1.5.1","dependencies":[]},
  {"name":"redcarpet","number":"1.0.0","dependencies":[]},
  {"name":"redcarpet","number":"1.1.0","dependencies":[]},
  {"name":"redcarpet","number":"1.12.0","dependencies":[]},
  {"name":"redcarpet","number":"1.12.2","dependencies":[]},
  {"name":"redcarpet","number":"1.17.2","dependencies":[]},
  {"name":"redcarpet","number":"2.1.1","dependencies":[]},
  {"name":"redcarpet","number":"2.2.1","dependencies":[]},
  {"name":"redcarpet","number":"2.2.2","dependencies":[]},
  {"name":"redcarpet","number":"2.3.0","dependencies":[]},
  {"name":"redcarpet","number":"3.0.0","dependencies":[]},
  {"name":"redis","number":"3.0.7","dependencies":[]},
  {"name":"redis","number":"3.0.6","dependencies":[]},
  {"name":"redis","number":"3.0.5","dependencies":[]},
  {"name":"redis","number":"0.0.1","dependencies":[]},
  {"name":"redis","number":"2.1.1","dependencies":[]},
  {"name":"redis","number":"2.0.11","dependencies":[]},
  {"name":"redis","number":"1.0.7","dependencies":[]},
  {"name":"redis","number":"0.1.2","dependencies":[]},
  {"name":"redis","number":"0.1.1","dependencies":[["rspec",null]]},
  {"name":"redis","number":"2.0.5","dependencies":[]},
  {"name":"redis","number":"2.0.8","dependencies":[]},
  {"name":"redis","number":"2.2.0","dependencies":[]},
  {"name":"redis","number":"2.0.7","dependencies":[]},
  {"name":"redis","number":"2.0.10","dependencies":[]},
  {"name":"redis","number":"2.2.2","dependencies":[]},
  {"name":"redis","number":"2.0.1","dependencies":[]},
  {"name":"redis","number":"1.0.0","dependencies":[]},
  {"name":"redis","number":"1.0.1","dependencies":[]},
  {"name":"redis","number":"2.0.12","dependencies":[]},
  {"name":"redis","number":"1.0.5","dependencies":[]},
  {"name":"redis","number":"2.0.2","dependencies":[]},
  {"name":"redis","number":"1.0.2","dependencies":[]},
  {"name":"redis","number":"2.0.9","dependencies":[]},
  {"name":"redis","number":"2.2.1","dependencies":[]},
  {"name":"redis","number":"1.0.4","dependencies":[]},
  {"name":"redis","number":"0.1.0","dependencies":[["rspec",null]]},
  {"name":"redis","number":"2.1.0","dependencies":[]},
  {"name":"redis","number":"2.0.13","dependencies":[]},
  {"name":"redis","number":"2.0.3","dependencies":[]},
  {"name":"redis","number":"2.0.4","dependencies":[]},
  {"name":"redis","number":"1.0.3","dependencies":[]},
  {"name":"redis","number":"2.0.0","dependencies":[]},
  {"name":"redis","number":"1.0.6","dependencies":[]},
  {"name":"redis","number":"0.2.0","dependencies":[]},
  {"name":"redis","number":"2.0.6","dependencies":[]},
  {"name":"redis","number":"3.0.0","dependencies":[]},
  {"name":"redis","number":"3.0.1","dependencies":[]},
  {"name":"redis","number":"3.0.2","dependencies":[]},
  {"name":"redis","number":"3.0.3","dependencies":[]},
  {"name":"redis","number":"3.0.4","dependencies":[]},
  {"name":"redis-actionpack","number":"3.1.4","dependencies":[["redis-store","1.1.0"],["actionpack","=3.1.4"],["redis-rack","=1.3.6"]]},
  {"name":"redis-actionpack","number":"3.1.3","dependencies":[["redis-store","=1.1.0"],["actionpack","=3.1.3"],["redis-rack","=1.3.5"]]},
  {"name":"redis-actionpack","number":"3.1.5","dependencies":[["redis-store","1.1.0"],["actionpack","3.1.5 || 4.0.0"],["redis-rack","1.3.6"]]},
  {"name":"redis-actionpack","number":"3.2.3","dependencies":[["redis-store","1.1.0"],["redis-rack","1.4.0"],["actionpack","3.2.3 || 4.0.0"]]},
  {"name":"redis-actionpack","number":"3.2.1","dependencies":[["redis-store","1.1.0"],["redis-rack","1.4.0"],["actionpack","=3.2.1"]]},
  {"name":"redis-actionpack","number":"0.0.0","dependencies":[]},
  {"name":"redis-actionpack","number":"3.2.2","dependencies":[["redis-store","1.1.0"],["redis-rack","1.4.0"],["actionpack","=3.2.2"]]},
  {"name":"redis-actionpack","number":"4.0.0","dependencies":[["redis-store","1.1.0"],["redis-rack","1.5.0"],["actionpack","4.0.0"]]},
  {"name":"redis-actionpack","number":"3.2.4","dependencies":[["redis-store","1.1.4"],["redis-rack","1.4.4"],["actionpack","3.2.0 || 4.0.0"]]},
  {"name":"redis-activesupport","number":"3.2.5","dependencies":[["activesupport","3.2.0 || 4.0.0"],["redis-store","1.1.0"]]},
  {"name":"redis-activesupport","number":"3.1.3","dependencies":[["redis-store","=1.1.0"],["activesupport","=3.1.3"]]},
  {"name":"redis-activesupport","number":"3.1.4","dependencies":[["redis-store","1.1.0"],["activesupport","=3.1.4"]]},
  {"name":"redis-activesupport","number":"3.1.5","dependencies":[["redis-store","1.1.0"],["activesupport","3.1.5 || 4.0.0"]]},
  {"name":"redis-activesupport","number":"3.2.3","dependencies":[["redis-store","1.1.0"],["activesupport","3.2.3 || 4.0.0"]]},
  {"name":"redis-activesupport","number":"3.2.1","dependencies":[["redis-store","1.1.0"],["activesupport","=3.2.1"]]},
  {"name":"redis-activesupport","number":"3.2.2","dependencies":[["redis-store","1.1.0"],["activesupport","=3.2.2"]]},
  {"name":"redis-activesupport","number":"0.0.0","dependencies":[]},
  {"name":"redis-activesupport","number":"4.0.0","dependencies":[["redis-store","1.1.0"],["activesupport","4.0.0"]]},
  {"name":"redis-activesupport","number":"3.2.4","dependencies":[["redis-store","1.1.0"],["activesupport","3.2.0 || 4.0.0"]]},
  {"name":"redis-namespace","number":"1.4.1","dependencies":[["redis","3.0.4"]]},
  {"name":"redis-namespace","number":"1.4.0","dependencies":[["redis","3.0.4"]]},
  {"name":"redis-namespace","number":"1.3.2","dependencies":[["redis","3.0.4"]]},
  {"name":"redis-namespace","number":"0.3.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.2.0","dependencies":[]},
  {"name":"redis-namespace","number":"0.1.0","dependencies":[]},
  {"name":"redis-namespace","number":"0.4.1","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.1.1","dependencies":[]},
  {"name":"redis-namespace","number":"0.4.3","dependencies":[]},
  {"name":"redis-namespace","number":"1.0.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.0.1","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.2.0","dependencies":[["redis","3.0.0"]]},
  {"name":"redis-namespace","number":"0.5.1","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.10.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.6.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.4.4","dependencies":[["redis","1.0.0 || 2.0.0 || 3.0.0"]]},
  {"name":"redis-namespace","number":"0.2.1","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.4.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.2.1","dependencies":[["redis","3.0.0"]]},
  {"name":"redis-namespace","number":"0.4.2","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.5.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.7.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.8.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"0.9.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.0.2","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.0.3","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.1.0","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.3.0","dependencies":[["redis","3.0.0"]]},
  {"name":"redis-namespace","number":"1.3.1","dependencies":[["redis","3.0.0"]]},
  {"name":"redis-namespace","number":"1.2.2","dependencies":[["redis","3.0.0"]]},
  {"name":"redis-namespace","number":"1.0.4","dependencies":[["redis",null]]},
  {"name":"redis-namespace","number":"1.1.1","dependencies":[["redis",null]]},
  {"name":"redis-rack","number":"1.4.1","dependencies":[["redis-store","1.1.0"],["rack","=1.4.1"]]},
  {"name":"redis-rack","number":"1.3.5","dependencies":[["redis-store","=1.1.0"],["rack","=1.3.5"]]},
  {"name":"redis-rack","number":"0.0.0","dependencies":[]},
  {"name":"redis-rack","number":"1.4.0","dependencies":[["redis-store","=1.1.0"],["rack","=1.4.0"]]},
  {"name":"redis-rack","number":"1.4.2","dependencies":[["redis-store","1.1.0"],["rack","1.4.1"]]},
  {"name":"redis-rack","number":"1.3.6","dependencies":[["redis-store","1.1.0"],["rack","=1.3.6"]]},
  {"name":"redis-rack","number":"1.5.0","dependencies":[["redis-store","1.1.0"],["rack","1.5.0"]]},
  {"name":"redis-rack","number":"1.4.3","dependencies":[["redis-store","1.1.0"],["rack","1.4.0"]]},
  {"name":"redis-rack","number":"1.4.4","dependencies":[["redis-store","1.1.4"],["rack","1.4.0"]]},
  {"name":"redis-rails","number":"3.2.1","dependencies":[["redis-store","1.1.0"],["redis-activesupport","3.2.1 || 4.0.0"],["redis-actionpack","3.2.1 || 4.0.0"]]},
  {"name":"redis-rails","number":"0.0.0","dependencies":[]},
  {"name":"redis-rails","number":"3.2.2","dependencies":[["redis-store","1.1.0"],["redis-activesupport","3.2.2 || 4.0.0"],["redis-actionpack","3.2.2 || 4.0.0"]]},
  {"name":"redis-rails","number":"3.1.5","dependencies":[["redis-store","1.1.0"],["redis-activesupport","3.1.5 || 4.0.0"],["redis-actionpack","3.1.5 || 4.0.0"]]},
  {"name":"redis-rails","number":"3.2.3","dependencies":[["redis-store","1.1.0"],["redis-activesupport","3.2.3 || 4.0.0"],["redis-actionpack","3.2.3 || 4.0.0"]]},
  {"name":"redis-rails","number":"3.1.3","dependencies":[["redis-store","=1.1.0"],["redis-activesupport","=3.1.3"],["redis-actionpack","=3.1.3"]]},
  {"name":"redis-rails","number":"3.1.4","dependencies":[["redis-store","1.1.0"],["redis-activesupport","=3.1.4"],["redis-actionpack","=3.1.4"]]},
  {"name":"redis-rails","number":"4.0.0","dependencies":[["redis-store","1.1.0"],["redis-activesupport","4.0.0"],["redis-actionpack","4.0.0"]]},
  {"name":"redis-rails","number":"3.2.4","dependencies":[["redis-store","1.1.4"],["redis-activesupport","3.2.4 || 4.0.0"],["redis-actionpack","3.2.4 || 4.0.0"]]},
  {"name":"redis-store","number":"0.3.9","dependencies":[]},
  {"name":"redis-store","number":"0.3.8","dependencies":[]},
  {"name":"redis-store","number":"0.3.7","dependencies":[]},
  {"name":"redis-store","number":"1.1.0","dependencies":[["redis","2.2.0 || 3.0.0"]]},
  {"name":"redis-store","number":"0.3.6","dependencies":[]},
  {"name":"redis-store","number":"1.1.1","dependencies":[["redis","2.2.0 || 3.0.0"]]},
  {"name":"redis-store","number":"1.1.3","dependencies":[["redis","2.2.0 || 3.0.0"]]},
  {"name":"redis-store","number":"1.1.2","dependencies":[["redis","2.2.0 || 3.0.0"]]},
  {"name":"redis-store","number":"1.1.4","dependencies":[["redis","2.2.0 || 3.0.0"]]},
  {"name":"ref","number":"1.0.0","dependencies":[]},
  {"name":"ref","number":"1.0.2","dependencies":[]},
  {"name":"ref","number":"1.0.3","dependencies":[]},
  {"name":"ref","number":"1.0.4","dependencies":[]},
  {"name":"ref","number":"1.0.5","dependencies":[]},
  {"name":"require-all","number":"1.3.2","dependencies":[]},
  {"name":"require-all","number":"1.3.1","dependencies":[]},
  {"name":"require-all","number":"1.0.0","dependencies":[]},
  {"name":"require-all","number":"1.2.0","dependencies":[]},
  {"name":"require-all","number":"1.1.0","dependencies":[]},
  {"name":"require-all","number":"1.0.1","dependencies":[]},
  {"name":"require-all","number":"1.2.1","dependencies":[]},
  {"name":"require-all","number":"1.3.0","dependencies":[]},
  {"name":"rest-client","number":"1.0.2","dependencies":[]},
  {"name":"rest-client","number":"1.0.1","dependencies":[]},
  {"name":"rest-client","number":"1.3.1","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.6.2","dependencies":[]},
  {"name":"rest-client","number":"1.6.3","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.9.0","dependencies":[]},
  {"name":"rest-client","number":"1.0.3","dependencies":[]},
  {"name":"rest-client","number":"1.3.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.4.0","dependencies":[]},
  {"name":"rest-client","number":"0.6.0","dependencies":[]},
  {"name":"rest-client","number":"0.5.1","dependencies":[]},
  {"name":"rest-client","number":"0.1.0","dependencies":[]},
  {"name":"rest-client","number":"1.1.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.0.0","dependencies":[]},
  {"name":"rest-client","number":"1.2.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.6.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.5.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.7.0","dependencies":[]},
  {"name":"rest-client","number":"1.6.1","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.5.1","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.3.0","dependencies":[]},
  {"name":"rest-client","number":"0.8.2","dependencies":[]},
  {"name":"rest-client","number":"0.9.2","dependencies":[]},
  {"name":"rest-client","number":"0.8.1","dependencies":[]},
  {"name":"rest-client","number":"0.8.0","dependencies":[]},
  {"name":"rest-client","number":"0.5.0","dependencies":[]},
  {"name":"rest-client","number":"1.0.4","dependencies":[]},
  {"name":"rest-client","number":"1.4.2","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.4.1","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.4.0","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.6.5","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.6.6","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"1.6.7","dependencies":[["mime-types","1.16.0 || 2.0.0"]]},
  {"name":"rest-client","number":"0.6.1","dependencies":[]},
  {"name":"rest-client","number":"0.2.0","dependencies":[]},
  {"name":"rspec","number":"2.4.0","dependencies":[["rspec-core","2.4.0"],["rspec-expectations","2.4.0"],["rspec-mocks","2.4.0"]]},
  {"name":"rspec","number":"2.0.1","dependencies":[["rspec-core","2.0.1"],["rspec-expectations","2.0.1"],["rspec-mocks","2.0.1"]]},
  {"name":"rspec","number":"1.3.0","dependencies":[]},
  {"name":"rspec","number":"1.1.12","dependencies":[["cucumber",null],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"rspec","number":"2.6.0","dependencies":[["rspec-core","2.6.0"],["rspec-expectations","2.6.0"],["rspec-mocks","2.6.0"]]},
  {"name":"rspec","number":"0.3.2","dependencies":[]},
  {"name":"rspec","number":"0.5.11","dependencies":[]},
  {"name":"rspec","number":"0.6.3","dependencies":[]},
  {"name":"rspec","number":"0.6.1","dependencies":[]},
  {"name":"rspec","number":"0.1.0","dependencies":[]},
  {"name":"rspec","number":"1.0.8","dependencies":[]},
  {"name":"rspec","number":"1.1.10","dependencies":[["diff-lcs",null],["syntax",null],["hoe","1.8.1 || 2.0.0"]]},
  {"name":"rspec","number":"0.1.5","dependencies":[]},
  {"name":"rspec","number":"2.0.0","dependencies":[["rspec-core","=2.0.0"],["rspec-expectations","=2.0.0"],["rspec-mocks","=2.0.0"]]},
  {"name":"rspec","number":"1.1.5","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec","number":"1.2.4","dependencies":[["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec","number":"1.1.3","dependencies":[]},
  {"name":"rspec","number":"0.9.0","dependencies":[]},
  {"name":"rspec","number":"1.1.7","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec","number":"2.7.0","dependencies":[["rspec-core","2.7.0"],["rspec-expectations","2.7.0"],["rspec-mocks","2.7.0"]]},
  {"name":"rspec","number":"1.1.11","dependencies":[["hoe","1.8.1 || 2.0.0"]]},
  {"name":"rspec","number":"0.9.1","dependencies":[]},
  {"name":"rspec","number":"1.1.2","dependencies":[]},
  {"name":"rspec","number":"0.7.2","dependencies":[]},
  {"name":"rspec","number":"0.5.2","dependencies":[]},
  {"name":"rspec","number":"0.1.2","dependencies":[]},
  {"name":"rspec","number":"1.1.4","dependencies":[]},
  {"name":"rspec","number":"0.7.4","dependencies":[]},
  {"name":"rspec","number":"0.5.8","dependencies":[]},
  {"name":"rspec","number":"1.1.0","dependencies":[]},
  {"name":"rspec","number":"2.8.0","dependencies":[["rspec-core","2.8.0"],["rspec-expectations","2.8.0"],["rspec-mocks","2.8.0"]]},
  {"name":"rspec","number":"0.9.2","dependencies":[]},
  {"name":"rspec","number":"0.1.6","dependencies":[]},
  {"name":"rspec","number":"0.7.0","dependencies":[]},
  {"name":"rspec","number":"1.0.3","dependencies":[]},
  {"name":"rspec","number":"0.5.9","dependencies":[]},
  {"name":"rspec","number":"0.5.5","dependencies":[]},
  {"name":"rspec","number":"0.1.7","dependencies":[]},
  {"name":"rspec","number":"1.0.5","dependencies":[]},
  {"name":"rspec","number":"1.0.6","dependencies":[]},
  {"name":"rspec","number":"0.5.14","dependencies":[]},
  {"name":"rspec","number":"0.5.13","dependencies":[]},
  {"name":"rspec","number":"0.5.12","dependencies":[]},
  {"name":"rspec","number":"0.3.1","dependencies":[]},
  {"name":"rspec","number":"0.5.3","dependencies":[]},
  {"name":"rspec","number":"1.2.3","dependencies":[["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec","number":"0.9.4","dependencies":[]},
  {"name":"rspec","number":"0.8.1","dependencies":[]},
  {"name":"rspec","number":"0.6.0","dependencies":[]},
  {"name":"rspec","number":"1.2.1","dependencies":[["cucumber",null],["hoe","1.11.0 || 2.0.0"]]},
  {"name":"rspec","number":"1.1.8","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec","number":"0.7.1","dependencies":[]},
  {"name":"rspec","number":"1.1.1","dependencies":[]},
  {"name":"rspec","number":"0.5.15","dependencies":[]},
  {"name":"rspec","number":"1.2.0","dependencies":[["cucumber",null],["hoe","1.10.0 || 2.0.0"]]},
  {"name":"rspec","number":"0.1.3","dependencies":[]},
  {"name":"rspec","number":"0.5.10","dependencies":[]},
  {"name":"rspec","number":"0.8.0","dependencies":[]},
  {"name":"rspec","number":"0.5.7","dependencies":[]},
  {"name":"rspec","number":"0.5.0","dependencies":[]},
  {"name":"rspec","number":"1.0.1","dependencies":[]},
  {"name":"rspec","number":"0.3.0","dependencies":[]},
  {"name":"rspec","number":"0.5.1","dependencies":[]},
  {"name":"rspec","number":"0.2.0","dependencies":[]},
  {"name":"rspec","number":"0.6.4","dependencies":[]},
  {"name":"rspec","number":"0.7.3","dependencies":[]},
  {"name":"rspec","number":"1.0.0","dependencies":[]},
  {"name":"rspec","number":"1.0.7","dependencies":[]},
  {"name":"rspec","number":"0.1.1","dependencies":[]},
  {"name":"rspec","number":"2.2.0","dependencies":[["rspec-core","2.2.0"],["rspec-expectations","2.2.0"],["rspec-mocks","2.2.0"]]},
  {"name":"rspec","number":"0.5.16","dependencies":[]},
  {"name":"rspec","number":"2.11.0","dependencies":[["rspec-core","2.11.0"],["rspec-expectations","2.11.0"],["rspec-mocks","2.11.0"]]},
  {"name":"rspec","number":"1.2.9","dependencies":[]},
  {"name":"rspec","number":"0.9.3","dependencies":[]},
  {"name":"rspec","number":"0.4.0","dependencies":[]},
  {"name":"rspec","number":"1.3.1","dependencies":[]},
  {"name":"rspec","number":"1.2.2","dependencies":[["cucumber",null],["hoe","1.11.0 || 2.0.0"]]},
  {"name":"rspec","number":"1.2.6","dependencies":[["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec","number":"1.3.2","dependencies":[]},
  {"name":"rspec","number":"1.1.6","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec","number":"0.6.2","dependencies":[]},
  {"name":"rspec","number":"1.2.5","dependencies":[["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec","number":"1.0.2","dependencies":[]},
  {"name":"rspec","number":"0.8.2","dependencies":[]},
  {"name":"rspec","number":"0.5.4","dependencies":[]},
  {"name":"rspec","number":"1.1.9","dependencies":[["diff-lcs",null],["spicycode-rcov",null],["syntax",null],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"rspec","number":"0.0.10","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec","number":"0.1.4","dependencies":[]},
  {"name":"rspec","number":"0.7.5","dependencies":[]},
  {"name":"rspec","number":"0.5.6","dependencies":[]},
  {"name":"rspec","number":"1.0.4","dependencies":[]},
  {"name":"rspec","number":"2.10.0","dependencies":[["rspec-core","2.10.0"],["rspec-expectations","2.10.0"],["rspec-mocks","2.10.0"]]},
  {"name":"rspec","number":"2.1.0","dependencies":[["rspec-core","2.1.0"],["rspec-expectations","2.1.0"],["rspec-mocks","2.1.0"]]},
  {"name":"rspec","number":"2.5.0","dependencies":[["rspec-core","2.5.0"],["rspec-expectations","2.5.0"],["rspec-mocks","2.5.0"]]},
  {"name":"rspec","number":"2.3.0","dependencies":[["rspec-core","2.3.0"],["rspec-expectations","2.3.0"],["rspec-mocks","2.3.0"]]},
  {"name":"rspec","number":"1.2.7","dependencies":[["cucumber",null],["hoe","2.1.0"]]},
  {"name":"rspec","number":"2.9.0","dependencies":[["rspec-core","2.9.0"],["rspec-expectations","2.9.0"],["rspec-mocks","2.9.0"]]},
  {"name":"rspec","number":"1.2.8","dependencies":[["cucumber",null],["hoe","2.3.1"]]},
  {"name":"rspec","number":"2.12.0","dependencies":[["rspec-core","2.12.0"],["rspec-expectations","2.12.0"],["rspec-mocks","2.12.0"]]},
  {"name":"rspec","number":"2.13.0","dependencies":[["rspec-core","2.13.0"],["rspec-expectations","2.13.0"],["rspec-mocks","2.13.0"]]},
  {"name":"rspec","number":"2.14.0","dependencies":[["rspec-core","2.14.0"],["rspec-expectations","2.14.0"],["rspec-mocks","2.14.0"]]},
  {"name":"rspec","number":"2.14.1","dependencies":[["rspec-core","2.14.0"],["rspec-expectations","2.14.0"],["rspec-mocks","2.14.0"]]},
  {"name":"rspec-core","number":"2.14.8","dependencies":[]},
  {"name":"rspec-core","number":"2.14.7","dependencies":[]},
  {"name":"rspec-core","number":"2.14.6","dependencies":[]},
  {"name":"rspec-core","number":"2.3.0","dependencies":[]},
  {"name":"rspec-core","number":"2.10.1","dependencies":[]},
  {"name":"rspec-core","number":"2.10.0","dependencies":[]},
  {"name":"rspec-core","number":"2.3.1","dependencies":[]},
  {"name":"rspec-core","number":"2.1.0","dependencies":[]},
  {"name":"rspec-core","number":"2.2.1","dependencies":[]},
  {"name":"rspec-core","number":"2.11.0","dependencies":[]},
  {"name":"rspec-core","number":"2.4.0","dependencies":[]},
  {"name":"rspec-core","number":"2.9.0","dependencies":[]},
  {"name":"rspec-core","number":"2.7.1","dependencies":[]},
  {"name":"rspec-core","number":"2.2.0","dependencies":[]},
  {"name":"rspec-core","number":"2.6.4","dependencies":[]},
  {"name":"rspec-core","number":"2.6.0","dependencies":[]},
  {"name":"rspec-core","number":"2.6.3","dependencies":[]},
  {"name":"rspec-core","number":"2.0.0","dependencies":[]},
  {"name":"rspec-core","number":"2.8.0","dependencies":[]},
  {"name":"rspec-core","number":"2.5.2","dependencies":[]},
  {"name":"rspec-core","number":"2.0.1","dependencies":[]},
  {"name":"rspec-core","number":"2.5.0","dependencies":[]},
  {"name":"rspec-core","number":"2.7.0","dependencies":[]},
  {"name":"rspec-core","number":"2.11.1","dependencies":[]},
  {"name":"rspec-core","number":"2.5.1","dependencies":[]},
  {"name":"rspec-core","number":"2.12.0","dependencies":[]},
  {"name":"rspec-core","number":"2.12.1","dependencies":[]},
  {"name":"rspec-core","number":"2.12.2","dependencies":[]},
  {"name":"rspec-core","number":"2.13.0","dependencies":[]},
  {"name":"rspec-core","number":"2.13.1","dependencies":[]},
  {"name":"rspec-core","number":"2.14.0","dependencies":[]},
  {"name":"rspec-core","number":"2.14.1","dependencies":[]},
  {"name":"rspec-core","number":"2.14.2","dependencies":[]},
  {"name":"rspec-core","number":"2.14.3","dependencies":[]},
  {"name":"rspec-core","number":"2.14.4","dependencies":[]},
  {"name":"rspec-core","number":"2.14.5","dependencies":[]},
  {"name":"rspec-expectations","number":"2.14.5","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.14.4","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.14.3","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.11.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.6.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.5.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.1.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.3.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.9.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.0.1","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.8.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.7.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.2.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.0.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.11.3","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.4.0","dependencies":[["diff-lcs","1.1.2"]]},
  {"name":"rspec-expectations","number":"2.9.1","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.10.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.11.1","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.11.2","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.12.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.12.1","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.13.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.14.0","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.14.1","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-expectations","number":"2.14.2","dependencies":[["diff-lcs","1.1.3"]]},
  {"name":"rspec-mocks","number":"2.14.6","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.5","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.4","dependencies":[]},
  {"name":"rspec-mocks","number":"2.6.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.0.0","dependencies":[["rspec-core","=2.0.0"],["rspec-expectations","=2.0.0"]]},
  {"name":"rspec-mocks","number":"2.0.1","dependencies":[["rspec-core","2.0.1"],["rspec-expectations","2.0.1"]]},
  {"name":"rspec-mocks","number":"2.8.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.1.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.5.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.4.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.9.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.11.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.11.1","dependencies":[]},
  {"name":"rspec-mocks","number":"2.11.3","dependencies":[]},
  {"name":"rspec-mocks","number":"2.10.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.3.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.7.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.10.1","dependencies":[]},
  {"name":"rspec-mocks","number":"2.2.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.11.2","dependencies":[]},
  {"name":"rspec-mocks","number":"2.12.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.12.1","dependencies":[]},
  {"name":"rspec-mocks","number":"2.12.2","dependencies":[]},
  {"name":"rspec-mocks","number":"2.13.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.13.1","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.0","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.1","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.2","dependencies":[]},
  {"name":"rspec-mocks","number":"2.14.3","dependencies":[]},
  {"name":"rspec-rails","number":"2.14.2","dependencies":[["rspec-mocks","2.14.0"],["rspec-expectations","2.14.0"],["rspec-core","2.14.0"],["railties","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["activemodel","3.0.0 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"rspec-rails","number":"2.14.1","dependencies":[["rspec-mocks","2.14.0"],["rspec-expectations","2.14.0"],["rspec-core","2.14.0"],["railties","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["activemodel","3.0.0 || 4.0.0"],["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"rspec-rails","number":"1.2.0","dependencies":[["rspec","=1.2.0"],["rack",null],["cucumber",null],["hoe","1.10.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.1.8","dependencies":[["rspec","=1.1.8"],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.3.2","dependencies":[["rspec","1.3.0 || 2.0.0"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"2.3.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.3.0"]]},
  {"name":"rspec-rails","number":"1.1.12","dependencies":[["rspec","=1.1.12"],["cucumber",null],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.1.0","dependencies":[["rspec","2.1.0"]]},
  {"name":"rspec-rails","number":"1.1.6","dependencies":[["rspec","=1.1.5"],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.1.7","dependencies":[["rspec","=1.1.7"],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.0.0","dependencies":[["rspec","=2.0.0"]]},
  {"name":"rspec-rails","number":"2.7.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.7.0"]]},
  {"name":"rspec-rails","number":"2.8.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.8.0"]]},
  {"name":"rspec-rails","number":"2.11.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.11.0"]]},
  {"name":"rspec-rails","number":"2.10.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.10.0"]]},
  {"name":"rspec-rails","number":"2.6.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.6.0"]]},
  {"name":"rspec-rails","number":"2.8.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.8.0"]]},
  {"name":"rspec-rails","number":"1.1.10","dependencies":[["rspec","1.1.10 || 2.0.0"],["hoe","1.8.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.2.6","dependencies":[["rspec","=1.2.6"],["rack",null],["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.5.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.5.0"]]},
  {"name":"rspec-rails","number":"1.2.3","dependencies":[["rspec","=1.2.3"],["rack",null],["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.6.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.6.0"]]},
  {"name":"rspec-rails","number":"2.9.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.9.0"]]},
  {"name":"rspec-rails","number":"2.11.4","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.11.0"]]},
  {"name":"rspec-rails","number":"1.3.1","dependencies":[["rspec","1.3.0 || 2.0.0"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"2.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.3.0"]]},
  {"name":"rspec-rails","number":"1.2.1","dependencies":[["rspec","=1.2.1"],["rack",null],["cucumber",null],["hoe","1.11.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.3.3","dependencies":[["rspec","=1.3.1"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"1.2.4","dependencies":[["rspec","=1.2.4"],["rack",null],["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.2.0","dependencies":[["rails","3.0.0 || 4.0.0"],["rspec","2.2.0"]]},
  {"name":"rspec-rails","number":"2.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.4.0"]]},
  {"name":"rspec-rails","number":"1.3.4","dependencies":[["rspec","1.3.1 || 2.0.0"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"1.3.0","dependencies":[["rspec","1.3.0 || 2.0.0"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"1.2.2","dependencies":[["rspec","=1.2.2"],["rack",null],["cucumber",null],["hoe","1.11.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.1.5","dependencies":[["rspec","=1.1.5"],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.2.5","dependencies":[["rspec","=1.2.5"],["rack",null],["cucumber",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.2.7","dependencies":[["rspec","1.2.7 || 2.0.0"],["rack",null],["cucumber",null],["hoe","2.1.0"]]},
  {"name":"rspec-rails","number":"2.0.1","dependencies":[["rspec","2.0.0"]]},
  {"name":"rspec-rails","number":"2.2.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.2.0"]]},
  {"name":"rspec-rails","number":"1.1.9","dependencies":[["rspec","=1.1.9"],["hoe","1.8.0 || 2.0.0"]]},
  {"name":"rspec-rails","number":"1.1.11","dependencies":[["rspec","=1.1.11"],["hoe","1.8.1 || 2.0.0"]]},
  {"name":"rspec-rails","number":"2.4.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.4.0"]]},
  {"name":"rspec-rails","number":"1.2.9","dependencies":[["rspec","1.2.9 || 2.0.0"],["rack","1.0.0"]]},
  {"name":"rspec-rails","number":"2.10.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec","2.10.0"]]},
  {"name":"rspec-rails","number":"2.12.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.12.0"],["rspec-expectations","2.12.0"],["rspec-mocks","2.12.0"]]},
  {"name":"rspec-rails","number":"2.12.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.12.0"],["rspec-expectations","2.12.0"],["rspec-mocks","2.12.0"]]},
  {"name":"rspec-rails","number":"2.12.2","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.12.0"],["rspec-expectations","2.12.0"],["rspec-mocks","2.12.0"]]},
  {"name":"rspec-rails","number":"2.13.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.13.0"],["rspec-expectations","2.13.0"],["rspec-mocks","2.13.0"]]},
  {"name":"rspec-rails","number":"2.13.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.13.0"],["rspec-expectations","2.13.0"],["rspec-mocks","2.13.0"]]},
  {"name":"rspec-rails","number":"2.13.2","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.13.0"],["rspec-expectations","2.13.0"],["rspec-mocks","2.13.0"]]},
  {"name":"rspec-rails","number":"2.14.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","3.0.0 || 4.0.0"],["railties","3.0.0 || 4.0.0"],["rspec-core","2.14.0"],["rspec-expectations","2.14.0"],["rspec-mocks","2.14.0"]]},
  {"name":"ruby-hmac","number":"0.3.1","dependencies":[["hoe","1.2.2 || 2.0.0"]]},
  {"name":"ruby-hmac","number":"0.3.2","dependencies":[["hoe","1.7.0 || 2.0.0"]]},
  {"name":"ruby-hmac","number":"0.4.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.4.2","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.4.1","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.4.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.3.2","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.3.1","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.3.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"0.0.9","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.0.1","dependencies":[]},
  {"name":"ruby-progressbar","number":"0.0.10","dependencies":[]},
  {"name":"ruby-progressbar","number":"0.11.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.0.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.0.2","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.1.0","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.1.1","dependencies":[]},
  {"name":"ruby-progressbar","number":"1.2.0","dependencies":[]},
  {"name":"rubyntlm","number":"0.1.1","dependencies":[]},
  {"name":"rubyntlm","number":"0.4.0","dependencies":[]},
  {"name":"rubyntlm","number":"0.2.0","dependencies":[]},
  {"name":"rubyntlm","number":"0.3.0","dependencies":[]},
  {"name":"rubyntlm","number":"0.3.1","dependencies":[]},
  {"name":"rubyntlm","number":"0.3.2","dependencies":[]},
  {"name":"rubyntlm","number":"0.3.3","dependencies":[]},
  {"name":"rubyntlm","number":"0.3.4","dependencies":[]},
  {"name":"rugged","number":"0.0.1","dependencies":[]},
  {"name":"rugged","number":"0.1.2","dependencies":[]},
  {"name":"rugged","number":"0.1.0","dependencies":[]},
  {"name":"rugged","number":"0.1.1","dependencies":[]},
  {"name":"rugged","number":"0.16.0","dependencies":[]},
  {"name":"rugged","number":"0.19.0","dependencies":[]},
  {"name":"safe-yaml","number":"1.0.1","dependencies":[]},
  {"name":"safe-yaml","number":"1.0.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.7","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.6","dependencies":[]},
  {"name":"safe-yaml","number":"0.1.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.2.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.2.2","dependencies":[]},
  {"name":"safe-yaml","number":"0.2.0","dependencies":[["psych",null]]},
  {"name":"safe-yaml","number":"0.3.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.4.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.5.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.5.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.5.2","dependencies":[]},
  {"name":"safe-yaml","number":"0.6.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.6.2","dependencies":[]},
  {"name":"safe-yaml","number":"0.6.3","dependencies":[]},
  {"name":"safe-yaml","number":"0.7.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.7.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.2","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.3","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.4","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.5","dependencies":[]},
  {"name":"safe-yaml","number":"0.8.6","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.0","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.1","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.2","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.3","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.4","dependencies":[]},
  {"name":"safe-yaml","number":"0.9.5","dependencies":[]},
  {"name":"sanitize","number":"2.1.0","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"1.0.0","dependencies":[["hpricot","0.6.0 || 1.0.0"]]},
  {"name":"sanitize","number":"1.0.7","dependencies":[["hpricot","0.8.1 || 1.0.0"]]},
  {"name":"sanitize","number":"2.0.0","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"1.2.0","dependencies":[["nokogiri","1.4.1"]]},
  {"name":"sanitize","number":"1.0.6","dependencies":[["hpricot","0.6.0 || 1.0.0"]]},
  {"name":"sanitize","number":"1.0.3","dependencies":[["hpricot","0.6.0 || 1.0.0"],["htmlentities","4.0.0"]]},
  {"name":"sanitize","number":"1.0.8","dependencies":[["hpricot","0.8.1 || 1.0.0"]]},
  {"name":"sanitize","number":"1.0.4","dependencies":[["hpricot","0.6.0 || 1.0.0"],["htmlentities","4.0.0"]]},
  {"name":"sanitize","number":"1.0.2","dependencies":[["hpricot","0.6.0 || 1.0.0"],["htmlentities","4.0.0"]]},
  {"name":"sanitize","number":"1.0.5","dependencies":[["hpricot","0.6.0 || 1.0.0"],["htmlentities","4.0.0"]]},
  {"name":"sanitize","number":"1.2.1","dependencies":[["nokogiri","1.4.1"]]},
  {"name":"sanitize","number":"1.1.0","dependencies":[["nokogiri","1.3.3"]]},
  {"name":"sanitize","number":"1.0.1","dependencies":[["hpricot","0.6.0 || 1.0.0"],["htmlentities","4.0.0"]]},
  {"name":"sanitize","number":"2.0.1","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"2.0.2","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"2.0.3","dependencies":[["nokogiri","1.4.4"],["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"2.0.4","dependencies":[["nokogiri","1.6.0"]]},
  {"name":"sanitize","number":"2.0.6","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sanitize","number":"2.0.5","dependencies":[["nokogiri","1.4.4"]]},
  {"name":"sass","number":"3.2.18","dependencies":[]},
  {"name":"sass","number":"3.3.4","dependencies":[]},
  {"name":"sass","number":"3.2.17","dependencies":[]},
  {"name":"sass","number":"3.2.16","dependencies":[]},
  {"name":"sass","number":"3.3.3","dependencies":[]},
  {"name":"sass","number":"3.3.2","dependencies":[]},
  {"name":"sass","number":"3.3.1","dependencies":[]},
  {"name":"sass","number":"3.3.0","dependencies":[["rake",null]]},
  {"name":"sass","number":"3.2.15","dependencies":[]},
  {"name":"sass","number":"3.2.14","dependencies":[]},
  {"name":"sass","number":"3.2.13","dependencies":[]},
  {"name":"sass","number":"3.2.12","dependencies":[]},
  {"name":"sass","number":"3.2.11","dependencies":[]},
  {"name":"sass","number":"3.1.6","dependencies":[]},
  {"name":"sass","number":"3.1.14","dependencies":[]},
  {"name":"sass","number":"3.1.1","dependencies":[]},
  {"name":"sass","number":"3.1.13","dependencies":[]},
  {"name":"sass","number":"3.1.11","dependencies":[]},
  {"name":"sass","number":"3.1.9","dependencies":[]},
  {"name":"sass","number":"3.1.18","dependencies":[]},
  {"name":"sass","number":"3.1.19","dependencies":[]},
  {"name":"sass","number":"3.1.20","dependencies":[]},
  {"name":"sass","number":"3.1.7","dependencies":[]},
  {"name":"sass","number":"3.2.1","dependencies":[]},
  {"name":"sass","number":"3.1.8","dependencies":[]},
  {"name":"sass","number":"3.1.0","dependencies":[]},
  {"name":"sass","number":"3.1.3","dependencies":[]},
  {"name":"sass","number":"3.1.15","dependencies":[]},
  {"name":"sass","number":"3.1.12","dependencies":[]},
  {"name":"sass","number":"3.1.21","dependencies":[]},
  {"name":"sass","number":"3.1.2","dependencies":[]},
  {"name":"sass","number":"3.1.4","dependencies":[]},
  {"name":"sass","number":"3.1.17","dependencies":[]},
  {"name":"sass","number":"3.1.10","dependencies":[]},
  {"name":"sass","number":"3.1.5","dependencies":[]},
  {"name":"sass","number":"3.2.0","dependencies":[]},
  {"name":"sass","number":"3.1.16","dependencies":[]},
  {"name":"sass","number":"3.2.2","dependencies":[]},
  {"name":"sass","number":"3.2.3","dependencies":[]},
  {"name":"sass","number":"3.2.4","dependencies":[]},
  {"name":"sass","number":"3.2.5","dependencies":[]},
  {"name":"sass","number":"3.2.6","dependencies":[]},
  {"name":"sass","number":"3.2.7","dependencies":[]},
  {"name":"sass","number":"3.2.8","dependencies":[]},
  {"name":"sass","number":"3.2.9","dependencies":[]},
  {"name":"sass","number":"3.2.10","dependencies":[]},
  {"name":"sass-rails","number":"4.0.2","dependencies":[["sprockets","2.8.0"],["sprockets-rails","2.0.0"],["railties","4.0.0"],["sass","3.2.0"]]},
  {"name":"sass-rails","number":"4.0.1","dependencies":[["sprockets-rails","2.0.0"],["railties","4.0.0"],["sass","3.1.10"]]},
  {"name":"sass-rails","number":"3.2.0","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.1.4","dependencies":[["sass","3.1.4"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"],["sprockets","2.0.0"]]},
  {"name":"sass-rails","number":"3.2.2","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.2.1","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.2.4","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.2.5","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.2.3","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.1.1","dependencies":[["sass","3.1.4"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.1.3","dependencies":[["sass","3.1.4"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"],["sprockets","2.0.0"]]},
  {"name":"sass-rails","number":"3.1.0","dependencies":[["sass","3.1.4"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"]]},
  {"name":"sass-rails","number":"3.1.2","dependencies":[["sass","3.1.4"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"],["sprockets","2.0.0"]]},
  {"name":"sass-rails","number":"3.1.5","dependencies":[["sass","3.1.10"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.1.6","dependencies":[["sass","3.1.10"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.2.6","dependencies":[["sass","3.1.10"],["railties","3.2.0 || 4.0.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sass-rails","number":"3.1.7","dependencies":[["sass","3.1.10"],["railties","3.1.0 || 4.0.0"],["actionpack","3.1.0 || 4.0.0"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"sass-rails","number":"4.0.0","dependencies":[["sass","3.1.10"],["railties","4.0.0"],["sprockets-rails","2.0.0"]]},
  {"name":"sdoc","number":"0.4.0","dependencies":[["json","1.8.0"],["rdoc","4.0.0"]]},
  {"name":"sdoc","number":"0.2.18","dependencies":[["rdoc","2.4.2 || 3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.15","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.2","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.6","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.1","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.3","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.2.19","dependencies":[["rdoc","2.4.2 || 3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.2.15","dependencies":[["rdoc","2.4.2 || 3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.0","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.2.20","dependencies":[["rdoc","=2.4.3"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.4","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.5","dependencies":[["rdoc","3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.8","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.11","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.14","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.16","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.7","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.2.14","dependencies":[["json","1.1.3"],["rdoc","2.4.2 || 3.0.0 || 4.0.0"]]},
  {"name":"sdoc","number":"0.2.16","dependencies":[["rdoc","2.4.2 || 3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.9","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.10","dependencies":[["rdoc","3.0.0 || 4.0.0"],["sanitize","2.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.2.17","dependencies":[["rdoc","2.4.2 || 3.0.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.18","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.17","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.19","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"sdoc","number":"0.3.20","dependencies":[["rdoc","3.10.0 || 4.0.0"],["json","1.1.3"]]},
  {"name":"seed-fu","number":"2.3.0","dependencies":[["activesupport","3.1.0 || 4.0.0"],["activerecord","3.1.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"2.0.1","dependencies":[["activerecord","3.0.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"1.2.3","dependencies":[["rails","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"1.2.2","dependencies":[["rails","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"2.0.0","dependencies":[["activerecord","3.0.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"2.1.0","dependencies":[["activerecord","3.1.0 || 4.0.0"],["activesupport","3.1.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"2.2.0","dependencies":[["activerecord","3.1.0 || 4.0.0"],["activesupport","3.1.0 || 4.0.0"]]},
  {"name":"seed-fu","number":"1.2.1","dependencies":[["rails","2.1.0 || 3.0.0 || 4.0.0"]]},
  {"name":"select2-rails","number":"3.5.4","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.5.3","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.5.2","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.5.1","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.5.0","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.4.9","dependencies":[["sass-rails",null],["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.9","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.0.0","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.2","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.1","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"2.1.0","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.2.0","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.7","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.3","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.5","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.1.0","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.4","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"0.0.6","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.1.1","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.2.1","dependencies":[["thor","0.14.0"]]},
  {"name":"select2-rails","number":"3.3.0","dependencies":[["thor","0.14.0"],["sass-rails","3.2.0 || 4.0.0"]]},
  {"name":"select2-rails","number":"3.3.1","dependencies":[["thor","0.14.0"],["sass-rails","3.2.0 || 4.0.0"]]},
  {"name":"select2-rails","number":"3.3.2","dependencies":[["thor","0.14.0"],["sass-rails","3.2.0 || 4.0.0"]]},
  {"name":"select2-rails","number":"3.4.0","dependencies":[["thor","0.14.0"],["sass-rails","3.2.0 || 4.0.0"]]},
  {"name":"select2-rails","number":"3.4.1","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.2","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.3","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.4","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.5","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.6","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.7","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"select2-rails","number":"3.4.8","dependencies":[["thor","0.14.0"],["sass-rails",null]]},
  {"name":"settingslogic","number":"2.0.5","dependencies":[]},
  {"name":"settingslogic","number":"1.0.0","dependencies":[["echoe",null]]},
  {"name":"settingslogic","number":"2.0.3","dependencies":[]},
  {"name":"settingslogic","number":"0.9.0","dependencies":[["echoe",null]]},
  {"name":"settingslogic","number":"2.0.7","dependencies":[["rake",null],["rspec",null]]},
  {"name":"settingslogic","number":"1.0.2","dependencies":[["activesupport",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"settingslogic","number":"1.0.3","dependencies":[["activesupport",null],["hoe","1.12.1 || 2.0.0"]]},
  {"name":"settingslogic","number":"2.0.6","dependencies":[]},
  {"name":"settingslogic","number":"1.0.4","dependencies":[["activesupport",null]]},
  {"name":"settingslogic","number":"2.0.0","dependencies":[]},
  {"name":"settingslogic","number":"2.0.2","dependencies":[]},
  {"name":"settingslogic","number":"1.0.1","dependencies":[]},
  {"name":"settingslogic","number":"2.0.1","dependencies":[]},
  {"name":"settingslogic","number":"2.0.8","dependencies":[]},
  {"name":"settingslogic","number":"2.0.9","dependencies":[]},
  {"name":"sexp-processor","number":"4.4.2","dependencies":[]},
  {"name":"sexp-processor","number":"4.4.1","dependencies":[]},
  {"name":"sexp-processor","number":"4.4.0","dependencies":[]},
  {"name":"sexp-processor","number":"3.1.0","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.2","dependencies":[["hoe","2.3.0"]]},
  {"name":"sexp-processor","number":"3.0.5","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.6","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.3","dependencies":[["hoe","2.3.3"]]},
  {"name":"sexp-processor","number":"3.0.4","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.1","dependencies":[["hoe","1.8.2 || 2.0.0"]]},
  {"name":"sexp-processor","number":"3.0.8","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.9","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.10","dependencies":[]},
  {"name":"sexp-processor","number":"3.2.0","dependencies":[]},
  {"name":"sexp-processor","number":"4.0.1","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.7","dependencies":[]},
  {"name":"sexp-processor","number":"3.0.0","dependencies":[["hoe","1.8.0 || 2.0.0"]]},
  {"name":"sexp-processor","number":"4.0.0","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.0","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.1","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.2","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.3","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.4","dependencies":[]},
  {"name":"sexp-processor","number":"4.1.5","dependencies":[]},
  {"name":"sexp-processor","number":"4.2.0","dependencies":[]},
  {"name":"sexp-processor","number":"4.2.1","dependencies":[]},
  {"name":"sexp-processor","number":"4.3.0","dependencies":[]},
  {"name":"shoulda-matchers","number":"2.5.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"2.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.1.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.0.0","dependencies":[]},
  {"name":"shoulda-matchers","number":"1.2.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.4.1","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.4.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"1.4.2","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.1.2"]]},
  {"name":"shoulda-matchers","number":"1.5.0","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.2.0"]]},
  {"name":"shoulda-matchers","number":"1.5.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.3.0"]]},
  {"name":"shoulda-matchers","number":"1.5.2","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.3.0"]]},
  {"name":"shoulda-matchers","number":"1.5.4","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.3.0"]]},
  {"name":"shoulda-matchers","number":"1.5.5","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.3.0"]]},
  {"name":"shoulda-matchers","number":"1.5.6","dependencies":[["activesupport","3.0.0 || 4.0.0"],["bourne","1.3.0"]]},
  {"name":"shoulda-matchers","number":"2.0.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"2.1.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"2.2.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"shoulda-matchers","number":"2.3.0","dependencies":[["activesupport","3.0.0 || 4.0.0"]]},
  {"name":"sidekiq","number":"2.17.7","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.6","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.5","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.4","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.3","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.2","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.1","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.6"]]},
  {"name":"sidekiq","number":"2.17.0","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.16.1","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.16.0","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.15.2","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.15.1","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.15.0","dependencies":[["json",null],["celluloid",null],["connection-pool","1.0.0 || 2.0.0"],["redis-namespace","1.3.1"],["redis","3.0.4"]]},
  {"name":"sidekiq","number":"2.14.1","dependencies":[["redis","3.0.4"],["redis-namespace","1.3.1"],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.0.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.11.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.0.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.11.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.3.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"1.1.4","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"0.10.1","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"2.1.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.11.1"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"1.2.1","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.2.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.11.1"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.3.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"0.8.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.11.2","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"0.9.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.11.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"1.0.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"0.10.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.11.1","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"0.7.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.5.0","dependencies":[["redis",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"1.1.1","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"1.1.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json",null]]},
  {"name":"sidekiq","number":"1.1.2","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"1.1.3","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"0.6.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.5.1","dependencies":[["redis",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"0.9.1","dependencies":[["redis",null],["redis-namespace",null],["connection-pool",null],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"2.0.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.11.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"1.2.0","dependencies":[["redis",null],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.10.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.2.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.11.1"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.3.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.1.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.11.1"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.0.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.0 || 1.0.0 || 2.0.0"],["celluloid","0.11.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.3.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.4.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.5.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"],["sprockets-sass",null],["sass",null]]},
  {"name":"sidekiq","number":"2.5.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"],["sprockets-sass",null],["sass",null]]},
  {"name":"sidekiq","number":"2.5.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.5.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.5.4","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","0.9.2 || 1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.4","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.6.5","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.4","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.7.5","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.8.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.9.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.10.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"],["sinatra",null],["slim",null],["i18n",null]]},
  {"name":"sidekiq","number":"2.10.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.12.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.11.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.13.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.11.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid","0.13.0"],["multi-json","1.0.0"]]},
  {"name":"sidekiq","number":"2.11.2","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["multi-json",null]]},
  {"name":"sidekiq","number":"2.12.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.12.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.12.3","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.12.4","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.13.0","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.13.1","dependencies":[["redis","3.0.0"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"sidekiq","number":"2.14.0","dependencies":[["redis","3.0.4"],["redis-namespace",null],["connection-pool","1.0.0 || 2.0.0"],["celluloid",null],["json",null]]},
  {"name":"simple-oauth","number":"0.1.6","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.8","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.1","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.3","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.4","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.2","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.0","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.5","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.7","dependencies":[]},
  {"name":"simple-oauth","number":"0.1.9","dependencies":[]},
  {"name":"simple-oauth","number":"0.2.0","dependencies":[]},
  {"name":"simplecov","number":"0.8.2","dependencies":[["docile","1.1.0"],["simplecov-html","0.8.0"],["multi-json",null]]},
  {"name":"simplecov","number":"0.8.1","dependencies":[["docile","1.1.0"],["simplecov-html","0.8.0"],["lockfile","2.1.0"],["multi-json",null]]},
  {"name":"simplecov","number":"0.6.0","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.5.4","dependencies":[["multi-json","1.0.3"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.6.4","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.4.0","dependencies":[["simplecov-html","0.4.0"]]},
  {"name":"simplecov","number":"0.7.0","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.7.0"]]},
  {"name":"simplecov","number":"0.3.1","dependencies":[]},
  {"name":"simplecov","number":"0.4.1","dependencies":[["simplecov-html","0.4.3"]]},
  {"name":"simplecov","number":"0.4.2","dependencies":[["simplecov-html","0.4.4"]]},
  {"name":"simplecov","number":"0.5.3","dependencies":[["multi-json","1.0.3"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.3.7","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.3.0","dependencies":[]},
  {"name":"simplecov","number":"0.6.3","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.3.2","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.3.6","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.3.5","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.5.2","dependencies":[["multi-json","1.0.3"],["simplecov-html","0.5.0"]]},
  {"name":"simplecov","number":"0.3.3","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.3.9","dependencies":[["simplecov-html",null]]},
  {"name":"simplecov","number":"0.6.1","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.6.2","dependencies":[["multi-json","1.3.0"],["simplecov-html","0.5.3"]]},
  {"name":"simplecov","number":"0.7.1","dependencies":[["multi-json","1.0.0"],["simplecov-html","0.7.1"]]},
  {"name":"simplecov-html","number":"0.8.0","dependencies":[]},
  {"name":"simplecov-html","number":"0.3.8","dependencies":[]},
  {"name":"simplecov-html","number":"0.4.5","dependencies":[]},
  {"name":"simplecov-html","number":"0.7.0","dependencies":[]},
  {"name":"simplecov-html","number":"0.3.5","dependencies":[["simplecov","0.3.0"]]},
  {"name":"simplecov-html","number":"0.4.3","dependencies":[]},
  {"name":"simplecov-html","number":"0.5.0","dependencies":[]},
  {"name":"simplecov-html","number":"0.3.7","dependencies":[]},
  {"name":"simplecov-html","number":"0.3.1","dependencies":[["simplecov",null]]},
  {"name":"simplecov-html","number":"0.3.3","dependencies":[["simplecov","0.3.0"]]},
  {"name":"simplecov-html","number":"0.3.4","dependencies":[["simplecov","0.3.0"]]},
  {"name":"simplecov-html","number":"0.3.9","dependencies":[]},
  {"name":"simplecov-html","number":"0.3.0","dependencies":[["simplecov",null]]},
  {"name":"simplecov-html","number":"0.3.2","dependencies":[["simplecov","0.3.0"]]},
  {"name":"simplecov-html","number":"0.4.4","dependencies":[]},
  {"name":"simplecov-html","number":"0.5.3","dependencies":[]},
  {"name":"simplecov-html","number":"0.7.1","dependencies":[]},
  {"name":"sinatra","number":"1.4.4","dependencies":[["rack-protection","1.4.0"],["tilt","1.3.4 || 2.0.0"],["rack","1.4.0"]]},
  {"name":"sinatra","number":"0.3.3","dependencies":[["rack","0.4.0 || 1.0.0"]]},
  {"name":"sinatra","number":"1.1.2","dependencies":[["rack","1.1.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.2.0","dependencies":[["mongrel","1.0.1"],["rack",null],["rack","=0.3.0"]]},
  {"name":"sinatra","number":"0.1.6","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"0.2.2","dependencies":[["mongrel","1.0.1"]]},
  {"name":"sinatra","number":"0.1.5","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"0.1.7","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"1.2.6","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.3.2","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"0.1.0","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"1.2.3","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.2","dependencies":[["rack",null],["shotgun",null],["rack-test",null]]},
  {"name":"sinatra","number":"1.2.0","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.1.3","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.2.7","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.6","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"0.2.1","dependencies":[["mongrel","1.0.1"]]},
  {"name":"sinatra","number":"0.3.0","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.1.4","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.5","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.3.0","dependencies":[["rack","1.3.0"],["rack-protection","1.1.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.3.1","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.2.1","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.6","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"0.9.4","dependencies":[["rack",null],["shotgun",null],["rack-test",null]]},
  {"name":"sinatra","number":"1.1.0","dependencies":[["rack","1.1.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.1","dependencies":[["rack",null],["rack",null]]},
  {"name":"sinatra","number":"0.9.0","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.2.2","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.0.0","dependencies":[["rack","1.0.0"]]},
  {"name":"sinatra","number":"1.2.8","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.1","dependencies":[["rack","1.3.0"],["rack-protection","1.1.0"],["tilt","1.3.0 || 2.0.0"],["rack","1.3.4"],["rack-protection","1.1.2"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.2","dependencies":[["rack","1.3.6"],["rack-protection","1.2.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.3","dependencies":[["rack","1.3.6"],["rack-protection","1.2.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.4","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.5","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sinatra","number":"1.2.9","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["backports",null]]},
  {"name":"sinatra","number":"1.4.1","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.0","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.2","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.3","dependencies":[["rack","1.4.0"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"six","number":"0.1.3","dependencies":[]},
  {"name":"six","number":"0.0.3","dependencies":[]},
  {"name":"six","number":"0.2.0","dependencies":[]},
  {"name":"six","number":"0.1.0","dependencies":[]},
  {"name":"six","number":"0.1.2","dependencies":[]},
  {"name":"six","number":"0.0.1","dependencies":[]},
  {"name":"six","number":"0.0.2","dependencies":[]},
  {"name":"six","number":"0.1.1","dependencies":[]},
  {"name":"slack-notifier","number":"0.3.0","dependencies":[]},
  {"name":"slack-notifier","number":"0.2.0","dependencies":[]},
  {"name":"slack-notifier","number":"0.1.1","dependencies":[["httparty","0.11.0"]]},
  {"name":"slack-notifier","number":"0.1.0","dependencies":[["httparty","0.11.0"]]},
  {"name":"slack-notifier","number":"0.0.1","dependencies":[["httparty","0.11.0"]]},
  {"name":"slack-notifier","number":"0.0.2","dependencies":[["httparty","0.11.0"]]},
  {"name":"slim","number":"2.0.2","dependencies":[["tilt","1.3.3 || 2.0.0"],["temple","0.6.6"]]},
  {"name":"slim","number":"0.4.0","dependencies":[]},
  {"name":"slim","number":"0.8.2","dependencies":[["temple","0.1.6"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.9.0","dependencies":[["temple","0.1.7"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.7.2","dependencies":[["temple","0.1.5"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"1.0.2","dependencies":[["temple","0.3.3"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"slim","number":"1.0.3","dependencies":[["temple","0.3.4"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"slim","number":"0.7.3","dependencies":[["temple","0.1.5"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"1.1.1","dependencies":[["temple","0.4.0"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"slim","number":"0.9.2","dependencies":[["temple","0.2.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.6.0","dependencies":[["escape-utils",null]]},
  {"name":"slim","number":"0.9.4","dependencies":[["temple","0.3.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.9.3","dependencies":[["temple","0.3.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.8.4","dependencies":[["temple","0.1.7"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.5.1","dependencies":[]},
  {"name":"slim","number":"1.0.4","dependencies":[["temple","0.3.4"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"slim","number":"0.2.0","dependencies":[]},
  {"name":"slim","number":"1.0.0","dependencies":[["temple","0.3.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"0.7.1","dependencies":[["temple","0.1.4"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.1.0","dependencies":[]},
  {"name":"slim","number":"0.7.4","dependencies":[["temple","0.1.6"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.8.1","dependencies":[["temple","0.1.6"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.7.0","dependencies":[["escape-utils",null],["temple","0.1.3"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.8.0","dependencies":[["temple","0.1.6"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.9.1","dependencies":[["temple","0.1.8"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"1.2.2","dependencies":[["temple","0.4.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.0","dependencies":[["temple","0.4.1"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"0.3.0","dependencies":[]},
  {"name":"slim","number":"1.0.1","dependencies":[["temple","0.3.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"slim","number":"1.3.2","dependencies":[["temple","0.5.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.3","dependencies":[["temple","0.5.5"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"0.8.3","dependencies":[["temple","0.1.6"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"slim","number":"0.3.1","dependencies":[]},
  {"name":"slim","number":"1.2.1","dependencies":[["temple","0.4.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"0.5.0","dependencies":[]},
  {"name":"slim","number":"1.2.0","dependencies":[["temple","0.4.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"0.4.1","dependencies":[]},
  {"name":"slim","number":"0.6.1","dependencies":[["escape-utils",null]]},
  {"name":"slim","number":"1.1.0","dependencies":[["temple","0.3.5"],["tilt","1.3.2 || 2.0.0"]]},
  {"name":"slim","number":"1.3.4","dependencies":[["temple","0.5.5"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.5","dependencies":[["temple","0.5.5"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.6","dependencies":[["temple","0.5.5"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.8","dependencies":[["temple","0.6.3"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"1.3.9","dependencies":[["temple","0.6.3"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"2.0.0","dependencies":[["temple","0.6.5"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slim","number":"2.0.1","dependencies":[["temple","0.6.6"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"slop","number":"3.5.0","dependencies":[]},
  {"name":"slop","number":"3.4.7","dependencies":[]},
  {"name":"slop","number":"1.5.5","dependencies":[]},
  {"name":"slop","number":"3.3.1","dependencies":[]},
  {"name":"slop","number":"3.0.3","dependencies":[]},
  {"name":"slop","number":"2.4.4","dependencies":[]},
  {"name":"slop","number":"1.7.0","dependencies":[]},
  {"name":"slop","number":"1.3.0","dependencies":[]},
  {"name":"slop","number":"1.2.0","dependencies":[]},
  {"name":"slop","number":"1.5.1","dependencies":[]},
  {"name":"slop","number":"2.3.1","dependencies":[]},
  {"name":"slop","number":"2.4.1","dependencies":[]},
  {"name":"slop","number":"1.6.1","dependencies":[]},
  {"name":"slop","number":"2.3.0","dependencies":[]},
  {"name":"slop","number":"1.4.1","dependencies":[]},
  {"name":"slop","number":"1.9.1","dependencies":[]},
  {"name":"slop","number":"3.0.2","dependencies":[]},
  {"name":"slop","number":"3.0.1","dependencies":[]},
  {"name":"slop","number":"3.0.0","dependencies":[]},
  {"name":"slop","number":"3.2.0","dependencies":[]},
  {"name":"slop","number":"1.4.0","dependencies":[]},
  {"name":"slop","number":"1.5.3","dependencies":[]},
  {"name":"slop","number":"0.1.9","dependencies":[]},
  {"name":"slop","number":"3.3.0","dependencies":[]},
  {"name":"slop","number":"3.0.4","dependencies":[]},
  {"name":"slop","number":"0.1.7","dependencies":[]},
  {"name":"slop","number":"2.1.0","dependencies":[]},
  {"name":"slop","number":"3.1.0","dependencies":[]},
  {"name":"slop","number":"2.2.0","dependencies":[]},
  {"name":"slop","number":"1.6.0","dependencies":[]},
  {"name":"slop","number":"1.9.0","dependencies":[]},
  {"name":"slop","number":"1.3.1","dependencies":[]},
  {"name":"slop","number":"1.0.0","dependencies":[]},
  {"name":"slop","number":"2.4.2","dependencies":[]},
  {"name":"slop","number":"1.8.0","dependencies":[]},
  {"name":"slop","number":"0.1.8","dependencies":[]},
  {"name":"slop","number":"1.2.1","dependencies":[]},
  {"name":"slop","number":"3.3.2","dependencies":[]},
  {"name":"slop","number":"3.3.3","dependencies":[]},
  {"name":"slop","number":"0.1.6","dependencies":[]},
  {"name":"slop","number":"2.4.3","dependencies":[]},
  {"name":"slop","number":"0.2.0","dependencies":[]},
  {"name":"slop","number":"0.1.4","dependencies":[]},
  {"name":"slop","number":"1.5.4","dependencies":[]},
  {"name":"slop","number":"1.1.0","dependencies":[]},
  {"name":"slop","number":"2.0.0","dependencies":[]},
  {"name":"slop","number":"1.5.0","dependencies":[]},
  {"name":"slop","number":"3.1.1","dependencies":[]},
  {"name":"slop","number":"2.4.0","dependencies":[]},
  {"name":"slop","number":"1.5.2","dependencies":[]},
  {"name":"slop","number":"0.1.5","dependencies":[]},
  {"name":"slop","number":"0.1.0","dependencies":[]},
  {"name":"slop","number":"3.4.0","dependencies":[]},
  {"name":"slop","number":"3.4.1","dependencies":[]},
  {"name":"slop","number":"3.4.2","dependencies":[]},
  {"name":"slop","number":"3.4.3","dependencies":[]},
  {"name":"slop","number":"3.4.4","dependencies":[]},
  {"name":"slop","number":"3.4.5","dependencies":[]},
  {"name":"slop","number":"3.4.6","dependencies":[]},
  {"name":"spinach","number":"0.8.7","dependencies":[["colorize","=0.5.8"],["gherkin-ruby",null]]},
  {"name":"spinach","number":"0.8.6","dependencies":[["colorize","=0.5.8"],["gherkin-ruby","0.3.0"]]},
  {"name":"spinach","number":"0.5.1","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.0.6","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["activesupport",null]]},
  {"name":"spinach","number":"0.3.3","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.3.0","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.4.0","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.1.2","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["hooks",null]]},
  {"name":"spinach","number":"0.4.2","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.3.1","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.1.1","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["hooks",null]]},
  {"name":"spinach","number":"0.1.3","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["hooks",null]]},
  {"name":"spinach","number":"0.0.1","dependencies":[["gherkin",null],["minitest",null]]},
  {"name":"spinach","number":"0.0.5","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["activesupport",null]]},
  {"name":"spinach","number":"0.0.4","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["activesupport",null]]},
  {"name":"spinach","number":"0.3.4","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.1.5","dependencies":[["gherkin",null],["colorize",null]]},
  {"name":"spinach","number":"0.1.0","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["hooks",null]]},
  {"name":"spinach","number":"0.1.4","dependencies":[["gherkin",null],["minitest",null],["colorize",null],["hooks",null]]},
  {"name":"spinach","number":"0.5.0","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.5.2","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.4.1","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.0.2","dependencies":[["gherkin",null],["minitest",null],["colorize",null]]},
  {"name":"spinach","number":"0.3.2","dependencies":[["gherkin-ruby","0.1.0"],["colorize",null]]},
  {"name":"spinach","number":"0.6.0","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.6.1","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.7.0","dependencies":[["gherkin-ruby","0.2.0"],["colorize",null]]},
  {"name":"spinach","number":"0.8.0","dependencies":[["gherkin-ruby","0.2.1"],["colorize","=0.5.8"]]},
  {"name":"spinach","number":"0.8.1","dependencies":[["gherkin-ruby","0.2.1"],["colorize","=0.5.8"]]},
  {"name":"spinach","number":"0.8.2","dependencies":[["gherkin-ruby","0.3.0"],["colorize","=0.5.8"]]},
  {"name":"spinach","number":"0.8.3","dependencies":[["gherkin-ruby","0.3.0"],["colorize","=0.5.8"]]},
  {"name":"spinach","number":"0.8.4","dependencies":[["gherkin-ruby","0.3.0"],["colorize","=0.5.8"]]},
  {"name":"spinach","number":"0.8.5","dependencies":[["gherkin-ruby","0.3.0"],["colorize","=0.5.8"]]},
  {"name":"spinach-rails","number":"0.0.7","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.5","dependencies":[["capybara",null],["spinach",null],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.1","dependencies":[["capybara",null],["spinach","0.1.0"],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.2","dependencies":[["capybara",null],["spinach","0.1.0"],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.1","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.6","dependencies":[["capybara",null],["spinach",null],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.0","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.6","dependencies":[["capybara","1.0.0 || 2.0.0"],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.8","dependencies":[["capybara","1.0.0 || 2.0.0"],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.3","dependencies":[["capybara",null],["spinach",null],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.9","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.2","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.5","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.4","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.8","dependencies":[["capybara",null],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.0.4","dependencies":[["capybara",null],["spinach",null],["rails","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.1.7","dependencies":[["capybara","1.0.0 || 2.0.0"],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.2.0","dependencies":[["capybara","2.0.0"],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spinach-rails","number":"0.2.1","dependencies":[["capybara","2.0.0"],["spinach",null],["railties","3.0.0 || 4.0.0"]]},
  {"name":"spork","number":"0.9.0","dependencies":[]},
  {"name":"spork","number":"0.6.2","dependencies":[]},
  {"name":"spork","number":"0.8.0","dependencies":[]},
  {"name":"spork","number":"0.5.6","dependencies":[]},
  {"name":"spork","number":"0.5.8","dependencies":[]},
  {"name":"spork","number":"0.7.7","dependencies":[]},
  {"name":"spork","number":"0.5.10","dependencies":[]},
  {"name":"spork","number":"0.5.9","dependencies":[]},
  {"name":"spork","number":"0.5.7","dependencies":[]},
  {"name":"spork","number":"0.5.5","dependencies":[]},
  {"name":"spork","number":"0.7.4","dependencies":[]},
  {"name":"spork","number":"0.7.8","dependencies":[]},
  {"name":"spork","number":"0.4.0","dependencies":[]},
  {"name":"spork","number":"0.8.4","dependencies":[]},
  {"name":"spork","number":"0.8.1","dependencies":[]},
  {"name":"spork","number":"0.8.3","dependencies":[]},
  {"name":"spork","number":"0.4.2","dependencies":[]},
  {"name":"spork","number":"0.7.5","dependencies":[]},
  {"name":"spork","number":"0.6.1","dependencies":[]},
  {"name":"spork","number":"0.6.0","dependencies":[]},
  {"name":"spork","number":"0.7.2","dependencies":[]},
  {"name":"spork","number":"0.4.4","dependencies":[]},
  {"name":"spork","number":"0.7.0","dependencies":[]},
  {"name":"spork","number":"0.5.3","dependencies":[]},
  {"name":"spork","number":"0.9.2","dependencies":[]},
  {"name":"spork","number":"0.8.5","dependencies":[]},
  {"name":"spork","number":"0.7.6","dependencies":[]},
  {"name":"spork","number":"0.5.2","dependencies":[]},
  {"name":"spork","number":"0.5.11","dependencies":[]},
  {"name":"spork","number":"0.5.1","dependencies":[]},
  {"name":"spork","number":"0.7.1","dependencies":[]},
  {"name":"spork","number":"0.7.3","dependencies":[]},
  {"name":"spork","number":"0.9.1","dependencies":[]},
  {"name":"spork","number":"0.8.2","dependencies":[]},
  {"name":"spork","number":"0.5.4","dependencies":[]},
  {"name":"spork","number":"0.6.3","dependencies":[]},
  {"name":"spork","number":"0.4.1","dependencies":[]},
  {"name":"spring","number":"1.1.2","dependencies":[]},
  {"name":"spring","number":"1.1.1","dependencies":[]},
  {"name":"spring","number":"1.1.0","dependencies":[]},
  {"name":"spring","number":"1.0.0","dependencies":[]},
  {"name":"spring","number":"0.9.2","dependencies":[]},
  {"name":"spring","number":"0.9.1","dependencies":[]},
  {"name":"spring","number":"0.9.0","dependencies":[]},
  {"name":"spring","number":"0.0.11","dependencies":[]},
  {"name":"spring","number":"0.0.1","dependencies":[["activesupport",null]]},
  {"name":"spring","number":"0.0.2","dependencies":[["activesupport",null]]},
  {"name":"spring","number":"0.0.3","dependencies":[["activesupport",null]]},
  {"name":"spring","number":"0.0.4","dependencies":[["activesupport",null]]},
  {"name":"spring","number":"0.0.5","dependencies":[]},
  {"name":"spring","number":"0.0.6","dependencies":[]},
  {"name":"spring","number":"0.0.7","dependencies":[]},
  {"name":"spring","number":"0.0.8","dependencies":[]},
  {"name":"spring","number":"0.0.9","dependencies":[]},
  {"name":"spring","number":"0.0.10","dependencies":[]},
  {"name":"spring-commands-rspec","number":"1.0.1","dependencies":[["spring",null]]},
  {"name":"spring-commands-rspec","number":"1.0.0","dependencies":[]},
  {"name":"spring-commands-spinach","number":"1.0.0","dependencies":[["spring",null]]},
  {"name":"sprockets","number":"2.12.0","dependencies":[["tilt","1.1.0 || 2.0.0"],["rack","1.0.0"],["multi-json","1.0.0"],["hike","1.2.0"]]},
  {"name":"sprockets","number":"2.11.0","dependencies":[["tilt","1.1.0 || 2.0.0"],["rack","1.0.0"],["multi-json","1.0.0"],["hike","1.2.0"]]},
  {"name":"sprockets","number":"2.10.1","dependencies":[["tilt","1.1.0 || 2.0.0"],["rack","1.0.0"],["multi-json","1.0.0"],["hike","1.2.0"]]},
  {"name":"sprockets","number":"2.3.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.1.2","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.3","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.1.0","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.3.1","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"0.9.1","dependencies":[]},
  {"name":"sprockets","number":"1.0.1","dependencies":[]},
  {"name":"sprockets","number":"1.0.0","dependencies":[]},
  {"name":"sprockets","number":"0.9.0","dependencies":[]},
  {"name":"sprockets","number":"2.0.4","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.2.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"1.0.2","dependencies":[]},
  {"name":"sprockets","number":"2.8.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.0.1","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.1.3","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.7.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.1.1","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.0.0","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.0.3","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.1","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.0.2","dependencies":[["hike","1.2.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.2.1","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.3.2","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.5.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.5","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.4","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.4.2","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.6.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.8.1","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.2.2","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.8.2","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.9.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.9.2","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.9.3","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets","number":"2.10.0","dependencies":[["hike","1.2.0"],["multi-json","1.0.0"],["rack","1.0.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sprockets-rails","number":"2.0.1","dependencies":[["activesupport","3.0.0 || 4.0.0"],["actionpack","4.0.0"],["sprockets","2.8.0"]]},
  {"name":"sprockets-rails","number":"0.0.0","dependencies":[]},
  {"name":"sprockets-rails","number":"0.0.1","dependencies":[["sprockets","1.0.2 || 2.0.0"]]},
  {"name":"sprockets-rails","number":"1.0.0","dependencies":[["sprockets","2.3.1"],["railties","4.0.0"]]},
  {"name":"sprockets-rails","number":"2.0.0","dependencies":[["sprockets","2.8.0"],["actionpack","4.0.0"],["activesupport","4.0.0"]]},
  {"name":"stamp","number":"0.1.0","dependencies":[]},
  {"name":"stamp","number":"0.0.2","dependencies":[]},
  {"name":"stamp","number":"0.1.6","dependencies":[]},
  {"name":"stamp","number":"0.0.1","dependencies":[]},
  {"name":"stamp","number":"0.1.1","dependencies":[]},
  {"name":"stamp","number":"0.0.3","dependencies":[]},
  {"name":"stamp","number":"0.1.2","dependencies":[]},
  {"name":"stamp","number":"0.1.3","dependencies":[]},
  {"name":"stamp","number":"0.1.4","dependencies":[]},
  {"name":"stamp","number":"0.1.5","dependencies":[]},
  {"name":"stamp","number":"0.2.0","dependencies":[]},
  {"name":"stamp","number":"0.3.0","dependencies":[]},
  {"name":"stamp","number":"0.4.0","dependencies":[]},
  {"name":"stamp","number":"0.5.0","dependencies":[]},
  {"name":"state-machine","number":"1.0.2","dependencies":[]},
  {"name":"state-machine","number":"1.1.0","dependencies":[]},
  {"name":"state-machine","number":"0.4.3","dependencies":[]},
  {"name":"state-machine","number":"0.7.3","dependencies":[]},
  {"name":"state-machine","number":"0.1.0","dependencies":[]},
  {"name":"state-machine","number":"0.8.0","dependencies":[]},
  {"name":"state-machine","number":"0.6.3","dependencies":[]},
  {"name":"state-machine","number":"0.8.1","dependencies":[]},
  {"name":"state-machine","number":"0.7.4","dependencies":[]},
  {"name":"state-machine","number":"0.7.5","dependencies":[]},
  {"name":"state-machine","number":"0.1.1","dependencies":[]},
  {"name":"state-machine","number":"0.2.1","dependencies":[]},
  {"name":"state-machine","number":"0.4.1","dependencies":[]},
  {"name":"state-machine","number":"0.4.2","dependencies":[]},
  {"name":"state-machine","number":"0.5.1","dependencies":[]},
  {"name":"state-machine","number":"0.5.0","dependencies":[]},
  {"name":"state-machine","number":"0.4.0","dependencies":[]},
  {"name":"state-machine","number":"0.2.0","dependencies":[]},
  {"name":"state-machine","number":"0.7.0","dependencies":[]},
  {"name":"state-machine","number":"0.9.3","dependencies":[]},
  {"name":"state-machine","number":"0.3.1","dependencies":[]},
  {"name":"state-machine","number":"0.5.2","dependencies":[]},
  {"name":"state-machine","number":"0.10.0","dependencies":[]},
  {"name":"state-machine","number":"0.9.4","dependencies":[]},
  {"name":"state-machine","number":"0.10.3","dependencies":[]},
  {"name":"state-machine","number":"0.10.4","dependencies":[]},
  {"name":"state-machine","number":"1.0.3","dependencies":[]},
  {"name":"state-machine","number":"1.0.0","dependencies":[]},
  {"name":"state-machine","number":"1.0.1","dependencies":[]},
  {"name":"state-machine","number":"0.10.1","dependencies":[]},
  {"name":"state-machine","number":"0.6.2","dependencies":[]},
  {"name":"state-machine","number":"0.7.2","dependencies":[]},
  {"name":"state-machine","number":"0.3.0","dependencies":[]},
  {"name":"state-machine","number":"0.7.6","dependencies":[]},
  {"name":"state-machine","number":"0.7.1","dependencies":[]},
  {"name":"state-machine","number":"0.9.0","dependencies":[]},
  {"name":"state-machine","number":"0.9.1","dependencies":[]},
  {"name":"state-machine","number":"0.9.2","dependencies":[]},
  {"name":"state-machine","number":"0.6.1","dependencies":[]},
  {"name":"state-machine","number":"0.6.0","dependencies":[]},
  {"name":"state-machine","number":"0.10.2","dependencies":[]},
  {"name":"state-machine","number":"1.1.1","dependencies":[]},
  {"name":"state-machine","number":"1.1.2","dependencies":[]},
  {"name":"state-machine","number":"1.2.0","dependencies":[]},
  {"name":"stringex","number":"2.4.2","dependencies":[]},
  {"name":"stringex","number":"2.4.1","dependencies":[]},
  {"name":"stringex","number":"2.3.0","dependencies":[]},
  {"name":"stringex","number":"2.2.2","dependencies":[]},
  {"name":"stringex","number":"2.2.1","dependencies":[]},
  {"name":"stringex","number":"2.2.0","dependencies":[]},
  {"name":"stringex","number":"2.1.2","dependencies":[]},
  {"name":"stringex","number":"2.1.1","dependencies":[]},
  {"name":"stringex","number":"2.1.0","dependencies":[]},
  {"name":"stringex","number":"1.3.2","dependencies":[]},
  {"name":"stringex","number":"1.3.3","dependencies":[]},
  {"name":"stringex","number":"1.4.0","dependencies":[]},
  {"name":"stringex","number":"1.1.0","dependencies":[]},
  {"name":"stringex","number":"1.0.3","dependencies":[]},
  {"name":"stringex","number":"1.0.0","dependencies":[]},
  {"name":"stringex","number":"1.0.1","dependencies":[]},
  {"name":"stringex","number":"1.0.2","dependencies":[]},
  {"name":"stringex","number":"1.3.1","dependencies":[]},
  {"name":"stringex","number":"1.2.0","dependencies":[]},
  {"name":"stringex","number":"1.2.1","dependencies":[]},
  {"name":"stringex","number":"1.2.2","dependencies":[]},
  {"name":"stringex","number":"1.3.0","dependencies":[]},
  {"name":"stringex","number":"1.5.0","dependencies":[["stringex",null]]},
  {"name":"stringex","number":"1.5.1","dependencies":[]},
  {"name":"stringex","number":"2.0.0","dependencies":[]},
  {"name":"stringex","number":"2.0.1","dependencies":[]},
  {"name":"stringex","number":"2.0.2","dependencies":[]},
  {"name":"stringex","number":"2.0.3","dependencies":[]},
  {"name":"stringex","number":"2.0.4","dependencies":[]},
  {"name":"stringex","number":"2.0.5","dependencies":[]},
  {"name":"stringex","number":"2.0.6","dependencies":[]},
  {"name":"stringex","number":"2.0.7","dependencies":[]},
  {"name":"stringex","number":"2.0.8","dependencies":[]},
  {"name":"stringex","number":"2.0.9","dependencies":[]},
  {"name":"stringex","number":"2.0.10","dependencies":[]},
  {"name":"stringex","number":"2.0.11","dependencies":[]},
  {"name":"temple","number":"0.6.7","dependencies":[]},
  {"name":"temple","number":"0.1.6","dependencies":[]},
  {"name":"temple","number":"0.4.1","dependencies":[]},
  {"name":"temple","number":"0.1.0","dependencies":[]},
  {"name":"temple","number":"0.0.1","dependencies":[]},
  {"name":"temple","number":"0.3.1","dependencies":[]},
  {"name":"temple","number":"0.5.5","dependencies":[]},
  {"name":"temple","number":"0.4.0","dependencies":[]},
  {"name":"temple","number":"0.3.5","dependencies":[]},
  {"name":"temple","number":"0.3.2","dependencies":[]},
  {"name":"temple","number":"0.1.4","dependencies":[]},
  {"name":"temple","number":"0.1.7","dependencies":[]},
  {"name":"temple","number":"0.1.3","dependencies":[]},
  {"name":"temple","number":"0.2.0","dependencies":[]},
  {"name":"temple","number":"0.1.1","dependencies":[]},
  {"name":"temple","number":"0.1.8","dependencies":[]},
  {"name":"temple","number":"0.1.2","dependencies":[]},
  {"name":"temple","number":"0.1.5","dependencies":[]},
  {"name":"temple","number":"0.3.0","dependencies":[]},
  {"name":"temple","number":"0.5.4","dependencies":[]},
  {"name":"temple","number":"0.3.4","dependencies":[]},
  {"name":"temple","number":"0.6.0","dependencies":[]},
  {"name":"temple","number":"0.6.3","dependencies":[]},
  {"name":"temple","number":"0.6.4","dependencies":[]},
  {"name":"temple","number":"0.6.5","dependencies":[]},
  {"name":"temple","number":"0.6.6","dependencies":[]},
  {"name":"term-ansicolor","number":"1.3.0","dependencies":[["tins","1.0.0"]]},
  {"name":"term-ansicolor","number":"1.0.5","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.3","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.4","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.0","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.1","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.7","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.2","dependencies":[]},
  {"name":"term-ansicolor","number":"0.0.4","dependencies":[]},
  {"name":"term-ansicolor","number":"1.0.6","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.0","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.1","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.2","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.3","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.4","dependencies":[]},
  {"name":"term-ansicolor","number":"1.1.5","dependencies":[]},
  {"name":"term-ansicolor","number":"1.2.0","dependencies":[["tins","0.8.0 || 1.0.0"]]},
  {"name":"term-ansicolor","number":"1.2.1","dependencies":[["tins","0.8.0 || 1.0.0"]]},
  {"name":"term-ansicolor","number":"1.2.2","dependencies":[["tins","0.8.0 || 1.0.0"]]},
  {"name":"test-after-commit","number":"0.2.3","dependencies":[]},
  {"name":"test-after-commit","number":"0.2.2","dependencies":[]},
  {"name":"test-after-commit","number":"0.0.1","dependencies":[]},
  {"name":"test-after-commit","number":"0.1.0","dependencies":[]},
  {"name":"test-after-commit","number":"0.1.1","dependencies":[]},
  {"name":"test-after-commit","number":"0.2.0","dependencies":[]},
  {"name":"test-after-commit","number":"0.2.1","dependencies":[]},
  {"name":"therubyracer","number":"0.12.1","dependencies":[["libv8","3.16.14"],["ref",null]]},
  {"name":"therubyracer","number":"0.6.0","dependencies":[]},
  {"name":"therubyracer","number":"0.7.0","dependencies":[]},
  {"name":"therubyracer","number":"0.4.3","dependencies":[]},
  {"name":"therubyracer","number":"0.4.0","dependencies":[]},
  {"name":"therubyracer","number":"0.8.1","dependencies":[]},
  {"name":"therubyracer","number":"0.5.0","dependencies":[]},
  {"name":"therubyracer","number":"0.6.2","dependencies":[]},
  {"name":"therubyracer","number":"0.6.1","dependencies":[]},
  {"name":"therubyracer","number":"0.10.0","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.7.5","dependencies":[]},
  {"name":"therubyracer","number":"0.4.8","dependencies":[]},
  {"name":"therubyracer","number":"0.5.5","dependencies":[]},
  {"name":"therubyracer","number":"0.9.10","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.9.2","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.7.1","dependencies":[]},
  {"name":"therubyracer","number":"0.4.4","dependencies":[]},
  {"name":"therubyracer","number":"0.4.5","dependencies":[]},
  {"name":"therubyracer","number":"0.4.7","dependencies":[]},
  {"name":"therubyracer","number":"0.8.0","dependencies":[]},
  {"name":"therubyracer","number":"0.9.3","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.4.6","dependencies":[]},
  {"name":"therubyracer","number":"0.4.2","dependencies":[]},
  {"name":"therubyracer","number":"0.9.9","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.5.2","dependencies":[]},
  {"name":"therubyracer","number":"0.9.8","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.4.9","dependencies":[]},
  {"name":"therubyracer","number":"0.5.3","dependencies":[]},
  {"name":"therubyracer","number":"0.7.4","dependencies":[]},
  {"name":"therubyracer","number":"0.10.1","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.9.5","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.5.1","dependencies":[]},
  {"name":"therubyracer","number":"0.9.4","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.4.1","dependencies":[]},
  {"name":"therubyracer","number":"0.6.3","dependencies":[]},
  {"name":"therubyracer","number":"0.8.2","dependencies":[]},
  {"name":"therubyracer","number":"0.5.4","dependencies":[]},
  {"name":"therubyracer","number":"0.7.2","dependencies":[]},
  {"name":"therubyracer","number":"0.9.6","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.10.2","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.9.0","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.9.1","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.7.3","dependencies":[]},
  {"name":"therubyracer","number":"0.9.7","dependencies":[["libv8","3.3.10"]]},
  {"name":"therubyracer","number":"0.11.0","dependencies":[["ref",null]]},
  {"name":"therubyracer","number":"0.11.1","dependencies":[["ref",null],["libv8","3.11.8"]]},
  {"name":"therubyracer","number":"0.11.2","dependencies":[["ref",null],["libv8","3.11.8"]]},
  {"name":"therubyracer","number":"0.11.3","dependencies":[["ref",null],["libv8","3.11.8"]]},
  {"name":"therubyracer","number":"0.11.4","dependencies":[["ref",null],["libv8","3.11.8"]]},
  {"name":"therubyracer","number":"0.12.0","dependencies":[["ref",null],["libv8","3.16.14"]]},
  {"name":"thin","number":"1.6.2","dependencies":[["daemons","1.0.9"],["eventmachine","1.0.0"],["rack","1.0.0"]]},
  {"name":"thin","number":"1.6.1","dependencies":[["daemons","1.0.9"],["eventmachine","1.0.0"],["rack","1.0.0"]]},
  {"name":"thin","number":"1.6.0","dependencies":[["daemons","1.0.9"],["eventmachine","1.0.0"],["rack","1.5.0"]]},
  {"name":"thin","number":"0.8.2","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.6","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.6.4","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.9","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.4.0","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.3.1","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.6.3","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.3.0","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.11","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.5.2","dependencies":[["eventmachine",null],["rack",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.7.0","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.6.2","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.7","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.4","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.5","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.5.0","dependencies":[["eventmachine",null],["rack",null]]},
  {"name":"thin","number":"0.4.0","dependencies":[]},
  {"name":"thin","number":"1.2.1","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.10","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.0.0","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.5.4","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.8.0","dependencies":[["rack",null],["daemons","1.0.9"],["eventmachine",null]]},
  {"name":"thin","number":"0.3.0","dependencies":[]},
  {"name":"thin","number":"0.8.1","dependencies":[["rack",null],["daemons","1.0.9"],["eventmachine",null]]},
  {"name":"thin","number":"0.4.1","dependencies":[]},
  {"name":"thin","number":"0.5.3","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.3","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.7.1","dependencies":[["rack",null],["daemons","1.0.9"],["eventmachine",null]]},
  {"name":"thin","number":"1.2.2","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.5.0","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.2.8","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.4.1","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.6.1","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"0.6.0","dependencies":[["rack",null],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thin","number":"1.5.1","dependencies":[["rack","1.0.0"],["eventmachine",null],["daemons","1.0.9"]]},
  {"name":"thor","number":"0.19.1","dependencies":[]},
  {"name":"thor","number":"0.19.0","dependencies":[]},
  {"name":"thor","number":"0.14.3","dependencies":[]},
  {"name":"thor","number":"0.13.0","dependencies":[]},
  {"name":"thor","number":"0.15.1","dependencies":[]},
  {"name":"thor","number":"0.11.7","dependencies":[]},
  {"name":"thor","number":"0.11.6","dependencies":[]},
  {"name":"thor","number":"0.15.0","dependencies":[]},
  {"name":"thor","number":"0.9.2","dependencies":[]},
  {"name":"thor","number":"0.9.5","dependencies":[]},
  {"name":"thor","number":"0.13.6","dependencies":[]},
  {"name":"thor","number":"0.13.4","dependencies":[]},
  {"name":"thor","number":"0.14.0","dependencies":[]},
  {"name":"thor","number":"0.12.0","dependencies":[]},
  {"name":"thor","number":"0.14.5","dependencies":[]},
  {"name":"thor","number":"0.14.1","dependencies":[]},
  {"name":"thor","number":"0.12.3","dependencies":[]},
  {"name":"thor","number":"0.14.6","dependencies":[]},
  {"name":"thor","number":"0.13.7","dependencies":[]},
  {"name":"thor","number":"0.11.5","dependencies":[]},
  {"name":"thor","number":"0.13.5","dependencies":[]},
  {"name":"thor","number":"0.14.2","dependencies":[]},
  {"name":"thor","number":"0.9.7","dependencies":[]},
  {"name":"thor","number":"0.9.6","dependencies":[]},
  {"name":"thor","number":"0.9.8","dependencies":[]},
  {"name":"thor","number":"0.15.2","dependencies":[]},
  {"name":"thor","number":"0.13.3","dependencies":[]},
  {"name":"thor","number":"0.14.4","dependencies":[]},
  {"name":"thor","number":"0.15.4","dependencies":[]},
  {"name":"thor","number":"0.16.0","dependencies":[]},
  {"name":"thor","number":"0.11.8","dependencies":[]},
  {"name":"thor","number":"0.12.2","dependencies":[]},
  {"name":"thor","number":"0.13.1","dependencies":[]},
  {"name":"thor","number":"0.15.3","dependencies":[]},
  {"name":"thor","number":"0.13.2","dependencies":[]},
  {"name":"thor","number":"0.9.9","dependencies":[]},
  {"name":"thor","number":"0.13.8","dependencies":[]},
  {"name":"thor","number":"0.17.0","dependencies":[]},
  {"name":"thor","number":"0.18.0","dependencies":[]},
  {"name":"thor","number":"0.18.1","dependencies":[]},
  {"name":"thread-safe","number":"0.3.1","dependencies":[["atomic","1.1.7"]]},
  {"name":"thread-safe","number":"0.2.0","dependencies":[["atomic","1.1.7"]]},
  {"name":"thread-safe","number":"0.0.1","dependencies":[]},
  {"name":"thread-safe","number":"0.0.2","dependencies":[]},
  {"name":"thread-safe","number":"0.0.3","dependencies":[]},
  {"name":"thread-safe","number":"0.1.3","dependencies":[["atomic",null]]},
  {"name":"thread-safe","number":"0.1.0","dependencies":[["atomic",null]]},
  {"name":"thread-safe","number":"0.1.1","dependencies":[["atomic",null]]},
  {"name":"thread-safe","number":"0.1.2","dependencies":[["atomic",null]]},
  {"name":"tilt","number":"2.0.1","dependencies":[]},
  {"name":"tilt","number":"2.0.0","dependencies":[]},
  {"name":"tilt","number":"1.3.2","dependencies":[]},
  {"name":"tilt","number":"1.3.1","dependencies":[]},
  {"name":"tilt","number":"0.8.0","dependencies":[]},
  {"name":"tilt","number":"1.2.1","dependencies":[]},
  {"name":"tilt","number":"1.0.1","dependencies":[]},
  {"name":"tilt","number":"0.9.0","dependencies":[]},
  {"name":"tilt","number":"0.2.0","dependencies":[]},
  {"name":"tilt","number":"1.1.0","dependencies":[]},
  {"name":"tilt","number":"0.3.0","dependencies":[]},
  {"name":"tilt","number":"0.5.0","dependencies":[]},
  {"name":"tilt","number":"1.0.0","dependencies":[]},
  {"name":"tilt","number":"0.4.0","dependencies":[]},
  {"name":"tilt","number":"1.2.0","dependencies":[]},
  {"name":"tilt","number":"0.10.0","dependencies":[]},
  {"name":"tilt","number":"0.7.0","dependencies":[]},
  {"name":"tilt","number":"0.6.0","dependencies":[]},
  {"name":"tilt","number":"1.3.0","dependencies":[]},
  {"name":"tilt","number":"1.3.3","dependencies":[]},
  {"name":"tilt","number":"1.2.2","dependencies":[]},
  {"name":"tilt","number":"1.3.4","dependencies":[]},
  {"name":"tilt","number":"1.3.5","dependencies":[]},
  {"name":"tilt","number":"1.3.6","dependencies":[]},
  {"name":"tilt","number":"1.3.7","dependencies":[]},
  {"name":"tilt","number":"1.4.0","dependencies":[]},
  {"name":"tilt","number":"1.4.1","dependencies":[]},
  {"name":"timers","number":"2.0.0","dependencies":[["hitimes",null]]},
  {"name":"timers","number":"1.0.0","dependencies":[]},
  {"name":"timers","number":"1.0.1","dependencies":[]},
  {"name":"timers","number":"0.0.0","dependencies":[]},
  {"name":"timers","number":"1.0.2","dependencies":[]},
  {"name":"timers","number":"1.1.0","dependencies":[]},
  {"name":"tinder","number":"1.9.4","dependencies":[["twitter-stream","0.1.0"],["multi-json","1.7.0"],["mime-types","1.19.0 || 2.0.0"],["json","1.8.0"],["hashie","1.0.0 || 2.0.0"],["faraday-middleware","0.9.0"],["faraday","0.8.9"],["eventmachine","1.0.0"]]},
  {"name":"tinder","number":"1.4.0","dependencies":[["activesupport",null],["httparty",null],["mime-types",null],["twitter-stream",null],["eventmachine",null]]},
  {"name":"tinder","number":"0.1.3","dependencies":[["activesupport","0.0.0 || 1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["hpricot","0.0.0 || 1.0.0"],["hoe","1.1.7 || 2.0.0"]]},
  {"name":"tinder","number":"1.2.2","dependencies":[["activesupport",null],["hpricot",null],["mime-types",null]]},
  {"name":"tinder","number":"1.2.0","dependencies":[["activesupport",null],["hpricot",null],["mime-types",null],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"tinder","number":"1.5.0","dependencies":[["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["eventmachine","0.12.0 || 1.0.0"],["faraday",null],["faraday-middleware",null],["hashie","1.0.0 || 2.0.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["faraday",null],["faraday-middleware",null]]},
  {"name":"tinder","number":"0.1.0","dependencies":[["activesupport","0.0.0 || 1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["hpricot","0.0.0 || 1.0.0"],["hoe","1.1.7 || 2.0.0"]]},
  {"name":"tinder","number":"1.3.0","dependencies":[["activesupport",null],["mime-types",null]]},
  {"name":"tinder","number":"0.1.9","dependencies":[["activesupport",null],["hpricot",null],["mime-types",null],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"tinder","number":"1.4.1","dependencies":[["activesupport",null],["httparty",null],["mime-types",null],["twitter-stream",null],["eventmachine",null]]},
  {"name":"tinder","number":"0.1.6","dependencies":[["activesupport",null],["hpricot",null],["hoe","1.5.1 || 2.0.0"]]},
  {"name":"tinder","number":"0.1.4","dependencies":[["activesupport","0.0.0 || 1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["hpricot","0.0.0 || 1.0.0"],["hoe","1.2.1 || 2.0.0"]]},
  {"name":"tinder","number":"1.4.3","dependencies":[["activesupport",null],["faraday","0.5.1"],["multipart-post",null],["mime-types",null],["twitter-stream",null],["eventmachine",null]]},
  {"name":"tinder","number":"1.6.0","dependencies":[["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["eventmachine","0.12.0 || 1.0.0"],["faraday",null],["faraday-middleware",null],["hashie","1.0.0 || 2.0.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["faraday",null],["faraday-middleware",null]]},
  {"name":"tinder","number":"1.1.7","dependencies":[["activesupport",null],["hpricot",null],["hoe","1.7.0 || 2.0.0"]]},
  {"name":"tinder","number":"1.2.1","dependencies":[["activesupport",null],["hpricot",null],["mime-types",null]]},
  {"name":"tinder","number":"0.1.2","dependencies":[["activesupport","0.0.0 || 1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["hpricot","0.0.0 || 1.0.0"],["hoe","1.1.7 || 2.0.0"]]},
  {"name":"tinder","number":"1.3.1","dependencies":[["activesupport",null],["httparty",null],["mime-types",null]]},
  {"name":"tinder","number":"0.1.8","dependencies":[["activesupport",null],["hpricot",null],["mime-types",null],["hoe","1.8.2 || 2.0.0"]]},
  {"name":"tinder","number":"1.4.4","dependencies":[["activesupport",null],["faraday","0.5.1"],["multipart-post",null],["mime-types",null],["twitter-stream",null],["eventmachine",null]]},
  {"name":"tinder","number":"1.8.0","dependencies":[["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["eventmachine","0.12.0 || 1.0.0"],["faraday",null],["faraday-middleware",null],["hashie","1.0.0 || 2.0.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["faraday",null],["faraday-middleware",null]]},
  {"name":"tinder","number":"1.9.0","dependencies":[["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["eventmachine",null],["faraday","0.8.0"],["faraday-middleware","0.8.0"],["hashie","1.0.0 || 2.0.0"],["json","1.6.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"]]},
  {"name":"tinder","number":"1.9.1","dependencies":[["eventmachine",null],["faraday","0.8.0"],["faraday-middleware","0.8.0"],["hashie","1.0.0 || 2.0.0"],["json","1.6.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"]]},
  {"name":"tinder","number":"1.7.0","dependencies":[["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["eventmachine","0.12.0 || 1.0.0"],["faraday",null],["faraday-middleware",null],["hashie","1.0.0 || 2.0.0"],["mime-types","1.16.0 || 2.0.0"],["multi-json","1.0.0"],["multipart-post","1.1.0 || 2.0.0"],["twitter-stream","0.1.0"],["activesupport","2.3.0 || 3.0.0 || 4.0.0"],["faraday",null],["faraday-middleware",null]]},
  {"name":"tinder","number":"0.1.1","dependencies":[["activesupport","0.0.0 || 1.0.0 || 2.0.0 || 3.0.0 || 4.0.0"],["hpricot","0.0.0 || 1.0.0"],["hoe","1.1.7 || 2.0.0"]]},
  {"name":"tinder","number":"1.4.2","dependencies":[["activesupport",null],["faraday","0.5.1"],["multipart-post",null],["mime-types",null],["twitter-stream",null],["eventmachine",null]]},
  {"name":"tinder","number":"0.1.5","dependencies":[["activesupport",null],["hpricot",null],["hoe","1.4.0 || 2.0.0"]]},
  {"name":"tinder","number":"1.9.2","dependencies":[["eventmachine","1.0.0"],["faraday","0.8.0"],["faraday-middleware","0.9.0"],["hashie","1.0.0 || 2.0.0"],["json","1.7.5"],["mime-types","1.19.0 || 2.0.0"],["multi-json","1.5.0"],["twitter-stream","0.1.0"]]},
  {"name":"tinder","number":"1.9.3","dependencies":[["eventmachine","1.0.0"],["faraday","0.8.0"],["faraday-middleware","0.9.0"],["hashie","1.0.0 || 2.0.0"],["json","1.8.0"],["mime-types","1.19.0 || 2.0.0"],["multi-json","1.7.0"],["twitter-stream","0.1.0"]]},
  {"name":"tins","number":"1.0.1","dependencies":[]},
  {"name":"tins","number":"1.0.0","dependencies":[]},
  {"name":"tins","number":"0.13.2","dependencies":[]},
  {"name":"tins","number":"0.13.1","dependencies":[]},
  {"name":"tins","number":"0.13.0","dependencies":[]},
  {"name":"tins","number":"0.12.0","dependencies":[]},
  {"name":"tins","number":"0.11.0","dependencies":[]},
  {"name":"tins","number":"0.10.0","dependencies":[]},
  {"name":"tins","number":"0.3.6","dependencies":[]},
  {"name":"tins","number":"0.4.0","dependencies":[]},
  {"name":"tins","number":"0.3.4","dependencies":[]},
  {"name":"tins","number":"0.4.3","dependencies":[]},
  {"name":"tins","number":"0.5.4","dependencies":[]},
  {"name":"tins","number":"0.5.0","dependencies":[]},
  {"name":"tins","number":"0.3.10","dependencies":[]},
  {"name":"tins","number":"0.3.14","dependencies":[]},
  {"name":"tins","number":"0.3.3","dependencies":[]},
  {"name":"tins","number":"0.3.2","dependencies":[]},
  {"name":"tins","number":"0.3.0","dependencies":[]},
  {"name":"tins","number":"0.5.6","dependencies":[]},
  {"name":"tins","number":"0.3.5","dependencies":[]},
  {"name":"tins","number":"0.3.13","dependencies":[]},
  {"name":"tins","number":"0.3.8","dependencies":[]},
  {"name":"tins","number":"0.3.9","dependencies":[]},
  {"name":"tins","number":"0.4.2","dependencies":[]},
  {"name":"tins","number":"0.3.1","dependencies":[]},
  {"name":"tins","number":"0.4.1","dependencies":[]},
  {"name":"tins","number":"0.3.7","dependencies":[]},
  {"name":"tins","number":"0.5.1","dependencies":[]},
  {"name":"tins","number":"0.5.3","dependencies":[]},
  {"name":"tins","number":"0.5.5","dependencies":[]},
  {"name":"tins","number":"0.6.0","dependencies":[]},
  {"name":"tins","number":"0.5.2","dependencies":[]},
  {"name":"tins","number":"0.3.12","dependencies":[]},
  {"name":"tins","number":"0.3.11","dependencies":[]},
  {"name":"tins","number":"0.7.0","dependencies":[]},
  {"name":"tins","number":"0.7.1","dependencies":[]},
  {"name":"tins","number":"0.7.2","dependencies":[]},
  {"name":"tins","number":"0.7.4","dependencies":[]},
  {"name":"tins","number":"0.7.3","dependencies":[]},
  {"name":"tins","number":"0.8.0","dependencies":[]},
  {"name":"tins","number":"0.8.2","dependencies":[]},
  {"name":"tins","number":"0.8.3","dependencies":[]},
  {"name":"tins","number":"0.8.4","dependencies":[]},
  {"name":"tins","number":"0.9.0","dependencies":[]},
  {"name":"treetop","number":"1.5.3","dependencies":[["polyglot","0.3.0"]]},
  {"name":"treetop","number":"1.5.1","dependencies":[["polyglot","0.3.0"]]},
  {"name":"treetop","number":"1.1.2","dependencies":[["facets","2.0.2"]]},
  {"name":"treetop","number":"1.4.7","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.2.5","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.5","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.3","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.8","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"0.1.0","dependencies":[]},
  {"name":"treetop","number":"1.4.2","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.1.4","dependencies":[["facets","2.0.2"]]},
  {"name":"treetop","number":"1.4.1","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.2.6","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.2.0","dependencies":[["facets","2.0.2"],["polyglot","0.0.0"]]},
  {"name":"treetop","number":"1.2.1","dependencies":[["facets","2.0.2"],["polyglot","0.0.0"]]},
  {"name":"treetop","number":"1.2.2","dependencies":[["facets","=2.0.2"],["polyglot","0.0.0"]]},
  {"name":"treetop","number":"1.1.1","dependencies":[["facets","2.0.2"]]},
  {"name":"treetop","number":"1.1.0","dependencies":[["facets","2.0.2"]]},
  {"name":"treetop","number":"1.0.2","dependencies":[["facets","2.0.2"]]},
  {"name":"treetop","number":"1.0.1","dependencies":[["facets","0.0.0"]]},
  {"name":"treetop","number":"1.0.0","dependencies":[["facets","0.0.0"]]},
  {"name":"treetop","number":"1.4.10","dependencies":[["polyglot",null],["polyglot",null]]},
  {"name":"treetop","number":"1.4.11","dependencies":[["polyglot",null],["polyglot",null]]},
  {"name":"treetop","number":"1.3.0","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.2.4","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.2.3","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.4","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.9","dependencies":[["polyglot",null]]},
  {"name":"treetop","number":"1.4.12","dependencies":[["polyglot",null],["polyglot",null]]},
  {"name":"treetop","number":"1.4.14","dependencies":[["polyglot",null],["polyglot",null]]},
  {"name":"treetop","number":"1.4.15","dependencies":[["polyglot",null],["polyglot",null]]},
  {"name":"turbolinks","number":"2.2.1","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"2.2.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"2.1.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"2.0.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.3.1","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"0.3.3","dependencies":[]},
  {"name":"turbolinks","number":"0.5.0","dependencies":[]},
  {"name":"turbolinks","number":"0.1.3","dependencies":[]},
  {"name":"turbolinks","number":"0.1.5","dependencies":[]},
  {"name":"turbolinks","number":"0.1.4","dependencies":[]},
  {"name":"turbolinks","number":"0.1.0","dependencies":[]},
  {"name":"turbolinks","number":"0.1.1","dependencies":[]},
  {"name":"turbolinks","number":"0.2.1","dependencies":[]},
  {"name":"turbolinks","number":"0.3.0","dependencies":[]},
  {"name":"turbolinks","number":"0.3.1","dependencies":[]},
  {"name":"turbolinks","number":"0.3.2","dependencies":[]},
  {"name":"turbolinks","number":"0.4.0","dependencies":[]},
  {"name":"turbolinks","number":"0.5.1","dependencies":[]},
  {"name":"turbolinks","number":"0.5.2","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"0.6.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"0.6.1","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.0.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.1.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.1.1","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.2.0","dependencies":[["coffee-rails",null]]},
  {"name":"turbolinks","number":"1.3.0","dependencies":[["coffee-rails",null]]},
  {"name":"twitter-stream","number":"0.1.13","dependencies":[["eventmachine","0.12.8 || 1.0.0"],["simple-oauth","0.1.4"]]},
  {"name":"twitter-stream","number":"0.1.14","dependencies":[["eventmachine",null],["simple-oauth","0.1.4"],["http-parser.rb","0.5.1"]]},
  {"name":"twitter-stream","number":"0.1.11","dependencies":[["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.1","dependencies":[]},
  {"name":"twitter-stream","number":"0.1.2","dependencies":[]},
  {"name":"twitter-stream","number":"0.1.9","dependencies":[["eventmachine",null],["roauth",null],["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.3","dependencies":[["eventmachine",null]]},
  {"name":"twitter-stream","number":"0.1.10","dependencies":[["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.4","dependencies":[["eventmachine",null]]},
  {"name":"twitter-stream","number":"0.1.8","dependencies":[["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.7","dependencies":[["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.6","dependencies":[["eventmachine",null]]},
  {"name":"twitter-stream","number":"0.1.0","dependencies":[]},
  {"name":"twitter-stream","number":"0.1.12","dependencies":[["eventmachine",null],["roauth",null]]},
  {"name":"twitter-stream","number":"0.1.15","dependencies":[["eventmachine",null],["simple-oauth","0.1.4"],["http-parser.rb","0.5.1"]]},
  {"name":"twitter-stream","number":"0.1.16","dependencies":[["eventmachine",null],["simple-oauth","0.1.4"],["http-parser.rb","0.5.1"]]},
  {"name":"tzinfo","number":"0.3.39","dependencies":[]},
  {"name":"tzinfo","number":"0.3.38","dependencies":[]},
  {"name":"tzinfo","number":"1.1.0","dependencies":[["thread-safe","0.1.0"]]},
  {"name":"tzinfo","number":"0.0.1","dependencies":[]},
  {"name":"tzinfo","number":"0.3.25","dependencies":[]},
  {"name":"tzinfo","number":"0.3.26","dependencies":[]},
  {"name":"tzinfo","number":"0.3.12","dependencies":[]},
  {"name":"tzinfo","number":"0.1.0","dependencies":[]},
  {"name":"tzinfo","number":"0.2.1","dependencies":[]},
  {"name":"tzinfo","number":"0.3.6","dependencies":[]},
  {"name":"tzinfo","number":"0.3.19","dependencies":[]},
  {"name":"tzinfo","number":"0.3.13","dependencies":[]},
  {"name":"tzinfo","number":"0.3.11","dependencies":[]},
  {"name":"tzinfo","number":"0.3.10","dependencies":[]},
  {"name":"tzinfo","number":"0.3.5","dependencies":[]},
  {"name":"tzinfo","number":"0.3.14","dependencies":[]},
  {"name":"tzinfo","number":"0.3.15","dependencies":[]},
  {"name":"tzinfo","number":"0.3.23","dependencies":[]},
  {"name":"tzinfo","number":"0.3.33","dependencies":[]},
  {"name":"tzinfo","number":"0.0.2","dependencies":[]},
  {"name":"tzinfo","number":"0.3.4","dependencies":[]},
  {"name":"tzinfo","number":"0.3.21","dependencies":[]},
  {"name":"tzinfo","number":"0.0.3","dependencies":[]},
  {"name":"tzinfo","number":"0.3.18","dependencies":[]},
  {"name":"tzinfo","number":"0.3.3","dependencies":[]},
  {"name":"tzinfo","number":"0.3.24","dependencies":[]},
  {"name":"tzinfo","number":"0.2.0","dependencies":[]},
  {"name":"tzinfo","number":"0.3.29","dependencies":[]},
  {"name":"tzinfo","number":"0.3.7","dependencies":[]},
  {"name":"tzinfo","number":"0.3.30","dependencies":[]},
  {"name":"tzinfo","number":"0.3.8","dependencies":[]},
  {"name":"tzinfo","number":"0.3.22","dependencies":[]},
  {"name":"tzinfo","number":"0.0.4","dependencies":[]},
  {"name":"tzinfo","number":"0.3.20","dependencies":[]},
  {"name":"tzinfo","number":"0.3.9","dependencies":[]},
  {"name":"tzinfo","number":"0.3.17","dependencies":[]},
  {"name":"tzinfo","number":"0.3.16","dependencies":[]},
  {"name":"tzinfo","number":"0.1.1","dependencies":[]},
  {"name":"tzinfo","number":"0.1.2","dependencies":[]},
  {"name":"tzinfo","number":"0.2.2","dependencies":[]},
  {"name":"tzinfo","number":"0.3.0","dependencies":[]},
  {"name":"tzinfo","number":"0.3.1","dependencies":[]},
  {"name":"tzinfo","number":"0.3.2","dependencies":[]},
  {"name":"tzinfo","number":"0.3.27","dependencies":[]},
  {"name":"tzinfo","number":"0.3.28","dependencies":[]},
  {"name":"tzinfo","number":"0.3.31","dependencies":[]},
  {"name":"tzinfo","number":"0.3.32","dependencies":[]},
  {"name":"tzinfo","number":"0.3.34","dependencies":[]},
  {"name":"tzinfo","number":"0.3.35","dependencies":[]},
  {"name":"tzinfo","number":"0.3.36","dependencies":[]},
  {"name":"tzinfo","number":"0.3.37","dependencies":[]},
  {"name":"tzinfo","number":"1.0.0","dependencies":[]},
  {"name":"tzinfo","number":"1.0.1","dependencies":[]},
  {"name":"uglifier","number":"2.5.0","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"2.4.0","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"2.3.3","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"2.3.2","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"2.3.1","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"2.3.0","dependencies":[["json","1.8.0"],["execjs",null]]},
  {"name":"uglifier","number":"0.3.0","dependencies":[["therubyracer",null]]},
  {"name":"uglifier","number":"1.2.5","dependencies":[["execjs",null],["multi-json","1.3.0"]]},
  {"name":"uglifier","number":"0.1.1","dependencies":[["therubyracer",null]]},
  {"name":"uglifier","number":"0.5.3","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.4.0","dependencies":[["therubyracer","0.8.0"]]},
  {"name":"uglifier","number":"1.0.3","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.1.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.2.3","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.5.2","dependencies":[["execjs",null],["multi-json",null]]},
  {"name":"uglifier","number":"1.2.4","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.2.0","dependencies":[["therubyracer",null]]},
  {"name":"uglifier","number":"1.2.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.0.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.5.1","dependencies":[["execjs",null],["json",null]]},
  {"name":"uglifier","number":"1.0.2","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.5.4","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"0.5.0","dependencies":[["execjs","0.1.0 || 1.0.0 || 2.0.0"],["json",null]]},
  {"name":"uglifier","number":"0.1.0","dependencies":[["therubyracer",null]]},
  {"name":"uglifier","number":"1.2.1","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.2.6","dependencies":[["execjs",null],["multi-json","1.3.0"]]},
  {"name":"uglifier","number":"1.2.7","dependencies":[["execjs",null],["multi-json","1.3.0"]]},
  {"name":"uglifier","number":"1.3.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.0.4","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.0.1","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"1.2.2","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.0.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.0.1","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.1.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.1.1","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.1.2","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.2.0","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"uglifier","number":"2.2.1","dependencies":[["execjs",null],["multi-json","1.0.2"]]},
  {"name":"underscore-rails","number":"1.6.0","dependencies":[]},
  {"name":"underscore-rails","number":"1.5.2","dependencies":[]},
  {"name":"underscore-rails","number":"1.2.0","dependencies":[]},
  {"name":"underscore-rails","number":"1.3.1","dependencies":[]},
  {"name":"underscore-rails","number":"1.2.2","dependencies":[]},
  {"name":"underscore-rails","number":"1.1.7","dependencies":[]},
  {"name":"underscore-rails","number":"1.3.0","dependencies":[]},
  {"name":"underscore-rails","number":"1.4.1","dependencies":[]},
  {"name":"underscore-rails","number":"1.4.2","dependencies":[]},
  {"name":"underscore-rails","number":"1.4.3","dependencies":[]},
  {"name":"underscore-rails","number":"1.4.4","dependencies":[]},
  {"name":"underscore-rails","number":"1.5.1","dependencies":[]},
  {"name":"unicorn","number":"4.8.2","dependencies":[["raindrops","0.7.0"],["kgio","2.6.0"],["rack",null]]},
  {"name":"unicorn","number":"4.8.1","dependencies":[["raindrops","0.7.0"],["kgio","2.6.0"],["rack",null]]},
  {"name":"unicorn","number":"4.8.0","dependencies":[["raindrops","0.7.0"],["kgio","2.6.0"],["rack",null]]},
  {"name":"unicorn","number":"4.7.0","dependencies":[["raindrops","0.7.0"],["kgio","2.6.0"],["rack",null]]},
  {"name":"unicorn","number":"0.8.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.91.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.2.1","dependencies":[]},
  {"name":"unicorn","number":"0.9.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.97.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.2.3","dependencies":[]},
  {"name":"unicorn","number":"0.5.4","dependencies":[]},
  {"name":"unicorn","number":"0.7.0","dependencies":[]},
  {"name":"unicorn","number":"3.6.0","dependencies":[["rack",null],["kgio","2.3.0"]]},
  {"name":"unicorn","number":"0.5.0","dependencies":[]},
  {"name":"unicorn","number":"0.6.0","dependencies":[]},
  {"name":"unicorn","number":"0.5.3","dependencies":[]},
  {"name":"unicorn","number":"0.95.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.2.2","dependencies":[]},
  {"name":"unicorn","number":"0.8.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.3","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.8.3","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.9.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.7.1","dependencies":[]},
  {"name":"unicorn","number":"0.5.2","dependencies":[]},
  {"name":"unicorn","number":"0.9.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.4.2","dependencies":[]},
  {"name":"unicorn","number":"0.1.0","dependencies":[]},
  {"name":"unicorn","number":"0.8.4","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.4","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.0.1","dependencies":[["rack",null],["kgio","2.0.0"]]},
  {"name":"unicorn","number":"0.4.1","dependencies":[]},
  {"name":"unicorn","number":"0.8.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"4.0.1","dependencies":[["rack",null],["kgio","2.4.0"],["raindrops","0.6.0"]]},
  {"name":"unicorn","number":"4.0.0","dependencies":[["rack",null],["kgio","2.4.0"],["raindrops","0.6.0"]]},
  {"name":"unicorn","number":"1.0.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.2.1","dependencies":[["rack",null],["kgio","2.1.0"]]},
  {"name":"unicorn","number":"1.1.5","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.97.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.96.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.0.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.5.1","dependencies":[]},
  {"name":"unicorn","number":"0.92.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.95.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.98.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.0.0","dependencies":[["rack",null],["kgio","2.0.0"]]},
  {"name":"unicorn","number":"3.6.1","dependencies":[["rack",null],["kgio","2.3.0"]]},
  {"name":"unicorn","number":"0.90.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.7.0","dependencies":[["rack",null],["kgio","2.3.0"]]},
  {"name":"unicorn","number":"0.99.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.96.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.6.2","dependencies":[["rack",null],["kgio","2.3.0"]]},
  {"name":"unicorn","number":"3.5.0","dependencies":[["rack",null],["kgio","2.3.0"]]},
  {"name":"unicorn","number":"4.1.0","dependencies":[["rack",null],["kgio","2.4.0"],["raindrops","0.6.0"]]},
  {"name":"unicorn","number":"0.94.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.7","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.991.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.5","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.95.3","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.4","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.1.0","dependencies":[["rack",null],["kgio","2.0.0"]]},
  {"name":"unicorn","number":"2.0.1","dependencies":[["rack",null],["kgio","1.3.1 || 2.0.0"]]},
  {"name":"unicorn","number":"3.4.0","dependencies":[["rack",null],["kgio","2.2.0"]]},
  {"name":"unicorn","number":"2.0.0","dependencies":[["rack",null],["kgio","1.3.1 || 2.0.0"]]},
  {"name":"unicorn","number":"1.0.2","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.3.0","dependencies":[["rack",null],["kgio","2.1.0"]]},
  {"name":"unicorn","number":"1.1.6","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.93.3","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"0.95.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"1.1.1","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"3.3.1","dependencies":[["rack",null],["kgio","2.1.0"]]},
  {"name":"unicorn","number":"0.990.0","dependencies":[["rack",null]]},
  {"name":"unicorn","number":"4.1.1","dependencies":[["rack",null],["kgio","2.4.0"],["raindrops","0.6.0"]]},
  {"name":"unicorn","number":"4.2.0","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.2.1","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.3.0","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.3.1","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.4.0","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.5.0","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.6.0","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.6.1","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.6.2","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn","number":"4.6.3","dependencies":[["rack",null],["kgio","2.6.0"],["raindrops","0.7.0"]]},
  {"name":"unicorn-worker-killer","number":"0.4.2","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.1.0","dependencies":[["unicorn","4.2.0"]]},
  {"name":"unicorn-worker-killer","number":"0.1.1","dependencies":[["unicorn","4.2.0"]]},
  {"name":"unicorn-worker-killer","number":"0.1.2","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.2.0","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.2.1","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.2.2","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.0","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.1","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.2","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.3","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.5","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.4","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.3.6","dependencies":[["unicorn","4.0.0"]]},
  {"name":"unicorn-worker-killer","number":"0.4.1","dependencies":[["unicorn","4.0.0"]]},
  {"name":"version-sorter","number":"1.0.0","dependencies":[]},
  {"name":"version-sorter","number":"1.1.0","dependencies":[]},
  {"name":"virtus","number":"1.0.2","dependencies":[["axiom-types","0.1.0"],["coercible","1.0.0"],["equalizer","0.0.9"],["descendants-tracker","0.0.3"]]},
  {"name":"virtus","number":"1.0.1","dependencies":[["axiom-types","0.0.5"],["coercible","1.0.0"],["equalizer","0.0.7"],["descendants-tracker","0.0.1"]]},
  {"name":"virtus","number":"1.0.0","dependencies":[["axiom-types","0.0.5"],["coercible","0.2.0 || 1.0.0"],["equalizer","0.0.7"],["descendants-tracker","0.0.1"]]},
  {"name":"virtus","number":"0.0.5","dependencies":[]},
  {"name":"virtus","number":"0.0.6","dependencies":[]},
  {"name":"virtus","number":"0.2.0","dependencies":[]},
  {"name":"virtus","number":"0.4.0","dependencies":[]},
  {"name":"virtus","number":"0.0.9","dependencies":[]},
  {"name":"virtus","number":"0.5.1","dependencies":[["backports","2.6.1 || 3.0.0"]]},
  {"name":"virtus","number":"0.0.3","dependencies":[]},
  {"name":"virtus","number":"0.4.2","dependencies":[["backports","2.5.3 || 3.0.0"]]},
  {"name":"virtus","number":"0.1.0","dependencies":[]},
  {"name":"virtus","number":"0.0.1","dependencies":[]},
  {"name":"virtus","number":"0.0.8","dependencies":[]},
  {"name":"virtus","number":"0.0.2","dependencies":[]},
  {"name":"virtus","number":"0.3.0","dependencies":[]},
  {"name":"virtus","number":"0.0.10","dependencies":[]},
  {"name":"virtus","number":"0.0.4","dependencies":[]},
  {"name":"virtus","number":"0.0.7","dependencies":[]},
  {"name":"virtus","number":"0.4.1","dependencies":[["backports","2.5.1 || 3.0.0"]]},
  {"name":"virtus","number":"0.5.0","dependencies":[["backports","2.6.1 || 3.0.0"]]},
  {"name":"virtus","number":"0.5.2","dependencies":[["backports","2.6.1 || 3.0.0"]]},
  {"name":"virtus","number":"0.5.3","dependencies":[["backports","2.6.1 || 3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"virtus","number":"0.5.4","dependencies":[["backports","2.6.1 || 3.0.0"],["descendants-tracker","0.0.1"]]},
  {"name":"virtus","number":"0.5.5","dependencies":[["backports","3.3.0"],["descendants-tracker","0.0.1"]]},
  {"name":"warden","number":"1.0.6","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.5","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.5.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.6","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.4","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.7","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.2.1","dependencies":[]},
  {"name":"warden","number":"0.2.3","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.5","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.7.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.8.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.8.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.5.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.5.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.4","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.3.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.6.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.3.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.7","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.1.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.1.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.2.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.6","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.4","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.4.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.10.1","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.5.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.4","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.2.2","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.5","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"0.9.5","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.0.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.2.0","dependencies":[["rack","1.0.0"]]},
  {"name":"warden","number":"1.2.3","dependencies":[["rack","1.0.0"]]},
  {"name":"webmock","number":"1.17.4","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.17.3","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.17.2","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.17.1","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.17.0","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.16.1","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.16.0","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.15.2","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.15.0","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.14.0","dependencies":[["crack",null],["addressable","2.2.7"]]},
  {"name":"webmock","number":"1.8.1","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.7","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.9","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.6","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.4","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"0.9.0","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"0.7.3","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.6.0","dependencies":[["addressable","2.2.2"],["crack",null]]},
  {"name":"webmock","number":"1.8.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.3.0","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.3.5","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.8.5","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.3.2","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.7.1","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"0.7.0","dependencies":[]},
  {"name":"webmock","number":"1.7.3","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.7.6","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.2.2","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.7.5","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"0.9.1","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.3.3","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.6.2","dependencies":[["addressable","2.2.2"],["crack",null]]},
  {"name":"webmock","number":"1.7.8","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.3.4","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.5.0","dependencies":[["addressable","2.2.2"],["crack",null]]},
  {"name":"webmock","number":"1.6.1","dependencies":[["addressable","2.2.2"],["crack",null]]},
  {"name":"webmock","number":"1.2.0","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.7.4","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.8.2","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.3","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"0.8.2","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"0.7.1","dependencies":[]},
  {"name":"webmock","number":"0.8.1","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"0.7.2","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.7.0","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.3.1","dependencies":[["addressable","2.1.1"],["crack",null]]},
  {"name":"webmock","number":"1.7.2","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.7.7","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.2.1","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.1.0","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.6.4","dependencies":[["addressable","2.2.0"],["crack",null],["addressable","2.2.5"]]},
  {"name":"webmock","number":"1.4.0","dependencies":[["addressable","2.2.2"],["crack",null]]},
  {"name":"webmock","number":"1.0.0","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"0.8.0","dependencies":[["addressable","2.1.1"]]},
  {"name":"webmock","number":"1.7.10","dependencies":[["addressable","2.2.5"],["crack",null]]},
  {"name":"webmock","number":"1.8.8","dependencies":[["addressable","2.2.8"],["crack",null]]},
  {"name":"webmock","number":"1.8.10","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.8.11","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.9.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.9.1","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.9.2","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.9.3","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.10.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.10.1","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.11.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.10.2","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.12.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.12.1","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.12.2","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.12.3","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"webmock","number":"1.13.0","dependencies":[["addressable","2.2.7"],["crack",null]]},
  {"name":"websocket-driver","number":"0.3.2","dependencies":[]},
  {"name":"websocket-driver","number":"0.3.1","dependencies":[]},
  {"name":"websocket-driver","number":"0.3.0","dependencies":[]},
  {"name":"websocket-driver","number":"0.1.0","dependencies":[]},
  {"name":"websocket-driver","number":"0.2.0","dependencies":[]},
  {"name":"websocket-driver","number":"0.2.1","dependencies":[]},
  {"name":"websocket-driver","number":"0.2.2","dependencies":[]},
  {"name":"websocket-driver","number":"0.2.3","dependencies":[]},
  {"name":"xpath","number":"0.1.2","dependencies":[["nokogiri","1.3.0"]]},
  {"name":"xpath","number":"0.1.3","dependencies":[["nokogiri","1.3.0"]]},
  {"name":"xpath","number":"0.1.0","dependencies":[]},
  {"name":"xpath","number":"0.1.1","dependencies":[["nokogiri","1.3.0"]]},
  {"name":"xpath","number":"0.1.4","dependencies":[["nokogiri","1.3.0"]]},
  {"name":"xpath","number":"1.0.0","dependencies":[["nokogiri","1.3.0"]]},
  {"name":"xpath","number":"2.0.0","dependencies":[["nokogiri","1.3.0"]]}
];

sinatraGems = [
  {"name":"launchy","number":"2.4.2","dependencies":[]},
  {"name":"launchy","number":"1.4.2","dependencies":[]},
  {"name":"launchy","number":"0.4.2","dependencies":[]},
  {"name":"rspec","number":"3.20.0","dependencies":[]},
  {"name":"rspec","number":"2.20.0","dependencies":[]},
  {"name":"rspec","number":"1.20.0","dependencies":[]},
  {"name":"rspec","number":"0.20.0","dependencies":[]},
  {"name":"rake","number":"12.0.0","dependencies":[]},
  {"name":"echoe","number":"1.0.0","dependencies":[]},
  {"name":"ffi","number":"0.6.3","dependencies":[]},
  {"name":"addressable","number":"2.3.6","dependencies":[]},
  {"name":"addressable","number":"2.1.1","dependencies":[]},
  {"name":"addressable","number":"1.0.1","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"2.2.3","dependencies":[]},
  {"name":"addressable","number":"2.3.2","dependencies":[]},
  {"name":"addressable","number":"2.2.5","dependencies":[]},
  {"name":"addressable","number":"0.1.1","dependencies":[["rake",null],["rspec",null]]},
  {"name":"addressable","number":"0.1.0","dependencies":[["rake",null],["rspec",null]]},
  {"name":"addressable","number":"2.0.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"addressable","number":"1.0.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"1.0.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"2.1.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"addressable","number":"2.0.0","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"addressable","number":"2.2.4","dependencies":[]},
  {"name":"addressable","number":"2.2.7","dependencies":[]},
  {"name":"addressable","number":"2.2.8","dependencies":[]},
  {"name":"addressable","number":"2.2.2","dependencies":[]},
  {"name":"addressable","number":"2.2.0","dependencies":[]},
  {"name":"addressable","number":"1.0.3","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"2.2.6","dependencies":[]},
  {"name":"addressable","number":"0.1.2","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"2.0.1","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"addressable","number":"1.0.4","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"addressable","number":"2.1.2","dependencies":[]},
  {"name":"addressable","number":"2.2.1","dependencies":[]},
  {"name":"addressable","number":"2.3.3","dependencies":[]},
  {"name":"addressable","number":"2.3.4","dependencies":[]},
  {"name":"addressable","number":"2.3.5","dependencies":[]},
  {"name":"bcrypt","number":"3.1.7","dependencies":[]},
  {"name":"bcrypt","number":"3.1.6","dependencies":[]},
  {"name":"bcrypt","number":"3.1.3","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.5","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"3.1.4","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"3.1.3","dependencies":[["bcrypt","3.1.3"]]},
  {"name":"bcrypt-ruby","number":"2.1.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"1.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.4","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.2","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.3","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.2","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.0.5","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.4","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.0.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"2.1.3","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.0.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.0","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.1","dependencies":[]},
  {"name":"bcrypt-ruby","number":"3.1.2","dependencies":[]},
  {"name":"capistrano","number":"3.1.0","dependencies":[["i18n",null],["rake","10.0.0 || 11.0.0 || 12.0.0"],["sshkit","1.3.0"]]},
  {"name":"capistrano","number":"3.0.1","dependencies":[["i18n",null],["rake","10.0.0 || 11.0.0 || 12.0.0"],["sshkit",null]]},
  {"name":"capistrano","number":"3.0.0","dependencies":[["i18n",null],["rake","10.0.0 || 11.0.0 || 12.0.0"],["sshkit",null]]},
  {"name":"capistrano","number":"2.5.21","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"]]},
  {"name":"capistrano","number":"2.5.6","dependencies":[["net-ssh","2.0.10"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"1.1.0","dependencies":[["net-ssh","1.0.8 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.3.0","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.1","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.11","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"1.4.1","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.11.2","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.5.13","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.20","dependencies":[["net-ssh",null],["net-ssh-gateway",null],["net-sftp",null],["net-scp",null],["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.17","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.4","dependencies":[["net-ssh","2.0.10"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.0.0","dependencies":[["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"],["highline","0.0.0 || 1.0.0"]]},
  {"name":"capistrano","number":"1.3.0","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.12.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.5.12","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.7","dependencies":[["net-ssh","2.0.10"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.2.0","dependencies":[["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"],["highline",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.5.10","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.3","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.5.15","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.7.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.5.8","dependencies":[["net-ssh","2.0.10"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.5.2","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.4.2","dependencies":[["net-ssh",null],["net-sftp",null],["net-scp",null],["net-ssh-gateway",null],["highline",null],["net-ssh","=2.0.0"],["net-sftp","=2.0.0"],["net-scp","=1.0.0"],["net-ssh-gateway","=1.0.0"]]},
  {"name":"capistrano","number":"2.5.16","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.19","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"1.2.0","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.5.5","dependencies":[["net-ssh","2.0.10"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null],["echoe",null]]},
  {"name":"capistrano","number":"2.5.18","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"1.4.0","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.4.3","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.4.1","dependencies":[]},
  {"name":"capistrano","number":"1.4.2","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.9.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.8.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.5.9","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.4.0","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.5.0","dependencies":[["net-ssh","2.0.0"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.1.0","dependencies":[["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"],["highline","0.0.0 || 1.0.0"]]},
  {"name":"capistrano","number":"1.3.1","dependencies":[["rake",null],["net-ssh","1.0.10 || 2.0.0"],["net-sftp","1.1.0 || 2.0.0"]]},
  {"name":"capistrano","number":"2.6.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.5.14","dependencies":[["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.0.0"],["highline",null]]},
  {"name":"capistrano","number":"2.13.5","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.14.1","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.14.2","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.2","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.1","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.0","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.3","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.4","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"capistrano","number":"2.15.5","dependencies":[["highline",null],["net-ssh","2.0.14"],["net-sftp","2.0.0"],["net-scp","1.0.0"],["net-ssh-gateway","1.1.0"]]},
  {"name":"data-mapper","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["dm-core","=0.9.4"],["dm-aggregates","=0.9.4"],["dm-migrations","=0.9.4"],["dm-serializer","=0.9.4"],["dm-timestamps","=0.9.4"],["dm-validations","=0.9.4"],["dm-cli","=0.9.4"],["dm-is-tree","=0.9.4"],["dm-observer","=0.9.4"],["dm-types","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"data-mapper","number":"0.9.9","dependencies":[["dm-core","=0.9.9"],["dm-core","=0.9.9"],["dm-aggregates","=0.9.9"],["dm-migrations","=0.9.9"],["dm-serializer","=0.9.9"],["dm-timestamps","=0.9.9"],["dm-validations","=0.9.9"],["dm-cli","=0.9.9"],["dm-is-tree","=0.9.9"],["dm-observer","=0.9.9"],["dm-types","=0.9.9"],["hoe","1.8.2"]]},
  {"name":"data-mapper","number":"1.0.2","dependencies":[["dm-core","=1.0.2"],["dm-aggregates","=1.0.2"],["dm-constraints","=1.0.2"],["dm-migrations","=1.0.2"],["dm-transactions","=1.0.2"],["dm-serializer","=1.0.2"],["dm-timestamps","=1.0.2"],["dm-validations","=1.0.2"],["dm-types","=1.0.2"]]},
  {"name":"data-mapper","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["dm-core","=0.9.5"],["dm-aggregates","=0.9.5"],["dm-migrations","=0.9.5"],["dm-serializer","=0.9.5"],["dm-timestamps","=0.9.5"],["dm-validations","=0.9.5"],["dm-cli","=0.9.5"],["dm-is-tree","=0.9.5"],["dm-observer","=0.9.5"],["dm-types","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"data-mapper","number":"1.0.1","dependencies":[["dm-core","=1.0.1"],["dm-aggregates","=1.0.1"],["dm-constraints","=1.0.1"],["dm-migrations","=1.0.1"],["dm-transactions","=1.0.1"],["dm-serializer","=1.0.1"],["dm-timestamps","=1.0.1"],["dm-validations","=1.0.1"],["dm-types","=1.0.1"]]},
  {"name":"data-mapper","number":"0.9.8","dependencies":[["dm-core","=0.9.8"],["dm-core","=0.9.8"],["dm-aggregates","=0.9.8"],["dm-migrations","=0.9.8"],["dm-serializer","=0.9.8"],["dm-timestamps","=0.9.8"],["dm-validations","=0.9.8"],["dm-cli","=0.9.8"],["dm-is-tree","=0.9.8"],["dm-observer","=0.9.8"],["dm-types","=0.9.8"],["hoe","1.8.2"]]},
  {"name":"data-mapper","number":"1.0.0","dependencies":[["dm-core","=1.0.0"],["dm-core","=1.0.0"],["dm-aggregates","=1.0.0"],["dm-constraints","=1.0.0"],["dm-migrations","=1.0.0"],["dm-transactions","=1.0.0"],["dm-serializer","=1.0.0"],["dm-timestamps","=1.0.0"],["dm-validations","=1.0.0"],["dm-types","=1.0.0"]]},
  {"name":"data-mapper","number":"0.10.0","dependencies":[["dm-core","=0.10.0"],["dm-core","=0.10.0"],["dm-aggregates","=0.10.0"],["dm-constraints","=0.10.0"],["dm-migrations","=0.10.0"],["dm-serializer","=0.10.0"],["dm-timestamps","=0.10.0"],["dm-validations","=0.10.0"],["dm-types","=0.10.0"]]},
  {"name":"data-mapper","number":"0.9.11","dependencies":[["dm-core","=0.9.11"],["dm-core","=0.9.11"],["dm-aggregates","=0.9.11"],["dm-migrations","=0.9.11"],["dm-serializer","=0.9.11"],["dm-timestamps","=0.9.11"],["dm-validations","=0.9.11"],["dm-cli","=0.9.11"],["dm-is-tree","=0.9.11"],["dm-observer","=0.9.11"],["dm-types","=0.9.11"],["hoe","1.11.0"]]},
  {"name":"data-mapper","number":"0.9.10","dependencies":[["dm-core","=0.9.10"],["dm-core","=0.9.10"],["dm-aggregates","=0.9.10"],["dm-migrations","=0.9.10"],["dm-serializer","=0.9.10"],["dm-timestamps","=0.9.10"],["dm-validations","=0.9.10"],["dm-cli","=0.9.10"],["dm-is-tree","=0.9.10"],["dm-observer","=0.9.10"],["dm-types","=0.9.10"],["hoe","1.8.2"]]},
  {"name":"data-mapper","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["dm-core","=0.9.6"],["dm-aggregates","=0.9.6"],["dm-migrations","=0.9.6"],["dm-serializer","=0.9.6"],["dm-timestamps","=0.9.6"],["dm-validations","=0.9.6"],["dm-cli","=0.9.6"],["dm-is-tree","=0.9.6"],["dm-observer","=0.9.6"],["dm-types","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"data-mapper","number":"0.10.1","dependencies":[["dm-core","=0.10.1"],["dm-core","=0.10.1"],["dm-aggregates","=0.10.1"],["dm-constraints","=0.10.1"],["dm-migrations","=0.10.1"],["dm-serializer","=0.10.1"],["dm-timestamps","=0.10.1"],["dm-validations","=0.10.1"],["dm-types","=0.10.1"]]},
  {"name":"data-mapper","number":"0.9.2","dependencies":[["dm-core",null],["dm-aggregates",null],["dm-migrations",null],["dm-serializer",null],["dm-timestamps",null],["dm-validations",null],["dm-cli",null],["dm-is-tree",null],["dm-observer",null],["dm-types",null]]},
  {"name":"data-mapper","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"],["dm-aggregates","0.10.2 || 1.0.0"],["dm-constraints","0.10.2 || 1.0.0"],["dm-migrations","0.10.2 || 1.0.0"],["dm-serializer","0.10.2 || 1.0.0"],["dm-timestamps","0.10.2 || 1.0.0"],["dm-validations","0.10.2 || 1.0.0"],["dm-types","0.10.2 || 1.0.0"]]},
  {"name":"data-mapper","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["dm-core","=0.9.3"],["dm-aggregates","=0.9.3"],["dm-migrations","=0.9.3"],["dm-serializer","=0.9.3"],["dm-timestamps","=0.9.3"],["dm-validations","=0.9.3"],["dm-cli","=0.9.3"],["dm-is-tree","=0.9.3"],["dm-observer","=0.9.3"],["dm-types","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"data-mapper","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["dm-core","=0.9.7"],["dm-aggregates","=0.9.7"],["dm-migrations","=0.9.7"],["dm-serializer","=0.9.7"],["dm-timestamps","=0.9.7"],["dm-validations","=0.9.7"],["dm-cli","=0.9.7"],["dm-is-tree","=0.9.7"],["dm-observer","=0.9.7"],["dm-types","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"data-mapper","number":"1.1.0","dependencies":[["dm-core","=1.1.0"],["dm-aggregates","=1.1.0"],["dm-constraints","=1.1.0"],["dm-migrations","=1.1.0"],["dm-transactions","=1.1.0"],["dm-serializer","=1.1.0"],["dm-timestamps","=1.1.0"],["dm-validations","=1.1.0"],["dm-types","=1.1.0"]]},
  {"name":"data-mapper","number":"1.2.0","dependencies":[["dm-core","1.2.0"],["dm-aggregates","1.2.0"],["dm-constraints","1.2.0"],["dm-migrations","1.2.0"],["dm-transactions","1.2.0"],["dm-serializer","1.2.0"],["dm-timestamps","1.2.0"],["dm-validations","1.2.0"],["dm-types","1.2.0"]]},
  {"name":"data-objects","number":"0.10.14","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.9.7","dependencies":[["addressable","2.0.0"],["extlib","0.9.8"],["hoe","1.8.2"]]},
  {"name":"data-objects","number":"0.2.0","dependencies":[]},
  {"name":"data-objects","number":"0.9.6","dependencies":[["addressable","1.0.3 || 2.0.0"],["extlib",null],["hoe","1.7.0"]]},
  {"name":"data-objects","number":"0.9.10","dependencies":[["addressable","2.0.0"],["extlib","0.9.8"],["hoe","1.8.2"]]},
  {"name":"data-objects","number":"0.10.3","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.5","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.9.2","dependencies":[["addressable","1.0.3 || 2.0.0"],["extlib",null]]},
  {"name":"data-objects","number":"0.10.0","dependencies":[["addressable","2.0.0"],["extlib","0.9.12"]]},
  {"name":"data-objects","number":"0.9.3","dependencies":[["addressable","1.0.3 || 2.0.0"],["extlib","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"data-objects","number":"0.10.2","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.9.5","dependencies":[["addressable","1.0.3 || 2.0.0"],["extlib",null],["hoe","1.7.0"]]},
  {"name":"data-objects","number":"0.9.4","dependencies":[["addressable","1.0.3 || 2.0.0"],["extlib","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"data-objects","number":"0.9.8","dependencies":[["addressable","2.0.0"],["extlib","0.9.8"],["hoe","1.8.2"]]},
  {"name":"data-objects","number":"0.9.9","dependencies":[["addressable","2.0.0"],["extlib","0.9.8"],["hoe","1.8.2"]]},
  {"name":"data-objects","number":"0.9.11","dependencies":[["addressable","2.0.0"],["extlib","0.9.9"],["hoe","1.8.2"]]},
  {"name":"data-objects","number":"0.9.12","dependencies":[["addressable","2.0.0"],["extlib","0.9.12"],["rspec","1.2.0 || 2.0.0 || 3.0.0"]]},
  {"name":"data-objects","number":"0.10.1","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.4","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.6","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.7","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.8","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.9","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.10","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.11","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.12","dependencies":[["addressable","2.1.0"]]},
  {"name":"data-objects","number":"0.10.13","dependencies":[["addressable","2.1.0"]]},
  {"name":"dm-aggregates","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-aggregates","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-aggregates","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-aggregates","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"]]},
  {"name":"dm-aggregates","number":"1.0.2","dependencies":[["dm-core","1.0.2"]]},
  {"name":"dm-aggregates","number":"1.0.1","dependencies":[["dm-core","1.0.1"]]},
  {"name":"dm-aggregates","number":"1.0.0","dependencies":[["dm-core","1.0.0"]]},
  {"name":"dm-aggregates","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-aggregates","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-aggregates","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"dm-aggregates","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-aggregates","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-aggregates","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-aggregates","number":"0.10.0","dependencies":[]},
  {"name":"dm-aggregates","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-aggregates","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-aggregates","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"dm-aggregates","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"dm-constraints","number":"0.9.4","dependencies":[["dm-core","=0.9.4"]]},
  {"name":"dm-constraints","number":"1.0.0","dependencies":[["dm-core","1.0.0"],["dm-migrations","1.0.0"]]},
  {"name":"dm-constraints","number":"0.9.5","dependencies":[["dm-core","=0.9.5"]]},
  {"name":"dm-constraints","number":"0.10.0","dependencies":[]},
  {"name":"dm-constraints","number":"1.0.1","dependencies":[["dm-core","1.0.1"],["dm-migrations","1.0.1"]]},
  {"name":"dm-constraints","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-constraints","number":"0.9.7","dependencies":[["dm-core","=0.9.7"]]},
  {"name":"dm-constraints","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"]]},
  {"name":"dm-constraints","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-constraints","number":"0.9.6","dependencies":[["dm-core","=0.9.6"]]},
  {"name":"dm-constraints","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-constraints","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-constraints","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-constraints","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-constraints","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"dm-constraints","number":"1.0.2","dependencies":[["dm-core","1.0.2"],["dm-migrations","1.0.2"]]},
  {"name":"dm-core","number":"1.0.0","dependencies":[["extlib","0.9.15"],["addressable","2.1.0"]]},
  {"name":"dm-core","number":"0.10.1","dependencies":[["extlib","0.9.13"],["addressable","2.1.0"]]},
  {"name":"dm-core","number":"0.10.2","dependencies":[["extlib","0.9.14"],["addressable","2.1.0"]]},
  {"name":"dm-core","number":"0.9.2","dependencies":[["data-objects","=0.9.2"],["extlib","=0.9.2"],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","1.0.4 || 2.0.0"]]},
  {"name":"dm-core","number":"0.9.8","dependencies":[["data-objects","0.9.9"],["extlib","0.9.9"],["addressable","2.0.1"]]},
  {"name":"dm-core","number":"0.9.11","dependencies":[["data-objects","0.9.11"],["extlib","0.9.11"],["addressable","2.0.2"]]},
  {"name":"dm-core","number":"0.9.4","dependencies":[["data-objects","=0.9.4"],["extlib","=0.9.4"],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","1.0.4 || 2.0.0"]]},
  {"name":"dm-core","number":"1.0.2","dependencies":[["extlib","0.9.15"],["addressable","2.2.0"]]},
  {"name":"dm-core","number":"0.9.6","dependencies":[["data-objects",null],["extlib",null],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","1.0.4 || 2.0.0"]]},
  {"name":"dm-core","number":"0.9.7","dependencies":[["data-objects","0.9.7"],["extlib","0.9.8"],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","2.0.0"]]},
  {"name":"dm-core","number":"0.9.10","dependencies":[["data-objects","0.9.11"],["extlib","0.9.10"],["addressable","2.0.1"]]},
  {"name":"dm-core","number":"0.9.3","dependencies":[["data-objects","=0.9.3"],["extlib","=0.9.3"],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","1.0.4 || 2.0.0"],["hoe","1.7.0"]]},
  {"name":"dm-core","number":"0.10.0","dependencies":[]},
  {"name":"dm-core","number":"0.9.5","dependencies":[["data-objects",null],["extlib",null],["rspec","1.1.3 || 2.0.0 || 3.0.0"],["addressable","1.0.4 || 2.0.0"]]},
  {"name":"dm-core","number":"1.0.1","dependencies":[["extlib","0.9.15"],["addressable","2.2.0"]]},
  {"name":"dm-core","number":"0.9.9","dependencies":[["data-objects","0.9.10"],["extlib","0.9.9"],["addressable","2.0.1"]]},
  {"name":"dm-core","number":"1.2.0","dependencies":[["addressable","2.2.6"]]},
  {"name":"dm-core","number":"1.1.0","dependencies":[["addressable","2.2.4"]]},
  {"name":"dm-core","number":"1.2.1","dependencies":[["addressable","2.3.0"]]},
  {"name":"dm-do-adapter","number":"1.0.2","dependencies":[["data-objects","0.10.2"],["dm-core","1.0.2"]]},
  {"name":"dm-do-adapter","number":"1.0.1","dependencies":[["data-objects","0.10.2"],["dm-core","1.0.1"]]},
  {"name":"dm-do-adapter","number":"1.0.0","dependencies":[["data-objects","0.10.1"],["dm-core","1.0.0"]]},
  {"name":"dm-do-adapter","number":"1.1.0","dependencies":[["data-objects","0.10.2"],["dm-core","1.1.0"]]},
  {"name":"dm-do-adapter","number":"1.2.0","dependencies":[["data-objects","0.10.6"],["dm-core","1.2.0"]]},
  {"name":"dm-migrations","number":"0.10.0","dependencies":[]},
  {"name":"dm-migrations","number":"1.0.1","dependencies":[["dm-core","1.0.1"]]},
  {"name":"dm-migrations","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-migrations","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-migrations","number":"0.9.7","dependencies":[["dm-core","0.9.7 || 1.0.0"],["hoe","1.8.2"]]},
  {"name":"dm-migrations","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-migrations","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-migrations","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-migrations","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-migrations","number":"1.0.0","dependencies":[["dm-core","1.0.0"]]},
  {"name":"dm-migrations","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-migrations","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-migrations","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-migrations","number":"0.9.6","dependencies":[["dm-core","0.9.5 || 1.0.0"],["hoe","1.7.0"]]},
  {"name":"dm-migrations","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"]]},
  {"name":"dm-migrations","number":"1.0.2","dependencies":[["dm-core","1.0.2"]]},
  {"name":"dm-migrations","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"dm-migrations","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-serializer","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"],["fastercsv","1.5.0"],["json-pure","1.2.0"]]},
  {"name":"dm-serializer","number":"1.0.2","dependencies":[["dm-core","1.0.2"],["fastercsv","1.5.3"],["json-pure","1.4.0"]]},
  {"name":"dm-serializer","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-serializer","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-serializer","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-serializer","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"dm-serializer","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-serializer","number":"0.10.0","dependencies":[]},
  {"name":"dm-serializer","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"dm-serializer","number":"1.0.1","dependencies":[["dm-core","1.0.1"],["fastercsv","1.5.3"],["json-pure","1.4.0"]]},
  {"name":"dm-serializer","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-serializer","number":"1.0.0","dependencies":[["dm-core","1.0.0"],["fastercsv","1.5.3"],["json-pure","1.4.3"]]},
  {"name":"dm-serializer","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-serializer","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-serializer","number":"1.1.0","dependencies":[["dm-core","1.1.0"],["fastercsv","1.5.4"],["json","1.4.6"]]},
  {"name":"dm-serializer","number":"1.2.0","dependencies":[["dm-core","1.2.0"],["fastercsv","1.5.4"],["multi-json","1.0.3"],["json","1.5.4"],["json-pure","1.5.4"]]},
  {"name":"dm-serializer","number":"1.2.1","dependencies":[["dm-core","1.2.0"],["fastercsv","1.5.4"],["multi-json","1.0.3"],["json","1.6.1"],["json-pure","1.6.1"]]},
  {"name":"dm-serializer","number":"1.2.2","dependencies":[["fastercsv","1.5.0"],["multi-json","1.0.0"],["json","1.6.0"],["json-pure","1.6.0"],["dm-core","1.2.0"]]},
  {"name":"dm-serializer","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-serializer","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-sqlite-adapter","number":"1.1.0","dependencies":[["do-sqlite3","0.10.2"],["dm-do-adapter","1.1.0"]]},
  {"name":"dm-sqlite-adapter","number":"1.0.2","dependencies":[["do-sqlite3","0.10.2"],["dm-do-adapter","1.0.2"]]},
  {"name":"dm-sqlite-adapter","number":"1.0.0","dependencies":[["do-sqlite3","0.10.2"],["dm-do-adapter","1.0.0"]]},
  {"name":"dm-sqlite-adapter","number":"1.2.0","dependencies":[["do-sqlite3","0.10.6"],["dm-do-adapter","1.2.0"]]},
  {"name":"dm-sqlite-adapter","number":"1.0.1","dependencies":[["do-sqlite3","0.10.2"],["dm-do-adapter","1.0.1"]]},
  {"name":"dm-timestamps","number":"0.10.0","dependencies":[]},
  {"name":"dm-timestamps","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-timestamps","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-timestamps","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"]]},
  {"name":"dm-timestamps","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-timestamps","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-timestamps","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-timestamps","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-timestamps","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-timestamps","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-timestamps","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-timestamps","number":"1.0.2","dependencies":[["dm-core","1.0.2"]]},
  {"name":"dm-timestamps","number":"1.0.0","dependencies":[["dm-core","1.0.0"]]},
  {"name":"dm-timestamps","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"dm-timestamps","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-timestamps","number":"1.0.1","dependencies":[["dm-core","1.0.1"]]},
  {"name":"dm-timestamps","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"dm-timestamps","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"dm-transactions","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-transactions","number":"1.0.0","dependencies":[["dm-core","1.0.0"]]},
  {"name":"dm-transactions","number":"1.0.2","dependencies":[["dm-core","1.0.2"]]},
  {"name":"dm-transactions","number":"1.0.1","dependencies":[["dm-core","1.0.1"]]},
  {"name":"dm-transactions","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"dm-types","number":"1.2.0","dependencies":[["bcrypt-ruby","3.0.0"],["dm-core","1.2.0"],["fastercsv","1.5.4"],["multi-json","1.0.3"],["json","1.5.4"],["stringex","1.3.0 || 2.0.0"],["uuidtools","2.1.2"]]},
  {"name":"dm-types","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-types","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["uuidtools",null],["hoe","1.8.2"]]},
  {"name":"dm-types","number":"0.9.11","dependencies":[["dm-core","=0.9.11"],["addressable","2.0.2"]]},
  {"name":"dm-types","number":"0.10.0","dependencies":[]},
  {"name":"dm-types","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-types","number":"1.0.2","dependencies":[["dm-core","1.0.2"],["fastercsv","1.5.3"],["json-pure","1.4.0"],["uuidtools","2.1.1"],["stringex","1.1.0 || 2.0.0"]]},
  {"name":"dm-types","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"],["addressable","2.0.1"]]},
  {"name":"dm-types","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-types","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-types","number":"0.10.2","dependencies":[["bcrypt-ruby","2.1.2 || 3.0.0"],["dm-core","0.10.2 || 1.0.0"],["fastercsv","1.5.0"],["json-pure","1.2.0"],["uuidtools","2.1.1"],["stringex","1.1.0 || 2.0.0"]]},
  {"name":"dm-types","number":"1.0.0","dependencies":[["dm-core","1.0.0"],["fastercsv","1.5.3"],["json-pure","1.4.3"],["uuidtools","2.1.1"],["stringex","1.1.0 || 2.0.0"]]},
  {"name":"dm-types","number":"1.2.1","dependencies":[["bcrypt-ruby","3.0.0"],["dm-core","1.2.0"],["fastercsv","1.5.4"],["multi-json","1.0.3"],["json","1.6.1"],["stringex","1.3.0 || 2.0.0"],["uuidtools","2.1.2"]]},
  {"name":"dm-types","number":"1.2.2","dependencies":[["bcrypt-ruby","3.0.0"],["fastercsv","1.5.0"],["multi-json","1.0.0"],["json","1.6.0"],["stringex","1.4.0 || 2.0.0"],["uuidtools","2.1.0"],["dm-core","1.2.0"]]},
  {"name":"dm-types","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["uuidtools",null],["hoe","1.7.0"]]},
  {"name":"dm-types","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"],["addressable","2.0.1"]]},
  {"name":"dm-types","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-types","number":"1.1.0","dependencies":[["bcrypt-ruby","2.1.4 || 3.0.0"],["dm-core","1.1.0"],["fastercsv","1.5.4"],["json","1.4.6"],["stringex","1.2.0 || 2.0.0"],["uuidtools","2.1.2"]]},
  {"name":"dm-types","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"],["addressable","2.0.1"],["bcrypt-ruby","2.0.0 || 3.0.0"],["json","1.1.3"]]},
  {"name":"dm-types","number":"1.0.1","dependencies":[["dm-core","1.0.1"],["fastercsv","1.5.3"],["json-pure","1.4.0"],["uuidtools","2.1.1"],["stringex","1.1.0 || 2.0.0"]]},
  {"name":"dm-validations","number":"0.10.0","dependencies":[]},
  {"name":"dm-validations","number":"0.10.1","dependencies":[["dm-core","=0.10.1"]]},
  {"name":"dm-validations","number":"0.9.4","dependencies":[["dm-core","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"dm-validations","number":"0.10.2","dependencies":[["dm-core","0.10.2 || 1.0.0"]]},
  {"name":"dm-validations","number":"0.9.7","dependencies":[["dm-core","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"dm-validations","number":"0.9.6","dependencies":[["dm-core","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"dm-validations","number":"0.9.5","dependencies":[["dm-core","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"dm-validations","number":"0.9.3","dependencies":[["dm-core","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"dm-validations","number":"1.0.0","dependencies":[["dm-core","1.0.0"]]},
  {"name":"dm-validations","number":"0.9.11","dependencies":[["dm-core","=0.9.11"]]},
  {"name":"dm-validations","number":"0.9.9","dependencies":[["dm-core","0.9.9 || 1.0.0"]]},
  {"name":"dm-validations","number":"0.9.2","dependencies":[["dm-core","=0.9.2"]]},
  {"name":"dm-validations","number":"1.0.1","dependencies":[["dm-core","1.0.1"]]},
  {"name":"dm-validations","number":"0.9.10","dependencies":[["dm-core","0.9.10 || 1.0.0"]]},
  {"name":"dm-validations","number":"0.9.8","dependencies":[["dm-core","0.9.8 || 1.0.0"]]},
  {"name":"dm-validations","number":"1.0.2","dependencies":[["dm-core","1.0.2"]]},
  {"name":"dm-validations","number":"1.1.0","dependencies":[["dm-core","1.1.0"]]},
  {"name":"dm-validations","number":"1.2.0","dependencies":[["dm-core","1.2.0"]]},
  {"name":"do-sqlite3","number":"0.10.14","dependencies":[["data-objects","=0.10.14"]]},
  {"name":"do-sqlite3","number":"0.10.5","dependencies":[["data-objects","=0.10.5"]]},
  {"name":"do-sqlite3","number":"0.9.8","dependencies":[["data-objects","=0.9.8"],["hoe","1.8.2"]]},
  {"name":"do-sqlite3","number":"0.9.7","dependencies":[["data-objects","=0.9.7"],["hoe","1.8.2"]]},
  {"name":"do-sqlite3","number":"0.10.2","dependencies":[["data-objects","=0.10.2"]]},
  {"name":"do-sqlite3","number":"0.10.9","dependencies":[["data-objects","=0.10.9"]]},
  {"name":"do-sqlite3","number":"0.10.8","dependencies":[["data-objects","=0.10.8"]]},
  {"name":"do-sqlite3","number":"0.10.1","dependencies":[["data-objects","=0.10.1"]]},
  {"name":"do-sqlite3","number":"0.9.6","dependencies":[["data-objects","=0.9.6"],["hoe","1.7.0"]]},
  {"name":"do-sqlite3","number":"0.9.4","dependencies":[["data-objects","=0.9.4"],["hoe","1.7.0"]]},
  {"name":"do-sqlite3","number":"0.9.12","dependencies":[["addressable","2.0.0"],["extlib","0.9.12"],["data-objects","=0.9.12"],["rspec","1.2.0 || 2.0.0 || 3.0.0"]]},
  {"name":"do-sqlite3","number":"0.9.11","dependencies":[["data-objects","=0.9.11"],["hoe","1.8.2"]]},
  {"name":"do-sqlite3","number":"0.10.4","dependencies":[["data-objects","=0.10.4"]]},
  {"name":"do-sqlite3","number":"0.9.3","dependencies":[["data-objects","=0.9.3"],["hoe","1.7.0"]]},
  {"name":"do-sqlite3","number":"0.2.3","dependencies":[["data-objects","0.0.0"]]},
  {"name":"do-sqlite3","number":"0.9.5","dependencies":[["data-objects","=0.9.5"],["hoe","1.7.0"]]},
  {"name":"do-sqlite3","number":"0.10.7","dependencies":[["data-objects","=0.10.7"]]},
  {"name":"do-sqlite3","number":"0.10.0","dependencies":[["addressable","2.0.0"],["extlib","0.9.12"],["data-objects","=0.10.0"]]},
  {"name":"do-sqlite3","number":"0.9.10","dependencies":[["data-objects","=0.9.10"],["hoe","1.8.2"]]},
  {"name":"do-sqlite3","number":"0.2.0","dependencies":[["data-objects","0.0.0"]]},
  {"name":"do-sqlite3","number":"0.2.5","dependencies":[["data-objects",null]]},
  {"name":"do-sqlite3","number":"0.9.2","dependencies":[["data-objects","=0.9.2"]]},
  {"name":"do-sqlite3","number":"0.10.3","dependencies":[["data-objects","=0.10.3"]]},
  {"name":"do-sqlite3","number":"0.2.2","dependencies":[["data-objects","0.0.0"]]},
  {"name":"do-sqlite3","number":"0.9.9","dependencies":[["data-objects","=0.9.9"],["hoe","1.8.2"]]},
  {"name":"do-sqlite3","number":"0.2.1","dependencies":[["data-objects","0.0.0"]]},
  {"name":"do-sqlite3","number":"0.10.6","dependencies":[["data-objects","=0.10.6"]]},
  {"name":"do-sqlite3","number":"0.10.10","dependencies":[["data-objects","=0.10.10"]]},
  {"name":"do-sqlite3","number":"0.10.11","dependencies":[["data-objects","=0.10.11"]]},
  {"name":"do-sqlite3","number":"0.10.12","dependencies":[["data-objects","=0.10.12"]]},
  {"name":"do-sqlite3","number":"0.10.13","dependencies":[["data-objects","=0.10.13"]]},
  {"name":"fastercsv","number":"0.1.4","dependencies":[]},
  {"name":"fastercsv","number":"1.1.0","dependencies":[]},
  {"name":"fastercsv","number":"1.1.1","dependencies":[]},
  {"name":"fastercsv","number":"0.1.0","dependencies":[]},
  {"name":"fastercsv","number":"1.5.3","dependencies":[]},
  {"name":"fastercsv","number":"1.0.0","dependencies":[]},
  {"name":"fastercsv","number":"1.2.2","dependencies":[]},
  {"name":"fastercsv","number":"1.2.0","dependencies":[]},
  {"name":"fastercsv","number":"0.1.9","dependencies":[]},
  {"name":"fastercsv","number":"0.1.8","dependencies":[]},
  {"name":"fastercsv","number":"0.2.0","dependencies":[]},
  {"name":"fastercsv","number":"1.2.3","dependencies":[]},
  {"name":"fastercsv","number":"0.1.2","dependencies":[]},
  {"name":"fastercsv","number":"0.1.1","dependencies":[]},
  {"name":"fastercsv","number":"0.1.3","dependencies":[]},
  {"name":"fastercsv","number":"0.2.1","dependencies":[]},
  {"name":"fastercsv","number":"1.2.1","dependencies":[]},
  {"name":"fastercsv","number":"1.5.1","dependencies":[]},
  {"name":"fastercsv","number":"1.5.0","dependencies":[]},
  {"name":"fastercsv","number":"1.4.0","dependencies":[]},
  {"name":"fastercsv","number":"0.1.6","dependencies":[]},
  {"name":"fastercsv","number":"1.5.4","dependencies":[]},
  {"name":"fastercsv","number":"1.5.5","dependencies":[]},
  {"name":"haml","number":"4.0.5","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.4","dependencies":[["tilt",null]]},
  {"name":"haml","number":"3.0.23","dependencies":[]},
  {"name":"haml","number":"2.2.13","dependencies":[]},
  {"name":"haml","number":"3.1.6","dependencies":[]},
  {"name":"haml","number":"1.8.2","dependencies":[]},
  {"name":"haml","number":"1.0.4","dependencies":[]},
  {"name":"haml","number":"2.2.4","dependencies":[]},
  {"name":"haml","number":"3.0.18","dependencies":[]},
  {"name":"haml","number":"3.0.2","dependencies":[]},
  {"name":"haml","number":"3.1.2","dependencies":[]},
  {"name":"haml","number":"2.0.9","dependencies":[]},
  {"name":"haml","number":"3.0.9","dependencies":[]},
  {"name":"haml","number":"2.2.12","dependencies":[]},
  {"name":"haml","number":"2.2.18","dependencies":[]},
  {"name":"haml","number":"2.2.1","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"1.0.0","dependencies":[]},
  {"name":"haml","number":"3.0.3","dependencies":[]},
  {"name":"haml","number":"3.0.13","dependencies":[]},
  {"name":"haml","number":"2.2.16","dependencies":[]},
  {"name":"haml","number":"1.5.2","dependencies":[]},
  {"name":"haml","number":"1.8.0","dependencies":[]},
  {"name":"haml","number":"3.0.16","dependencies":[]},
  {"name":"haml","number":"1.7.0","dependencies":[]},
  {"name":"haml","number":"2.2.17","dependencies":[]},
  {"name":"haml","number":"3.1.3","dependencies":[]},
  {"name":"haml","number":"2.0.4","dependencies":[]},
  {"name":"haml","number":"3.1.4","dependencies":[]},
  {"name":"haml","number":"1.0.5","dependencies":[]},
  {"name":"haml","number":"2.0.7","dependencies":[]},
  {"name":"haml","number":"2.2.24","dependencies":[]},
  {"name":"haml","number":"2.2.11","dependencies":[]},
  {"name":"haml","number":"3.0.14","dependencies":[]},
  {"name":"haml","number":"1.0.1","dependencies":[]},
  {"name":"haml","number":"2.2.20","dependencies":[]},
  {"name":"haml","number":"1.7.1","dependencies":[]},
  {"name":"haml","number":"2.2.9","dependencies":[]},
  {"name":"haml","number":"3.0.5","dependencies":[]},
  {"name":"haml","number":"3.0.7","dependencies":[]},
  {"name":"haml","number":"2.2.8","dependencies":[]},
  {"name":"haml","number":"3.0.4","dependencies":[]},
  {"name":"haml","number":"2.2.2","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"3.0.1","dependencies":[]},
  {"name":"haml","number":"2.0.8","dependencies":[]},
  {"name":"haml","number":"3.0.10","dependencies":[]},
  {"name":"haml","number":"2.0.6","dependencies":[]},
  {"name":"haml","number":"2.0.3","dependencies":[]},
  {"name":"haml","number":"3.0.24","dependencies":[]},
  {"name":"haml","number":"2.0.2","dependencies":[]},
  {"name":"haml","number":"1.5.0","dependencies":[]},
  {"name":"haml","number":"2.0.1","dependencies":[]},
  {"name":"haml","number":"3.1.1","dependencies":[]},
  {"name":"haml","number":"2.2.5","dependencies":[]},
  {"name":"haml","number":"2.2.3","dependencies":[]},
  {"name":"haml","number":"2.2.14","dependencies":[]},
  {"name":"haml","number":"3.1.5","dependencies":[]},
  {"name":"haml","number":"2.2.0","dependencies":[["yard",null],["maruku",null]]},
  {"name":"haml","number":"2.2.22","dependencies":[]},
  {"name":"haml","number":"2.2.23","dependencies":[]},
  {"name":"haml","number":"2.2.21","dependencies":[]},
  {"name":"haml","number":"2.2.15","dependencies":[]},
  {"name":"haml","number":"3.0.11","dependencies":[]},
  {"name":"haml","number":"3.0.25","dependencies":[]},
  {"name":"haml","number":"1.0.2","dependencies":[]},
  {"name":"haml","number":"3.0.17","dependencies":[]},
  {"name":"haml","number":"3.0.0","dependencies":[]},
  {"name":"haml","number":"2.0.0","dependencies":[]},
  {"name":"haml","number":"3.0.21","dependencies":[]},
  {"name":"haml","number":"2.2.6","dependencies":[]},
  {"name":"haml","number":"2.2.10","dependencies":[]},
  {"name":"haml","number":"2.0.5","dependencies":[]},
  {"name":"haml","number":"2.2.19","dependencies":[]},
  {"name":"haml","number":"3.0.22","dependencies":[]},
  {"name":"haml","number":"3.0.15","dependencies":[]},
  {"name":"haml","number":"3.0.12","dependencies":[]},
  {"name":"haml","number":"3.0.6","dependencies":[]},
  {"name":"haml","number":"3.1.0","dependencies":[]},
  {"name":"haml","number":"3.1.7","dependencies":[]},
  {"name":"haml","number":"1.8.1","dependencies":[]},
  {"name":"haml","number":"1.0.3","dependencies":[]},
  {"name":"haml","number":"1.5.1","dependencies":[]},
  {"name":"haml","number":"1.7.2","dependencies":[]},
  {"name":"haml","number":"2.0.10","dependencies":[]},
  {"name":"haml","number":"3.1.8","dependencies":[]},
  {"name":"haml","number":"4.0.0","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.1","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.2","dependencies":[["tilt",null]]},
  {"name":"haml","number":"4.0.3","dependencies":[["tilt",null]]},
  {"name":"highline","number":"1.6.21","dependencies":[]},
  {"name":"highline","number":"1.6.20","dependencies":[]},
  {"name":"highline","number":"1.6.10","dependencies":[]},
  {"name":"highline","number":"1.4.0","dependencies":[]},
  {"name":"highline","number":"1.2.1","dependencies":[]},
  {"name":"highline","number":"1.0.4","dependencies":[]},
  {"name":"highline","number":"1.2.5","dependencies":[]},
  {"name":"highline","number":"0.3.0","dependencies":[]},
  {"name":"highline","number":"0.6.1","dependencies":[]},
  {"name":"highline","number":"1.6.7","dependencies":[]},
  {"name":"highline","number":"1.0.2","dependencies":[]},
  {"name":"highline","number":"1.6.5","dependencies":[]},
  {"name":"highline","number":"1.0.0","dependencies":[]},
  {"name":"highline","number":"0.4.0","dependencies":[]},
  {"name":"highline","number":"1.6.9","dependencies":[]},
  {"name":"highline","number":"1.6.8","dependencies":[]},
  {"name":"highline","number":"1.2.3","dependencies":[]},
  {"name":"highline","number":"1.5.1","dependencies":[]},
  {"name":"highline","number":"1.6.6","dependencies":[]},
  {"name":"highline","number":"1.6.2","dependencies":[]},
  {"name":"highline","number":"1.6.1","dependencies":[]},
  {"name":"highline","number":"1.0.1","dependencies":[]},
  {"name":"highline","number":"1.2.6","dependencies":[]},
  {"name":"highline","number":"0.2.0","dependencies":[]},
  {"name":"highline","number":"1.2.4","dependencies":[]},
  {"name":"highline","number":"1.2.9","dependencies":[]},
  {"name":"highline","number":"1.5.0","dependencies":[]},
  {"name":"highline","number":"1.2.2","dependencies":[]},
  {"name":"highline","number":"1.2.7","dependencies":[]},
  {"name":"highline","number":"1.6.12","dependencies":[]},
  {"name":"highline","number":"1.6.14","dependencies":[]},
  {"name":"highline","number":"1.6.15","dependencies":[]},
  {"name":"highline","number":"1.6.13","dependencies":[]},
  {"name":"highline","number":"1.2.0","dependencies":[]},
  {"name":"highline","number":"1.6.11","dependencies":[]},
  {"name":"highline","number":"1.2.8","dependencies":[]},
  {"name":"highline","number":"1.5.2","dependencies":[]},
  {"name":"highline","number":"0.5.0","dependencies":[]},
  {"name":"highline","number":"1.6.16","dependencies":[]},
  {"name":"highline","number":"1.6.17","dependencies":[]},
  {"name":"highline","number":"1.6.18","dependencies":[]},
  {"name":"highline","number":"1.6.19","dependencies":[]},
  {"name":"json","number":"1.8.1","dependencies":[]},
  {"name":"json","number":"1.1.0","dependencies":[]},
  {"name":"json","number":"0.4.3","dependencies":[]},
  {"name":"json","number":"1.1.5","dependencies":[]},
  {"name":"json","number":"1.0.1","dependencies":[]},
  {"name":"json","number":"1.6.1","dependencies":[]},
  {"name":"json","number":"1.2.0","dependencies":[]},
  {"name":"json","number":"0.4.2","dependencies":[]},
  {"name":"json","number":"1.0.3","dependencies":[]},
  {"name":"json","number":"1.2.1","dependencies":[]},
  {"name":"json","number":"1.1.2","dependencies":[]},
  {"name":"json","number":"1.7.2","dependencies":[]},
  {"name":"json","number":"1.6.4","dependencies":[]},
  {"name":"json","number":"1.6.5","dependencies":[]},
  {"name":"json","number":"1.5.3","dependencies":[]},
  {"name":"json","number":"1.4.4","dependencies":[]},
  {"name":"json","number":"1.6.0","dependencies":[]},
  {"name":"json","number":"1.4.2","dependencies":[]},
  {"name":"json","number":"1.0.0","dependencies":[]},
  {"name":"json","number":"1.0.4","dependencies":[]},
  {"name":"json","number":"1.4.0","dependencies":[]},
  {"name":"json","number":"1.1.4","dependencies":[]},
  {"name":"json","number":"1.1.6","dependencies":[]},
  {"name":"json","number":"1.2.3","dependencies":[]},
  {"name":"json","number":"1.2.4","dependencies":[]},
  {"name":"json","number":"1.5.1","dependencies":[]},
  {"name":"json","number":"1.7.0","dependencies":[]},
  {"name":"json","number":"1.5.2","dependencies":[]},
  {"name":"json","number":"1.6.2","dependencies":[]},
  {"name":"json","number":"1.4.6","dependencies":[]},
  {"name":"json","number":"1.6.7","dependencies":[]},
  {"name":"json","number":"1.1.9","dependencies":[]},
  {"name":"json","number":"1.5.4","dependencies":[]},
  {"name":"json","number":"1.1.8","dependencies":[]},
  {"name":"json","number":"1.1.7","dependencies":[]},
  {"name":"json","number":"1.7.1","dependencies":[]},
  {"name":"json","number":"0.4.1","dependencies":[]},
  {"name":"json","number":"1.7.3","dependencies":[]},
  {"name":"json","number":"1.6.3","dependencies":[]},
  {"name":"json","number":"1.7.4","dependencies":[]},
  {"name":"json","number":"1.1.3","dependencies":[]},
  {"name":"json","number":"1.4.5","dependencies":[]},
  {"name":"json","number":"1.5.0","dependencies":[]},
  {"name":"json","number":"1.4.1","dependencies":[]},
  {"name":"json","number":"0.4.0","dependencies":[]},
  {"name":"json","number":"1.2.2","dependencies":[]},
  {"name":"json","number":"1.7.5","dependencies":[]},
  {"name":"json","number":"1.0.2","dependencies":[]},
  {"name":"json","number":"1.1.1","dependencies":[]},
  {"name":"json","number":"1.6.6","dependencies":[]},
  {"name":"json","number":"1.4.3","dependencies":[]},
  {"name":"json","number":"1.7.6","dependencies":[]},
  {"name":"json","number":"1.5.5","dependencies":[]},
  {"name":"json","number":"1.6.8","dependencies":[]},
  {"name":"json","number":"1.7.7","dependencies":[]},
  {"name":"json","number":"1.8.0","dependencies":[]},
  {"name":"json-pure","number":"1.8.1","dependencies":[]},
  {"name":"json-pure","number":"1.1.5","dependencies":[]},
  {"name":"json-pure","number":"1.4.4","dependencies":[]},
  {"name":"json-pure","number":"1.4.1","dependencies":[]},
  {"name":"json-pure","number":"1.4.0","dependencies":[]},
  {"name":"json-pure","number":"1.0.2","dependencies":[]},
  {"name":"json-pure","number":"1.0.0","dependencies":[]},
  {"name":"json-pure","number":"1.1.6","dependencies":[]},
  {"name":"json-pure","number":"1.1.3","dependencies":[]},
  {"name":"json-pure","number":"1.1.1","dependencies":[]},
  {"name":"json-pure","number":"1.6.2","dependencies":[]},
  {"name":"json-pure","number":"1.2.4","dependencies":[]},
  {"name":"json-pure","number":"1.7.2","dependencies":[]},
  {"name":"json-pure","number":"1.0.4","dependencies":[]},
  {"name":"json-pure","number":"1.1.0","dependencies":[]},
  {"name":"json-pure","number":"1.2.1","dependencies":[]},
  {"name":"json-pure","number":"1.5.4","dependencies":[]},
  {"name":"json-pure","number":"1.2.2","dependencies":[]},
  {"name":"json-pure","number":"1.6.6","dependencies":[]},
  {"name":"json-pure","number":"1.6.7","dependencies":[]},
  {"name":"json-pure","number":"1.7.1","dependencies":[]},
  {"name":"json-pure","number":"1.1.2","dependencies":[]},
  {"name":"json-pure","number":"1.0.1","dependencies":[]},
  {"name":"json-pure","number":"1.2.3","dependencies":[]},
  {"name":"json-pure","number":"1.5.2","dependencies":[]},
  {"name":"json-pure","number":"1.6.0","dependencies":[]},
  {"name":"json-pure","number":"1.5.3","dependencies":[]},
  {"name":"json-pure","number":"1.0.3","dependencies":[]},
  {"name":"json-pure","number":"1.7.0","dependencies":[]},
  {"name":"json-pure","number":"1.1.8","dependencies":[]},
  {"name":"json-pure","number":"1.4.3","dependencies":[]},
  {"name":"json-pure","number":"1.2.0","dependencies":[]},
  {"name":"json-pure","number":"1.4.6","dependencies":[]},
  {"name":"json-pure","number":"1.1.4","dependencies":[]},
  {"name":"json-pure","number":"1.5.1","dependencies":[]},
  {"name":"json-pure","number":"1.5.0","dependencies":[]},
  {"name":"json-pure","number":"1.6.1","dependencies":[]},
  {"name":"json-pure","number":"1.4.2","dependencies":[]},
  {"name":"json-pure","number":"1.4.5","dependencies":[]},
  {"name":"json-pure","number":"1.1.9","dependencies":[]},
  {"name":"json-pure","number":"1.1.7","dependencies":[]},
  {"name":"json-pure","number":"1.6.3","dependencies":[]},
  {"name":"json-pure","number":"1.6.4","dependencies":[]},
  {"name":"json-pure","number":"1.6.5","dependencies":[]},
  {"name":"json-pure","number":"1.7.3","dependencies":[]},
  {"name":"json-pure","number":"1.7.4","dependencies":[]},
  {"name":"json-pure","number":"1.7.5","dependencies":[]},
  {"name":"json-pure","number":"1.7.6","dependencies":[]},
  {"name":"json-pure","number":"1.7.7","dependencies":[]},
  {"name":"json-pure","number":"1.5.5","dependencies":[]},
  {"name":"json-pure","number":"1.6.8","dependencies":[]},
  {"name":"json-pure","number":"1.8.0","dependencies":[]},
  {"name":"multi-json","number":"1.9.2","dependencies":[]},
  {"name":"multi-json","number":"1.9.1","dependencies":[]},
  {"name":"multi-json","number":"1.9.0","dependencies":[]},
  {"name":"multi-json","number":"1.8.4","dependencies":[]},
  {"name":"multi-json","number":"1.8.3","dependencies":[]},
  {"name":"multi-json","number":"1.8.2","dependencies":[]},
  {"name":"multi-json","number":"1.8.1","dependencies":[]},
  {"name":"multi-json","number":"1.3.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.2","dependencies":[]},
  {"name":"multi-json","number":"0.0.5","dependencies":[]},
  {"name":"multi-json","number":"1.1.0","dependencies":[]},
  {"name":"multi-json","number":"1.2.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.2","dependencies":[]},
  {"name":"multi-json","number":"1.0.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.5","dependencies":[]},
  {"name":"multi-json","number":"1.3.6","dependencies":[]},
  {"name":"multi-json","number":"0.0.4","dependencies":[]},
  {"name":"multi-json","number":"1.0.1","dependencies":[]},
  {"name":"multi-json","number":"0.0.2","dependencies":[]},
  {"name":"multi-json","number":"0.0.3","dependencies":[]},
  {"name":"multi-json","number":"1.0.3","dependencies":[]},
  {"name":"multi-json","number":"1.3.7","dependencies":[]},
  {"name":"multi-json","number":"1.4.0","dependencies":[]},
  {"name":"multi-json","number":"1.5.0","dependencies":[]},
  {"name":"multi-json","number":"1.3.1","dependencies":[]},
  {"name":"multi-json","number":"1.3.3","dependencies":[]},
  {"name":"multi-json","number":"1.3.0","dependencies":[]},
  {"name":"multi-json","number":"1.5.1","dependencies":[]},
  {"name":"multi-json","number":"1.6.0","dependencies":[]},
  {"name":"multi-json","number":"1.6.1","dependencies":[]},
  {"name":"multi-json","number":"1.8.0","dependencies":[]},
  {"name":"multi-json","number":"1.7.0","dependencies":[]},
  {"name":"multi-json","number":"1.7.1","dependencies":[]},
  {"name":"multi-json","number":"1.7.2","dependencies":[]},
  {"name":"multi-json","number":"1.7.3","dependencies":[]},
  {"name":"multi-json","number":"1.7.4","dependencies":[]},
  {"name":"multi-json","number":"1.7.5","dependencies":[]},
  {"name":"multi-json","number":"1.7.6","dependencies":[]},
  {"name":"multi-json","number":"1.7.7","dependencies":[]},
  {"name":"multi-json","number":"1.7.8","dependencies":[]},
  {"name":"multi-json","number":"1.7.9","dependencies":[]},
  {"name":"net-scp","number":"1.0.2","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.3","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.1","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.0","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.0.4","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-scp","number":"1.1.0","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-scp","number":"1.1.1","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-scp","number":"1.1.2","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-sftp","number":"1.0.0","dependencies":[["net-ssh",null]]},
  {"name":"net-sftp","number":"0.5.0","dependencies":[["net-ssh",null]]},
  {"name":"net-sftp","number":"0.9.0","dependencies":[["net-ssh",null]]},
  {"name":"net-sftp","number":"1.0.1","dependencies":[["net-ssh","1.0.0 || 2.0.0"]]},
  {"name":"net-sftp","number":"1.1.0","dependencies":[["net-ssh","1.0.0 || 2.0.0"]]},
  {"name":"net-sftp","number":"2.0.5","dependencies":[["net-ssh","2.0.9"]]},
  {"name":"net-sftp","number":"2.0.4","dependencies":[["net-ssh","2.0.9"]]},
  {"name":"net-sftp","number":"2.0.3","dependencies":[["net-ssh","2.0.9"]]},
  {"name":"net-sftp","number":"2.0.2","dependencies":[["net-ssh","2.0.9"],["echoe",null]]},
  {"name":"net-sftp","number":"2.0.1","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-sftp","number":"2.0.0","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-sftp","number":"1.1.1","dependencies":[["net-ssh","1.0.0 || 2.0.0"],["net-ssh","1.0.0 || 2.0.0"]]},
  {"name":"net-sftp","number":"2.1.0","dependencies":[["net-ssh","2.6.4"]]},
  {"name":"net-sftp","number":"2.1.1","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-sftp","number":"2.1.2","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"net-ssh","number":"2.8.0","dependencies":[]},
  {"name":"net-ssh","number":"2.7.0","dependencies":[]},
  {"name":"net-ssh","number":"2.0.23","dependencies":[]},
  {"name":"net-ssh","number":"1.0.5","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.1.4","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.1.1","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.1","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.22","dependencies":[]},
  {"name":"net-ssh","number":"2.0.18","dependencies":[]},
  {"name":"net-ssh","number":"1.1.3","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"0.9.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"0.5.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.8","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.11","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.0","dependencies":[]},
  {"name":"net-ssh","number":"1.0.7","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.20","dependencies":[]},
  {"name":"net-ssh","number":"2.0.6","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.1.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.1.3","dependencies":[]},
  {"name":"net-ssh","number":"2.0.13","dependencies":[]},
  {"name":"net-ssh","number":"2.0.7","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.2","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.2.1","dependencies":[]},
  {"name":"net-ssh","number":"2.3.0","dependencies":[]},
  {"name":"net-ssh","number":"2.0.24","dependencies":[]},
  {"name":"net-ssh","number":"2.0.1","dependencies":[]},
  {"name":"net-ssh","number":"2.0.2","dependencies":[]},
  {"name":"net-ssh","number":"1.0.9","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.1.0","dependencies":[]},
  {"name":"net-ssh","number":"1.1.2","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.10","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.6","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.19","dependencies":[]},
  {"name":"net-ssh","number":"2.0.5","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"1.0.3","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.10","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.2.2","dependencies":[]},
  {"name":"net-ssh","number":"2.0.14","dependencies":[]},
  {"name":"net-ssh","number":"2.0.8","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.16","dependencies":[]},
  {"name":"net-ssh","number":"2.0.15","dependencies":[]},
  {"name":"net-ssh","number":"2.0.17","dependencies":[]},
  {"name":"net-ssh","number":"2.0.21","dependencies":[]},
  {"name":"net-ssh","number":"0.6.0","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"1.0.4","dependencies":[["needle","1.2.0"]]},
  {"name":"net-ssh","number":"2.0.9","dependencies":[["echoe",null]]},
  {"name":"net-ssh","number":"2.0.3","dependencies":[]},
  {"name":"net-ssh","number":"2.0.4","dependencies":[]},
  {"name":"net-ssh","number":"2.1.4","dependencies":[]},
  {"name":"net-ssh","number":"2.2.0","dependencies":[]},
  {"name":"net-ssh","number":"2.5.2","dependencies":[]},
  {"name":"net-ssh","number":"2.6.1","dependencies":[]},
  {"name":"net-ssh","number":"2.6.2","dependencies":[]},
  {"name":"net-ssh","number":"2.6.3","dependencies":[]},
  {"name":"net-ssh","number":"2.6.4","dependencies":[]},
  {"name":"net-ssh","number":"2.6.5","dependencies":[]},
  {"name":"net-ssh","number":"2.6.6","dependencies":[]},
  {"name":"net-ssh","number":"2.6.7","dependencies":[]},
  {"name":"net-ssh","number":"2.6.8","dependencies":[]},
  {"name":"net-ssh-gateway","number":"1.0.1","dependencies":[["net-ssh","1.99.1 || 2.0.0"],["echoe",null]]},
  {"name":"net-ssh-gateway","number":"1.0.0","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-ssh-gateway","number":"1.1.0","dependencies":[["net-ssh","1.99.1 || 2.0.0"]]},
  {"name":"net-ssh-gateway","number":"1.2.0","dependencies":[["net-ssh","2.6.5"]]},
  {"name":"rack","number":"0.9.0","dependencies":[["test-spec",null],["camping",null],["fcgi",null],["memcache-client",null],["mongrel",null],["ruby-openid","2.0.0"],["thin",null]]},
  {"name":"rack","number":"1.1.3","dependencies":[]},
  {"name":"rack","number":"1.1.0","dependencies":[]},
  {"name":"rack","number":"1.2.3","dependencies":[]},
  {"name":"rack","number":"1.2.2","dependencies":[]},
  {"name":"rack","number":"0.2.0","dependencies":[]},
  {"name":"rack","number":"0.4.0","dependencies":[]},
  {"name":"rack","number":"1.1.1","dependencies":[]},
  {"name":"rack","number":"1.2.0","dependencies":[]},
  {"name":"rack","number":"1.2.1","dependencies":[]},
  {"name":"rack","number":"1.0.0","dependencies":[["test-spec",null],["camping",null],["fcgi",null],["memcache-client",null],["mongrel",null],["ruby-openid","2.0.0"],["thin",null]]},
  {"name":"rack","number":"1.3.2","dependencies":[]},
  {"name":"rack","number":"1.3.3","dependencies":[]},
  {"name":"rack","number":"1.0.1","dependencies":[]},
  {"name":"rack","number":"0.3.0","dependencies":[]},
  {"name":"rack","number":"0.1.0","dependencies":[]},
  {"name":"rack","number":"0.9.1","dependencies":[]},
  {"name":"rack","number":"1.1.2","dependencies":[]},
  {"name":"rack","number":"1.2.4","dependencies":[]},
  {"name":"rack","number":"1.2.5","dependencies":[]},
  {"name":"rack","number":"1.3.5","dependencies":[]},
  {"name":"rack","number":"1.3.0","dependencies":[]},
  {"name":"rack","number":"1.3.1","dependencies":[]},
  {"name":"rack","number":"1.3.4","dependencies":[]},
  {"name":"rack","number":"1.3.6","dependencies":[]},
  {"name":"rack","number":"1.4.0","dependencies":[]},
  {"name":"rack","number":"1.4.1","dependencies":[]},
  {"name":"rack","number":"1.3.7","dependencies":[]},
  {"name":"rack","number":"1.4.2","dependencies":[]},
  {"name":"rack","number":"1.1.4","dependencies":[]},
  {"name":"rack","number":"1.2.6","dependencies":[]},
  {"name":"rack","number":"1.3.8","dependencies":[]},
  {"name":"rack","number":"1.4.3","dependencies":[]},
  {"name":"rack","number":"1.2.7","dependencies":[]},
  {"name":"rack","number":"1.4.4","dependencies":[]},
  {"name":"rack","number":"1.1.5","dependencies":[]},
  {"name":"rack","number":"1.3.9","dependencies":[]},
  {"name":"rack","number":"1.5.0","dependencies":[]},
  {"name":"rack","number":"1.5.1","dependencies":[]},
  {"name":"rack","number":"1.2.8","dependencies":[]},
  {"name":"rack","number":"1.4.5","dependencies":[]},
  {"name":"rack","number":"1.1.6","dependencies":[]},
  {"name":"rack","number":"1.3.10","dependencies":[]},
  {"name":"rack","number":"1.5.2","dependencies":[]},
  {"name":"rack-protection","number":"1.5.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.5.1","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.3","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.4","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"0.1.0","dependencies":[["rack",null],["escape-utils",null]]},
  {"name":"rack-protection","number":"1.2.0","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.1.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.0.0","dependencies":[["rack",null],["escape-utils",null]]},
  {"name":"rack-protection","number":"1.3.1","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.3.2","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.4.0","dependencies":[["rack",null]]},
  {"name":"rack-protection","number":"1.5.0","dependencies":[["rack",null]]},
  {"name":"sass","number":"3.2.18","dependencies":[]},
  {"name":"sass","number":"3.3.4","dependencies":[]},
  {"name":"sass","number":"3.2.17","dependencies":[]},
  {"name":"sass","number":"3.2.16","dependencies":[]},
  {"name":"sass","number":"3.3.3","dependencies":[]},
  {"name":"sass","number":"3.3.2","dependencies":[]},
  {"name":"sass","number":"3.3.1","dependencies":[]},
  {"name":"sass","number":"3.3.0","dependencies":[["rake",null]]},
  {"name":"sass","number":"3.2.15","dependencies":[]},
  {"name":"sass","number":"3.2.14","dependencies":[]},
  {"name":"sass","number":"3.2.13","dependencies":[]},
  {"name":"sass","number":"3.2.12","dependencies":[]},
  {"name":"sass","number":"3.2.11","dependencies":[]},
  {"name":"sass","number":"3.1.6","dependencies":[]},
  {"name":"sass","number":"3.1.14","dependencies":[]},
  {"name":"sass","number":"3.1.1","dependencies":[]},
  {"name":"sass","number":"3.1.13","dependencies":[]},
  {"name":"sass","number":"3.1.11","dependencies":[]},
  {"name":"sass","number":"3.1.9","dependencies":[]},
  {"name":"sass","number":"3.1.18","dependencies":[]},
  {"name":"sass","number":"3.1.19","dependencies":[]},
  {"name":"sass","number":"3.1.20","dependencies":[]},
  {"name":"sass","number":"3.1.7","dependencies":[]},
  {"name":"sass","number":"3.2.1","dependencies":[]},
  {"name":"sass","number":"3.1.8","dependencies":[]},
  {"name":"sass","number":"3.1.0","dependencies":[]},
  {"name":"sass","number":"3.1.3","dependencies":[]},
  {"name":"sass","number":"3.1.15","dependencies":[]},
  {"name":"sass","number":"3.1.12","dependencies":[]},
  {"name":"sass","number":"3.1.21","dependencies":[]},
  {"name":"sass","number":"3.1.2","dependencies":[]},
  {"name":"sass","number":"3.1.4","dependencies":[]},
  {"name":"sass","number":"3.1.17","dependencies":[]},
  {"name":"sass","number":"3.1.10","dependencies":[]},
  {"name":"sass","number":"3.1.5","dependencies":[]},
  {"name":"sass","number":"3.2.0","dependencies":[]},
  {"name":"sass","number":"3.1.16","dependencies":[]},
  {"name":"sass","number":"3.2.2","dependencies":[]},
  {"name":"sass","number":"3.2.3","dependencies":[]},
  {"name":"sass","number":"3.2.4","dependencies":[]},
  {"name":"sass","number":"3.2.5","dependencies":[]},
  {"name":"sass","number":"3.2.6","dependencies":[]},
  {"name":"sass","number":"3.2.7","dependencies":[]},
  {"name":"sass","number":"3.2.8","dependencies":[]},
  {"name":"sass","number":"3.2.9","dependencies":[]},
  {"name":"sass","number":"3.2.10","dependencies":[]},
  {"name":"shotgun","number":"0.6.0","dependencies":[["rack",null]]},
  {"name":"shotgun","number":"0.4.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.5.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.7.0","dependencies":[["rack","1.0.0"]]},
  {"name":"shotgun","number":"0.8.0","dependencies":[["rack","1.0.0"]]},
  {"name":"shotgun","number":"0.2.0","dependencies":[["rack",null],["launchy",null],["rack",null],["launchy",null]]},
  {"name":"shotgun","number":"0.1.0","dependencies":[["rack",null],["rack",null]]},
  {"name":"shotgun","number":"0.3.0","dependencies":[["rack",null],["launchy",null],["launchy",null]]},
  {"name":"shotgun","number":"0.9.0","dependencies":[["rack","1.0.0"]]},
  {"name":"sinatra","number":"1.4.4","dependencies":[["rack-protection","1.4.0"],["tilt","1.3.4 || 2.0.0"],["rack","1.4.0"]]},
  {"name":"sinatra","number":"0.3.3","dependencies":[["rack","0.4.0 || 1.0.0"]]},
  {"name":"sinatra","number":"1.1.2","dependencies":[["rack","1.1.0"],["tilt","1.2.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.2.0","dependencies":[["mongrel","1.0.1"],["rack",null],["rack","=0.3.0"]]},
  {"name":"sinatra","number":"0.1.6","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"0.2.2","dependencies":[["mongrel","1.0.1"]]},
  {"name":"sinatra","number":"0.1.5","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"0.1.7","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"1.2.6","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.3.2","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"0.1.0","dependencies":[["mongrel","1.0.1"],["rack",null]]},
  {"name":"sinatra","number":"1.2.3","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.2","dependencies":[["rack",null],["shotgun",null],["rack-test",null]]},
  {"name":"sinatra","number":"1.2.0","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.1.3","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.2.7","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.6","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"0.2.1","dependencies":[["mongrel","1.0.1"]]},
  {"name":"sinatra","number":"0.3.0","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.1.4","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.5","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.3.0","dependencies":[["rack","1.3.0"],["rack-protection","1.1.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.3.1","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.2.1","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.6","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"0.9.4","dependencies":[["rack",null],["shotgun",null],["rack-test",null]]},
  {"name":"sinatra","number":"1.1.0","dependencies":[["rack","1.1.0"],["tilt","1.1.0 || 2.0.0"]]},
  {"name":"sinatra","number":"0.9.1","dependencies":[["rack",null],["rack",null]]},
  {"name":"sinatra","number":"0.9.0","dependencies":[["rack",null]]},
  {"name":"sinatra","number":"1.2.2","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.0.0","dependencies":[["rack","1.0.0"]]},
  {"name":"sinatra","number":"1.2.8","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.1","dependencies":[["rack","1.3.0"],["rack-protection","1.1.0"],["tilt","1.3.0 || 2.0.0"],["rack","1.3.4"],["rack-protection","1.1.2"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.2","dependencies":[["rack","1.3.6"],["rack-protection","1.2.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.3","dependencies":[["rack","1.3.6"],["rack-protection","1.2.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.4","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.3 || 2.0.0"]]},
  {"name":"sinatra","number":"1.3.5","dependencies":[["rack","1.4.0"],["rack-protection","1.3.0"],["tilt","1.3.0 || 2.0.0"]]},
  {"name":"sinatra","number":"1.2.9","dependencies":[["rack","1.1.0"],["tilt","1.2.2 || 2.0.0"],["backports",null]]},
  {"name":"sinatra","number":"1.4.1","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.0","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.2","dependencies":[["rack","1.5.2"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sinatra","number":"1.4.3","dependencies":[["rack","1.4.0"],["tilt","1.3.4 || 2.0.0"],["rack-protection","1.4.0"]]},
  {"name":"sqlite3","number":"1.3.9","dependencies":[]},
  {"name":"sqlite3","number":"0.0.7","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.0.0","dependencies":[]},
  {"name":"sqlite3","number":"0.0.6","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.0.5","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.0.4","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.0.3","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"1.3.5","dependencies":[]},
  {"name":"sqlite3","number":"0.0.8","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"1.3.6","dependencies":[]},
  {"name":"sqlite3","number":"1.3.4","dependencies":[]},
  {"name":"sqlite3","number":"1.3.3","dependencies":[]},
  {"name":"sqlite3","number":"0.0.1","dependencies":[]},
  {"name":"sqlite3","number":"0.0.2","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.1.0","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"0.1.1","dependencies":[["ffi",null]]},
  {"name":"sqlite3","number":"1.3.7","dependencies":[]},
  {"name":"sqlite3","number":"1.3.8","dependencies":[]},
  {"name":"stringex","number":"2.5.1","dependencies":[]},
  {"name":"stringex","number":"2.5.0","dependencies":[]},
  {"name":"stringex","number":"2.4.2","dependencies":[]},
  {"name":"stringex","number":"2.4.1","dependencies":[]},
  {"name":"stringex","number":"2.3.0","dependencies":[]},
  {"name":"stringex","number":"2.2.2","dependencies":[]},
  {"name":"stringex","number":"2.2.1","dependencies":[]},
  {"name":"stringex","number":"2.2.0","dependencies":[]},
  {"name":"stringex","number":"2.1.2","dependencies":[]},
  {"name":"stringex","number":"2.1.1","dependencies":[]},
  {"name":"stringex","number":"2.1.0","dependencies":[]},
  {"name":"stringex","number":"1.3.2","dependencies":[]},
  {"name":"stringex","number":"1.3.3","dependencies":[]},
  {"name":"stringex","number":"1.4.0","dependencies":[]},
  {"name":"stringex","number":"1.1.0","dependencies":[]},
  {"name":"stringex","number":"1.0.3","dependencies":[]},
  {"name":"stringex","number":"1.0.0","dependencies":[]},
  {"name":"stringex","number":"1.0.1","dependencies":[]},
  {"name":"stringex","number":"1.0.2","dependencies":[]},
  {"name":"stringex","number":"1.3.1","dependencies":[]},
  {"name":"stringex","number":"1.2.0","dependencies":[]},
  {"name":"stringex","number":"1.2.1","dependencies":[]},
  {"name":"stringex","number":"1.2.2","dependencies":[]},
  {"name":"stringex","number":"1.3.0","dependencies":[]},
  {"name":"stringex","number":"1.5.0","dependencies":[["stringex",null]]},
  {"name":"stringex","number":"1.5.1","dependencies":[]},
  {"name":"stringex","number":"2.0.0","dependencies":[]},
  {"name":"stringex","number":"2.0.1","dependencies":[]},
  {"name":"stringex","number":"2.0.2","dependencies":[]},
  {"name":"stringex","number":"2.0.3","dependencies":[]},
  {"name":"stringex","number":"2.0.4","dependencies":[]},
  {"name":"stringex","number":"2.0.5","dependencies":[]},
  {"name":"stringex","number":"2.0.6","dependencies":[]},
  {"name":"stringex","number":"2.0.7","dependencies":[]},
  {"name":"stringex","number":"2.0.8","dependencies":[]},
  {"name":"stringex","number":"2.0.9","dependencies":[]},
  {"name":"stringex","number":"2.0.10","dependencies":[]},
  {"name":"stringex","number":"2.0.11","dependencies":[]},
  {"name":"tilt","number":"2.0.1","dependencies":[]},
  {"name":"tilt","number":"2.0.0","dependencies":[]},
  {"name":"tilt","number":"1.3.2","dependencies":[]},
  {"name":"tilt","number":"1.3.1","dependencies":[]},
  {"name":"tilt","number":"0.8.0","dependencies":[]},
  {"name":"tilt","number":"1.2.1","dependencies":[]},
  {"name":"tilt","number":"1.0.1","dependencies":[]},
  {"name":"tilt","number":"0.9.0","dependencies":[]},
  {"name":"tilt","number":"0.2.0","dependencies":[]},
  {"name":"tilt","number":"1.1.0","dependencies":[]},
  {"name":"tilt","number":"0.3.0","dependencies":[]},
  {"name":"tilt","number":"0.5.0","dependencies":[]},
  {"name":"tilt","number":"1.0.0","dependencies":[]},
  {"name":"tilt","number":"0.4.0","dependencies":[]},
  {"name":"tilt","number":"1.2.0","dependencies":[]},
  {"name":"tilt","number":"0.10.0","dependencies":[]},
  {"name":"tilt","number":"0.7.0","dependencies":[]},
  {"name":"tilt","number":"0.6.0","dependencies":[]},
  {"name":"tilt","number":"1.3.0","dependencies":[]},
  {"name":"tilt","number":"1.3.3","dependencies":[]},
  {"name":"tilt","number":"1.2.2","dependencies":[]},
  {"name":"tilt","number":"1.3.4","dependencies":[]},
  {"name":"tilt","number":"1.3.5","dependencies":[]},
  {"name":"tilt","number":"1.3.6","dependencies":[]},
  {"name":"tilt","number":"1.3.7","dependencies":[]},
  {"name":"tilt","number":"1.4.0","dependencies":[]},
  {"name":"tilt","number":"1.4.1","dependencies":[]},
  {"name":"uuidtools","number":"1.0.3","dependencies":[]},
  {"name":"uuidtools","number":"2.1.0","dependencies":[]},
  {"name":"uuidtools","number":"1.0.7","dependencies":[["rake",null],["rspec","1.1.11 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"uuidtools","number":"2.1.1","dependencies":[]},
  {"name":"uuidtools","number":"0.1.3","dependencies":[]},
  {"name":"uuidtools","number":"1.0.6","dependencies":[["rake",null],["rspec","1.1.11 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"uuidtools","number":"0.1.4","dependencies":[]},
  {"name":"uuidtools","number":"1.0.2","dependencies":[]},
  {"name":"uuidtools","number":"2.1.2","dependencies":[]},
  {"name":"uuidtools","number":"0.1.2","dependencies":[]},
  {"name":"uuidtools","number":"0.1.1","dependencies":[]},
  {"name":"uuidtools","number":"0.1.0","dependencies":[]},
  {"name":"uuidtools","number":"1.0.5","dependencies":[["rake",null],["rspec","1.1.11 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"uuidtools","number":"1.0.0","dependencies":[]},
  {"name":"uuidtools","number":"1.0.1","dependencies":[]},
  {"name":"uuidtools","number":"2.0.0","dependencies":[["rake",null],["rspec","1.1.11 || 2.0.0 || 3.0.0"],["launchy",null]]},
  {"name":"uuidtools","number":"1.0.4","dependencies":[["rake",null],["rspec","1.0.8 || 2.0.0 || 3.0.0"]]},
  {"name":"uuidtools","number":"2.1.3","dependencies":[]},
  {"name":"uuidtools","number":"2.1.4","dependencies":[]}
];
