---
title: User Interfaces
description: General tips for structuring your UI code, independent of your view rendering technology.
discourseTopicId: 19665
---

<h2 id="view-layers">View layers</h2>

Meteor supports many view layers.

The most popular are:
- [React](react.html): official [page](http://reactjs.org/)
- [Blaze](blaze.html): official [page](http://blazejs.org/)
- [Angular](http://www.angular-meteor.com): official [page](https://angular.io/)
- [Vue](vue.html): official [page](https://vuejs.org/)
- [Svelte](https://www.meteor.com/tutorials/svelte/creating-an-app): official [page](https://svelte.dev/)

If you are starting with web development we recommend that you use Blaze as it's very simple to learn.

Now if you are an advanced developer or already have a view layer library that you prefer Meteor is not going to get in your way. Just go ahead with your preferred one.

Each view layer library has trade-offs. Check the official page of each one to understand more or try all of them yourself with Meteor.

As Meteor simplifies a lot the set up of new apps you can try them all in a short time, follow our [tutorials](https://www.meteor.com/developers/tutorials) for a step-by-step guide.
