---
title: Changelog
order: 1001
description: A log of significant changes to the Meteor Guide.
---
- 2021/07/21: Added "Apollo" article
- 2021/07/20: Tweaked VueJS navigation structure and updated some information. Mention Picker in server-side routing.
- 2020/09/13: Removed the section about crosswalk from the Cordova guide
- 2020/08/08: Added "Hot Code Push" guide
- 2020/04/26: Added "React Native" section to build, and renamed "Mobile" to "Cordova"
- 2020/02/03: Added "Preventing unnecessary data retrieval" section to Accounts
- 2018/10/23: Added VueJS SSR Rendering for Meteor guide
- 2018/10/14: Added VueJS Integration guide
- 2018/03/03: Added HTTP Headers to the production security section and made Helmet the official recommendation. Update Mobile section to refer to HTTP header section for CSP instead of Browser Policy package. [#750](https://github.com/meteor/guide/pull/750)
- 2017/10/28: Removed mention of `react-addons-pure-render-mixin` package from "Using Meteor's data system" section as it is no longer needed.
- 2017/09/08: Updated "Using Meteor's data system" section to describe the new `withTracker` function as it now replaces `createContainer`.
- 2017/03/22: Added Docker section within Deployment and Monitoring.
- 2017/03/05: Updated "Testing" to use the replacement `dispatch:mocha` package instead of the previous suggestions from `dispatch:*`. [PR#618](https://github.com/meteor/guide/pull/618) [PR#614](https://github.com/meteor/guide/pull/614)
- 2017/02/08: Updated MongoDb hosting services with more details and recommendations. [PR#609](https://github.com/meteor/guide/pull/609)
- 2017/01/19: Updated recommendations for forcing SSL to avoid the `force-ssl` package when possible.
- 2017/01/07: Created new section "TypeScript".
- 2017/01/04: Changed "Testing" section to reference `dburles:factory` in the same spirit as the `meteor/todos` app [PR #598](https://github.com/meteor/guide/pull/598)
- 2016/07/02: Created new section in ui-ux on use of i18n with React.
- 2016/05/28: Created new section "A simple React unit test" [PR #466](https://github.com/meteor/guide/pull/466).
- 2016/05/22: Created new section "Testing publications" for separated `publication-collector` package (as [discussed here](https://github.com/meteor/todos/issues/119)).
- 2016/05/05: Changed Build Section organization to separate Atmosphere and npm.  [Discussed here](https://github.com/meteor/guide/pull/390#issuecomment-212577341). [PR #410](https://github.com/meteor/guide/pull/410)
- 2016/04/16: Switch order of Code Style and Application structure sections. [PR #383](https://github.com/meteor/guide/pull/383)
- 2016/04/16: Added [Writing Packages - Creating an npm package](https://guide.meteor.com/writing-packages.html#creating-npm) and [Using Packages - Overriding packages - npm](https://guide.meteor.com/using-packages.html#npm-overriding). [PR #381](https://github.com/meteor/guide/pull/381)
- 2016/04/16: Added "Writing Packages - Creating an npm package" and "Using Packages - Overriding packages - npm". [PR #381](https://github.com/meteor/guide/pull/381)
Fixed old changelog PR reference
- 2016/04/07: Add more examples and details on application structure using imports. [PR #356](https://github.com/meteor/guide/pull/356)
- 2016/04/04: Add more content on writing and publishing Atmosphere packages. [PR #339](https://github.com/meteor/guide/pull/339)
- 2016/04/03: Add back in build tool default loading order rules. [PR #340](https://github.com/meteor/guide/pull/340)
- 2016/04/01: Added CoffeeScript exports syntax. [PR #328](https://github.com/meteor/guide/pull/328)
- 2016/04/01: Changed Mocha test code snippets to use function expressions instead of arrow functions, after the discussion on [Issue #318](https://github.com/meteor/guide/issues/318). [PR #323](https://github.com/meteor/guide/pull/323)
- 2016/04/01: Added `gadicc:blaze-react-component` in a new "Blaze in React" section of the React article. [PR #325](https://github.com/meteor/guide/pull/325)
- 2016/03/31: Added Chromatic demo video and React Storybook to User Interfaces article. [PR #320](https://github.com/meteor/guide/pull/320)

Changelog is only tracked since the Meteor 1.3 release.
