---
title: Migrating to Meteor 2.9
description: How to migrate your application to Meteor 2.9.
---

Meteor `2.9` introduces some changes in the `accounts` packages, the new method `Email.sendAsync`, the new method `Meteor.userAsync`, and more. For a complete breakdown of the changes, please refer to the [changelog](http://docs.meteor.com/changelog.html).


<h3 id="why-like-this">Why is this new API important?</h3>

You may know that on Meteor we use a package called [Fibers](https://github.com/laverdet/node-fibers). This package is what makes it possible to call an async function inside Meteor in a sync way (without having to wait for the promise to resolve).  

But starting from Node 16, Fibers will stop working, so Meteor needs to move away from Fibers, otherwise, we'll be stuck on Node 14.

If you want to know more about the plan, you can check this [discussion](https://github.com/meteor/meteor/discussions/11505).

<h3 id="why-now">Why doing this change now?</h3>

This will be a considerable change for older Meteor applications, and some parts of the code of any Meteor app will have to be adjusted eventually. So it's important to start the migration process as soon as possible.

The migration process started in version 2.8. We recommend you [check that out](2.8-migration.htm) first in case you skipped.

<h3 id="should-i-update">Can I update to this version without changing my app?</h3>

Yes. You can update to this version without changing your app.

<h2 id="what-is-new">What's new?</h2>

Let's start with the accounts and OAuth packages. Some methods had to be restructured to work without Fibers in the future. The current methods will continue working as of today, but if you use some of the methods we'll mention below in custom login packages, we recommend you adapt them.

Internal methods that are now async:

- **_attemptLogin**
- **_loginMethod**
- **_runLoginHandlers**
- **Accounts._checkPassword**:  still works as always, but now has a new version called `Accounts._checkPasswordAsync`.


We also have changes to asynchronous context in the registry of handlers for OAuth services.

Now, the OAuth.Register method accepts an async handler, and it is possible to use the await option internally, avoiding to use methods that run on Fibers, such as **HTTP** (deprecated Meteor package), `Meteor.wrapAsync` and `Promise.await`.

Before the changes you would have something like:

```js
OAuth.registerService('github', 2, null, (query) => {
  const accessTokenCall = Meteor.wrapAsync(getAccessToken);
  const accessToken = accessTokenCall(query);
  const identityCall = Meteor.wrapAsync(getIdentity);
…
});
```

Now you have:

```js
OAuth.registerService('github', 2, null, async (query) => {
  const accessToken = await getAccessToken(query);
  const identity = await getIdentity(accessToken);
  const emails = await getEmails(accessToken);
…
});
```

<h3 id="new-async-methods">New async methods</h3>

We now have async version of methods that you already use. They are:

- [Email.sendAsync()](https://github.com/meteor/meteor/pull/12101/files#diff-b2453acdfd34fb563a1e258956d2733ab06a2aa77c87e402cfa53a86a48133a8R86-R107)
- [Meteor.userAsync()](https://github.com/meteor/meteor/pull/12274)
- [CssTools.minifyCssAsync()](https://github.com/meteor/meteor/pull/12105)

<h3 id="breaking-async">Breaking async</h3>

`Accounts.createUserVerifyingEmail` is now completely async:

- [Accounts.createUserVerifyingEmail](https://github.com/meteor/meteor/issues/12398)

To upgrade change from
```js
Meteor.methods({
  createUserAccount (user) {
    /**
     * This seems to be the issue.
     * Using the other method `createUser` works as expected.
     */
    Accounts.createUserVerifyingEmail({
      username: user.username,
      email: user.email,
      password: user.password,
    });
  }
});
```

to

```js
Meteor.methods({
  async createUserAccount (user) {
    await Accounts.createUserVerifyingEmail({
      username: user.username,
      email: user.email,
      password: user.password,
    });
  }
});
```

<h3 id="accounts-base">Accounts-base without service-configuration</h3>

Now `accounts-base` is [no longer tied up](https://github.com/meteor/meteor/pull/12202) with `service-configuration`. So, if you don't use third-party login on your project, you don't need to add the package `service-configuration` anymore.

<h2 id="older-versions">Migrating from a version older than 2.8?</h2>

If you're migrating from a version of Meteor older than Meteor 2.8, there may be important considerations not listed in this guide. Please review the older migration guides for details:

* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
