---
title: Migrating to Meteor 2.14
description: How to migrate your application to Meteor 2.14.
---

Most of the new features in Meteor 2.14 are either applied directly behind the
scenes (in a backwards compatible manner) or are opt-in. For a complete
breakdown of the changes, please refer to the [changelog](http://docs.meteor.com/changelog.html).


<h2 id="changes">Changes in Meteor 2.14</h2>

<h3 id="cordova">Cordova Package</h3>

Cordova has been updated to v12.0.1 for Android and v7.0.1 for iOS. This
requires a few changes to your Cordova project:

  - The `splash-screen` package has removed the `cordova-plugin-splashscreen`
    is now on `cordova-android` core, so we have removed the dependency from the
    `splash-screen` package.
    As a result we are dropping the support for dark mode splash screen on Android.
    To create this now you need to create two themes on your `config.xml` file.
    You can follow in their [docs](https://cordova.apache.org/docs/en/latest/core/features/splashscreen/index.html) how to update your splash screen


Your `.mobile-config.js` file should have the following preferences:

```js

App.setPreference('android-targetSdkVersion', '33')
App.setPreference('android-minSdkVersion', '28')

```

<h2 id="older-versions">Migrating from a version older than 2.13?</h2>

If you're migrating from a version of Meteor older than Meteor 2.13, there may
be important considerations not listed in this guide.
 Please review the older migration guides for details:

* [Migrating to Meteor 2.13](2.13-migration.html) (from 2.12)
* [Migrating to Meteor 2.12](2.12-migration.html) (from 2.11)
* [Migrating to Meteor 2.11](2.11-migration.html) (from 2.10)
* [Migrating to Meteor 2.10](2.10-migration.html) (from 2.9)
* [Migrating to Meteor 2.9](2.9-migration.html) (from 2.8)
* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
