---
title: Migrating to Meteor 2.13
description: How to migrate your application to Meteor 2.13.
---

Most of the new features in Meteor 2.13 are either applied directly behind the
scenes (in a backwards compatible manner) or are opt-in. For a complete
breakdown of the changes, please refer to the [changelog](http://docs.meteor.com/changelog.html).

In order to correctly run projects in Meteor 2.13 with Docker, you will need to
update your Dockerfile to use our [Docker image](https://hub.docker.com/r/meteor/node) that contains Nodejs v14.21.4.

If you are using [Meteor Cloud](https://www.meteor.com/cloud) default base image, you don't need to change anything. If you are using a custom image, please update it accordingly to use the docker image provided or make sure you are using our Node.js 14.21.4 with the security updates.

<h3 id="known-issues"> Known Issues in Meteor 2.13 </h3>

> This issue was solved in Meteor 2.13.3.

When migrating to Meteor 2.13, some users might encounter the following error when updating:

```shell
Error: incorrect data check
    at Zlib.zlibOnError [as onerror] (zlib.js:187:17)
 => awaited here:
 ...
    at /tools/cli/main.js:1165:7 {
  errno: -3,
  code: 'Z_DATA_ERROR'
  }

```

<h3 id="solution"> Solution </h3>

The solution for this issue is running the following command in your terminal:

```shell

curl https://install.meteor.com/\?release\=2.13.3 | sh

```

<h2 id="older-versions">Migrating from a version older than 2.12?</h2>

If you're migrating from a version of Meteor older than Meteor 2.12, there may
be important considerations not listed in this guide.
 Please review the older migration guides for details:

* [Migrating to Meteor 2.12](2.12-migration.html) (from 2.11)
* [Migrating to Meteor 2.11](2.11-migration.html) (from 2.10)
* [Migrating to Meteor 2.10](2.10-migration.html) (from 2.9)
* [Migrating to Meteor 2.9](2.9-migration.html) (from 2.8)
* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
