---
title: Migrating to Meteor 2.12
description: How to migrate your application to Meteor 2.12.
---

Most of the new features in Meteor 2.12 are either applied directly behind the 
scenes (in a backwards compatible manner) or are opt-in. For a complete
breakdown of the changes, please refer to the [changelog](http://docs.meteor.com/changelog.html).

The above being said, there are a few items that you should implement to 
have easier time in the future.

<h3 id="old-api-warning">Old API Warning</h3>

With our migration to the new async/await API, we have added a warning to the
old API. In order to use it, before running your application, set the
environment variable `WARN_WHEN_USING_OLD_API` to `true`. For example, you can
run the folling command in your application directory:

```bash
WARN_WHEN_USING_OLD_API=true meteor
```

It will run your app and every time you use the old API, you will see a warning
in your console. This will help you find the places in your code that need to
be updated.

If you are in doubt whether a particular API is old or new, you can check our [v2.8 migration](https://guide.meteor.com/v2.10/2.8-migration.html) guide
that lists all the changes in the new API.

<h2 id="older-versions">Migrating from a version older than 2.11?</h2>

If you're migrating from a version of Meteor older than Meteor 2.11, there may 
be important considerations not listed in this guide.
 Please review the older migration guides for details:

* [Migrating to Meteor 2.11](2.11-migration.html) (from 2.10)
* [Migrating to Meteor 2.10](2.10-migration.html) (from 2.9)
* [Migrating to Meteor 2.9](2.9-migration.html) (from 2.8)
* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
