---
title: Migrating to Meteor 2.11
description: How to migrate your application to Meteor 2.11.
---

Most of the new features in Meteor 2.11 are either applied directly behind the scenes (in a backwards compatible manner)
or are opt-in. For a complete breakdown of the changes, please refer to
the [changelog](http://docs.meteor.com/changelog.html).

The above being said, there are a few items that you should implement to have easier time in the future.

<h3 id="mongo-5">MongoDB 6.0.3</h3>

#### Introduction

> This migration is recommended but not required. Since Meteor v2.2.0 we support
> MongoDB v6.x (not with its full
> features), [You can check the compatibility table](https://www.mongodb.com/docs/drivers/node/current/compatibility/)
> but we encourage everybody to run the
> the latest version of Meteor as soon as possible as you can benefit from a new
> MongoDB driver and also other features that we are always adding to Meteor.



Meteor before 2.11 was supporting MongoDB Server 5.x, starting from this version we've upgraded to MongoDB Node.js
driver from version 4.12.1 to 4.14

This change was necessary at the time of writing this guide (January 2023) as MongoDB Atlas is going to migrate
automatically all the clusters in the plans Atlas M0 (Free Cluster), M2, and M5 to MongoDB 6.0 in February 2022, but
this change would be necessary anyway as this is now the latest version of MongoDB Server. The migration in the M0, M2
and M5 is just a sign from MongoDB that they believe MongoDB 6.0 should be the version used by everybody as soon as
possible.

An important note is that we have migrated everything supported by Meteor to be compatible with MongoDB 6.x and also
MongoDB Node.js Driver 4.x but this doesn't include, as you should expect, what you do in your code or package
using `rawCollection`. `rawCollection` is a way for Meteor to provide you the freedom to interact with MongoDB driver
but that also comes with the responsibility to keep your code up-to-date with the version of the driver used by Meteor.

That said, we encourage everybody to run the latest version of Meteor as soon as possible as you can benefit from a new
MongoDB driver and also other features that we are always adding to Meteor.

This version of Meteor is also compatible with previous version of MongoDB server, so you can continue using the latest
Meteor without any issues even if you are not running MongoDB 6.x yet. You can
check [here](https://docs.mongodb.com/drivers/node/current/compatibility/) which versions of MongoDB server the Node.js
driver in the version 4.13.0 supports and as a consequence these are the versions of MongoDB server supported by Meteor
2.11 as well. In short, Meteor 2.11 supports these versions of MongoDB server:6.1, 6.0, 5.0, 4.4, 4.2, 4.0, 3.6.

#### Embedded MongoDB

If you are using Embedded MongoDB in your local environment you should run `meteor reset` in order to have your database
working properly after this upgrade. `meteor reset` is going to remove all the data in your local database.

#### ```meteor mongo```

From MongoDB version 6.X, the `mongo` shell is not available anymore. It can be
seen [here](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/#legacy-mongo-shell-removed) for more
info.
For this reason the `meteor mongo` command is not going to work anymore. If you are using this command, you should use
the `mongosh` command instead.
We will be working for a future version of Meteor to have `meteor mongo` working again with `mongosh` but for now you
can use `mongosh` directly.

#### Removed Operators

The following operators have been removed from MongoDB 6.0.3 retrieved from
the [MongoDB 6.0.3 Release Notes](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/#removed-operators):

- $comment:
  Use [cursor.comment()](https://www.mongodb.com/docs/manual/reference/method/cursor.comment/#mongodb-method-cursor.comment)
- $explain:
  Use [cursor.explain()](https://www.mongodb.com/docs/manual/reference/method/cursor.explain/#mongodb-method-cursor.explain)
- $hint:
  Use [cursor.hint()](https://www.mongodb.com/docs/manual/reference/method/cursor.hint/#mongodb-method-cursor.hint))
- $max: Use [cursor.max()](https://www.mongodb.com/docs/manual/reference/method/cursor.max/#mongodb-method-cursor.max)
- $maxTimeMS:
  Use [cursor.maxTimeMS()](https://www.mongodb.com/docs/manual/reference/method/cursor.maxTimeMS/#mongodb-method-cursor.maxTimeMS)
- $min: Use [cursor.min()](https://www.mongodb.com/docs/manual/reference/method/cursor.min/#mongodb-method-cursor.min)
- $orderby:
  Use [cursor.sort()](https://www.mongodb.com/docs/manual/reference/method/cursor.sort/#mongodb-method-cursor.sort)
- $query:
  See [Cursor Methods](https://www.mongodb.com/docs/manual/reference/method/js-cursor/#std-label-doc-cursor-methods)
- $returnKey:
  Use [cursor.returnKey()](https://www.mongodb.com/docs/manual/reference/method/cursor.returnKey/#mongodb-method-cursor.returnKey)
- $showDiskLoc: Use
  [cursor.showRecordId](https://www.mongodb.com/docs/manual/reference/method/cursor.returnKey/#mongodb-method-cursor.showRecordId)
- db.getLastError():
  See [Legacy Opcodes Removed](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/#std-label-legacy-op-codes-removed)
- db.getLastErrorObj():
  See [Legacy Opcodes Removed](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/#std-label-legacy-op-codes-removed)
- getLastError:
  See [Legacy Opcodes Removed](https://www.mongodb.com/docs/manual/release-notes/6.0-compatibility/#std-label-legacy-op-codes-removed)

#### Changes

Nothing has changed in the Meteor API. You may face issues if you are using any
of the features that have been mentioned above

Below we describe a few common cases in this migration:

#### 1) Same version of MongoDB server

If you are not changing your MongoDB server version you don't need to change anything in your code, but as we did many
changes on how Meteor interact with MongoDB in order to be compatible with the new driver we recommend that you test
your application carefully before releasing to production with this Meteor version.

We've made many tests in real applications and also in our automatic tests suite, we believe we've fixed all the issues
that we found along the way but Meteor interaction with MongoDB is so broad and open that maybe you have different use
cases that could lead to different issues.

Again, we are not aware of any issues that were introduced by these changes, but it's important that you check your app
behavior, especially if you have places where you believe you are not using MongoDB in a traditional way.

#### 2) Migrating from MongoDB 5.x to MongoDB 6.x

As we have made many changes to Meteor core packages in this version we recommend the following steps to migrate:

- Upgrade your app to use Meteor 2.11 (meteor update --release 2.11) in a branch;
- Create a staging environment with MongoDB 6.x and your app environment using the branch created in the previous step;
    - If you are using MongoDB Atlas, in MongoDB Atlas we were not able to migrate to a free MongoDB 6.x instance, so we
      had to migrate to a paid cluster in order to test the app properly, maybe this will change after February 2023;
- Set up your staging database with MongoDB 6.x and restore your production data there, or populate this database in a
  way that you can reproduce the same cases as if you were in production;
- Run your app pointing your MONGO_URL to this new database, that is running MongoDB 6.x;
- Run your end-to-end tests in this environment. If you don't have a robust end-to-end test we recommend that you test
  your app manually to make sure everything is working properly.
- Once you have a stable end-to-end test (or manual test), you can consider that you are ready to run using MongoDB 6.x,
  so you can consider it as any other database version migration.

We are not aware of any issues that were introduced by the necessary changes to support MongoDB, but it's important that
you check your app behavior, especially if you have places where you believe you are not using MongoDB in a traditional
way.

<h2 id="older-versions">Migrating from a version older than 2.10?</h2>

If you're migrating from a version of Meteor older than Meteor 2.10, there may be important considerations not listed in
this guide. Please review the older migration guides for details:

* [Migrating to Meteor 2.10](2.10-migration.html) (from 2.9)
* [Migrating to Meteor 2.9](2.9-migration.html) (from 2.8)
* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
