---
title: Migrating to Meteor 2.10
description: How to migrate your application to Meteor 2.10.
---

Most of the new features in Meteor 2.10 are either applied directly behind the scenes (in a backwards compatible manner) or are opt-in. For a complete breakdown of the changes, please refer to the [changelog](http://docs.meteor.com/changelog.html).

The above being said, there are a few items that you should implement to have easier time in the future.

<h3 id="async-tracker">Async Tracker</h3>

Wrapping your async calls in a ```Tracker.withComputation``` method will make sure that even async calls are reactive.

before if you used a code like the one below it would only run once and would not be reactive
```javascript
Tracker.autorun(async function example1() {
  let asyncData = await asyncDataFunction();
  let users = Meteor.users.find({}).fetch();
});
```
To be reactive before 2.10 you would need to call the reactive data sources before the async call

```javascript
Tracker.autorun(async function example2() {
  let users = Meteor.users.find({}).fetch();
  let asyncData = await asyncDataFunction();
});
```
Now you can have both examples reactive by wrapping the async call in a ```Tracker.withComputation``` method

```javascript

Tracker.autorun(async function example1(computation) {
  let asyncData = await Tracker.withComputation(computation, () => asyncDataFunction());
  let users = Meteor.users.find({}).fetch();
});

Tracker.autorun(async function example2(computation) {
  let users = await Tracker.withComputation(computation, () => Meteor.users.find({}).fetch());
  let asyncData = await Tracker.withComputation(computation, () => asyncDataFunction());
  
});

// using async mongo api
Tracker.autorun(async function example2(computation) {
  let asyncData = await Tracker.withComputation(computation, () => asyncDataFunction());
  let users = await Tracker.withComputation(computation, () => Meteor.users.find({}).fetchAsync());
});
```
<h2 id="older-versions">Migrating from a version older than 2.9?</h2>

If you're migrating from a version of Meteor older than Meteor 2.9, there may be important considerations not listed in this guide. Please review the older migration guides for details:

* [Migrating to Meteor 2.9](2.9-migration.html) (from 2.8)
* [Migrating to Meteor 2.8](2.8-migration.html) (from 2.7)
* [Migrating to Meteor 2.7](2.7-migration.html) (from 2.6)
* [Migrating to Meteor 2.6](2.6-migration.html) (from 2.5)
* [Migrating to Meteor 2.5](2.5-migration.html) (from 2.4)
* [Migrating to Meteor 2.4](2.4-migration.html) (from 2.3)
* [Migrating to Meteor 2.3](2.3-migration.html) (from 2.2)
* [Migrating to Meteor 2.2](2.2-migration.html) (from 2.0)
* [Migrating to Meteor 2.0](2.0-migration.html) (from 1.12)
* [Migrating to Meteor 1.12](1.12-migration.html) (from 1.11)
* [Migrating to Meteor 1.11](1.11-migration.html) (from 1.10.2)
* [Migrating to Meteor 1.10.2](1.10.2-migration.html) (from 1.10)
* [Migrating to Meteor 1.10](1.10-migration.html) (from 1.9.3)
* [Migrating to Meteor 1.9.3](1.9.3-migration.html) (from 1.9)
* [Migrating to Meteor 1.9](1.9-migration.html) (from 1.8.3)
* [Migrating to Meteor 1.8.3](1.8.3-migration.html) (from 1.8.2)
* [Migrating to Meteor 1.8.2](1.8.2-migration.html) (from 1.8)
* [Migrating to Meteor 1.8](1.8-migration.html) (from 1.7)
* [Migrating to Meteor 1.7](1.7-migration.html) (from 1.6)
* [Migrating to Meteor 1.6](1.6-migration.html) (from 1.5)
* [Migrating to Meteor 1.5](1.5-migration.html) (from 1.4)
* [Migrating to Meteor 1.4](1.4-migration.html) (from 1.3)
* [Migrating to Meteor 1.3](1.3-migration.html) (from 1.2)
