---
title: Docs
---

> Meteor 2.x uses the deprecated Node.js 14. Meteor 3.0 has been released and runs on Node.js 20. Check out our [v3 docs](https://v3-docs.meteor.com) and [migration guide](https://v3-migration-docs.meteor.com/).

<!--  XXX: note that this content is somewhat duplicated on the guide, and should be updated in parallel -->
<h2 id="what-is-meteor">What is Meteor?</h2>

Meteor is a full-stack JavaScript platform for developing modern web and mobile applications. Meteor includes a key set of technologies for building connected-client reactive applications, a build tool, and a curated set of packages from the Node.js and general JavaScript community.

- Meteor allows you to develop in **one language**, JavaScript, in all environments: application server, web browser, and mobile device.

- Meteor uses **data on the wire**, meaning the server sends data, not HTML, and the client renders it.

- Meteor **embraces the ecosystem**, bringing the best parts of the extremely active JavaScript community to you in a careful and considered way.

- Meteor provides **full stack reactivity**, allowing your UI to seamlessly reflect the true state of the world with minimal development effort.

<h2 id="learning-more">Meteor resources</h2>

1. First, learn how to install meteor in the [installation section](/install.html).

1. The place to get started with Meteor is the [tutorials page](https://www.meteor.com/developers/tutorials).

1. [Meteor Examples](https://github.com/meteor/examples) is a list of examples using Meteor. You can also include your example with Meteor.

1. Once you are familiar with the basics, the [Meteor Guide](http://guide.meteor.com) covers intermediate material on how to use Meteor in a larger scale app.

1. Visit the [Meteor discussion forums](https://forums.meteor.com) to announce projects, get help, talk about the community, or discuss changes to core.

1. [Meteor Slack Community](https://join.slack.com/t/meteor-community/shared_invite/enQtODA0NTU2Nzk5MTA3LWY5NGMxMWRjZDgzYWMyMTEyYTQ3MTcwZmU2YjM5MTY3MjJkZjQ0NWRjOGZlYmIxZjFlYTA5Mjg4OTk3ODRiOTc) is the best place to ask (and answer!) technical questions and also meet Meteor developers.

1. [Atmosphere](https://atmospherejs.com) is the repository of community packages designed especially for Meteor.


{% oldRedirects %}

<!-- hidden comment to trigger a change -->
