## v2.14.0, 2023-12-12

### Highlights

Hacktoberfest release! 🎉

* MongoDB driver has been updated to v4.17.2.

* You can now set `DISABLE_SOCKJS_CORS=1` if you want to prevent SockJS from setting CORS headers. Do not set this option if you will have DDP clients from other origins connecting to the DDP server. [PR #12789]

* Added guide on [how to prepare for Meteor 3.0 migration](https://guide.meteor.com/prepare-meteor-3.0).

* New DDP merge strategy `NO_MERGE_MULTI`, which is similar to `NO_MERGE`, but it does track whether a document is used by multiple publications. [PR #12742]

* Appcache has been further deprecated and moved to the deprecated packages folder.

* Added `Accounts.createUserAsync` into the client.

* Many packages had their underscore dependency removed.

* Cordova has been updated to v12.0.1 for Android and v7.0.1 for iOS, being able to build to SDK 33.

* `meteor create` command is now interactive!

* Added `firstRunPromise` property to `Tracker` autorun blocks, that forces autorun blocks to be executed in synchronous-looking order by storing the value autorun promise thus making it awaitable.

#### Migration Steps

##### Android splash screen
If you have been using `splash-screen` for Cordova, you need to update your code as Android changed their splash screen API,
the `cordova-plugin-splashscreen` is now on `cordova-android` core, so we have removed the dependency from the `splash-screen`
package. As a result we are dropping the support for dark mode splash screen on Android.

To create this now you need to create two themes on your `config.xml` file.

>  Note that it's still possible to have it by adding the according themes with App.appendToConfig and App.addResourceFile - but this is not something Meteor will do automatically right now.

For more information you can check our [Migration Guide](https://guide.meteor.com/2.14-migration.html)

## Breaking Changes

* `splash-screen` package has removed the `cordova-plugin-splashscreen` dependency. See migration steps for more info.

## Docs

- Added guide on [how to prepare for Meteor 3.0 migration](https://guide.meteor.com/prepare-meteor-3.0).
- Added guide on [performance improvements](https://guide.meteor.com/performance-improvement).
- Added FAQ about [Meteor 3](https://guide.meteor.com/3.0-migration).

##  Internal API changes

* Tool
  - Rename `EACCESS` to `EACCES` to follow the Windows spelling
  - Fixed links in skeletons
  - Fixed build issue in Vue skeleton
  - Updated `source-map-support`
  - Fixed bugs in negated “in” and “instanceof” expressions
  - Updated `semver` to v7.5.4
  - Updated `@meteorjs/babel` to v7.18.4
  - Cordova has been updated to v12.0.1 for Android and v7.0.1 for iOS, being able to build to SDK 33.
  - `meteor create` command was re-made to be more interactive

## Meteor Version Release

* `accounts-base@get-version`
  - Ensure that `onLogin` callback fires properly
  - Indexes are now created asynchronously

* `accounts-oauth@get-version`
  - Indexes are now created asynchronously

* `accounts-password@get-version`
  - Add `Accounts.createUserAsync` to the client, a promise-based version of `Accounts.createUser`
  - Indexes are now created asynchronously

* `accounts-passwordless@get-version`
  - Fix #12401, ensure that user is found with ID
  - Indexes are now created asynchronously

* `babel-compiler@get-version`
  - Updated `@meteorjs/babel` to v7.18.4

* `boilerplate-generator@get-version`
  - Removed Underscore dependency

* `browser-policy-content@get-version`
  - Removed Underscore dependency

* `constraint-solver@get-version`
  - Removed Underscore dependency

* `crosswalk@get-version`
  - Updated `cordova-plugin-crosswalk-webview` to v2.4.0
  - Deprecated the package

* `ddp-rate-limiter@get-version`
  - Removed Underscore dependency
* `ddp-server@get-version`:
  - Allow setting `DISABLE_SOCKJS_CORS` to prevent SockJS from setting CORS headers
  - Added new publication strategy `NO_MERGE_MULTI`

* `ecmascript@get-version`:
  - Bumped to get latest version of `@babel/compiler`

* `facebook-oauth@get-version`:
  - Updated default version of Facebook GraphAPI to v17

* `launch-screen@get-version`
  - Removed `cordova-plugin-splashscreen` dependency

* `fetch@get-version`:
  - Update `node-fetch` to version 1.6.12
  - Update `whatwg-fetch` to version 3.6.17

* `logging@get-version`:
  - Added TS types
  - Updated `chalk` to v4.1.2

* `logic-solver@get-version`
  - Removed Underscore dependency

* `meteor@get-version`:
  - Improve TS types

* `mobile-experience@get-version`:
  - Bumped to get latests version of `cordova` dependencies

* `modern-browsers@get-version`
  - Added `appleMail` user agent to allow modern bundle on iPads

* `modules@get-version`
  - Updated version of reify to v0.24.1

* `mongo@get-version`
  - Added deprecation messages into type definitions
  - Fix ObjectIDs handling in oplogV2V1Converter

* `npm-mongo@get-version`:
  - Bumped MongoDB driver to version 4.17.2

* `oauth@get-version`
  - Indexes are now created asynchronously
  - `remove` DB calls migrated to `removeAsync`

* `package-version-parser@get-version`
  - Updated `semver` to v7.5.4

* `react-fast-refresh@get-version`:
  - Updated `semver` to version 7.5.4

* `service-configuration@get-version`
  - Indexes are now created asynchronously
  - Add types for ConfigError

* `socket-stream-client@get-version`
  - Removed Underscore dependency

* `standard-minifier-css@get-version`
  - Updated `@babel/runtime` to v7.23.5
  - Updated `minifier-css` to v1.6.4
  - Updated `logging` package to v1.3.2

* `test-server-tests-in-console-once@get-version`
  - Removed Underscore dependency

* `tinytest@get-version`
  - Removed Underscore dependency

* `tracker@get-version`
  - Added `firstRunPromise` property, that forces autorun blocks to be executed
   in synchronous-looking order by storing the value autorun promise
    thus making it awaitable

* `typescript@get-version`:
  - Updated to 4.9.5

* `webapp@get-version`
  - Updated `cordova-plugin-meteor-webapp` to v2.0.3
  - Updated `cookie-parser` to v1.4.6
  - Updated `send` to v0.18.0
  - Updated `stream-to-string` to v1.2.1
  - Updated `qs` to v6.11.2
  - Updated `@types/connect` to v3.4.38


## Independent releases

* `google-oauth@1.4.4`:
  - Remove logging request/response in google_server

* NPM `@meteorjs/babel@7.18.4`
  - Updated `@meteorjs/reify` to v0.24.1

* NPM `@meteorjs/babel-preset-meteor@7.10.1`
  - Add Facebook in-app browser

* NPM `cordova-plugin-meteor-webapp@2.0.2`
  - Fixed Android hot code push failing

* NPM `cordova-plugin-meteor-webapp@2.0.3`
  - Fix pull manifest from correct url if parameter are used in baseurl

* NPM `meteor-node-stubs@1.2.6`
  - Update dependencies
  - Deep update dependencies that were highlighted by `npm audit`

## Contributors

- [@StorytellerCZ](https://github.com/sponsors/StorytellerCZ)
- [@Grubba27](https://github.com/sponsors/Grubba27)
- [@vit0rr](https://github.com/vit0rr)
- [@realyze](https://github.com/realyze)
- [@jamauro](https://github.com/jamauro)
- [@Torgen](https://github.com/Torgen)
- [@brucejo75](https://github.com/brucejo75)
- [@zodern](https://github.com/sponsors/zodern)
- [@alisnic](https://github.com/alisnic)
- [@ebroder](https://github.com/ebroder)
- [@BANSAL-NISHU](https://github.com/BANSAL-NISHU)
- [@salmanhasni](https://github.com/salmanhasni)
- [@jdgjsag67251](https://github.com/jdgjsag67251)
- [@guncebektas](https://github.com/guncebektas)
- [@harryadel](https://github.com/harryadel)
- [@dd137](https://github.com/dd137)
- [@matheusccastroo](https://github.com/matheusccastroo)
- [@mr-loop-1](https://github.com/mr-loop-1)

For making this great framework even better!

