## Contributing to Meteor Documentation

Thanks for considering contributing to Meteor documentation. We really appreciate your assistance.

The simplest way to contribute to a project is to open an issue or pull request (PR) on GitHub issue [tracker](https://github.com/meteor/meteor/issues).

## Issues

If you see a problem with a particular piece of content, you can hit the "Edit on GitHub" button to jump straight to the file on GitHub. If you are keen, you can submit a Pull Request immediately to fix the problem; alternatively, hit the "Issues" button at the top to open an issue reporting the problem.

## Pull Requests

We welcome changes both large and small.

### Small changes

Smaller changes such as fixing typos and small edits for clarity will typically be merged quickly, and are very helpful! Contributions like this enable us to maintain our high quality of documentation

### Larger changes

Larger changes like section rewrites, new sections, and even entirely new articles are also encouraged! In fact, some large parts of our documentation have been contributed by community members. However, more controversial larger changes may require some discussion and buy-in from the documentation maintainers before being accepted—if you are unsure, it may be sensible to open an issue discussing the changes before making them.

## Becoming a documentation maintainer

If you make larger contributions to the above properties, you may be invited to become a community documentation maintainer. This is both a recognition of your contribution (thank you!) and the granting of commit rights on the above repositories.

With those rights you can merge the Pull Requests of others as well as commit directly to the repository (and in some cases deploy the site). So please use your discretion and be courteous.
