<div align="center">
  <a href="https://www.meteor.com" target="_blank">
    <img align="center" width="225" src="https://user-images.githubusercontent.com/841294/26841702-0902bbee-4af3-11e7-9805-0618da66a246.png">
  </a>
</div>

<br>

<div align="center">

[![Travis CI Status](https://api.travis-ci.com/meteor/meteor.svg?branch=devel)](https://app.travis-ci.com/github/meteor/meteor)
[![CircleCI Status](https://circleci.com/gh/meteor/meteor.svg?style=svg)](https://app.circleci.com/pipelines/github/meteor/meteor?branch=devel)
[![built with Meteor](https://img.shields.io/badge/Meteor-3.0.3-green?logo=meteor&logoColor=white)](https://meteor.com)
![node-current](https://img.shields.io/node/v/meteor)
![Discord](https://img.shields.io/discord/1247973371040239676)
![Twitter Follow](https://img.shields.io/twitter/follow/meteorjs?style=social)

</div>

<hr>

Meteor is an **ultra-simple** environment for building **modern** web applications.

<hr>

- [Official Website](https://www.meteor.com)
- [Installation](https://docs.meteor.com/about/install.html)
- [Documentation](https://docs.meteor.com/#/full/)

<hr>

### 📚 **Create your applications using modern JavaScript**

Benefit from the latest technology updates to rapidly prototype and develop your applications.

<hr>

### ✨ **Integrate technologies you already use**

Use popular frameworks and tools right out-of-the-box. Focus on building features instead of configuring disparate components yourself.

<hr>

### 💻 **Build apps for any device**

Use the same code whether you’re developing for web, iOS, Android, or desktop for a seamless update experience for your users.

<hr>

# 🔥 Getting Started

How about trying a tutorial to get started with your favorite technology?

| [<img align="left" width="25" src="https://upload.wikimedia.org/wikipedia/commons/a/a7/React-icon.svg"> React](https://docs.meteor.com/tutorials/react/) |
| - |
| [<img align="left" width="25" src="https://progsoft.net/images/blaze-css-icon-3e80acb3996047afd09f1150f53fcd78e98c1e1b.png"> Blaze](https://blaze-tutorial.meteor.com/) |
| [<img align="left" width="25" src="https://vuejs.org/images/logo.png"> Vue](https://vue-tutorial.meteor.com/) |
| [<img align="left" width="25" src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/1b/Svelte_Logo.svg/1200px-Svelte_Logo.svg.png"> Svelte](https://svelte-tutorial.meteor.com/) |

Next, read the [documentation](https://docs.meteor.com/) and get some [examples](https://github.com/meteor/examples).

# 🚀 Quick Start

On your platform, use this line:

```shell
> npm install -g meteor
```
 
🚀 To create a project:

```shell
> meteor create my-app
```

☄️ Run it:

```shell
cd my-app
meteor
```

# 🧱 Developer Resources

**Building an application with Meteor?**

* Deploy on [Meteor Cloud](https://www.meteor.com/cloud)
* Discuss on [Forums](https://forums.meteor.com/)
* Join the Meteor Discord by clicking this [invite link](https://discord.gg/hZkTCaVjmT).
* Announcement list. Subscribe in the [footer](https://www.meteor.com/).


Interested in helping or contributing to Meteor?  These resources will help:

* [Core development guide](DEVELOPMENT.md)
* [Contribution guidelines](CONTRIBUTING.md)
* [Feature requests](https://github.com/meteor/meteor/discussions/)
* [Issue tracker](https://github.com/meteor/meteor/issues)

To uninstall Meteor: 
  - If installed via npm, run:
      ```shell
      meteor-installer uninstall
      ```
  - If installed via curl, run:
    ```shell
    rm -rf ~/.meteor 
    sudo rm /usr/local/bin/meteor
    ```
To find more information about installation, [read here](https://docs.meteor.com/about/install.html#uninstall).
