BEGIN;

CREATE TYPE do_not_recommend_entity_type AS ENUM ('artist', 'release', 'release_group', 'recording');

CREATE TABLE recommendation.do_not_recommend (
    id              INTEGER GENERATED BY DEFAULT AS IDENTITY NOT NULL,
    user_id         INTEGER NOT NULL,
    entity          do_not_recommend_entity_type NOT NULL,
    entity_mbid     UUID NOT NULL,
    until           TIMESTAMP WITH TIME ZONE,
    created         TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT NOW()
);

ALTER TABLE recommendation.do_not_recommend
    ADD CONSTRAINT rec_do_not_recommend_pkey PRIMARY KEY (id);

ALTER TABLE recommendation.do_not_recommend
    ADD CONSTRAINT do_not_recommend_user_id_foreign_key
    FOREIGN KEY (user_id)
    REFERENCES "user" (id)
    ON DELETE CASCADE;

CREATE UNIQUE INDEX user_id_entity_ndx_do_not_recommend ON recommendation.do_not_recommend (user_id, entity, entity_mbid);

COMMIT;
