# 用法

## 建库

本小节主要说明，如何根据原始物料数据集来创建可供线上检索的索引集合，大致分为以下几个步骤：

1. **预处理**，把原始数据转换为较为通用的 jsonline 格式以供建库使用

    ```
    sh preprocess.sh
    ```

2. **构建索引**，输入预处理后的数据产出向量+文档关键字段等索引数据（每行一个文档对象）

    ```
    sh build.sh
    ```

3. **推送倒排和正排**，把倒排（向量）和正排（文档字段）数据分别推送到各个组件服务端

    ```
    sh push_milvus.sh
    # 测试推送是否成功
    # sh pull_milvus.sh

    sh push_mongo.sh
    # 测试推送是否成功
    # sh pull_mongo.sh
    ```

## 模型导出

建库时，我们使用了离线训练好的模型，在线检索时要保证跟离线模型的**一致性**。

这里演示如何把离线模型导出并推送到线上：

```
sh export.sh
```

离线模型会导出 onnx 和 tokenizer，然后把它们写入 S3 存储供其它线上组件加载使用。
