/*
* Copyright [2019] [Metamagic]
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*  Created by sagar on 4/02/2019.
*/
import { Component, HostBinding, Input } from '@angular/core';

@Component({
    selector: 'amexio-body-ce',
    templateUrl: './amexio.body.component.html',
})
export class AmexioCardCEBodyComponent {

    @HostBinding('attr.class') cardclass = 'card-container-body';

    @HostBinding('style.overflow')
    get width(): string {
        if (this.height === '' || this.height ===  null) {
            return 'unset';
        } else {
            return 'auto';
        }
    }

    @Input('align') align = '';

    // tslint:disable-next-line:no-input-rename
    @Input('bg-image') bgimage: string;

    @Input('color') color: string;

    @Input('background') background: string;

    @Input('height') height = '';

    ribbonType = false;

    constructor() {
    }
}
