

<h1 align="center">
  <br>
  <a href="http://www.amexio.tech/"><img src="https://image.ibb.co/kdy6Ev/logo.png" alt="Amexio" width="200"></a>
  <br>
    Amexio Angular EXtensions v5.20.0
  <br>
</h1>

<div align="center">
  <b>Amexio (Angular MetaMagic EXtensions for Inputs and Outputs)</b> is a rich set of  170+  Angular (4/5/6/7/8)
UI Components powered by HTML5 & CSS3 for <b>Responsive Web Design & 80+ built-in Material Design Themes.</b> Components includes Form components, charts, maps, dashboards, Tabs, Grids, Trees, Layouts etc <b>with Accessibility support, Animation effect and Directives</b>. We added <b>D3 Charts support </b>with <b>Amexio Drillable Charts</b> option. We augmented the <b>Amexio Layouts</b> with more layout options and brought <b>CSS3 Grid Layout</b> to Amexio with Responsive Design Pattern. Amexio comes in three flavours - Standard Edition, Enterprise Edition and Creative Edition, All the ediitions are open source and free.

</div>
<br/>

<div align="center">
  <!-- NPM version -->
  <a href="https://npmjs.org/package/amexio-ng-extensions">
    <img src="https://badge.fury.io/js/amexio-ng-extensions.svg"
      alt="NPM version" />
  </a>
  <!-- Downloads -->
  <a href="https://npmjs.org/package/amexio-ng-extensions">
    <img src="https://img.shields.io/npm/dw/amexio-ng-extensions.svg" alt="Weekly Downloads"/>
  </a>
  <a href="https://npmjs.org/package/amexio-ng-extensions">
    <img src="https://img.shields.io/npm/dm/amexio-ng-extensions.svg" alt="Monthly Downloads"/>
  </a>
   <a href="https://npmjs.org/package/amexio-ng-extensions">
    <img src="https://img.shields.io/npm/dt/amexio-ng-extensions.svg" alt="Total Downloads" />
  </a>
  <img src="https://travis-ci.org/meta-magic/amexio.github.io.svg?branch=v5.14" />
  <!--
  <a href="https://codecov.io/gh/meta-magic/amexio.github.io">
  <img src="https://codecov.io/gh/meta-magic/amexio.github.io/branch/v5.1/graph/badge.svg" />
</a>
-->
  <!--
  <script src="//platform.linkedin.com/in.js" type="text/javascript"> lang: en_US</script>
<script type="IN/FollowCompany" data-id="13316060" data-counter="top"></script>
-->
<br>
<a class="badge-align" href="https://www.codacy.com/app/arafkarsh/amexio.github.io?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=meta-magic/amexio.github.io&amp;utm_campaign=Badge_Grade"><img src="https://api.codacy.com/project/badge/Grade/06ad409b12ad4c1c81794c81889dc6ee"/></a>

<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=alert_status" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=reliability_rating" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=security_rating" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=sqale_rating" />
<a/>
<br>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=vulnerabilities" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">  
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=bugs" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=code_smells" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=sqale_index" />
<a/>
<a href="https://sonarcloud.io/dashboard?id=Amexio-API">
  <img src="https://sonarcloud.io/api/project_badges/measure?project=Amexio-API&metric=ncloc" />
<a/>
<br>
  <a href="https://github.com/meta-magic/amexio.github.io/blob/v5.1/LICENSE.md">
    <img src="https://img.shields.io/github/license/meta-magic/amexio.github.io.svg" />
  </a>
  <a href="https://github.com/meta-magic/amexio.github.io/issues"> 
    <img src="https://img.shields.io/github/issues/meta-magic/amexio.github.io.svg" />
  </a>
  <a href="https://github.com/meta-magic/amexio.github.io/issues"> 
    <img src="https://img.shields.io/github/issues-closed/meta-magic/amexio.github.io.svg" />
  </a>
  <a href="https://github.com/meta-magic/amexio.github.io"> 
    <img src="https://img.shields.io/github/languages/code-size/meta-magic/amexio.github.io.svg" />
  </a>
   <a href="https://github.com/meta-magic/amexio.github.io/stargazers"> 
    <img src="https://img.shields.io/github/stars/meta-magic/amexio.github.io.svg" />
  </a>
  <a href="https://gitter.im/amexio-github-io/">
    <img src="https://img.shields.io/gitter/room/amexio-github-io/amexio-github-io.svg" />
  </a>

</div>

<div align="center">
  <h3>
    <a href="http://www.amexio.tech/">
      Website
    </a>
    <span> | </span>
    <a href="http://api.amexio.org">
      API Docs
    </a>
    <span> | </span>
    <a href="http://demo.amexio.org/">
      Demo SE
    </a>
    <span> | </span>
    <a href="http://eedemo.amexio.org/">
      Demo EE
    </a>
    <span> | </span>
    <a href="https://gitter.im/amexio-github-io/">
      Forum
    </a>
    <span> | </span>
    <a href="https://www.metamagicglobal.com/">
      MetaMagic Global
    </a>
  </h3>
</div>

<br/>

<div align="center">
 <a href="https://npmjs.org/package/amexio-ng-extensions">
  <img src="https://nodei.co/npm/amexio-ng-extensions.png?downloads=true&downloadRank=true&stars=true" />
 </a>
</div>
<br/>
<!--
  <img src="https://sonarcloud.io/images/project_badges/sonarcloud-orange.svg" />
-->
 <br>
  
## Browsers support <sub><sup><sub><sub>made by <a href="https://godban.github.io">godban</a></sub></sub></sup></sub>

| [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/edge.png" alt=" Edge" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br> Edge | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/firefox.png" alt="Firefox" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>Firefox | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/chrome.png" alt="Chrome" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/safari.png" alt="Safari" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>Safari | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/opera.png" alt="Opera" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>Opera | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/safari-ios.png" alt="iOS Safari" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>iOS Safari | [<img src="https://raw.githubusercontent.com/godban/browsers-support-badges/master/src/images/chrome-android.png" alt="Chrome for Android" width="16px" height="16px" />](http://godban.github.io/browsers-support-badges/)</br>Chrome for Android |
| --------- | --------- | --------- | --------- | --------- | --------- | --------- |
| Edge last 5 versions| last 5 versions| last 5 versions| last 3 versions| last 4 versions| last 3 versions| last 3 versions

## Table of Content

- [Features](#features)
- [Overview](#overview)
- [Getting Started](#getting-started)
- [Installation](#amexio-angular-extension---installation)
- [Amexio Modules](#amexio-modules)
- [Amexio Themes](#amexio-themes-material--bootstrap)
- [License](#license)

## Features

- __Pure TypeScript:__ Amexio is a pure Typescript library with 0 Dependencies & Angular 4/5/6/7/8 Support.
- __170+ High Grade Components:__ We make sure you're nothing short of while building your app.
- __Forms:__ Amexio API supports both Template Driven Forms and Reactive Forms. 
- __Layouts:__ With v5.4 release More than half a dozen layout options are supported including CSS3 Grids. 
- __Responsive Web Design:__ Out of the box Responsive Web Design with 50+ Material Design based Themes.
- __Charts, Dashboads, D3:__ Powerful Charting library including D3 Charts with Drillable & Zoomable capabilities. 
- __Server Rending Support:__ Components support & optimized for server side rendering.
- __Highly Customizable Styling:__ Lot of customization can be done easily using the Amexio SCSS files.
- __Accessibility Support:__ ARIA 1.1 Support, WCAG 2.1 and Section 508 Compliance. Checkout [Roadmap](https://amexio.tech/roadmap)
- __Security & Quality:__ Every Amexio build goes thru Security Scanning using Sonar to ensure very High Quality Standards. 
- __Modular Support:__ Load Only what you want, amexio is Modular.
- __FOSS:__ Amexio API is Free and Open Source Software based on Apache 2 License

## Amexio References

- [Home Page](http://www.amexio.tech): Amexio Suite of Products
- [Showcase](http://showcase.amexio.org): Amexio Demo Apps for Standard, Enterprise and Creative Editions
- [API Docs](http://api.amexio.org): Amexio API Documentation
- [Brochure](https://api.amexio.org/AmexioBrochure.pdf): Amexio API Brochure
- [Video Tutorials](https://www.youtube.com/watch?v=zpfpfnOV6Y0&list=PLi505KVOMPrGRUgJF4C3QoXbrhFGEOI4j): 2+ Hours of Tutorials
- [Beta Version](http://beta.amexio.org): Amexio Beta version API Docs
- [Amexio Support](https://amexio.tech/support): Basic support is free. Paid Support - Bronze, Silver, Gold Packages
- [Quality Assurance](https://amexio.tech/quality-assurance): Quality Assurance Details and Dashboard
- [Roadmap](https://amexio.tech/roadmap): All the release details and future releases,

## Angular CLI - Installation

### Overview

The Angular CLI is a tool to initialize, develop, scaffold and maintain Angular applications

### Getting Started

To install the Angular CLI:

```bash
npm install -g @angular/cli
```
Generating and serving an Angular project via a development server Create and run a new project:

```bash
ng new my-project
cd my-project
ng serve
```

Navigate to http://localhost:4200/. The app will automatically reload if you change any of the source files.

For More on Angular CLI [commands](https://github.com/angular/angular-cli/wiki) click on the link.

## Amexio D3 Charts - Installation

To install this library, follow the steps given below:

```bash
$ cd your-angular-project
```

```bash
$ npm install amexio-chart-d3 --save
```
and then from your Angular `AppModule`:

```typescript
import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import {FormsModule} from "@angular/forms";
import { AppComponent } from './app.component';

// To import D3-Chart :- 

import { AmexioChartD3Module } from 'amexio-chart-d3';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    AmexioChartD3Module,
  ],
  providers: [],
  bootstrap: [AppComponent]
})
export class AppModule { }
```


## Amexio Angular Extension - Installation

To install this library, follow the steps given below:

```bash
$ cd your-angular-project
```

```bash
$ npm install amexio-ng-extensions@latest --save
```

and then from your Angular `AppModule`:

```typescript
import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import {FormsModule} from "@angular/forms";
import { AppComponent } from './app.component';

// Import your library
import { AmexioWidgetModule,CommonDataService } from 'amexio-ng-extensions';

// To import Charts
import { AmexioChartsModule } from 'amexio-ng-extensions';

//To import Maps 
import { AmexioMapsModule } from 'amexio-ng-extensions';

// To import Dashboard
import { AmexioDashboardModule } from 'amexio-ng-extensions';


// To import Enterprise
import { AmexioEnterpriseModule } from 'amexio-ng-extensions';
@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    AmexioWidgetModule,
    AmexioChartsModule,
    AmexioMapsModule,
    AmexioDashboardModule,
    AmexioEnterpriseModule
  ],
  providers: [CommonDataService],
  bootstrap: [AppComponent]
})
export class AppModule { }
```
# Amexio Modules
<table> 
<tr>
<th>Amexio Modules</th>
</tr>

<tr>
<td>AmexioWidgetModule</td>
</tr>

<tr>
<td>AmexioFormsModule</td>
</tr>

<tr>
<td>AmexioDataModule</td>
</tr>

<tr>
<td>AmexioLayoutModule</td>
</tr>

<tr>
<td>AmexioPaneModule</td>
</tr>

<tr>
<td>AmexioNavModule</td>
</tr>

<tr>
<td>AmexioMediaModule</td>
</tr>

<tr>
<td>AmexioMapsModule</td>
</tr>

<tr>
<td>AmexioChartsModule</td>
</tr>

<tr>
<td>AmexioDashBoardModule</td>
</tr>

<tr>
<td>AmexioEnterpriseModule</td>
</tr>

</table>

# Amexio Themes (Amexio / Amexio Material)

To use the default theme import the
`../node_modules/amexio-ng-extensions/styles/mda/at-md-blue.scss`
in your app styles.scss
Or refer the below table for other themes provided.

<table> 
<tr>
<th>Amexio Material Themes</th>
<th>Amexio Themes</th>
</tr>
<tr>
 <td>AT-MD-Gold-Amber</td>
 <td>AT-AM-Ocean-Blue</td>
</tr>
<tr>
 <td>AT-MD-Army-Olive</td>
 <td>AT-AM-Tiger</td>
</tr>
<tr>
<td>AT-MD-Ash Stone Black</td>
<td>AT-AM-Lime Green</td> 
</tr>
<tr>
 <td>AT-MD-Black</td>
 <td>AT-AM-Matrix</td>
</tr>
<tr>
 <td>AT-MD-Blue</td>
 <td>AT-AM-Spicy-Apricot</td>
</tr>
<tr>
	<td>AT-MD-Blue-Grey</td>
	<td>AT-AM-Byzantine-Crystal</td>
</tr>
<tr>
	<td>AT-MD-Ginger-Bread</td>
	<td>AT-AM-Honey-Prussian</td>
</tr>
<tr>
	<td>AT-MD-Cerise Magneta</td>
	<td>AT-AM-Persian-Laguna</td>
</tr>
<tr>
	<td>AT-MD-Charcoal Russet</td>
	<td>AT-AM-Burgandy-Magenta</td>
</tr>
<tr>
	<td>AT-MD-Fern-Lime</td>
	<td>AT-AM-Navy-Grape</td>
</tr>
<tr>
 <td>AT-MD-Frenchrose-mulberry</td>
 <td>AT-AM-Matrix-Amber</td>
</tr>
<tr>
 <td>AT-MD-Grape-Voliet</td>
 <td>AT-AM-Matrix-Cream</td>
</tr>

<tr>
 <td>AT-MD-Hot-Pink-Fuchsia</td>
 <td>AT-AM-Matrix-Maya</td>
</tr>

<tr>
 <td>AT-MD-Saphire</td>
 <td>AT-AM-Matrix-Ultra</td>
</tr>

<tr>
 <td>AT-MD-Jungle-Mint</td>
 <td>AT-AM-Royal-Kelly</td>
</tr>

<tr>
 <td>AT-MD-Maya-Light-Blue</td>
 <td>AT-AM-Royal-Pineapple</td>
</tr>

<tr>
 <td>AT-MD-Mahogany Barny Red</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Navy Egyptian</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Raspberry Sangria</td>
 <td></td>
</tr>


<tr>
 <td>AT-MD-Red Maroon</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Sacremento Jado</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Yale Azure</td>
 <td></td>
</tr>

<tr>
 <td>At-MD-Tronbone Royal</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Pineapple-Flaxen</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Pumpkin-Fire</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Mauve-Orchid</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Honey-Mustard</td>
 <td></td>
</tr>

<tr>
 <td>AT-MD-Bruntor-Tangerine</td>
 <td></td>
</tr>
</table>

# Amexio Microsoft Visual Studio Code Extensions

This extension will help the developers of Visual Studio Code with quick code snippet for the Amexio Markup as well as Amexio TypeScript for the Angular Extensions.
<ul>
<li>Available for v3.x series</li>
<li>Plugin for v4.0 will be available in the first week of Feb 2018.</li>
</ul>

## Usage

Select the Amexio Ui Component
<img src="https://raw.githubusercontent.com/meta-magic/Amexio-VSC-Extension/master/images/Amexio-VSC-Ex-1.jpg" />

Fill up the required Component Params
<img src="https://raw.githubusercontent.com/meta-magic/Amexio-VSC-Extension/master/images/Amexio-VSC-Ex-2.jpg" />


## License

Copyright © [MetaMagic Global Inc](http://www.metamagicglobal.com/), 2017-19. NJ, USA. [Amexio Angular EXtensions](http://www.amexio.tech). All rights reserved.<br>
BetaMagic Global Pvt Ltd, Pune, Maharashtra, India is a wholly owned subsidiary of MetaMagic Global Inc, NJ, USA.

Licensed under the [Apache 2.0](http://www.amexio.org/metamagic-showcase/license.html)  License. [Amexio API Docs](http://api.amexio.org) by [CC By 4.0](https://creativecommons.org/licenses/by/4.0/legalcode)

**Enjoy!**
