package de.mpc.pia.intermediate.piaxml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;


/**
 * Model for score in a spectrumMatch
 * 
 * @author julian
 * 
 */
@XmlRootElement(name = "Score")
public class ScoreXML {

	private String cvLabel;

	private String cvAccession;
	
	private String name;
	
	private Double value;
	
	
	/**
	 * Gets the value of the cvAccession property.
	 * @return
	 */
	@XmlAttribute(required = true)
	public String getCvAccession() {
		return cvAccession;
	}
	
	
	/**
	 * Sets the value of the cvAccession property.
	 */
	public void setCvAccession(String cvAccession) {
		this.cvAccession = cvAccession;
	}
	
	
	/**
	 * Gets the value of the cvName property.
	 * @return
	 */
	@XmlAttribute(required = true)
	public String getName() {
		return name;
	}
	
	
	/**
	 * Sets the value of the cvName property.
	 */
	public void setName(String name) {
		this.name = name;
	}
	
	
	/**
	 * Gets the value of the value property.
	 * @return
	 */
	@XmlAttribute(required = true)
	public Double getValue() {
		return value;
	}
	
	
	/**
	 * Sets the value of the value property.
	 */
	public void setValue(Double value) {
		this.value = value;
	}


	@XmlAttribute(required = false)
	public String getCvLabel() {
		return cvLabel;
	}

	public void setCvLabel(String cvLabel) {
		this.cvLabel = cvLabel;
	}

	@Override
	public String toString() {
		return '[' +cvLabel + ',' + cvAccession + ',' + name + ',' + value + ']';
	}
}
