/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.AnalysisSoftware;
import uk.ac.ebi.jmzidml.model.mzidml.DatabaseFilters;
import uk.ac.ebi.jmzidml.model.mzidml.DatabaseTranslation;
import uk.ac.ebi.jmzidml.model.mzidml.Enzymes;
import uk.ac.ebi.jmzidml.model.mzidml.MassTable;
import uk.ac.ebi.jmzidml.model.mzidml.ModificationParams;
import uk.ac.ebi.jmzidml.model.mzidml.Param;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;

public class SpectrumIdentificationProtocolCreator
extends MyIdentMLObject {
    public SpectrumIdentificationProtocol spectrumIdentificationProtocol;
    HashMap<String, MassTable> mapMassTables = new HashMap();

    public SpectrumIdentificationProtocolCreator(MzIdentMLMarshallerWriter mw, String id, AnalysisSoftware analysisSoftware, Param searchType, ParamList thresholdList) {
        super(mw);
        this.spectrumIdentificationProtocol = new SpectrumIdentificationProtocol();
        this.spectrumIdentificationProtocol.setId(id);
        this.spectrumIdentificationProtocol.setAnalysisSoftware(analysisSoftware);
        this.spectrumIdentificationProtocol.setSearchType(searchType);
        this.spectrumIdentificationProtocol.setThreshold(thresholdList);
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.spectrumIdentificationProtocol, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void setName(String name) {
        this.spectrumIdentificationProtocol.setName(name);
    }

    public void addThreshold(AbstractParam threshold) {
        this.spectrumIdentificationProtocol.getThreshold().getParamGroup().add(threshold);
    }

    public void setAdditionalSearchParams(ParamList additionalSearchParamsList) {
        this.spectrumIdentificationProtocol.setAdditionalSearchParams(additionalSearchParamsList);
    }

    public void addAdditionalSearchParam(AbstractParam additionalSearchParam) {
        this.spectrumIdentificationProtocol.getAdditionalSearchParams().getParamGroup().add(additionalSearchParam);
    }

    public void setModificationParams(ModificationParams modificationParams) {
        this.spectrumIdentificationProtocol.setModificationParams(modificationParams);
    }

    public void setEnzymes(Enzymes enzymes) {
        this.spectrumIdentificationProtocol.setEnzymes(enzymes);
    }

    public void addUniqueMassTable(MassTable massTable) {
        ((Object)((Object)this)).getClass();
        String id = massTable.getId();
        if (!this.mapMassTables.containsKey(id)) {
            this.spectrumIdentificationProtocol.getMassTable().add(massTable);
            this.mapMassTables.put(id, massTable);
        } else {
            this.logger.warn("Tried to add a non-unique MassTable to the SpectrumIdentificationProtocol");
        }
    }

    public void setFragmentTolerance(Tolerance fragmentTolerance) {
        this.spectrumIdentificationProtocol.setFragmentTolerance(fragmentTolerance);
    }

    public void setParentTolerance(Tolerance parentTolerance) {
        this.spectrumIdentificationProtocol.setParentTolerance(parentTolerance);
    }

    public void setDatabaseFilters(DatabaseFilters databaseFilters) {
        this.spectrumIdentificationProtocol.setDatabaseFilters(databaseFilters);
    }

    public void setDatabaseTranslation(DatabaseTranslation databaseTranslation) {
        this.spectrumIdentificationProtocol.setDatabaseTranslation(databaseTranslation);
    }
}

