/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.BaseLib.Rounder;
import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.Fragmentation;
import uk.ac.ebi.jmzidml.model.mzidml.MassTable;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidenceRef;
import uk.ac.ebi.jmzidml.model.mzidml.Sample;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationItem;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class SpectrumIdentificationItemCreator
extends MyIdentMLObject {
    public SpectrumIdentificationItem spectrumIdentificationItem;
    HashMap<String, PeptideEvidenceRef> mapPeptideEvidenceRefs = new HashMap();
    HashMap<String, CvParam> mapCvParam = new HashMap();
    HashMap<String, UserParam> mapUserParam = new HashMap();

    public SpectrumIdentificationItemCreator(MzIdentMLMarshallerWriter mw, String id, Integer chargeState, double experimentalMassToCharge, Integer rank, Boolean passThreshold) {
        super(mw);
        this.spectrumIdentificationItem = new SpectrumIdentificationItem();
        this.spectrumIdentificationItem.setId(id);
        this.spectrumIdentificationItem.setChargeState(chargeState.intValue());
        ((Object)((Object)this)).getClass();
        this.spectrumIdentificationItem.setExperimentalMassToCharge(Rounder.roundDbl((double)experimentalMassToCharge, (int)7).doubleValue());
        this.spectrumIdentificationItem.setRank(rank.intValue());
        this.spectrumIdentificationItem.setPassThreshold(passThreshold.booleanValue());
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.spectrumIdentificationItem, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void setName(String name) {
        this.spectrumIdentificationItem.setName(name);
    }

    public void setCalculatedMassToCharge(Double calculatedMassToCharge) {
        double d = calculatedMassToCharge;
        ((Object)((Object)this)).getClass();
        this.spectrumIdentificationItem.setCalculatedMassToCharge(Rounder.roundDbl((double)d, (int)7));
    }

    public void setCalculatedPI(Float calculatedPI) {
        float f = calculatedPI.floatValue();
        ((Object)((Object)this)).getClass();
        this.spectrumIdentificationItem.setCalculatedPI(Rounder.roundFlt((float)f, (int)7));
    }

    public void setPeptideRef(Peptide peptide) {
        this.spectrumIdentificationItem.setPeptide(peptide);
    }

    public void setMassTableRef(MassTable massTable) {
        this.spectrumIdentificationItem.setMassTable(massTable);
    }

    public void setSampleRef(Sample sample) {
        this.spectrumIdentificationItem.setSample(sample);
    }

    public void addPeptideEvidenceRef(PeptideEvidenceRef peptideEvidenceRef) {
        this.spectrumIdentificationItem.getPeptideEvidenceRef().add(peptideEvidenceRef);
    }

    public void addUniquePeptideEvidenceRef(PeptideEvidenceRef peptideEvidenceRef) {
        ((Object)((Object)this)).getClass();
        String id = peptideEvidenceRef.getPeptideEvidence().getId();
        if (!this.mapPeptideEvidenceRefs.containsKey(id)) {
            this.spectrumIdentificationItem.getPeptideEvidenceRef().add(peptideEvidenceRef);
            this.mapPeptideEvidenceRefs.put(id, peptideEvidenceRef);
        } else {
            this.logger.trace("Tried to add a non-unique PeptideEvidenceRef to the SpectrumIdentificationItem");
        }
    }

    public void setFragmentation(Fragmentation fragmentation) {
        this.spectrumIdentificationItem.setFragmentation(fragmentation);
    }

    public void addUniqueCvParam(CvParam cvParam) {
        ((Object)((Object)this)).getClass();
        String acc = cvParam.getAccession();
        if (!this.mapCvParam.containsKey(acc)) {
            this.spectrumIdentificationItem.getCvParam().add(cvParam);
            this.mapCvParam.put(acc, cvParam);
        } else {
            this.logger.trace("Tried to add a non-unique CvParam with accession '{}' to the SpectrumIdentificationItem with ID '{}'", (Object)acc, (Object)this.spectrumIdentificationItem.getId());
        }
    }

    public void addUniqueUserParam(UserParam userParam) {
        ((Object)((Object)this)).getClass();
        String name = userParam.getName();
        if (!this.spectrumIdentificationItem.getUserParam().contains(userParam)) {
            this.spectrumIdentificationItem.getUserParam().add(userParam);
            this.mapUserParam.put(name, userParam);
        } else {
            this.logger.debug("Tried to add a non-unique UserParam with name '{}' to the SpectrumIdentificationItem with ID '{}' ", (Object)name, (Object)this.spectrumIdentificationItem.getId());
        }
    }
}

