/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidence;
import uk.ac.ebi.jmzidml.model.mzidml.SequenceCollection;

public class SequenceCollectionCreator
extends MyIdentMLObject {
    public SequenceCollection sequenceCollection;
    HashMap<String, DBSequence> mapDBSequences = new HashMap();
    HashMap<String, Peptide> mapPeptides = new HashMap();
    HashMap<String, PeptideEvidence> mapPeptideEvidences = new HashMap();

    public SequenceCollectionCreator(MzIdentMLMarshallerWriter mw) {
        super(mw);
        this.sequenceCollection = new SequenceCollection();
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.sequenceCollection, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void addUniqueDBSequence(DBSequence dbSequence) {
        ((Object)((Object)this)).getClass();
        String id = dbSequence.getId();
        if (!this.mapDBSequences.containsKey(id)) {
            this.sequenceCollection.getDBSequence().add(dbSequence);
            this.mapDBSequences.put(id, dbSequence);
        } else {
            this.logger.trace("Tried to add a non-unique DBSequence to the SequenceCollection - ID: " + id);
        }
    }

    public void addUniquePeptide(Peptide peptide) {
        ((Object)((Object)this)).getClass();
        String id = peptide.getId();
        if (!this.mapPeptides.containsKey(id)) {
            this.sequenceCollection.getPeptide().add(peptide);
            this.mapPeptides.put(id, peptide);
        } else {
            this.logger.trace("Tried to add a non-unique Peptide to the SequenceCollection - ID: " + id);
        }
    }

    public void addUniquePeptideEvidence(PeptideEvidence peptideEvidence) {
        ((Object)((Object)this)).getClass();
        String id = peptideEvidence.getId();
        if (!this.mapPeptideEvidences.containsKey(id)) {
            this.sequenceCollection.getPeptideEvidence().add(peptideEvidence);
            this.mapPeptideEvidences.put(id, peptideEvidence);
        } else {
            this.logger.trace("Tried to add a non-unique PeptideEvidence to the SequenceCollection");
        }
    }
}

