/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.SearchModification;
import uk.ac.ebi.jmzidml.model.mzidml.SpecificityRules;

public class SearchModificationCreator
extends MyIdentMLObject {
    public SearchModification searchModification;
    HashMap<String, CvParam> mapCvParam = new HashMap();

    public SearchModificationCreator(MzIdentMLMarshallerWriter mw, Boolean fixedMod, Float massDelta, List<String> residues) {
        super(mw);
        this.searchModification = new SearchModification();
        this.searchModification.setFixedMod(fixedMod.booleanValue());
        this.searchModification.setMassDelta(massDelta.floatValue());
        for (String residue : residues) {
            this.addResidue(residue);
        }
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.searchModification, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void addSpecificityRule(SpecificityRules specificityRules) {
        this.searchModification.getSpecificityRules().add(specificityRules);
    }

    public void addUniqueCvParam(CvParam cvParam) {
        ((Object)((Object)this)).getClass();
        String acc = cvParam.getAccession();
        if (!this.mapCvParam.containsKey(acc)) {
            this.searchModification.getCvParam().add(cvParam);
            this.mapCvParam.put(acc, cvParam);
        } else {
            this.logger.trace("Tried to add a non-unique CvParam with accession '{}' to the SearchModification with residues '{}'", (Object)acc, (Object)this.searchModification.getResidues());
        }
    }

    private void addResidue(String residue) {
        this.searchModification.getResidues().add(residue);
    }
}

