/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideHypothesis;
import uk.ac.ebi.jmzidml.model.mzidml.ProteinDetectionHypothesis;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class ProteinDetectionHypothesisCreator
extends MyIdentMLObject {
    public ProteinDetectionHypothesis proteinDetectionHypothesis;
    HashMap<String, PeptideHypothesis> mapPeptideHypotheses = new HashMap();
    HashMap<String, CvParam> mapCvParam = new HashMap();
    HashMap<String, UserParam> mapUserParam = new HashMap();

    public ProteinDetectionHypothesisCreator(MzIdentMLMarshallerWriter mw, String id, Boolean passThreshold) {
        super(mw);
        this.proteinDetectionHypothesis = new ProteinDetectionHypothesis();
        this.proteinDetectionHypothesis.setId(id);
        this.proteinDetectionHypothesis.setPassThreshold(passThreshold.booleanValue());
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.proteinDetectionHypothesis, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void setName(String name) {
        this.proteinDetectionHypothesis.setName(name);
    }

    public void setDBSequenceRef(DBSequence dbSequence) {
        this.proteinDetectionHypothesis.setDBSequence(dbSequence);
    }

    public void addUniquePeptideHypothesis(PeptideHypothesis peptideHypothesis) {
        ((Object)((Object)this)).getClass();
        String id = peptideHypothesis.getPeptideEvidenceRef();
        if (!this.mapPeptideHypotheses.containsKey(id)) {
            this.proteinDetectionHypothesis.getPeptideHypothesis().add(peptideHypothesis);
            this.mapPeptideHypotheses.put(id, peptideHypothesis);
        } else {
            this.logger.trace("Tried to add a non-unique PeptideHypothesis with ID '{}' to the ProteinDetectionHypothesis with ID '{}'", (Object)id, (Object)this.proteinDetectionHypothesis.getId());
        }
    }

    public void addUniqueCvParam(CvParam cvParam) {
        ((Object)((Object)this)).getClass();
        String acc = cvParam.getAccession();
        if (!this.mapCvParam.containsKey(acc)) {
            this.proteinDetectionHypothesis.getCvParam().add(cvParam);
            this.mapCvParam.put(acc, cvParam);
        } else {
            this.logger.trace("Tried to add a non-unique CvParam with accession '{}' to the ProteinDetectionHypothesis with ID '{}'", (Object)acc, (Object)this.proteinDetectionHypothesis.getId());
        }
    }

    public void addUniqueUserParam(UserParam userParam) {
        ((Object)((Object)this)).getClass();
        String name = userParam.getName();
        if (!this.mapUserParam.containsKey(name)) {
            this.proteinDetectionHypothesis.getUserParam().add(userParam);
            this.mapUserParam.put(name, userParam);
        } else {
            this.logger.trace("Tried to add a non-unique UserParam with name '{}' to the ProteinDetectionHypothesis with ID '{}' ", (Object)name, (Object)this.proteinDetectionHypothesis.getId());
        }
    }

    public void addParam(AbstractParam abstractParam) {
        if (abstractParam instanceof CvParam) {
            this.addUniqueCvParam((CvParam)abstractParam);
        } else if (abstractParam instanceof UserParam) {
            this.addUniqueUserParam((UserParam)abstractParam);
        }
    }

    public void addCvParam(CvParam cvParam) {
        this.proteinDetectionHypothesis.getCvParam().add(cvParam);
    }

    public void addUserParam(UserParam userParam) {
        this.proteinDetectionHypothesis.getUserParam().add(userParam);
    }
}

