/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DBSequence;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.PeptideEvidence;
import uk.ac.ebi.jmzidml.model.mzidml.TranslationTable;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class PeptideEvidenceCreator
extends MyIdentMLObject {
    public PeptideEvidence peptideEvidence;
    HashMap<String, CvParam> mapCvParam = new HashMap();
    HashMap<String, UserParam> mapUserParam = new HashMap();

    public PeptideEvidenceCreator(MzIdentMLMarshallerWriter mw, String id, DBSequence dbSequence_ref, Peptide peptide) {
        super(mw);
        this.peptideEvidence = new PeptideEvidence();
        this.peptideEvidence.setId(id);
        this.peptideEvidence.setDBSequence(dbSequence_ref);
        this.peptideEvidence.setPeptide(peptide);
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.peptideEvidence, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void setName(String name) {
        this.peptideEvidence.setName(name);
    }

    public void SetPeptide(Peptide peptide) {
        this.peptideEvidence.setPeptide(peptide);
    }

    public void setStart(Integer start) {
        this.peptideEvidence.setStart(start);
    }

    public void setEnd(Integer end) {
        this.peptideEvidence.setEnd(end);
    }

    public void setPre(String pre) {
        this.peptideEvidence.setPre(pre);
    }

    public void setPost(String post) {
        this.peptideEvidence.setPost(post);
    }

    public void setTranslationTable(TranslationTable translationTable) {
        this.peptideEvidence.setTranslationTable(translationTable);
    }

    public void setFrame(Integer frame) {
        this.peptideEvidence.setFrame(frame);
    }

    public void setIsDecoy(Boolean isDecoy) {
        this.peptideEvidence.setIsDecoy(isDecoy);
    }

    public void addUniqueCvParam(CvParam cvParam) {
        ((Object)((Object)this)).getClass();
        String acc = cvParam.getAccession();
        if (!this.mapCvParam.containsKey(acc)) {
            this.peptideEvidence.getCvParam().add(cvParam);
            this.mapCvParam.put(acc, cvParam);
        } else {
            this.logger.trace("Tried to add a non-unique CvParam with accession '{}' to the PeptideEvidence with ID '{}'", (Object)acc, (Object)this.peptideEvidence.getId());
        }
    }

    public void addUniqueUserParam(UserParam userParam) {
        ((Object)((Object)this)).getClass();
        String name = userParam.getName();
        if (!this.mapUserParam.containsKey(name)) {
            this.peptideEvidence.getUserParam().add(userParam);
            this.mapUserParam.put(name, userParam);
        } else {
            this.logger.debug("Tried to add a non-unique UserParam with name '{}' to the PeptideEvidence with ID '{}' ", (Object)name, (Object)this.peptideEvidence.getId());
        }
    }
}

