/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.List;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.Modification;
import uk.ac.ebi.jmzidml.model.mzidml.Peptide;
import uk.ac.ebi.jmzidml.model.mzidml.SubstitutionModification;

public class PeptideCreator
extends MyIdentMLObject {
    public Peptide peptide = new Peptide();

    public PeptideCreator(MzIdentMLMarshallerWriter mw, String id, String peptideSequence) {
        super(mw);
        this.peptide.setId(id);
        this.peptide.setPeptideSequence(peptideSequence);
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.peptide, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void updateID(String modIdStr) {
        this.peptide.setId(this.peptide.getId() + modIdStr);
    }

    public void setName(String name) {
        this.peptide.setName(name);
    }

    public void addUniqueModification(Modification modification) {
        List modList = this.peptide.getModification();
        for (Modification mod : modList) {
            if (mod.getLocation() != modification.getLocation()) continue;
            this.logger.debug("Modification at position {} already added to peptide {}", (Object)modification.getLocation(), (Object)this.peptide.getId());
            return;
        }
        this.peptide.getModification().add(modification);
    }

    public void addUniqueSubstitutionModification(SubstitutionModification substitutionModification) {
        List substModList = this.peptide.getSubstitutionModification();
        for (SubstitutionModification substMod : substModList) {
            if (substMod.getLocation() != substitutionModification.getLocation()) continue;
            this.logger.debug("SubstitutionModification at position {} already added to peptide {}", (Object)substitutionModification.getLocation(), (Object)this.peptide.getId());
            return;
        }
        this.peptide.getSubstitutionModification().add(substitutionModification);
    }

    public void addParam(AbstractParam abstractParam) {
        if (!this.peptide.getParamGroup().contains(abstractParam)) {
            this.peptide.getParamGroup().add(abstractParam);
        } else {
            this.logNotUniqueListElement(abstractParam);
        }
    }
}

