/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.AmbiguousResidue;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.MassTable;
import uk.ac.ebi.jmzidml.model.mzidml.Residue;
import uk.ac.ebi.jmzidml.model.mzidml.UserParam;

public class MassTableCreator
extends MyIdentMLObject {
    public MassTable massTable;
    HashMap<String, CvParam> mapCvParam = new HashMap();
    HashMap<String, UserParam> mapUserParam = new HashMap();

    public MassTableCreator(MzIdentMLMarshallerWriter mw, String id, String msLevel) {
        super(mw);
        String[] strArr;
        this.massTable = new MassTable();
        this.massTable.setId(id);
        for (String str : strArr = msLevel.split(MyConstants.STR_BLANK)) {
            if (str.isEmpty()) continue;
            this.massTable.getMsLevel().add(Integer.parseInt(str));
        }
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.massTable, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void setName(String name) {
        this.massTable.setName(name);
    }

    public void addResidue(Residue residue) {
        this.massTable.getResidue().add(residue);
    }

    public void addAmbiguousResidue(AmbiguousResidue ambiguousResidue) {
        this.massTable.getAmbiguousResidue().add(ambiguousResidue);
    }

    public void addUniqueCvParam(CvParam cvParam) {
        ((Object)((Object)this)).getClass();
        String acc = cvParam.getAccession();
        if (!this.mapCvParam.containsKey(acc)) {
            this.massTable.getCvParam().add(cvParam);
            this.mapCvParam.put(acc, cvParam);
        } else {
            this.logger.trace("Tried to add a non-unique CvParam with accession '{}' to the MassTable with ID '{}'", (Object)acc, (Object)this.massTable.getId());
        }
    }

    public void addUniqueUserParam(UserParam userParam) {
        ((Object)((Object)this)).getClass();
        String name = userParam.getName();
        if (!this.mapUserParam.containsKey(name)) {
            this.massTable.getUserParam().add(userParam);
            this.mapUserParam.put(name, userParam);
        } else {
            this.logger.debug("Tried to add a non-unique UserParam with name '{}' to the MassTable with ID '{}'", (Object)name, (Object)this.massTable.getId());
        }
    }
}

