/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.MzIdentML11Wrapper;

import de.mpc.MzIdentML11Wrapper.MyIdentMLObject;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import java.io.Writer;
import java.util.HashMap;
import uk.ac.ebi.jmzidml.model.MzIdentMLObject;
import uk.ac.ebi.jmzidml.model.mzidml.Inputs;
import uk.ac.ebi.jmzidml.model.mzidml.SearchDatabase;
import uk.ac.ebi.jmzidml.model.mzidml.SourceFile;
import uk.ac.ebi.jmzidml.model.mzidml.SpectraData;

public class InputsCreator
extends MyIdentMLObject {
    public Inputs inputs;
    HashMap<String, SourceFile> mapSourceFiles = new HashMap();
    HashMap<String, SearchDatabase> mapSearchDatabases = new HashMap();
    HashMap<String, SpectraData> mapSpectraData = new HashMap();

    public InputsCreator(MzIdentMLMarshallerWriter mw) {
        super(mw);
        this.inputs = new Inputs();
    }

    public void marshall() {
        this.mw.marshaller.marshal((MzIdentMLObject)this.inputs, (Writer)this.mw.fileWriter);
        this.flushMarshalling();
    }

    public void addUniqueSourceFile(SourceFile sourceFile) {
        ((Object)((Object)this)).getClass();
        String id = sourceFile.getId();
        if (!this.mapSourceFiles.containsKey(id)) {
            this.inputs.getSourceFile().add(sourceFile);
            this.mapSourceFiles.put(id, sourceFile);
        } else {
            this.logger.warn("Tried to add a non-unique SourceFile to the Inputs");
        }
    }

    public void addUniqueSearchDatabase(SearchDatabase searchDatabase) {
        ((Object)((Object)this)).getClass();
        String id = searchDatabase.getId();
        if (!this.mapSearchDatabases.containsKey(id)) {
            this.inputs.getSearchDatabase().add(searchDatabase);
            this.mapSearchDatabases.put(id, searchDatabase);
        } else {
            this.logger.warn("Tried to add a non-unique SearchDatabase to the Inputs");
        }
    }

    public void addUniqueSpectraData(SpectraData spectraData) {
        ((Object)((Object)this)).getClass();
        String id = spectraData.getId();
        if (!this.mapSpectraData.containsKey(id)) {
            this.inputs.getSpectraData().add(spectraData);
            this.mapSpectraData.put(id, spectraData);
        } else {
            this.logger.warn("Tried to add a non-unique SpectraData to the Inputs");
        }
    }
}

