/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.CvtBaseLib.SpecObj;

import de.mpc.CvtBaseLib.AParameterHandler;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import de.mpc.MzIdentML11Wrapper.OrganizationCreator;
import de.mpc.MzIdentML11Wrapper.ParentOrganizationCreator;
import java.util.ArrayList;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.Organization;
import uk.ac.ebi.jmzidml.model.mzidml.ParentOrganization;

public class DefaultOrganizations {
    private final String ORG_MPC = "ORG_MPC";
    private final String ORG_UNI_BOCHUM = "ORG_UNI_BOCHUM";
    private final String ORG_BRUKER = "ORG_BRUKER";
    private final String ORG_THERMO = "ORG_THERMO";
    private MzIdentMLMarshallerWriter mw = null;
    private AParameterHandler ph = null;

    public DefaultOrganizations(MzIdentMLMarshallerWriter mw, AParameterHandler ph) {
        this.mw = mw;
        this.ph = ph;
    }

    public ArrayList<Organization> getOrganizations(ConverterType convType) {
        ArrayList<Organization> organizationList = new ArrayList<Organization>();
        if (convType == ConverterType.PD) {
            organizationList.add(this.getThermoOrganization());
        } else if (convType == ConverterType.PS) {
            organizationList.add(this.getBrukerDaltonikOrganization());
        }
        organizationList.add(this.getMPCOrganization());
        organizationList.add(this.getUniBochumOrganization());
        return organizationList;
    }

    public Organization getBrukerDaltonikOrganization() {
        CvParamCreator cpcEMail;
        CvParamCreator cpcURL;
        OrganizationCreator oc = new OrganizationCreator(this.mw, this.ORG_BRUKER);
        oc.setName("Bruker Daltonik GmbH");
        CvParamCreator cpcAdr = this.ph.getCvParamCreatorForCvTerm("contact address", "MS");
        if (cpcAdr != null) {
            cpcAdr.setValue("Bruker Daltonik GmbH, D-28359 Bremen, Germany");
            oc.addParam((AbstractParam)cpcAdr.cvParam);
        }
        if ((cpcURL = this.ph.getCvParamCreatorForCvTerm("contact URL", "MS")) != null) {
            cpcURL.setValue("www.bdal.de");
            oc.addParam((AbstractParam)cpcURL.cvParam);
        }
        if ((cpcEMail = this.ph.getCvParamCreatorForCvTerm("contact email", "MS")) != null) {
            cpcEMail.setValue("proteineer.support@bdal.de");
            oc.addParam((AbstractParam)cpcEMail.cvParam);
        }
        return oc.organization;
    }

    public Organization getThermoOrganization() {
        OrganizationCreator oc = new OrganizationCreator(this.mw, this.ORG_THERMO);
        oc.setName("Thermo Fisher Scientific Inc.");
        CvParamCreator cpcAdr = this.ph.getCvParamCreatorForCvTerm("contact address", "MS");
        cpcAdr.setValue("81 Wyman Street, Waltham, MA 02454 USA");
        oc.addParam((AbstractParam)cpcAdr.cvParam);
        CvParamCreator cpcURL = this.ph.getCvParamCreatorForCvTerm("contact URL", "MS");
        cpcURL.setValue("http://www.thermoscientific.com/ecomm/servlet/productsdetail?productId=11961811&groupType=PRODUCT&searchType=0&storeId=11152");
        oc.addParam((AbstractParam)cpcURL.cvParam);
        CvParamCreator cpcEMail = this.ph.getCvParamCreatorForCvTerm("contact email", "MS");
        cpcEMail.setValue("http://www.thermo.com");
        oc.addParam((AbstractParam)cpcEMail.cvParam);
        return oc.organization;
    }

    public Organization getMPCOrganization() {
        CvParamCreator cpcEMail;
        CvParamCreator cpcURL;
        OrganizationCreator oc = new OrganizationCreator(this.mw, this.ORG_MPC);
        oc.setName("Medizinisches Proteom Center (MPC)");
        CvParamCreator cpcAdr = this.ph.getCvParamCreatorForCvTerm("contact address", "MS");
        if (cpcAdr != null) {
            cpcAdr.setValue("Zentrum fuer Klinische Forschung (building: ZKF), Universitaetsstrasse 150, D-44801 Bochum");
            oc.addParam((AbstractParam)cpcAdr.cvParam);
        }
        if ((cpcURL = this.ph.getCvParamCreatorForCvTerm("contact URL", "MS")) != null) {
            cpcURL.setValue("http://www.medizinisches-proteom-center.de/");
            oc.addParam((AbstractParam)cpcURL.cvParam);
        }
        if ((cpcEMail = this.ph.getCvParamCreatorForCvTerm("contact email", "MS")) != null) {
            cpcEMail.setValue("katrin.marcus_AT_rub.de");
            oc.addParam((AbstractParam)cpcEMail.cvParam);
        }
        oc.setParent(this.getUniBochumParentOrganization());
        return oc.organization;
    }

    private ParentOrganization getUniBochumParentOrganization() {
        Organization org = this.getUniBochumOrganization();
        ParentOrganizationCreator poc = new ParentOrganizationCreator(this.mw, org);
        return poc.parentOrganization;
    }

    public Organization getUniBochumOrganization() {
        CvParamCreator cpcURL;
        OrganizationCreator oc = new OrganizationCreator(this.mw, this.ORG_UNI_BOCHUM);
        oc.setName("Ruhr-University of Bochum");
        CvParamCreator cpcAdr = this.ph.getCvParamCreatorForCvTerm("contact address", "MS");
        if (cpcAdr != null) {
            cpcAdr.setValue("Universitaetsstrasse 150, D-44801 Bochum");
            oc.addParam((AbstractParam)cpcAdr.cvParam);
        }
        if ((cpcURL = this.ph.getCvParamCreatorForCvTerm("contact URL", "MS")) != null) {
            cpcURL.setValue("http://www.ruhr-uni-bochum.de/index_en.htm");
            oc.addParam((AbstractParam)cpcURL.cvParam);
        }
        return oc.organization;
    }

    public static enum ConverterType {
        PD,
        PS;

    }
}

