/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.CvtBaseLib;

import de.mpc.BaseLib.BaseCVHelper;
import de.mpc.MzIdentML11Wrapper.CvCreator;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;

public class CVHelper
extends BaseCVHelper {
    public static CvCreator getCV(MzIdentMLMarshallerWriter mw, String ontID) {
        return new CvCreator(mw, ontID, CVHelper.getOntologyFullName((String)ontID), CVHelper.getOntologyURI((String)ontID));
    }

    public static CvCreator getCvCreator(String cvID) {
        CvCreator cvc = new CvCreator();
        cvc.cv.setFullName(BaseCVHelper.getOntologyFullName((String)cvID));
        cvc.cv.setId(cvID);
        cvc.cv.setUri(BaseCVHelper.getOntologyURI((String)cvID));
        cvc.cv.setVersion(BaseCVHelper.getOntologyVersion((String)cvID));
        return cvc;
    }

    public static CvParamCreator getCvParamCreator(String accession, String name, CvCreator cvc) {
        CvParamCreator cpc = new CvParamCreator();
        cpc.cvParam.setAccession(accession);
        cpc.cvParam.setCv(cvc.cv);
        cpc.cvParam.setName(name);
        return cpc;
    }

    public static boolean testCVConsistency(CvParamCreator cpc, String methodName) {
        if (cpc != null) {
            String cvRefStr = cpc.cvParam.getCvRef();
            if (cpc.cvParam.getAccession().startsWith(cvRefStr)) {
                return true;
            }
            logger.trace("Accession and cvRef are inconsistent for {} with accession {} and cvRef {} in method {}.", new Object[]{cpc.cvParam.getName(), cpc.cvParam.getAccession(), cpc.cvParam.getCvRef(), methodName});
            return false;
        }
        logger.debug("cp is null in in method {}.", (Object)methodName);
        return true;
    }
}

