/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.CvtBaseLib;

import de.mpc.BaseLib.DB.DBParams;
import de.mpc.BaseLib.PICalculator;
import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.CvtBaseLib.SpecObj.SpecifiedOrganization;
import de.mpc.CvtBaseLib.SpecObj.SpecifiedResearcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AProgParams {
    protected final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private boolean bCalcTheoreticalMz = true;
    private boolean bCalcPI = true;
    private boolean bLogDBStructure = false;
    private boolean bResolveTaxID = true;
    private boolean bStartedFromGUI = true;
    private boolean bExportPDL = true;
    private boolean bUseShortIDs = true;
    private PICalculator.PKSet piCalcMethod = PICalculator.PKSet.Consensus;
    private String mzIdentMLOutputFullFileName = "";
    private String mzIdentMLOutputFilePath = "";
    private SpecifiedOrganization specOrganization = null;
    private SpecifiedResearcher specResearcher = null;
    private DBParams dbParams = null;

    public boolean doMzCalculation() {
        return this.bCalcTheoreticalMz;
    }

    public boolean doPICalculation() {
        return this.bCalcPI;
    }

    public boolean doDBStructureLogging() {
        return this.bLogDBStructure;
    }

    public boolean doTaxIDResolving() {
        return this.bResolveTaxID;
    }

    public boolean wasStartedFromGUI() {
        return this.bStartedFromGUI;
    }

    public boolean makePDLExport() {
        return this.bExportPDL;
    }

    public boolean useShortIDs() {
        return this.bUseShortIDs;
    }

    public PICalculator.PKSet getPICalculationMethod() {
        return this.piCalcMethod;
    }

    public String getMzIdentMLOutputFullFileName() {
        return this.mzIdentMLOutputFullFileName;
    }

    public String getMzIdentMLOutputFilePath() {
        int pos = this.mzIdentMLOutputFullFileName.lastIndexOf(47);
        if (pos > -1) {
            this.mzIdentMLOutputFilePath = this.mzIdentMLOutputFullFileName.substring(0, pos);
        } else {
            pos = this.mzIdentMLOutputFullFileName.lastIndexOf(92);
            if (pos > -1) {
                this.mzIdentMLOutputFilePath = this.mzIdentMLOutputFullFileName.substring(0, pos);
            }
        }
        return this.mzIdentMLOutputFilePath;
    }

    public SpecifiedOrganization getSpecifiedOrganization() {
        return this.specOrganization;
    }

    public SpecifiedResearcher getSpecifiedResearcher() {
        return this.specResearcher;
    }

    public DBParams getDBParams() {
        return this.dbParams;
    }

    public void setMzCalculationFlag(boolean bDoMzCalculation) {
        this.bCalcTheoreticalMz = bDoMzCalculation;
    }

    public void setPICalculationFlag(boolean bDoPICalculation) {
        this.bCalcPI = bDoPICalculation;
    }

    public void setDBStructureLogging(boolean bLogDB) {
        this.bLogDBStructure = bLogDB;
    }

    public void setTaxIDResolveFlag(boolean bResolveTax) {
        this.bResolveTaxID = bResolveTax;
    }

    public void setStartedFromGUI(boolean bStartedFromGUI) {
        this.bStartedFromGUI = bStartedFromGUI;
    }

    public void setExportPDLFlag(boolean bExportPDL) {
        this.bExportPDL = bExportPDL;
    }

    public void shouldUseShortIDs(boolean bShortIDs) {
        this.bUseShortIDs = bShortIDs;
    }

    public void setPICalculationMethod(PICalculator.PKSet calcMethod) {
        this.piCalcMethod = calcMethod;
    }

    public void setMzIdentMLOutputFullFileName(String fileName) {
        int pos = fileName.indexOf(58);
        if (pos > -1) {
            String part1 = fileName.substring(0, pos + 1);
            String part2 = fileName.substring(pos + 1).replace(MyConstants.STR_COLON, "");
            this.mzIdentMLOutputFullFileName = part1 + part2;
        } else {
            this.mzIdentMLOutputFullFileName = fileName;
        }
    }

    public void setSpecifiedOrganization(SpecifiedOrganization specOrganization) {
        this.specOrganization = specOrganization;
    }

    public void setSpecifiedResearcher(SpecifiedResearcher specResearcher) {
        this.specResearcher = specResearcher;
    }

    public void setDBParams(DBParams dbParams) {
        this.dbParams = dbParams;
    }
}

