/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.CvtBaseLib;

import de.mpc.BaseLib.CVQuery;
import de.mpc.BaseLib.Pair;
import de.mpc.CvtBaseLib.CVHelper;
import de.mpc.MzIdentML11Wrapper.CvCreator;
import de.mpc.MzIdentML11Wrapper.CvParamCreator;
import de.mpc.MzIdentML11Wrapper.MzIdentMLMarshallerWriter;
import de.mpc.MzIdentML11Wrapper.ParamCreator;
import de.mpc.MzIdentML11Wrapper.PersonCreator;
import de.mpc.MzIdentML11Wrapper.UserParamCreator;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;

public abstract class AParameterHandler {
    public final String STR_PERS_PROGRAMMER = "PERS_PROG";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final HashMap<Pair<String, String>, CvParamCreator> cvParamMap = new HashMap();
    private MzIdentMLMarshallerWriter mw = null;

    public AParameterHandler(MzIdentMLMarshallerWriter mw) {
        this.mw = mw;
    }

    public CvParamCreator getCvParamCreatorForCvTerm(String term, String ontology) {
        String key;
        Pair keyPair = new Pair((Object)term, (Object)ontology);
        if (this.cvParamMap.containsKey(keyPair)) {
            CvParamCreator cpcFromMap = this.cvParamMap.get(keyPair);
            CvParamCreator cpc = new CvParamCreator();
            cpc.cvParam.setAccession(cpcFromMap.cvParam.getAccession());
            cpc.cvParam.setCv(cpcFromMap.cvParam.getCv());
            cpc.cvParam.setName(cpcFromMap.cvParam.getName());
            cpc.cvParam.setUnitAccession(cpcFromMap.cvParam.getUnitAccession());
            cpc.cvParam.setUnitCv(cpcFromMap.cvParam.getUnitCv());
            cpc.cvParam.setUnitName(cpcFromMap.cvParam.getUnitName());
            cpc.cvParam.setValue("");
            return cpc;
        }
        if (term.startsWith("Mapping") || term.startsWith("MascotXValue") || term.equals("phospho_beta_elim") || term.equals("Carbamidomethyl / +57.021 Da (C)") || term.equals("Oxidation / +15.995 Da (M)")) {
            switch (term = this.replaceMappingModificationName(term)) {
                case "Carbamidomethyl / +57.021 Da (C)": 
                case "Oxidation / +15.995 Da (M)": {
                    ontology = "UNIMOD";
                    break;
                }
                case "residues isobaric at 113.084064 Da": 
                case "residues isobaric at 71.037114 Da": 
                case "residues isobaric at 128.058578 Da": 
                case "dehydrated residue": 
                case "L-cysteine residue": 
                case "L-histidine residue": 
                case "L-lysine residue": 
                case "L-proline residue": 
                case "L-arginine residue": 
                case "L-tyrosine residue": {
                    ontology = "MOD";
                    break;
                }
                case "unknown modification": {
                    ontology = "MS";
                }
            }
        }
        if (this.checkKey(key = CVQuery.getUniqueOLSKey((String)term, (String)ontology), term, ontology)) {
            CvCreator cvc = CVHelper.getCV(this.mw, ontology);
            CvParamCreator cpc = new CvParamCreator(this.mw, term, cvc, key, ontology);
            if (ontology.equals("MOD")) {
                cvc = CVHelper.getCV(this.mw, "MOD");
                cpc = new CvParamCreator(this.mw, term, cvc, key, ontology);
            }
            CVHelper.testCVConsistency(cpc, "getCvParamCreatorForCvTerm-1");
            return cpc;
        }
        if (ontology.equals("MOD")) {
            key = CVQuery.getUniqueOLSKey((String)term, (String)"UNIMOD");
            if (this.checkKey(key, term, "UNIMOD")) {
                CvCreator cvc = CVHelper.getCV(this.mw, "UNIMOD");
                CvParamCreator cpc = new CvParamCreator(this.mw, term, cvc, key, ontology);
                CVHelper.testCVConsistency(cpc, "getCvParamCreatorForCvTerm-2");
                return cpc;
            }
            return null;
        }
        return null;
    }

    protected final String replaceMappingModificationName(String modName) {
        if (modName.equals("MappingA")) {
            return "residues isobaric at 71.037114 Da";
        }
        if (modName.equals("MappingC")) {
            return "L-cysteine residue";
        }
        if (modName.equals("MappingH")) {
            return "L-histidine residue";
        }
        if (modName.equals("MappingK")) {
            return "L-lysine residue";
        }
        if (modName.equals("MappingL") || modName.equals("MappingL / +113.084 Da (X)")) {
            return "residues isobaric at 113.084064 Da";
        }
        if (modName.equals("MappingP")) {
            return "L-proline residue";
        }
        if (modName.equals("MappingQ")) {
            return "residues isobaric at 128.058578 Da";
        }
        if (modName.equals("MappingR")) {
            return "L-arginine residue";
        }
        if (modName.equals("MappingY")) {
            return "L-tyrosine residue";
        }
        if (modName.equals("phospho_beta_elim")) {
            return "dehydrated residue";
        }
        if (modName.equals("Carbamidomethyl / +57.021 Da (C)")) {
            return "Carbamidomethyl";
        }
        if (modName.equals("Oxidation / +15.995 Da (M)")) {
            return "Oxidation";
        }
        if (modName.startsWith("MascotXValue") || modName.equals("MappingD") || modName.equals("MappingE") || modName.equals("MappingF") || modName.equals("MappingG") || modName.equals("MappingM") || modName.equals("MappingN") || modName.equals("MappingS") || modName.equals("MappingT") || modName.equals("MappingV") || modName.equals("MappingW")) {
            return "unknown modification";
        }
        this.logger.trace("Unhandled modName {} in replaceMappingModificationName()", (Object)modName);
        return modName;
    }

    private boolean checkKey(String key, String term, String ontology) {
        if (key == null) {
            this.logger.debug("Null accession key for term {} of ontology {}", (Object)term, (Object)ontology);
            return false;
        }
        if (key.isEmpty() && !term.equals("unknown modification")) {
            this.logger.trace("Empty accession key for term {} of ontology {}", (Object)term, (Object)ontology);
        }
        return true;
    }

    public CvParamCreator getCvParamCreatorForCvTermAndSetStringValue(String term, String ontology, String strValue) {
        CvParamCreator cpc = this.getCvParamCreatorForCvTerm(term, ontology);
        if (cpc != null) {
            cpc.setValue(strValue);
            CVHelper.testCVConsistency(cpc, "getCvParamCreatorForCvTermAndSetStringValue");
        }
        return cpc;
    }

    public ParamCreator getParamCreatorForCvTerm(String term, String ontology, String value) {
        ParamCreator pc = new ParamCreator(this.mw);
        if (term.equals("database name")) {
            UserParamCreator upc = new UserParamCreator(this.mw, term);
            pc.setAbstractParam((AbstractParam)upc.userParam);
        } else {
            CvParamCreator cpc = this.getCvParamCreatorForCvTerm(term, ontology);
            if (cpc == null) {
                this.logger.error("ERROR - The OLS (Ontology Lookup Server) at the EBI is down - term: {} \tontology: {}", (Object)term, (Object)ontology);
            } else {
                pc.setAbstractParam((AbstractParam)cpc.cvParam);
            }
        }
        return pc;
    }

    public UserParamCreator getUserParamCreatorForParamName(String paramName) {
        return new UserParamCreator(this.mw, paramName);
    }

    protected final CvParamCreator getCvParamCreatorForCvAccession(String accession, String ontology) {
        String term = CVQuery.getUniqueOLSTerm((String)accession, (String)ontology);
        CvCreator cvc = CVHelper.getCV(this.mw, ontology);
        CvParamCreator cpc = new CvParamCreator(this.mw, term, cvc, accession, ontology);
        CVHelper.testCVConsistency(cpc, "getCvParamCreatorForCvAccession");
        return cpc;
    }

    public PersonCreator getProgrammer() {
        PersonCreator pcProg = new PersonCreator(this.mw, this.STR_PERS_PROGRAMMER);
        CvParamCreator cpcMail = this.getCvParamCreatorForCvTerm("contact email", "MS");
        cpcMail.setValue("mayerg97@rub.de");
        pcProg.addParam((AbstractParam)cpcMail.cvParam);
        CvParamCreator cpcAdr = this.getCvParamCreatorForCvTerm("contact address", "MS");
        cpcAdr.setValue("Medical Proteome Center (MPC), Universit\u00e4tsstrasse 150, ZKF I, E.049a, D-44801 Bochum");
        pcProg.addParam((AbstractParam)cpcAdr.cvParam);
        this.setFullName(pcProg, "Gerhard Mayer");
        return pcProg;
    }

    private PersonCreator setFullName(PersonCreator pcProg, String fullName) {
        String lastName;
        String firstName;
        int pos = fullName.indexOf(32);
        if (pos >= 0) {
            firstName = fullName.substring(0, pos);
            lastName = fullName.substring(pos + 1);
        } else {
            firstName = "";
            lastName = fullName;
        }
        pcProg.setFirstName(firstName);
        pcProg.setLastName(lastName);
        return pcProg;
    }
}

