/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.progress;

import de.mpc.BaseLib.CurrentTime;
import de.mpc.BaseLib.MyLogger;
import de.mpc.BaseLib.constants.MyConstants;
import javax.swing.JProgressBar;

public class MyProgressBar
extends JProgressBar {
    private static final String STR_PERCENT_FINISHED = "% finished";
    private static final String STR_STARTED = " started";
    private static final String STR_FINISHED = " finished";
    private static final String STR_AT = " at ";
    JProgressBar progressBar = null;
    int maxValue = 100;
    int counter = 0;
    boolean bVerbose = false;
    String description = null;

    public MyProgressBar(int maxValue, String description, boolean bVerbose) {
        this.maxValue = maxValue;
        this.progressBar = new JProgressBar(0, this.maxValue);
        this.progressBar.setVisible(true);
        this.progressBar.setStringPainted(true);
        this.bVerbose = bVerbose;
        this.description = description;
        if (this.bVerbose) {
            StringBuilder sb = new StringBuilder();
            sb.append(MyConstants.newline).append("MyProgressBar for ");
            sb.append(this.description);
            sb.append(STR_STARTED).append(STR_AT);
            sb.append(CurrentTime.getCurrentTime());
            MyLogger.writeLogMsg(sb.toString());
        }
    }

    public void incCounter() {
        ++this.counter;
        assert (this.counter <= this.maxValue);
        if (this.bVerbose) {
            float ratio = 100.0f * ((float)this.counter / (float)this.maxValue);
            int percent = (int)ratio;
            this.progressBar.setValue(percent);
            this.progressBar.setString(this.getPercentString(percent));
            this.progressBar.updateUI();
            MyLogger.writeProgress(this.counter, this.maxValue);
            if (this.counter == this.maxValue) {
                StringBuilder sb = new StringBuilder();
                sb.append("\nMyProgressBar for ");
                sb.append(this.description);
                sb.append(STR_FINISHED).append(STR_AT);
                sb.append(CurrentTime.getCurrentTime());
                MyLogger.writeLogMsg(sb.toString());
                this.counter = 0;
            }
        }
    }

    public String getPercentString(Integer percent) {
        String tmpStr = percent.toString();
        StringBuilder sb = new StringBuilder(percent.toString());
        sb.append(tmpStr);
        if (this.bVerbose) {
            sb.append('(').append(this.counter).append('/').append(this.maxValue).append(')');
        }
        sb.append(STR_PERCENT_FINISHED);
        return sb.toString();
    }

    public int getCounter() {
        return this.counter;
    }
}

