/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.progress;

import de.mpc.BaseLib.constants.MyConstants;
import de.mpc.BaseLib.progress.ConversionProgressThread;
import de.mpc.BaseLib.progress.MyProgressBar;
import java.util.Locale;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionProgress {
    private final String STR_CREATION = "ConversionProgress object created";
    private final int UPDATE_INTERVAL = 10000;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Stack<MyProgressBar> progressBarStack = new Stack();
    private final Stack<Integer> maxNoStack = new Stack();
    private final Stack<Integer> actNoStack = new Stack();
    private final Stack<String> statusTextStack = new Stack();
    private final ConversionProgressThread convProgThread = new ConversionProgressThread();
    private boolean bPAGFound = false;

    public ConversionProgress(int maxCount) {
        this.initStacksAndStartThread(maxCount, this.STR_CREATION);
    }

    private void initStacksAndStartThread(int maxCount, String statText) {
        this.actNoStack.clear();
        this.actNoStack.push(0);
        this.maxNoStack.clear();
        this.maxNoStack.push(maxCount);
        this.statusTextStack.clear();
        this.statusTextStack.push(statText);
        this.progressBarStack.clear();
        MyProgressBar progressBar = new MyProgressBar(maxCount, statText, true);
        this.progressBarStack.push(progressBar);
        this.convProgThread.setUpdateInterval(this.UPDATE_INTERVAL);
    }

    public String getProgressText() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getStatusText()).append(" - ");
        sb.append(MyConstants.STR_PARENTHESIS_OPEN);
        sb.append(String.format(Locale.ENGLISH, "%6d", this.getActNumber()));
        sb.append(MyConstants.STR_SLASH);
        sb.append(String.format(Locale.ENGLISH, "%6d", this.getMaxNumber()));
        sb.append(MyConstants.STR_PARENTHESIS_CLOSE).append(" - ");
        sb.append(String.format(Locale.ENGLISH, "%3.1f", Float.valueOf(this.getPercentageDone())));
        sb.append(MyConstants.STR_PERCENT);
        return sb.toString();
    }

    private float getPercentageDone() {
        int maxNumber = this.getMaxNumber();
        int actNumber = this.getActNumber();
        if (actNumber < maxNumber && maxNumber > 0) {
            return (float)actNumber / (float)maxNumber * 100.0f;
        }
        return 0.0f;
    }

    public void replaceStackState(String statText) {
        this.peekStackState();
        this.pushStackState(0, 1, statText);
    }

    public void replaceStackState(int maxCount, String statText) {
        this.peekStackState();
        this.pushStackState(0, maxCount, statText);
    }

    public void replaceStackState(int actCount, int maxCount, String statText) {
        this.peekStackState();
        this.pushStackState(actCount, maxCount, statText);
    }

    public void pushStackState(String statText) {
        int actNumber = this.getActNumber();
        this.actNoStack.push(actNumber);
        int maxNumber = this.getMaxNumber();
        this.maxNoStack.push(maxNumber);
        this.statusTextStack.push(statText);
        MyProgressBar progressBar = new MyProgressBar(maxNumber, statText, true);
        this.progressBarStack.push(progressBar);
    }

    public void pushStackState(int maxCount, String statText) {
        int actNumber = this.getActNumber();
        this.actNoStack.push(actNumber);
        this.maxNoStack.push(maxCount);
        this.statusTextStack.push(statText);
        MyProgressBar progressBar = new MyProgressBar(maxCount, statText, true);
        this.progressBarStack.push(progressBar);
    }

    public void pushStackState(int actCount, int maxCount, String statText) {
        this.actNoStack.push(actCount);
        this.maxNoStack.push(maxCount);
        this.statusTextStack.push(statText);
        MyProgressBar progressBar = new MyProgressBar(maxCount, statText, true);
        this.progressBarStack.push(progressBar);
    }

    public void peekStackState() {
        if (!(this.actNoStack.isEmpty() || this.maxNoStack.isEmpty() || this.statusTextStack.isEmpty() || this.progressBarStack.isEmpty())) {
            this.actNoStack.peek();
            this.maxNoStack.peek();
            this.statusTextStack.peek();
            this.progressBarStack.peek();
        } else {
            this.logger.warn("peekStackState() is not possible - stacks are already empty.");
        }
    }

    public void incCounter() {
        int actNo = this.popActNumber() + 1;
        this.pushActNumber(actNo);
        this.incProgressBar();
        assert (this.getActNumber() < this.getMaxNumber());
    }

    private void incProgressBar() {
        MyProgressBar progressBar = this.popProgressBar();
        progressBar.incCounter();
        this.pushProgressBar(progressBar);
    }

    public boolean getPAGFoundFlag() {
        return this.bPAGFound;
    }

    private int popActNumber() {
        return this.actNoStack.pop();
    }

    public int getActNumber() {
        return this.actNoStack.peek();
    }

    public int getMaxNumber() {
        return this.maxNoStack.peek();
    }

    private String getStatusText() {
        return this.statusTextStack.peek();
    }

    private MyProgressBar popProgressBar() {
        return this.progressBarStack.pop();
    }

    public void setPAGFoundFlag(boolean bValue) {
        this.bPAGFound = bValue;
    }

    private void pushActNumber(int actNo) {
        this.actNoStack.push(actNo);
    }

    private void pushProgressBar(MyProgressBar progressBar) {
        this.progressBarStack.push(progressBar);
    }
}

