/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.obo;

import de.mpc.BaseLib.BaseCVHelper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBOInitialRead {
    private static final String ID_LINE = "id: ";
    private static final String DATA_VERSION_LINE = "data-version: ";
    private static final String NAME_LINE = "name: ";
    private static final String NEW_TERM_LINE = "[Term]";
    private static final String REMARK_LINE = "remark: ";
    private static final String SYNONYM_LINE = "synonym: ";
    private static final String VERSION_LINE_PART = "version: ";
    private static final String XREF_VALUE_TYPE_LINE = "xref: value-type:";
    private static final String STR_ERROR = "Error";
    private static final int ANZ_TRIALS = 1;
    private static final Logger logger = LoggerFactory.getLogger(OBOInitialRead.class);
    private static final HashMap<String, String> term2IDMap = new HashMap();
    private static final HashMap<String, String> ID2TermMap = new HashMap();
    private static final HashMap<String, Boolean> hasValueTypeMap = new HashMap();
    private static boolean bReadIn = false;

    private static void initMaps() {
        String[] ontologyIDs;
        for (String ontID : ontologyIDs = BaseCVHelper.getOntologyIDsForInitialRead()) {
            String uri = BaseCVHelper.getOntologyURI(ontID);
            OBOInitialRead.readOBOFileFromInternet(ontID, uri);
        }
        bReadIn = true;
        logger.debug("All OBO files read in.");
    }

    private static void readOBOFileFromInternet(String ontID, String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException malfexc) {
            malfexc.printStackTrace(System.err);
            System.err.println("Please check the URL for the obo file: " + urlStr);
        }
        if (url != null) {
            BufferedReader buff = null;
            int anzTrials = 1;
            boolean bReadFromLocalResource = false;
            do {
                logger.debug("Start {}th read trial.", (Object)anzTrials);
                try {
                    buff = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
                }
                catch (IOException ioexc) {
                    logger.warn("Can't read obo file {} from the Internet in the {}th trial.", (Object)urlStr, (Object)anzTrials);
                    if (anzTrials < 1) continue;
                    logger.error("Please check your internet connection or try later again.");
                    System.err.println("Please check your internet connection or try later again.");
                    JOptionPane.showMessageDialog(null, "The website " + urlStr + " is not reachable at the moment - try to read from local resource", STR_ERROR, 0);
                    buff = OBOInitialRead.readOBOFileFromLocalResource(ontID);
                    bReadFromLocalResource = true;
                }
            } while (buff == null || ++anzTrials <= 1);
            if (!bReadFromLocalResource) {
                OBOInitialRead.readOBOFromBufferedReader(buff, ontID);
            }
        } else {
            logger.debug("URL is null in readOBOFileFromInternet() for {}", (Object)urlStr);
        }
    }

    private static void readOBOFromBufferedReader(BufferedReader buff, String ontID) {
        try {
            String line;
            String id = "";
            String cvTerm = "";
            ArrayList<String> synonymList = new ArrayList<String>();
            logger.debug("Reading OBO file {} from buffer.", (Object)ontID);
            while ((line = buff.readLine()) != null) {
                int pos1;
                if (line.equals(NEW_TERM_LINE)) {
                    OBOInitialRead.add2Maps(ontID, id, cvTerm, synonymList);
                    cvTerm = "";
                    id = "";
                    synonymList = new ArrayList();
                    continue;
                }
                if (line.startsWith(ID_LINE)) {
                    pos1 = line.indexOf(58);
                    id = line.substring(pos1 + 1).trim();
                    continue;
                }
                if (line.startsWith(NAME_LINE)) {
                    pos1 = line.indexOf(58);
                    cvTerm = line.substring(pos1 + 1).trim();
                    continue;
                }
                if ((line.startsWith(REMARK_LINE) || line.startsWith(DATA_VERSION_LINE)) && line.indexOf(VERSION_LINE_PART) > 0) {
                    pos1 = line.lastIndexOf(58);
                    String version = line.substring(pos1 + 1).trim();
                    BaseCVHelper.setVersion(ontID, version);
                    continue;
                }
                if (line.startsWith(SYNONYM_LINE)) {
                    pos1 = line.indexOf(34);
                    int pos2 = line.lastIndexOf(34);
                    if (pos2 <= pos1) continue;
                    synonymList.add(line.substring(pos1 + 1, pos2));
                    continue;
                }
                if (!line.startsWith(XREF_VALUE_TYPE_LINE)) continue;
                hasValueTypeMap.put(ontID + cvTerm, true);
            }
            buff.close();
            OBOInitialRead.add2Maps(ontID, id, cvTerm, synonymList);
            logger.info("OBO file {} read from local resource.", (Object)ontID);
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace(System.err);
            logger.debug("Error reading the obo file from the BufferedReader for {}", (Object)ontID);
        }
    }

    protected static BufferedReader readOBOFileFromLocalResource(String ontID) {
        String oboFilePath;
        logger.debug("Reading the OBO file {} from local resource.", (Object)ontID);
        switch (ontID) {
            case "MOD": {
                oboFilePath = ".\\resources\\obofiles\\PSI-MOD.obo";
                break;
            }
            case "MS": {
                oboFilePath = ".\\resources\\obofiles\\psi-ms.obo";
                break;
            }
            case "UNIMOD": {
                oboFilePath = ".\\resources\\obofiles\\unimod.obo";
                break;
            }
            case "UO": {
                oboFilePath = ".\\resources\\obofiles\\unit.obo";
                break;
            }
            default: {
                String msg = "Ontology file " + ontID + " cannot be read";
                logger.error(msg);
                JOptionPane.showMessageDialog(null, msg, STR_ERROR, 0);
                oboFilePath = "";
            }
        }
        return OBOInitialRead.readOboFileFromLocalFilePath(ontID, oboFilePath);
    }

    private static BufferedReader readOboFileFromLocalFilePath(String ontID, String oboFilePath) {
        try {
            if (!oboFilePath.isEmpty()) {
                BufferedReader buff = new BufferedReader(new InputStreamReader(new FileInputStream(oboFilePath)));
                OBOInitialRead.readOBOFromBufferedReader(buff, ontID);
                return buff;
            }
            logger.error("Unhandled case in readOBOFileFromLocalResource(): {}\t{}", (Object)ontID, (Object)oboFilePath);
            System.exit(-1);
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace(System.err);
        }
        return null;
    }

    private static void add2Maps(String ontID, String id, String cvTerm, ArrayList<String> synonymList) {
        String suffix = '_' + ontID;
        String key = cvTerm + suffix;
        term2IDMap.put(key, id);
        for (String synonym : synonymList) {
            key = synonym + suffix;
            term2IDMap.put(key, id);
        }
        key = id + suffix;
        ID2TermMap.put(key, cvTerm);
    }

    public static String getIDFromCVTerm(String cvTerm, String ontologyID) {
        String key;
        if (!bReadIn) {
            OBOInitialRead.initMaps();
        }
        if (term2IDMap.containsKey(key = cvTerm + '_' + ontologyID)) {
            return term2IDMap.get(key);
        }
        return "";
    }

    public static String getCVTermFromID(String id, String ontologyID) {
        String key;
        if (!bReadIn) {
            OBOInitialRead.initMaps();
        }
        if (ID2TermMap.containsKey(key = id + '_' + ontologyID)) {
            return ID2TermMap.get(key);
        }
        return "";
    }

    public static boolean isValidTerm(String termStr, String ontologyID) {
        if (!bReadIn) {
            OBOInitialRead.initMaps();
        }
        return term2IDMap.containsKey(termStr + '_' + ontologyID);
    }

    public static boolean hasCVTermAValue(String termStr, String ontID) {
        String tmpStr = ontID + termStr;
        return hasValueTypeMap.containsKey(tmpStr) && hasValueTypeMap.get(tmpStr) != false;
    }
}

