/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import de.mpc.BaseLib.SystemProps;
import de.mpc.BaseLib.XML.XsdValidationLogErrorHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSchemaValidator
extends DefaultHandler {
    public static final String STR_MzIdentML_SCHEMA_URL = "http://www.psidev.info/sites/default/files/mzIdentML1.1.0.xsd";
    public static final String STR_MzQuantML_SCHEMA_URL = "https://code.google.com/p/mzquantml/source/browse/trunk/schema/mzQuantML_1_0_0.xsd";
    public static final String STR_TRAML_SCHEMA_URL = "http://www.peptideatlas.org/schemas/TraML/1.0.0/TraML1.0.0.xsd";
    public static final String STR_MZML_SCHEMA_URL = "http://psidev.cvs.sourceforge.net/viewvc/psidev/psi/psi-ms/mzML/schema/mzML1.1.0.xsd";
    public static final String STR_PRIDEXML_SCHEMA_URL = "http://www.ebi.ac.uk/pride/help_resources/pride.xsd";
    private static final int BUF_SIZE = 4096;
    private static final Logger logger = LoggerFactory.getLogger(XMLSchemaValidator.class);

    protected static final boolean validate(Schema xsdSchema, String xmlFileName) {
        try {
            Validator validator = xsdSchema.newValidator();
            validator.setErrorHandler(new XsdValidationLogErrorHandler(xmlFileName));
            validator.validate(new StreamSource(new File(xmlFileName)));
        }
        catch (IOException | SAXException saxex) {
            saxex.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public static boolean validateXML(String schemaFileName, String xmlFileName) {
        return XMLSchemaValidator.validate(XMLSchemaValidator.compileXsdSchema(schemaFileName), xmlFileName);
    }

    public static boolean validateMzIdentMLFile(String mzIdentMLFileName) {
        return XMLSchemaValidator.validateXML(STR_MzIdentML_SCHEMA_URL, mzIdentMLFileName);
    }

    public static boolean validateMzQuantMLFile(String mzQuantMLFileName) {
        return XMLSchemaValidator.validateXML(STR_MzQuantML_SCHEMA_URL, mzQuantMLFileName);
    }

    public static boolean validateTraMLFile(String fullTraMLFileName) {
        return XMLSchemaValidator.validateXML(STR_TRAML_SCHEMA_URL, fullTraMLFileName);
    }

    public static boolean validateMzMLFile(String fullMzMLFileName) {
        return XMLSchemaValidator.validateXML(STR_MZML_SCHEMA_URL, fullMzMLFileName);
    }

    public static boolean validatePRIDEXMLFile(String fullPRIDEXMLFileName) {
        return XMLSchemaValidator.validateXML(STR_PRIDEXML_SCHEMA_URL, fullPRIDEXMLFileName);
    }

    protected static final File readXMLSchemaFileFromInternet(String urlStr) {
        try {
            FileOutputStream fos;
            File file;
            URL url = new URL(urlStr);
            URLConnection connection = url.openConnection();
            try (InputStream in = connection.getInputStream();){
                int len;
                file = new File(SystemProps.getTemporaryFilesPath() + "tmp.xsd");
                fos = new FileOutputStream(file);
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) != -1) {
                    fos.write(buf, 0, len);
                }
            }
            fos.close();
            return file;
        }
        catch (IOException ioex) {
            ioex.printStackTrace(System.err);
            return null;
        }
    }

    protected static final Schema compileXsdSchema(String xsdSchema) {
        Schema schema = null;
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            File file = XMLSchemaValidator.readXMLSchemaFileFromInternet(xsdSchema);
            schema = schemaFactory.newSchema(file);
            file.delete();
        }
        catch (SAXException saxex) {
            saxex.printStackTrace(System.err);
        }
        return schema;
    }
}

