/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import de.mpc.BaseLib.XML.BaseSaxParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHandlerBase<T>
extends DefaultHandler {
    protected final String STR_LIST = "List";
    protected final boolean START_FLAG = true;
    protected final boolean END_FLAG = false;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final boolean bDebugFlag = true;
    protected BaseSaxParser parser = null;
    protected String lastActivated = null;

    public XMLHandlerBase(BaseSaxParser parser) {
        this.parser = parser;
    }

    @Override
    public void startDocument() throws SAXException {
        this.logger.error("Please override startDocument in the derived ...XMLHandler class.");
    }

    @Override
    public void endDocument() throws SAXException {
        this.logger.error("Please override endDocument in the derived ...XMLHandler class.");
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.printTraceStr("processingInstruction Target: " + target + "\tData: " + data);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.logger.error("Please override startElement in the derived ...XMLHandler class.");
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.logger.error("Please override endElement in the derived ...XMLHandler class.");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.logger.error("Please override characters in the derived ...XMLHandler class.");
    }

    protected final void checkIfCharactersAreEmpty(String charStr, String msgStr) {
        if (charStr.length() > 0) {
            this.logger.error(msgStr + '-' + charStr);
        }
    }

    protected abstract void checkForEmptyLists();

    protected final boolean isNotAllWhiteSpace(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected final String getKeyFromStr(String str) {
        int pos = str.indexOf(58);
        if (pos > -1) {
            return str.substring(0, str.indexOf(58));
        }
        return str;
    }

    protected final String getValueFromStr(String str) {
        int pos = str.indexOf(58);
        if (pos > -1) {
            return str.substring(str.indexOf(58) + 1, str.length());
        }
        return str;
    }

    protected final String trimChar(String str, char chToTrim) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == chToTrim) continue;
            sb.append(chToTrim);
        }
        return sb.toString();
    }

    protected final BigInteger getBigIntFromStr(String str) {
        BigInteger bigInt = BigInteger.ZERO;
        if (str.isEmpty()) {
            return bigInt;
        }
        try {
            bigInt = BigInteger.valueOf(Long.parseLong(str));
        }
        catch (NumberFormatException nfex) {
            try {
                bigInt = BigInteger.valueOf(Long.parseLong(str, 16));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return bigInt;
    }

    protected final BigDecimal getBigDecimalFromStr(String str) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (str.isEmpty()) {
            return bigDecimal;
        }
        try {
            bigDecimal = BigDecimal.valueOf(Long.parseLong(str));
        }
        catch (NumberFormatException nfex) {
            try {
                bigDecimal = BigDecimal.valueOf(Long.parseLong(str, 16));
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace(System.err);
            }
        }
        return bigDecimal;
    }

    protected final ArrayList<T> resetList(ArrayList<T> arrList) {
        arrList.clear();
        arrList = null;
        return arrList;
    }

    protected final String getClassNameFromDecoratedName(String str) {
        String retStr;
        int posAt = str.indexOf(64);
        int posDollar = str.lastIndexOf(36);
        if (posAt == -1 && posDollar == -1) {
            return str;
        }
        if (posDollar > -1) {
            String tmpStr;
            retStr = tmpStr = str.substring(posDollar + 1, posAt);
        } else if (posAt > -1) {
            String tmpStr = str.substring(0, posAt);
            int posPoint = tmpStr.lastIndexOf(46) + 1;
            retStr = tmpStr.substring(posPoint);
        } else {
            retStr = "";
        }
        return retStr;
    }

    protected final void printTraceStr(String str) {
        this.getClass();
        this.logger.trace(str);
    }
}

