/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class XMLGregorianCalendarConverter {
    private static DatatypeFactory datatypeFactory = null;

    public static XMLGregorianCalendar asXMLGregorianCalendar(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTimeInMillis(date.getTime());
        return datatypeFactory.newXMLGregorianCalendar(gc);
    }

    public static Date asDate(XMLGregorianCalendar xgc) {
        if (xgc == null) {
            return null;
        }
        return xgc.toGregorianCalendar().getTime();
    }

    public static XMLGregorianCalendar getXMLGregorianCalendar(String str, String dateFormatStr) {
        Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatStr);
        try {
            date = simpleDateFormat.parse(str);
        }
        catch (ParseException ex) {
            ex.printStackTrace(System.err);
        }
        XMLGregorianCalendar xgc = XMLGregorianCalendarConverter.asXMLGregorianCalendar(date);
        return xgc;
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException dce) {
            throw new IllegalStateException("Exception while obtaining DatatypeFactory instance", dce);
        }
    }
}

