/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class MySAXHandler
extends DefaultHandler {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    @Override
    public void startDocument() {
        this.logger.debug("Start document: ");
    }

    @Override
    public void endDocument() {
        this.logger.debug("End document: ");
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attr) {
        this.logger.debug("Start element: local name: {} qname: {} uri: {}", new Object[]{localName, qname, uri});
        int attrCount = attr.getLength();
        if (attrCount > 0) {
            this.logger.debug("Attributes:");
            for (int i = 0; i < attrCount; ++i) {
                this.logger.debug("  Name : {}", (Object)attr.getQName(i));
                this.logger.debug("  Type : {}", (Object)attr.getType(i));
                this.logger.debug("  Value: {}", (Object)attr.getValue(i));
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qname) {
        this.logger.debug("End element: local name: {} qname: {} uri: {}", new Object[]{localName, qname, uri});
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.logger.debug("Characters: {}", (Object)new String(ch, start, length));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.logger.debug("Ignorable whitespace: {}", (Object)new String(ch, start, length));
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.logger.debug("Start {} namespace scope. URI: {}", (Object)prefix, (Object)uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.logger.debug("End {} namespace scope.", (Object)prefix);
    }

    @Override
    public void warning(SAXParseException spe) {
        this.logger.warn("Warning at line {}", (Object)spe.getLineNumber());
        this.logger.warn(spe.getMessage());
    }

    @Override
    public void fatalError(SAXParseException spe) {
        this.logger.error("Fatal error at line ", (Object)spe.getLineNumber());
        this.logger.error(spe.getMessage());
        spe.printStackTrace(System.err);
    }
}

