/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import de.mpc.BaseLib.XML.ValidationRunnable;
import de.mpc.BaseLib.XML.XMLSchemaValidator;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadingXsdValidation
extends XMLSchemaValidator {
    private static final Logger logger = LoggerFactory.getLogger(MultithreadingXsdValidation.class);

    public static void validateXMLFiles(String[] fileNames) {
        if (fileNames.length < 2) {
            logger.debug("Please specify a XSD-Schema and one or more XML-files.");
            return;
        }
        Schema xsdSchema = XMLSchemaValidator.compileXsdSchema(fileNames[0]);
        for (int i = 1; i < fileNames.length; ++i) {
            logger.debug("{} + {}", (Object)fileNames[0], (Object)fileNames[i]);
            new Thread(new ValidationRunnable(xsdSchema, fileNames[i])).start();
        }
    }
}

