/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib.XML;

import de.mpc.BaseLib.constants.MyConstants;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public abstract class BaseSaxParser {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    protected SAXParser saxParser = null;
    private boolean isValidating = false;
    private boolean isNamespaceAware = false;
    private boolean isIncludeAware = false;

    public BaseSaxParser(String xmlInputFile) {
        this.initSaxParser(xmlInputFile);
    }

    private void initSaxParser(String fileName) {
        try {
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setNamespaceAware(true);
            saxFactory.setValidating(true);
            this.isNamespaceAware = true;
            this.isValidating = true;
            this.isIncludeAware = false;
            this.saxParser = saxFactory.newSAXParser();
            this.logger.info("XML file " + fileName + " read.");
        }
        catch (ParserConfigurationException | SAXException sex) {
            sex.printStackTrace(System.err);
        }
    }

    public Object getProperty(String name) {
        try {
            return this.saxParser.getProperty(name);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException snre) {
            snre.printStackTrace(System.err);
            return null;
        }
    }

    public void setProperty(String name, Object obj) {
        try {
            this.saxParser.setProperty(name, obj);
        }
        catch (SAXNotRecognizedException | SAXNotSupportedException snre) {
            snre.printStackTrace(System.err);
        }
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public boolean isNamespaceAware() {
        return this.isNamespaceAware;
    }

    public boolean isIncludeAware() {
        return this.isIncludeAware;
    }

    public XMLReader getXMLReader() {
        try {
            return this.saxParser.getXMLReader();
        }
        catch (SAXException sex) {
            sex.printStackTrace(System.err);
            return null;
        }
    }

    protected final InputSource getInputSource(String xmlStr) {
        String xmlContent = xmlStr.replace("\r\n\r\n", MyConstants.newline);
        ByteArrayInputStream inStream = new ByteArrayInputStream(xmlContent.getBytes());
        InputSource inpSource = new InputSource();
        inpSource.setByteStream(inStream);
        return inpSource;
    }
}

