/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant {
    private String strValue = "";
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public Variant(String str) {
        this.strValue = str;
    }

    public String getStrValue() {
        return this.strValue;
    }

    public int getIntValue() {
        try {
            return Integer.parseInt(this.strValue);
        }
        catch (NumberFormatException nfex) {
            nfex.printStackTrace(System.err);
            this.logger.error("Variant " + this.getStrValue() + " cannot be converted to int.");
            return -1;
        }
    }

    public long getLongValue() {
        try {
            return Long.parseLong(this.strValue);
        }
        catch (NumberFormatException nfex) {
            nfex.printStackTrace(System.err);
            this.logger.error("Variant " + this.getStrValue() + " cannot be converted to long.");
            return -1L;
        }
    }

    public float getFloatValue() {
        try {
            return Float.parseFloat(this.strValue);
        }
        catch (NumberFormatException nfex) {
            nfex.printStackTrace(System.err);
            this.logger.error("Variant " + this.getStrValue() + " cannot be converted to double.");
            return 0.0f;
        }
    }

    public double getDoubleValue() {
        try {
            return Double.parseDouble(this.strValue);
        }
        catch (NumberFormatException nfex) {
            nfex.printStackTrace(System.err);
            this.logger.error("Variant " + this.getStrValue() + " cannot be converted to double.");
            return 0.0;
        }
    }
}

