/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.Pair;
import de.mpc.BaseLib.SystemProps;
import de.mpc.BaseLib.constants.MyConstants;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaxonomyReader {
    private final String WORK_DIR = SystemProps.getUserWorkingDirectory();
    private final String TAXONOMY_FILE_PATH_IN = this.WORK_DIR + "\\resources\\taxonomy_ID_names.txt";
    private final Logger logger = LoggerFactory.getLogger(TaxonomyReader.class);
    private final HashMap<String, Integer> name2TaxIDMap = new HashMap();
    private final HashMap<Integer, String> taxID2NameMap = new HashMap();
    private final HashMap<String, Pair<Integer, String>> str2TaxIDOrganismNameMap = new HashMap();

    public TaxonomyReader() {
        this.doInitialReadIn();
    }

    private void doInitialReadIn() {
        this.logger.debug("Start reading taxonomy file");
        try (BufferedReader buffReader = new BufferedReader(new FileReader(this.TAXONOMY_FILE_PATH_IN));){
            String line;
            while ((line = buffReader.readLine()) != null) {
                String[] splitter = line.split(MyConstants.STR_TAB);
                Integer taxID = Integer.valueOf(splitter[0]);
                if (!this.name2TaxIDMap.containsKey(splitter[1])) {
                    this.name2TaxIDMap.put(splitter[1], taxID);
                }
                if (this.taxID2NameMap.containsKey(taxID)) continue;
                this.taxID2NameMap.put(taxID, splitter[1]);
            }
        }
        catch (IOException ioexc) {
            ioexc.printStackTrace(System.err);
            System.err.println("Can't read the taxonomy ID file from " + this.TAXONOMY_FILE_PATH_IN);
        }
        this.logger.debug("End reading taxonomy file");
    }

    public int getTaxID(String organismName) {
        if (this.name2TaxIDMap.isEmpty()) {
            this.doInitialReadIn();
        } else if (this.name2TaxIDMap.containsKey(organismName)) {
            return this.name2TaxIDMap.get(organismName);
        }
        return -1;
    }

    public String getOrganismName(String strTaxID) {
        String taxIDStr = strTaxID.trim();
        if (this.taxID2NameMap.isEmpty()) {
            this.doInitialReadIn();
        } else {
            Integer taxID = Integer.valueOf(taxIDStr);
            if (this.taxID2NameMap.containsKey(taxID)) {
                return this.taxID2NameMap.get(taxID);
            }
        }
        return "";
    }

    public Pair<Integer, String> tryToGetOrganismNameFromStr(String str) {
        if (this.str2TaxIDOrganismNameMap.containsKey(str)) {
            return this.str2TaxIDOrganismNameMap.get(str);
        }
        if (this.taxID2NameMap.isEmpty()) {
            this.doInitialReadIn();
        } else {
            HashMap<Integer, String> candidatesMap = new HashMap<Integer, String>();
            for (String organismName : this.name2TaxIDMap.keySet()) {
                if (str.indexOf(organismName) <= -1) continue;
                candidatesMap.put(this.name2TaxIDMap.get(organismName), organismName);
            }
            if (candidatesMap.size() > 0) {
                int taxID = this.getLongestCandidate(candidatesMap);
                if (taxID != -1) {
                    String organism = candidatesMap.get(taxID);
                    if (this.isEmbeddedByTwoCompatibleCharacters(str, organism)) {
                        Pair<Integer, String> retPair = new Pair<Integer, String>(taxID, organism);
                        this.str2TaxIDOrganismNameMap.put(str, retPair);
                        return retPair;
                    }
                } else {
                    this.logger.debug("TaxID = -1L for organismName");
                }
            }
        }
        return null;
    }

    private boolean isEmbeddedByTwoCompatibleCharacters(String str, String organismName) {
        return this.isEmbeddedBy(str, organismName, '{', '}') || this.isEmbeddedBy(str, organismName, '(', ')') || this.isEmbeddedBy(str, organismName, '[', ']') || this.isEmbeddedBy(str, organismName, ' ', ' ') || this.isEmbeddedBy(str, organismName, ' ', '|') || this.isEmbeddedBy(str, organismName, '#', '#');
    }

    private boolean isEmbeddedBy(String str, String organismName, char chr1, char chr2) {
        StringBuilder strB = new StringBuilder();
        strB.append(chr1).append(organismName).append(chr2);
        return str.indexOf(strB.toString()) > -1;
    }

    private int getLongestCandidate(HashMap<Integer, String> candMap) {
        int maxLen = -1;
        int maxKey = -1;
        for (int key : candMap.keySet()) {
            int len = candMap.get(key).length();
            if (len <= maxLen) continue;
            maxKey = key;
            maxLen = len;
        }
        return maxKey;
    }
}

