/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import de.mpc.BaseLib.constants.MyConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopWatch {
    private final int DAYS_PER_WEEK = 7;
    private final int HOURS_PER_DAY = 24;
    private final int MINS_PER_HOUR = 60;
    private final int SECS_PER_MIN = 60;
    private final int MILLIS_PER_SEC = 1000;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private long startTime = 0L;
    private long stopTime = 0L;
    private boolean bRunning = false;
    private final String comment;
    private long millisAlreadyRan;

    public StopWatch(String comment) {
        this.comment = comment;
        this.millisAlreadyRan = 0L;
    }

    public void start() {
        this.millisAlreadyRan = 0L;
        this.startTime = System.currentTimeMillis();
        this.bRunning = true;
    }

    public void reStart() {
        this.startTime = System.currentTimeMillis();
        this.bRunning = true;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.bRunning = false;
        this.millisAlreadyRan += this.stopTime - this.startTime;
    }

    public long getElapsedTimeMilliSecs() {
        if (this.bRunning) {
            return this.millisAlreadyRan + System.currentTimeMillis() - this.startTime;
        }
        return this.millisAlreadyRan + this.stopTime - this.startTime;
    }

    public String getUsedTimeAsString() {
        long millis = this.getElapsedTimeMilliSecs();
        return this.convertMillisToString(millis);
    }

    public String convertMillisToString(long millis) {
        this.getClass();
        long secs = millis / 1000L;
        this.getClass();
        Long restMillis = millis % 1000L;
        this.getClass();
        long mins = secs / 60L;
        this.getClass();
        Long restSecs = secs % 60L;
        this.getClass();
        long hours = mins / 60L;
        this.getClass();
        Long restMins = mins % 60L;
        this.getClass();
        Long days = hours / 24L;
        this.getClass();
        Long restHours = hours % 24L;
        long l = days;
        this.getClass();
        Long weeks = l / 7L;
        long l2 = days;
        this.getClass();
        Long restDays = l2 % 7L;
        StringBuilder sb = new StringBuilder();
        sb.append("millis: ").append(millis).append(" - Elapsed time (").append(this.comment).append("): ");
        sb.append(weeks.toString());
        sb.append(" weeks ");
        String restDaysStr = restDays.toString();
        if (restDaysStr.length() == 1) {
            sb.append("0");
        }
        sb.append(restDaysStr);
        sb.append(" days ");
        String restHoursStr = restHours.toString();
        if (restHoursStr.length() == 1) {
            sb.append("0");
        }
        sb.append(restHoursStr);
        sb.append(MyConstants.STR_COLON);
        String restMinsStr = restMins.toString();
        if (restMinsStr.length() == 1) {
            sb.append("0");
        }
        sb.append(restMinsStr);
        sb.append(MyConstants.STR_COLON);
        String restSecsStr = restSecs.toString();
        if (restSecsStr.length() == 1) {
            sb.append("0");
        }
        sb.append(restSecsStr);
        sb.append(MyConstants.STR_POINT);
        String restMillisStr = restMillis.toString();
        if (restSecsStr.length() == 1) {
            sb.append("00");
        } else if (restSecsStr.length() == 2) {
            sb.append("00");
        }
        sb.append(restMillisStr);
        return sb.toString();
    }
}

