/*
 * Decompiled with CFR 0.152.
 */
package de.mpc.BaseLib;

import java.text.SimpleDateFormat;
import java.util.Date;

public class SVNVersion {
    private static final String TEMPLATE_SVN_REVISION = "$Revision: XYZ $";
    private static final String SVN_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z (EEE, d MMM yyyy)";
    private static String svnRevision = "";
    private static String svnDate = "";
    private static String revNumber = "";

    private static String makeBuildDate(int day, String month, int year) {
        StringBuilder strB = new StringBuilder();
        strB.append('(');
        strB.append(String.valueOf(day)).append(' ');
        strB.append(month).append(' ');
        strB.append(String.valueOf(year)).append(')');
        return strB.toString();
    }

    private static String makeVersionNumber(int major, int minor, int revision) {
        StringBuilder strB = new StringBuilder();
        strB.append(String.valueOf(major)).append('.');
        strB.append(String.valueOf(minor)).append('.');
        strB.append(String.valueOf(revision)).append(' ');
        return strB.toString();
    }

    private static String getRevNumber() {
        return svnRevision.substring(11, svnRevision.length() - 2);
    }

    private static String getDateStr() {
        return svnDate.substring(svnDate.length() - 14, svnDate.length() - 3);
    }

    public static String getActualDateStr() {
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(SVN_DATE_FORMAT);
        StringBuilder strB = new StringBuilder();
        strB.append("$Date: ").append(sdf.format(date)).append(" $");
        return strB.toString();
    }

    public static String getActualSVNVersionText(int major, int minor, int revision) {
        revNumber = String.valueOf(revision);
        svnRevision = TEMPLATE_SVN_REVISION.replace("XYZ", revNumber);
        svnDate = SVNVersion.getActualDateStr();
        StringBuilder strB = new StringBuilder();
        strB.append(String.valueOf(major)).append('.').append(String.valueOf(minor)).append('.');
        strB.append(SVNVersion.getRevNumber());
        strB.append(' ').append('(');
        strB.append(SVNVersion.getDateStr());
        strB.append(')');
        return strB.toString();
    }

    public static String getBuildSVNVersionText(int day, String month, int year, int major, int minor, int revision) {
        StringBuilder strB = new StringBuilder();
        strB.append(SVNVersion.makeVersionNumber(major, minor, revision));
        strB.append(SVNVersion.makeBuildDate(day, month, year));
        return strB.toString();
    }
}

